package com.ejianc.foundation.permission.service.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.foundation.cache.PermissionCacheManage;
import com.ejianc.foundation.oms.bean.ComboRoleEntity;
import com.ejianc.foundation.oms.service.IComboRoleService;
import com.ejianc.foundation.orgcenter.bean.OrgEntity;
import com.ejianc.foundation.orgcenter.service.IOrgService;
import com.ejianc.foundation.permission.bean.MangerUserRoleRelationEntity;
import com.ejianc.foundation.permission.bean.RoleAppRelationEntity;
import com.ejianc.foundation.permission.bean.RoleButtonRelationEntity;
import com.ejianc.foundation.permission.bean.RoleEntity;
import com.ejianc.foundation.permission.bean.RolePostRelationEntity;
import com.ejianc.foundation.permission.bean.RoleUserRelationEntity;
import com.ejianc.foundation.permission.mapper.RoleAppRelationMapper;
import com.ejianc.foundation.permission.mapper.RoleButtonRelationMapper;
import com.ejianc.foundation.permission.mapper.RoleMapper;
import com.ejianc.foundation.permission.mapper.RolePostRelationMapper;
import com.ejianc.foundation.permission.mapper.RoleUserRelationMapper;
import com.ejianc.foundation.permission.service.IMangerUserRoleRelationService;
import com.ejianc.foundation.permission.service.IRoleAppRelationService;
import com.ejianc.foundation.permission.service.IRoleButtonRelationService;
import com.ejianc.foundation.permission.service.IRolePostRelationService;
import com.ejianc.foundation.permission.service.IRoleService;
import com.ejianc.foundation.permission.service.IRoleUserRelationService;
import com.ejianc.foundation.permission.vo.AppVO;
import com.ejianc.foundation.permission.vo.ButtonVO;
import com.ejianc.foundation.permission.vo.RolePostRelationVO;
import com.ejianc.foundation.permission.vo.RoleUserRelationVO;
import com.ejianc.foundation.permission.vo.RoleVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.usercenter.bean.UserEntity;
import com.ejianc.foundation.usercenter.service.IUserService;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.cache.redis.CacheManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

@Service
public class RoleServiceImpl extends BaseServiceImpl<RoleMapper, RoleEntity> implements IRoleService {

	private static final String ROLE_BILL_CODE = "IDM_ROLE";
	private final static String CURRENTROLE_APP_KEY = "currentrole_app_key:";
	private final static String CURRENTROLE_USER_KEY = "currentrole_user_key:";
	private final static String CURRENTROLE_POST_KEY = "currentrole_post_key:";
	//当前角色的应用按钮KEY
	private final static String CURRENTROLE_APP_BUTTON_KEY = "currentrole_app_button_key:";
	
	@Autowired
	private IRoleAppRelationService roleAppRelationService;
	@Autowired
	private IRoleButtonRelationService roleButtonRelationService;
	@Autowired
	private RoleAppRelationMapper appmapper;
	@Autowired
	private RoleButtonRelationMapper buttonmapper;
	@Autowired
	private IRoleUserRelationService roleUserRelationService;
	@Autowired
	private RoleUserRelationMapper usermapper;
	@Autowired
	private RolePostRelationMapper rolePostRelationMapper;
	@Autowired
	private IRolePostRelationService rolePostRelationService;
	@Autowired
	private IUserService userService;
	@Autowired
	private IOrgService orgService;
	@Autowired
	private PermissionCacheManage permissionCacheManage;
	@Autowired
	private IBillCodeApi billCodeApi;
	@Autowired
	private IComboRoleService comboRoleService;
	@Autowired
	private CacheManager cacheManager;
	@Autowired
	private IMangerUserRoleRelationService roleRelationService;

	@Override
	@Transactional
	public CommonResponse<String> save(RoleVO roleVO, boolean syncEs, boolean levelAuthOpen) {
		Long tenantId = InvocationInfoProxy.getTenantid();
		RoleEntity entity = new RoleEntity();
		if (roleVO.getFkCopy()) {
			/** 复制角色 */
			Long sourceRoleId = roleVO.getId();
			if(!(roleVO.getCopyToOrgIds()!=null&&roleVO.getCopyToOrgIds().size()>0)){
				throw new BusinessException("缺少目的组织，请先填写");
			}
			List<String> codes = new ArrayList<>();
			List<RoleEntity> addRoleEntitys = new ArrayList<>();
			/** 编码为空则自动生成*/
			CommonResponse<List<String>> roleResponse = billCodeApi.getCodeBatchByRuleCode(ROLE_BILL_CODE, tenantId, roleVO.getCopyToOrgIds().size());
			if(roleResponse.isSuccess()) {
				codes = roleResponse.getData();
			}else{
				throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
			}
			roleVO.setDr(0);
			if (StringUtils.isNotBlank(roleVO.getCompileUserName())) {
				roleVO.setCompileUserName(InvocationInfoProxy.getUsercode());
			}
			roleVO.setState(1);
			roleVO.setId(null);
			if (StringUtils.isBlank(roleVO.getCompileUserName())) {
				UserEntity userEntity = userService.getById(InvocationInfoProxy.getUserid());
				roleVO.setCompileUserName(userEntity != null ? userEntity.getUserName() : "");
			}
			
			// 查询复制的应用及按钮权限+用户
			Map<String, Object> param = new HashMap<>();
			param.put("roleId", sourceRoleId);
			// 应用
			List<AppVO> appvos = appmapper.queryPageByProperties(param);
			List<RoleAppRelationEntity> appList = new ArrayList<>();
			// 按钮
			List<ButtonVO> btnvos = buttonmapper.queryProperties(param);
			List<RoleButtonRelationEntity> btnList = new ArrayList<>();
			// 用户---暂时不需要复制角色下的用户
//			param.put("tenantId", InvocationInfoProxy.getTenantid());
//			List<RoleUserRelationVO> uservos = usermapper.queryPageByProperties(param);
//			List<RoleUserRelationEntity> userList = new ArrayList<>();
			
			for(Long orgId : roleVO.getCopyToOrgIds()){
				entity = BeanMapper.map(roleVO, RoleEntity.class);
				entity.setId(IdWorker.getId());
				entity.setOrgId(orgId);
				entity.setCode(codes.get(roleVO.getCopyToOrgIds().indexOf(orgId)));
				addRoleEntitys.add(entity);

				for (AppVO e : appvos) {
					RoleAppRelationEntity rentity = new RoleAppRelationEntity();
					rentity.setAppId(e.getId());
					rentity.setRoleId(entity.getId());
					rentity.setDr(0);
					appList.add(rentity);
				}
				for (ButtonVO e : btnvos) {
					RoleButtonRelationEntity bentity = new RoleButtonRelationEntity();
					bentity.setAppId(e.getAppId());
					bentity.setButtonId(e.getId());
					bentity.setRoleId(entity.getId());
					btnList.add(bentity);
				}
			}
			
			//保存角色
			if(addRoleEntitys.size() > 0){
				this.saveOrUpdateBatch(addRoleEntitys, addRoleEntitys.size(), syncEs);
			}

			if (appList.size() > 0) {
				roleAppRelationService.saveOrUpdateBatch(appList, appList.size(), false);
			}
			if (btnList.size() > 0) {
				roleButtonRelationService.saveOrUpdateBatch(btnList, btnList.size(), false);
			}
			//刷新角色应用缓存
			if (appList.size() > 0) {
				permissionCacheManage.putRoleAppsCache(entity.getId(), appvos);
			}
			if(levelAuthOpen && !Objects.equals("1",InvocationInfoProxy.getUserType())){
				/** 开启了分级授权的非超级管理员 ， 维护自己的角色权限 */
				if(addRoleEntitys.size() > 0){
					List<MangerUserRoleRelationEntity> roleRelationEntities = new ArrayList<>();
					for (RoleEntity role : addRoleEntitys) {
						OrgEntity orgVO = orgService.selectById(role.getOrgId());
						MangerUserRoleRelationEntity relationEntity = new MangerUserRoleRelationEntity();
						relationEntity.setOrgId(role.getOrgId());
						relationEntity.setOrgName(orgVO.getName());
						relationEntity.setRoleId(role.getId());
						relationEntity.setRoleName(role.getName());
						relationEntity.setUserId(InvocationInfoProxy.getUserid());
						roleRelationEntities.add(relationEntity);
					}
					roleRelationService.saveOrUpdateBatch(roleRelationEntities);
				}
			}
		} else {
			if (roleVO.getId() != null) {
				// 修改
				RoleEntity oldEntity = super.getById(roleVO.getId());
				oldEntity.setCode(roleVO.getCode());
				QueryParam param = new QueryParam();
				param.getParams().put("code",new Parameter(QueryParam.EQ,roleVO.getCode()));
				param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
				List<RoleEntity> list = queryList(param,false);
				if(ListUtil.isNotEmpty(list) && !list.get(0).getId().equals(roleVO.getId())){
					throw new BusinessException("角色编码重复！");
				}
				oldEntity.setName(roleVO.getName());
				oldEntity.setSequence(roleVO.getSequence());
				oldEntity.setNote(roleVO.getNote());
				oldEntity.setState(oldEntity.getState());
				oldEntity.setProperty(roleVO.getProperty());
				oldEntity.setCompileUserName(oldEntity.getCompileUserName());
				entity = BeanMapper.map(oldEntity, RoleEntity.class);
				this.saveOrUpdate(entity, syncEs);
				if(levelAuthOpen){
					/** 开启了 修改分级授权的角色名称 */
					QueryParam queryParam = new QueryParam();
					queryParam.getParams().put("roleId",new Parameter(QueryParam.EQ,entity.getId()));
					List<MangerUserRoleRelationEntity> roleRelationEntities = roleRelationService.queryList(queryParam);
					if(ListUtil.isNotEmpty(roleRelationEntities)){
						for (MangerUserRoleRelationEntity relationEntity : roleRelationEntities) {
							relationEntity.setRoleName(entity.getName());
						}
						roleRelationService.saveOrUpdateBatch(roleRelationEntities);
					}
				}
			} else {
				// 新增
				if(StringUtils.isEmpty(roleVO.getCode())){
					/** 编码为空则自动生成*/
					CommonResponse<String> roleResponse = billCodeApi.getCodeBatchByRuleCode(ROLE_BILL_CODE, tenantId);
					if(roleResponse.isSuccess()) {
						roleVO.setCode(roleResponse.getData());
					}else{
						throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
					}
				}else {
					QueryParam param = new QueryParam();
					param.getParams().put("code",new Parameter(QueryParam.EQ,roleVO.getCode()));
					param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
					List<RoleEntity> list = queryList(param,false);
					if(ListUtil.isNotEmpty(list)){
						throw new BusinessException("角色编码重复！");
					}
				}
				roleVO.setOrgId(InvocationInfoProxy.getOrgId());
				roleVO.setDr(0);
				if (StringUtils.isNotBlank(roleVO.getCompileUserName())) {
					UserEntity userEntity = userService.getById(InvocationInfoProxy.getUserid());
					roleVO.setCompileUserName(userEntity != null ? userEntity.getUserName() : "");
				}
				roleVO.setState(1);
				entity = BeanMapper.map(roleVO, RoleEntity.class);
				this.saveOrUpdate(entity, syncEs);
				if(levelAuthOpen && !Objects.equals("1",InvocationInfoProxy.getUserType())){
					/** 开启了分级授权的非超级管理员 ， 维护自己的角色权限 */
					MangerUserRoleRelationEntity relationEntity = new MangerUserRoleRelationEntity();
					OrgEntity orgVO = orgService.selectById(entity.getOrgId());
					relationEntity.setOrgId(entity.getOrgId());
					relationEntity.setOrgName(orgVO.getName());
					relationEntity.setRoleId(entity.getId());
					relationEntity.setRoleName(entity.getName());
					relationEntity.setUserId(InvocationInfoProxy.getUserid());
					roleRelationService.saveOrUpdate(relationEntity);
				}
			}
		}
		return CommonResponse.success("保存成功");
	}

	@Override
	@Transactional
	public CommonResponse<String> delete(List<Long> ids) {
		//按理说只有组织code为ORG-OMS（即当前登录组织为平台运营时判断）
        OrgEntity orgEntity = orgService.getById(InvocationInfoProxy.getOrgId());
		if("ORG-OMS".equals(orgEntity.getCode())){
			//删除前校验：判断角色是否被套餐引用
			QueryWrapper<ComboRoleEntity> queryWrapper = new QueryWrapper<>();
			queryWrapper.eq("dr", 0);
			queryWrapper.in("role_id", ids);
			List<ComboRoleEntity> list = comboRoleService.list(queryWrapper);
			if(list!=null&&list.size()>0){
				List<Long> roleIds = list.stream().map(ComboRoleEntity::getRoleId).collect(Collectors.toList());
				List<RoleEntity> role = (List<RoleEntity>) this.listByIds(roleIds);
				String message = "";
				for(RoleEntity r : role){
					if(message.length()>0){
						message += ("、"+r.getName());
					}else{
						message += r.getName();
					}
				}
				throw new BusinessException(message+"已被套餐引用，请先删除套餐与角色的关系");
			}
		}
		
		super.removeByIds(ids);
		// 删除应用权限
		QueryWrapper<RoleAppRelationEntity> queryWrapper = new QueryWrapper<>();
		queryWrapper.in("role_id", ids);
		queryWrapper.eq("dr", 0);
//		appmapper.delete(queryWrapper);
		List<RoleAppRelationEntity> roleAppRelationList = roleAppRelationService.list(queryWrapper);
		if(roleAppRelationList!=null&&roleAppRelationList.size()>0){
			roleAppRelationService.delete(roleAppRelationList);
		}
		// 删除按钮权限
//		QueryWrapper<RoleButtonRelationEntity> wrapper = new QueryWrapper<>();
//		wrapper.in("role_id", ids);
//		wrapper.eq("dr", 0);
//		buttonmapper.delete(wrapper);
		// 删除用户权限
		QueryWrapper<RoleUserRelationEntity> userwrapper = new QueryWrapper<>();
		userwrapper.in("role_id", ids);
		userwrapper.eq("dr", 0);
//		usermapper.delete(userwrapper);
		List<RoleUserRelationEntity> roleUserRelationList = roleUserRelationService.list(userwrapper);
		if(roleUserRelationList!=null&&roleUserRelationList.size()>0){
			List<Long> userIds = new ArrayList<>();
			roleUserRelationList.forEach(e -> {
				userIds.add(e.getId());
			});
			roleUserRelationService.delete(userIds);
		}
		//删除岗位权限
		rolePostRelationService.deleteByRoleIds(ids);
		return CommonResponse.success("删除成功");
	}

	@Override
	public RoleVO queryDetail(Long id) {
		RoleEntity entity = baseMapper.selectById(id);
		if (entity != null) {
			return BeanMapper.map(entity, RoleVO.class);
		}
		return null;
	}

	@Override
	public void refreshAuthCache() {
		QueryWrapper<RoleEntity> queryWrapper = new QueryWrapper<>();
		List<RoleEntity> roleList = baseMapper.selectList(queryWrapper);
		if (roleList != null && roleList.size() > 0) {
			//
			for (RoleEntity roleEntity : roleList) {
				List<AppVO> appVos = null;
				if(999999L == roleEntity.getTenantId()) {
					appVos = appmapper.queryAuthListByRoleId(roleEntity.getId());
				}else{
					Map<String, Object> queryParam = new HashMap<>();
					queryParam.put("tenantId", roleEntity.getTenantId());
					queryParam.put("roleId", roleEntity.getId());
					appVos = appmapper.queryPageByProperties(queryParam);
				}
				//查询角色用户信息
				QueryWrapper<RoleUserRelationEntity> roleUserQueryWrapper = new QueryWrapper<>();
				roleUserQueryWrapper.eq("role_id", roleEntity.getId());
				List<RoleUserRelationEntity> roleUserRelationEntities = usermapper.selectList(roleUserQueryWrapper);
				List<RoleUserRelationVO> roleUserRelationVos = BeanMapper.mapList(roleUserRelationEntities, RoleUserRelationVO.class);
				//查询角色岗位信息
				QueryWrapper<RolePostRelationEntity> rolePostQueryWrapper = new QueryWrapper<>();
				rolePostQueryWrapper.eq("role_id", roleEntity.getId());
				List<RolePostRelationEntity> rolePostRelationEntities = rolePostRelationMapper.selectList(rolePostQueryWrapper);
				List<RolePostRelationVO> rolePostRelationVos = BeanMapper.mapList(rolePostRelationEntities, RolePostRelationVO.class);
				
				cacheManager.removeCache(CURRENTROLE_APP_KEY + roleEntity.getId());
				cacheManager.removeCache(CURRENTROLE_USER_KEY + roleEntity.getId());
				cacheManager.removeCache(CURRENTROLE_POST_KEY + roleEntity.getId());

				/** 删除按钮权限缓存 */
				cacheManager.removeCache(CURRENTROLE_APP_BUTTON_KEY + roleEntity.getId());
				/** 查询角色应用下有权限的按钮 */
				if(ListUtil.isNotEmpty(appVos)){
					Map<String, Object> param = new HashMap<>();
					for(AppVO app:appVos){
						param.put("roleId", roleEntity.getId());
						param.put("appId", app.getId());
						param.put("dr", 0);
						List<ButtonVO> btnVos = buttonmapper.queryProperties(param);
						if(ListUtil.isNotEmpty(btnVos)){
							app.setChildren(btnVos);
						}
					}
				}
				permissionCacheManage.putRoleAppsCache(roleEntity.getId(), appVos);
				permissionCacheManage.putRoleUsersCache(roleEntity.getId(), roleUserRelationVos);
				permissionCacheManage.putRolePostsCache(roleEntity.getId(), rolePostRelationVos);
			}
		}
	}

	@Override
	public List<Long> queryRoleIdstByCurrentUserId(Long userId, Long tenantId, UserContext userContext) {
		QueryParam roleUserRelationParam = new QueryParam();
		roleUserRelationParam.getParams().put("user_id", new Parameter(QueryParam.EQ, userId));
		roleUserRelationParam.getParams().put("tenant_id", new Parameter(QueryParam.EQ, tenantId));
		List<RoleUserRelationEntity> entities = roleUserRelationService.queryList(roleUserRelationParam, false);
		List<Long> roleIds = new ArrayList<>();
		Map<Long, Long> roleIdMap = new HashMap<>();
		if (entities != null && entities.size() > 0) {
			for (RoleUserRelationEntity entity : entities) {
				roleIds.add(entity.getRoleId());
				roleIdMap.put(entity.getRoleId(), entity.getRoleId());
			}
		}
		
		List<RolePostRelationEntity> rolePostEntities = rolePostRelationMapper.queryRolePostByUserId(userId, tenantId);
		if(rolePostEntities != null && rolePostEntities.size() > 0) {
//			JSONObject extJsonObj = new JSONObject();
			for(RolePostRelationEntity rolePostEntity:rolePostEntities) {
				if(rolePostEntity.getJobOrgId() != null) {
					if(!roleIdMap.containsKey(rolePostEntity.getRoleId())) {
						roleIds.add(rolePostEntity.getRoleId());
					}
					/*//放入角色组织缓存关系
					String cacheKey = "user_role_post_cache_"+rolePostEntity.getRoleId()+"_"+userId;
					String cacheValue = extJsonObj.getString(cacheKey);
					if(StringUtils.isNotBlank(cacheValue)) {
						extJsonObj.put(cacheKey, rolePostEntity.getJobOrgId()+","+cacheValue);
					}else{
						extJsonObj.put(cacheKey, rolePostEntity.getJobOrgId()+"");
					}*/
				}
			}
			/*if(!extJsonObj.isEmpty() && userContext != null) {
				userContext.setExt(extJsonObj);
			}*/
		}
		
		roleIdMap.clear();
		return roleIds;
	}

	@Override
	public List<RoleVO> queryRoleByUserId(Long userId, Long tenantId) {
		QueryParam roleUserRelationParam = new QueryParam();
		roleUserRelationParam.getParams().put("user_id", new Parameter(QueryParam.EQ, userId));
		roleUserRelationParam.getParams().put("tenant_id", new Parameter(QueryParam.EQ, tenantId));
		List<RoleUserRelationEntity> entities = roleUserRelationService.queryList(roleUserRelationParam, false);
		List<Long> roleIds = null;
		if (entities != null && entities.size() > 0) {
			roleIds = new ArrayList<>();
			for (RoleUserRelationEntity entity : entities) {
				roleIds.add(entity.getRoleId());
			}
		}
		List<RoleEntity> list = (List<RoleEntity>) this.listByIds(roleIds);
		List<RoleVO> back = null;
		if(list!=null&&list.size()>0){
			back = BeanMapper.mapList(list, RoleVO.class);
		}
		return back;
	}

}
