package com.ejianc.foundation.cache;

import java.nio.charset.Charset;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import com.alibaba.fastjson.JSON;
import com.ejianc.foundation.apigateway.vo.ServInfoVO;
import com.ejianc.framework.cache.redis.CacheManager;
import com.ejianc.framework.cache.serializer.Serializer;
import com.ejianc.framework.cache.serializer.impl.DefaultJDKSerializer;

@Component
public class ServiceCacheManage {

	public static final String DEFAULT_CHARSET = "UTF-8";
	// 所有应用缓存
	private final static String SERVICE_LIST_KEY = "service_list_key";

	@Autowired
	private CacheManager cacheManager;

	private Serializer serializer = new DefaultJDKSerializer();
	
	public void putServiceListToCache(List<ServInfoVO> servInfoList) {
		cacheManager.removeCache(SERVICE_LIST_KEY);
		if(servInfoList != null && servInfoList.size() > 0) {
			cacheManager.piplineExecute(pipeline -> {
				pipeline.multi();
				String key = SERVICE_LIST_KEY;
				for (ServInfoVO servInfoVo : servInfoList) {
					byte[] keyBytes = key.getBytes(Charset.forName(DEFAULT_CHARSET));
					byte[] fieldBytes = servInfoVo.getUrl().getBytes(Charset.forName(DEFAULT_CHARSET));
					byte[] contentBytes = serializer.marshalToByte(JSON.toJSONString(servInfoVo));
					pipeline.hset(keyBytes, fieldBytes, contentBytes);
				}
				pipeline.exec();
			});
		}
	}
	
	public void putServiceToCache(ServInfoVO servInfoVo) {
		String key = SERVICE_LIST_KEY;
		cacheManager.hset(key, servInfoVo.getUrl(), JSON.toJSONString(servInfoVo));
	}
	
	public ServInfoVO getServInfoVoCache(String url) {
		String key = SERVICE_LIST_KEY;
		String content = cacheManager.hget(key, url);
		ServInfoVO servInfoVo = JSON.parseObject(content, ServInfoVO.class);
		return servInfoVo;
	}
	
	public void removeServInfo(String url) {
		String key = SERVICE_LIST_KEY;
		cacheManager.hdel(key, url);
	}
}
