/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.orgcenter.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.cache.PermissionCacheManage;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.orgcenter.bean.DeptEntity;
import com.ejianc.foundation.orgcenter.bean.EmployeeEntity;
import com.ejianc.foundation.orgcenter.bean.JobEntity;
import com.ejianc.foundation.orgcenter.bean.OrgEntity;
import com.ejianc.foundation.orgcenter.bean.PostEntity;
import com.ejianc.foundation.orgcenter.mapper.EmployeeMapper;
import com.ejianc.foundation.orgcenter.mapper.JobMapper;
import com.ejianc.foundation.orgcenter.service.IDeptService;
import com.ejianc.foundation.orgcenter.service.IEmployeeService;
import com.ejianc.foundation.orgcenter.service.IJobService;
import com.ejianc.foundation.orgcenter.service.IOrgService;
import com.ejianc.foundation.orgcenter.service.IPostService;
import com.ejianc.foundation.orgcenter.vo.EmployeeImportVO;
import com.ejianc.foundation.orgcenter.vo.EmployeeJobVO;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.foundation.orgcenter.vo.JobVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.orgcenter.vo.PostVO;
import com.ejianc.foundation.permission.bean.RoleUserRelationEntity;
import com.ejianc.foundation.permission.mapper.RoleUserRelationMapper;
import com.ejianc.foundation.permission.service.IRoleUserRelationService;
import com.ejianc.foundation.permission.vo.RoleUserRelationVO;
import com.ejianc.foundation.sign.bean.SignEntity;
import com.ejianc.foundation.sign.service.ISignService;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.tenant.service.IPasswordPolicyService;
import com.ejianc.foundation.usercenter.bean.UserEntity;
import com.ejianc.foundation.usercenter.bean.UserTenantRelationEntity;
import com.ejianc.foundation.usercenter.service.IUserManagerRelationAppService;
import com.ejianc.foundation.usercenter.service.IUserService;
import com.ejianc.foundation.usercenter.service.IUserTenantRelationService;
import com.ejianc.foundation.usercenter.util.PasswordUtils;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.foundation.utils.gdty.param.GdtyEmp;
import com.ejianc.foundation.utils.ynsbj.param.YnsbjEmp;
import com.ejianc.foundation.utils.ynsbj.param.YnsbjEmpJob;
import com.ejianc.foundation.utils.ynsbj.resp.YnsbjDataInfo;
import com.ejianc.framework.cache.redissonlock.RedissonLocker;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.builder.BuilderException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="employeeService")
public class EmployeeServiceImpl
extends BaseServiceImpl<EmployeeMapper, EmployeeEntity>
implements IEmployeeService {
    private static final String EMPLOYEE_BILL_CODE = "IDM_EMPLOYEE";
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private EmployeeMapper employeeMapper;
    @Autowired
    private IJobService jobService;
    @Autowired
    private IUserService userService;
    @Autowired
    private IRoleUserRelationService roleUserRelationService;
    @Autowired
    private IOrgService orgService;
    @Autowired
    private PermissionCacheManage permissionCacheManager;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IDeptService deptService;
    @Autowired
    private IPostService postService;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IUserTenantRelationService userTenantRelationService;
    @Autowired
    private IUserManagerRelationAppService userManagerRelationAppService;
    @Autowired
    private RedissonLocker redissonLocker;
    @Autowired
    private IPasswordPolicyService passwordPolicyService;
    @Autowired
    private JobMapper jobMapper;
    @Autowired
    private RoleUserRelationMapper roleUserRelationMapper;
    @Autowired
    private ISignService signService;

    @Override
    public IPage<EmployeeVO> pageList(Map<String, Object> params) {
        Object orgId = params.get("orgId");
        if (orgId != null) {
            OrgVO orgVo = this.orgService.queryDetail(Long.parseLong(orgId.toString()));
            if (orgVo != null) {
                params.put("innerCode", orgVo.getInnerCode());
            }
        } else {
            return new Page();
        }
        List<Object> voList = new ArrayList();
        Page page = new Page();
        page.setCurrent((long)Integer.valueOf(params.get("pageNumber").toString()).intValue());
        page.setSize((long)Integer.valueOf(params.get("pageSize").toString()).intValue());
        long total = this.employeeMapper.count(params);
        page.setTotal(total);
        if (total == 0L) {
            page.setRecords(voList);
            return page;
        }
        long startLine = (page.getCurrent() < 1L ? 0L : page.getCurrent() - 1L) * page.getSize();
        params.put("startLine", startLine);
        params.put("pageSize", page.getSize());
        voList = this.employeeMapper.getList(params);
        if (ListUtil.isNotEmpty(voList)) {
            for (EmployeeVO employeeVO : voList) {
                List<OrgVO> parentOrgs = this.orgService.findParentsByOrgIdAsc(employeeVO.getOrgId());
                String parentOrgStr = "";
                if (parentOrgs != null && parentOrgs.size() > 0) {
                    for (OrgVO parentOrg : parentOrgs) {
                        parentOrgStr = parentOrgStr + parentOrg.getName() + "/";
                    }
                    parentOrgStr = parentOrgStr.substring(0, parentOrgStr.length() - 1);
                }
                employeeVO.setOrgName(parentOrgStr);
            }
        }
        page.setRecords(voList);
        return page;
    }

    @Override
    public IPage<EmployeeVO> pageALLList(Map<String, Object> params) {
        List<Object> voList = new ArrayList();
        Page page = new Page();
        page.setCurrent((long)Integer.valueOf(params.get("pageNumber").toString()).intValue());
        page.setSize((long)Integer.valueOf(params.get("pageSize").toString()).intValue());
        long total = this.employeeMapper.count(params);
        page.setTotal(total);
        if (total == 0L) {
            page.setRecords(voList);
            return page;
        }
        long startLine = (page.getCurrent() < 1L ? 0L : page.getCurrent() - 1L) * page.getSize();
        params.put("startLine", startLine);
        params.put("pageSize", page.getSize());
        voList = this.employeeMapper.getList(params);
        page.setRecords(voList);
        return page;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EmployeeEntity save(EmployeeVO employeeVO) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        EmployeeEntity dbEntity = (EmployeeEntity)((Object)super.getById((Serializable)employeeVO.getId()));
        try {
            this.redissonLocker.lock(employeeVO.getMobilePhone() + "_save", TimeUnit.SECONDS, 10);
            JobEntity job = this.jobService.getCurMainJob(employeeVO.getId());
            UserTenantRelationEntity userTenantRelationEntity = null;
            if (null == dbEntity) {
                DeptEntity dept;
                CommonResponse employeeResponse = this.billCodeApi.getCodeBatchByRuleCode(EMPLOYEE_BILL_CODE, tenantId);
                if (!employeeResponse.isSuccess()) {
                    throw new BuilderException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
                }
                employeeVO.setCode((String)employeeResponse.getData());
                employeeVO.setState(Integer.valueOf(1));
                employeeVO.setTenantId(tenantId);
                employeeVO.setDr(BaseVO.DR_UNDELETE);
                UserVO user = this.userService.generateNewUser(employeeVO);
                if (user == null) {
                    throw new BusinessException("\u65b0\u589e\u4eba\u5458\u5931\u8d25\uff0c \u624b\u673a\u53f7\u5df2\u5b58\u5728,\u8bf7\u7528\u6237\u81ea\u5df1\u7533\u8bf7\u52a0\u5165\u4f01\u4e1a");
                }
                employeeVO.setUserId(user.getId());
                employeeVO.setId(user.getId());
                QueryWrapper query = new QueryWrapper();
                query.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
                query.eq((Object)"org_id", (Object)employeeVO.getOrgId());
                Integer sequence = this.employeeMapper.selectCount((Wrapper)query);
                employeeVO.setSequence(Integer.valueOf(null == sequence ? 1 : sequence + 1));
                dbEntity = (EmployeeEntity)((Object)BeanMapper.map((Object)employeeVO, EmployeeEntity.class));
                Long deptId = employeeVO.getDeptId();
                if (deptId != null && Objects.equals(1, employeeVO.getDeptHead()) && (dept = this.deptService.selectById(deptId)).getDeptHead() != null && !Objects.equals(dept.getDeptHead(), user.getId())) {
                    this.jobService.updateDeptHeadNoByDeptId(deptId);
                    dept.setDeptHead(user.getId());
                    this.deptService.saveOrUpdate((Object)dept);
                }
                job = this.generateJob(employeeVO);
                UserTenantRelationEntity entity = new UserTenantRelationEntity();
                entity.setUserId(user.getId());
                entity.setEmployeeId(employeeVO.getId());
                entity.setOrgId(employeeVO.getOrgId());
                entity.setTenantId(employeeVO.getTenantId());
                entity.setPostId(employeeVO.getTenantId());
                entity.setDeptId(employeeVO.getDeptId());
                entity.setMainSpaceFlag(1);
                if (employeeVO.getTypeId() == null) {
                    entity.setTypeId(2);
                } else {
                    entity.setTypeId(employeeVO.getTypeId());
                }
                entity.setState(1);
                this.userTenantRelationService.saveOrUpdate((Object)entity, false);
            } else {
                UserVO user = this.userService.selectById(dbEntity.getUserId());
                user.setUserMobile(employeeVO.getMobilePhone());
                user.setSex(employeeVO.getSex() != null ? employeeVO.getSex().toString() : null);
                user.setUserName(employeeVO.getName());
                user.setAvator(employeeVO.getPhotoPath());
                if (employeeVO.getTypeId() != null) {
                    user.setTypeId(employeeVO.getTypeId());
                }
                job = this.jobService.getCurMainJob(employeeVO.getId());
                this.dealDeptHead(employeeVO, job);
                job.setRoleIds(employeeVO.getRoleIds());
                job.setRoleNames(employeeVO.getRoleNames());
                job.setDeptHead(employeeVO.getDeptHead());
                QueryWrapper wrapper = new QueryWrapper();
                wrapper.eq((Object)"user_id", (Object)dbEntity.getUserId());
                wrapper.eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid());
                wrapper.eq((Object)"dr", (Object)0);
                List list = this.userTenantRelationService.list((Wrapper)wrapper);
                if (list != null && list.size() > 0) {
                    userTenantRelationEntity = (UserTenantRelationEntity)((Object)list.get(0));
                    userTenantRelationEntity.setOrgId(employeeVO.getOrgId());
                    userTenantRelationEntity.setPostId(employeeVO.getPostId());
                    userTenantRelationEntity.setDeptId(employeeVO.getDeptId());
                    if (employeeVO.getTypeId() != null) {
                        userTenantRelationEntity.setTypeId(employeeVO.getTypeId());
                    }
                    if (userTenantRelationEntity.getMainSpaceFlag() == 1) {
                        dbEntity = (EmployeeEntity)((Object)BeanMapper.map((Object)employeeVO, EmployeeEntity.class));
                        user.setOrgId(employeeVO.getOrgId());
                    } else {
                        employeeVO.setTenantId(dbEntity.getTenantId());
                        employeeVO.setOrgId(dbEntity.getOrgId());
                        employeeVO.setDeptId(dbEntity.getDeptId());
                        employeeVO.setPostId(dbEntity.getPostId());
                        dbEntity = (EmployeeEntity)((Object)BeanMapper.map((Object)employeeVO, EmployeeEntity.class));
                    }
                    this.userTenantRelationService.saveOrUpdate((Object)userTenantRelationEntity, false);
                    if (null != job && null != userTenantRelationEntity) {
                        job.setEmployeeId(dbEntity.getId());
                        job.setOrgId(userTenantRelationEntity.getOrgId());
                        job.setPostId(userTenantRelationEntity.getPostId());
                        job.setDeptId(userTenantRelationEntity.getDeptId());
                    }
                }
                this.userService.saveOrUpdate(BeanMapper.map((Object)user, UserEntity.class), false);
            }
            super.saveOrUpdate((Object)dbEntity);
            if (employeeVO.getUserSignatureFileId() != null) {
                this.attachmentApi.updateAttachRef(employeeVO.getId(), Arrays.asList(employeeVO.getUserSignatureFileId()));
            }
            this.signService.updateFromEmpployee(dbEntity.getUserId(), employeeVO.getUserSignatureFileId(), employeeVO.getUserSignaturePath());
            this.jobService.saveOrUpdate((Object)job, false);
            if (employeeVO.getRoleDataList() != null && employeeVO.getRoleDataList().size() > 0) {
                ArrayList<RoleUserRelationVO> addRoleUserList = new ArrayList<RoleUserRelationVO>();
                ArrayList<Long> delRoleUserIds = new ArrayList<Long>();
                for (RoleUserRelationVO item : employeeVO.getRoleDataList()) {
                    if ("add".equals(item.getRowState())) {
                        RoleUserRelationVO vo = new RoleUserRelationVO();
                        vo.setRoleId(item.getRoleId());
                        vo.setUserId(dbEntity.getUserId());
                        vo.setEmployeeId(dbEntity.getId());
                        vo.setJobId(job.getId());
                        vo.setAuthOrgId(job.getOrgId());
                        addRoleUserList.add(vo);
                        continue;
                    }
                    if (!"del".equals(item.getRowState())) continue;
                    delRoleUserIds.add(item.getId());
                }
                if (addRoleUserList != null && addRoleUserList.size() > 0) {
                    this.roleUserRelationService.saveRoleUser(addRoleUserList);
                }
                if (delRoleUserIds != null && delRoleUserIds.size() > 0) {
                    this.roleUserRelationService.delete(delRoleUserIds);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.redissonLocker.unlock(employeeVO.getMobilePhone() + "_save");
        }
        return dbEntity;
    }

    private void dealDeptHead(EmployeeVO employeeVO, JobEntity job) {
        if (Objects.equals(job.getDeptId(), employeeVO.getDeptId())) {
            if (!Objects.equals(job.getDeptHead(), employeeVO.getDeptHead()) && job.getDeptId() != null) {
                DeptEntity dept = this.deptService.selectById(job.getDeptId());
                if (Objects.equals(job.getDeptHead(), 1) && !Objects.equals(employeeVO.getDeptHead(), 1)) {
                    this.jobService.updateDeptHeadNoByDeptId(job.getDeptId());
                    dept.setDeptHead(null);
                    this.deptService.saveOrUpdate((Object)dept);
                }
                if (Objects.equals(employeeVO.getDeptHead(), 1) && !Objects.equals(job.getDeptHead(), 1)) {
                    this.jobService.updateDeptHeadNoByDeptId(job.getDeptId());
                    dept.setDeptHead(employeeVO.getUserId());
                    this.deptService.saveOrUpdate((Object)dept);
                }
            }
        } else {
            DeptEntity dept;
            if (job.getDeptId() == null && employeeVO.getDeptId() != null && Objects.equals(employeeVO.getDeptHead(), 1)) {
                dept = this.deptService.selectById(employeeVO.getDeptId());
                this.jobService.updateDeptHeadNoByDeptId(employeeVO.getDeptId());
                dept.setDeptHead(employeeVO.getUserId());
                this.deptService.saveOrUpdate((Object)dept);
            }
            if (job.getDeptId() != null || employeeVO.getDeptId() == null || !Objects.equals(employeeVO.getDeptHead(), 1)) {
                // empty if block
            }
            if (employeeVO.getDeptId() == null && job.getDeptId() != null && Objects.equals(job.getDeptHead(), 1)) {
                dept = this.deptService.selectById(job.getDeptId());
                this.jobService.updateDeptHeadNoByDeptId(employeeVO.getDeptId());
                dept.setDeptHead(null);
                this.deptService.saveOrUpdate((Object)dept);
            }
            if (employeeVO.getDeptId() != null || job.getDeptId() == null || !Objects.equals(job.getDeptHead(), 1)) {
                // empty if block
            }
            if (employeeVO.getDeptId() != null && job.getDeptId() != null) {
                DeptEntity olddept;
                if (Objects.equals(job.getDeptHead(), 1) && Objects.equals(employeeVO.getDeptHead(), 1)) {
                    olddept = this.deptService.selectById(job.getDeptId());
                    this.jobService.updateDeptHeadNoByDeptId(job.getDeptId());
                    olddept.setDeptHead(null);
                    this.deptService.saveOrUpdate((Object)olddept);
                    DeptEntity dept2 = this.deptService.selectById(employeeVO.getDeptId());
                    this.jobService.updateDeptHeadNoByDeptId(employeeVO.getDeptId());
                    dept2.setDeptHead(employeeVO.getUserId());
                    this.deptService.saveOrUpdate((Object)dept2);
                }
                if (Objects.equals(job.getDeptHead(), 1) && !Objects.equals(employeeVO.getDeptHead(), 1)) {
                    olddept = this.deptService.selectById(job.getDeptId());
                    this.jobService.updateDeptHeadNoByDeptId(job.getDeptId());
                    olddept.setDeptHead(null);
                    this.deptService.saveOrUpdate((Object)olddept);
                }
                if (!Objects.equals(job.getDeptHead(), 1) && Objects.equals(employeeVO.getDeptHead(), 1)) {
                    dept = this.deptService.selectById(employeeVO.getDeptId());
                    this.jobService.updateDeptHeadNoByDeptId(employeeVO.getDeptId());
                    dept.setDeptHead(employeeVO.getUserId());
                    this.deptService.saveOrUpdate((Object)dept);
                }
                if (Objects.equals(job.getDeptHead(), 1) || !Objects.equals(employeeVO.getDeptHead(), 1)) {
                    // empty if block
                }
            }
        }
    }

    private void checkInfo(EmployeeVO employeeVO) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("mobilePhone", new Parameter("eq", (Object)employeeVO.getMobilePhone()));
        queryParam.getParams().put("dr", new Parameter("eq", (Object)0));
        List list = this.queryList(queryParam, false);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            throw new BusinessException("\u4fdd\u5b58\u4eba\u5458\u4fe1\u606f\u5931\u8d25\uff0c\u8be5\u79df\u6237\u6ce8\u518c\u624b\u673a\u53f7\u5df2\u88ab\u4eba\u5458id\u4e3a\u3010" + ((EmployeeEntity)((Object)list.get(0))).getId() + "\u3011\u7684\u7528\u6237\u4f7f\u7528\uff01");
        }
    }

    @Override
    @Transactional
    public EmployeeEntity save(EmployeeVO employeeVO, UserEntity user) {
        this.checkInfo(employeeVO);
        employeeVO.setState(Integer.valueOf(1));
        employeeVO.setDr(BaseVO.DR_UNDELETE);
        employeeVO.setUserId(user.getId());
        employeeVO.setId(user.getId());
        employeeVO.setSequence(Integer.valueOf(1));
        employeeVO.setWorkTime(new Date());
        EmployeeEntity dbEntity = (EmployeeEntity)((Object)BeanMapper.map((Object)employeeVO, EmployeeEntity.class));
        super.saveOrUpdate((Object)dbEntity, false);
        JobEntity job = this.generateJob(employeeVO);
        this.jobService.saveOrUpdate((Object)job, false);
        employeeVO.setJobId(job.getId());
        employeeVO.setOrgId(job.getOrgId());
        employeeVO.setDeptId(job.getDeptId());
        employeeVO.setPostId(job.getPostId());
        return dbEntity;
    }

    public JobEntity generateJob(EmployeeVO employeeVO) {
        JobEntity vo = new JobEntity();
        vo.setProperty(JobVO.JOB_TYPE_MAIN);
        vo.setEmployeeId(employeeVO.getId());
        vo.setCurState(JobVO.STATE_ACTIVE);
        vo.setJobStartTime(employeeVO.getWorkTime());
        vo.setOrgId(employeeVO.getOrgId());
        vo.setDeptId(employeeVO.getDeptId());
        vo.setPostId(employeeVO.getPostId());
        vo.setDr(BaseVO.DR_UNDELETE);
        vo.setTenantId(employeeVO.getTenantId());
        vo.setDeptHead(employeeVO.getDeptHead());
        vo.setRoleIds(employeeVO.getRoleIds());
        vo.setRoleNames(employeeVO.getRoleNames());
        return vo;
    }

    @Override
    @Transactional
    public void writtenOff(JobVO job) {
        EmployeeEntity e = (EmployeeEntity)((Object)((EmployeeMapper)this.baseMapper).selectById(job.getEmployeeId()));
        if (null == e) {
            this.logger.error(String.format("\u4eba\u5458\u4e3b\u952e-{}\u5bf9\u5e94\u7684\u8bb0\u5f55\u4e0d\u5b58\u5728", job.getEmployeeId()));
            throw new BusinessException("\u4eba\u5458\u6ce8\u9500\u5931\u8d25\uff0c\u4eba\u5458\u8bb0\u5f55\u4e0d\u5b58\u5728!");
        }
        JobEntity jobEntity = this.jobService.getById(job.getId());
        if (null == jobEntity) {
            this.logger.error(String.format("\u5f85\u5220\u9664\u7684\u4eba\u5458-{}\u8be5\u4efb\u804c\u8bb0\u5f55\u4e0d\u5b58\u5728", e.getName()));
            throw new BusinessException(String.format("\u5f85\u5220\u9664\u7684\u4eba\u5458-[%s]\u8be5\u4efb\u804c\u8bb0\u5f55\u4e0d\u5b58\u5728", e.getName()));
        }
        if (jobEntity.getProperty().equals(JobVO.JOB_TYPE_MAIN)) {
            throw new BusinessException("\u4e3b\u804c\u4e0d\u5141\u8bb8\u6ce8\u9500\uff01");
        }
        QueryParam roleUserQueryParam = new QueryParam();
        roleUserQueryParam.getParams().put("employeeId", new Parameter("eq", (Object)jobEntity.getEmployeeId()));
        roleUserQueryParam.getParams().put("jobId", new Parameter("eq", (Object)jobEntity.getId()));
        roleUserQueryParam.getParams().put("authOrgId", new Parameter("eq", (Object)jobEntity.getOrgId()));
        List roleUserRelations = this.roleUserRelationService.queryList(roleUserQueryParam, false);
        if (CollectionUtils.isNotEmpty((Collection)roleUserRelations)) {
            this.roleUserRelationService.delete(roleUserRelations.stream().map(r -> r.getId()).collect(Collectors.toList()));
        }
        jobEntity.setCurState(JobVO.STATE_INACTIVE);
        jobEntity.setJobEndTime(new Timestamp(System.currentTimeMillis()));
        this.jobService.saveOrUpdate((Object)jobEntity, false);
        if (job.getDeptId() != null && Objects.equals(job.getDeptHead(), 1)) {
            DeptEntity dept = this.deptService.selectById(job.getDeptId());
            this.jobService.updateDeptHeadNoByDeptId(job.getDeptId());
            dept.setDeptHead(null);
            this.deptService.saveOrUpdate((Object)dept);
        }
    }

    @Override
    public void moveEmployee(Map<String, Object> param) {
        Long orgId = Long.valueOf(param.get("orgId").toString());
        Long deptId = null != param.get("deptId") ? Long.valueOf(param.get("deptId").toString()) : null;
        Long postId = param.get("postId") != null ? Long.valueOf(param.get("postId").toString()) : null;
        Integer deptHead = null != param.get("deptHead") ? Integer.valueOf(param.get("deptHead").toString()) : null;
        this.logger.info("#########{}", param);
        Map relations = null;
        if (param.get("detail") == null) {
            relations = new HashMap();
            List emp = (List)param.get("selectEmployees");
            this.logger.info("emp{}", (Object)JSONObject.toJSONString((Object)emp));
            for (Map map : emp) {
                ArrayList<RoleUserRelationVO> relationVOS = new ArrayList<RoleUserRelationVO>();
                RoleUserRelationVO vo = new RoleUserRelationVO();
                vo.setAuthOrgId(orgId);
                vo.setEmployeeId(Long.valueOf(Long.parseLong((String)map.get("id"))));
                vo.setPostId(postId);
                relationVOS.add(vo);
                relations.put(map.get("id"), relationVOS);
            }
        } else {
            relations = (Map)param.get("detail");
        }
        ArrayList<EmployeeEntity> employeeList = new ArrayList<EmployeeEntity>();
        ArrayList<UserEntity> updateUserList = new ArrayList<UserEntity>();
        ArrayList<UserTenantRelationEntity> userTenantRelationList = new ArrayList<UserTenantRelationEntity>();
        List<RoleUserRelationVO> currentRelation = null;
        JobEntity currentMainJob = null;
        List curEmployeeMainJobs = new ArrayList();
        ArrayList<Long> delRealtionList = new ArrayList<Long>();
        ArrayList<JobEntity> saveJobList = new ArrayList<JobEntity>();
        QueryParam queryParam = null;
        ArrayList<RoleUserRelationVO> saveRelation = new ArrayList<RoleUserRelationVO>();
        List newRelations = null;
        ArrayList curRelationsStr = new ArrayList();
        for (String employeeId : relations.keySet()) {
            newRelations = JSONArray.parseArray((String)JSONArray.toJSONString(relations.get(employeeId)), RoleUserRelationVO.class);
            curRelationsStr.clear();
            QueryWrapper wrapper = new QueryWrapper();
            wrapper.eq((Object)"employee_id", (Object)employeeId);
            wrapper.eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid());
            wrapper.eq((Object)"dr", (Object)0);
            List list = this.userTenantRelationService.list((Wrapper)wrapper);
            Boolean mainSpaceFlag = false;
            UserTenantRelationEntity nowUserTenantRelationEntity = null;
            if (list != null && list.size() > 0) {
                nowUserTenantRelationEntity = (UserTenantRelationEntity)((Object)list.get(0));
                if (((UserTenantRelationEntity)((Object)list.get(0))).getMainSpaceFlag() == 1) {
                    mainSpaceFlag = true;
                    nowUserTenantRelationEntity.setOrgId(orgId);
                    nowUserTenantRelationEntity.setDeptId(deptId);
                    nowUserTenantRelationEntity.setPostId(postId);
                    userTenantRelationList.add(nowUserTenantRelationEntity);
                }
            }
            queryParam = new QueryParam();
            queryParam.getParams().put("employee_id", new Parameter("eq", (Object)Long.valueOf(employeeId)));
            queryParam.getParams().put("property", new Parameter("eq", (Object)JobVO.JOB_TYPE_MAIN));
            queryParam.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
            curEmployeeMainJobs = this.jobService.queryList(queryParam, false);
            for (JobEntity job2 : curEmployeeMainJobs) {
                if (job2.getCurState() != JobVO.STATE_ACTIVE) continue;
                currentMainJob = job2;
                break;
            }
            HashMap<String, Object> p = new HashMap<String, Object>();
            p.put("jobIds", curEmployeeMainJobs.stream().map(job -> job.getId()).collect(Collectors.toList()));
            p.put("tenantId", InvocationInfoProxy.getTenantid());
            currentRelation = this.roleUserRelationService.queryListByProperties(p);
            if (CollectionUtils.isNotEmpty(currentRelation)) {
                curRelationsStr.addAll(currentRelation.stream().map(r -> r.getRoleId() + "_" + r.getAuthOrgId()).collect(Collectors.toList()));
            }
            JobEntity newJob = new JobEntity();
            String projectPost = ((RoleUserRelationVO)newRelations.get(0)).getProjectPost();
            Long projectPostId = ((RoleUserRelationVO)newRelations.get(0)).getProjectPostId();
            Long postIds = ((RoleUserRelationVO)newRelations.get(0)).getPostId() != null ? ((RoleUserRelationVO)newRelations.get(0)).getPostId() : postId;
            this.logger.info("postId{}", (Object)postIds);
            this.generateNewJob(Long.valueOf(employeeId), orgId, deptId, postIds, newJob, JobVO.JOB_TYPE_MAIN, deptHead, projectPost, projectPostId);
            saveJobList.add(newJob);
            if (mainSpaceFlag.booleanValue()) {
                EmployeeEntity employee = (EmployeeEntity)((Object)((EmployeeMapper)this.baseMapper).selectById(((RoleUserRelationVO)newRelations.get(0)).getEmployeeId()));
                employee.setOrgId(orgId);
                employee.setTenantId(InvocationInfoProxy.getTenantid());
                employee.setDeptId(deptId);
                if (postIds != null) {
                    employee.setPostId(postIds);
                } else {
                    employee.setPostId(employee.getPostId());
                }
                employeeList.add(employee);
                UserEntity user = (UserEntity)((Object)this.userService.getById(employee.getUserId()));
                user.setOrgId(orgId);
                user.setTenantId(InvocationInfoProxy.getTenantid());
                updateUserList.add(user);
            }
            for (RoleUserRelationVO newr : newRelations) {
                if (newr.getRoleId() != null) {
                    newJob.setRoleIds(StringUtils.isNotBlank((CharSequence)newJob.getRoleIds()) ? newJob.getRoleIds() + "," + newr.getRoleId().toString() : newr.getRoleId().toString());
                }
                if (StringUtils.isNotBlank((CharSequence)newr.getRoleName())) {
                    newJob.setRoleNames(StringUtils.isNotBlank((CharSequence)newJob.getRoleNames()) ? newJob.getRoleNames() + "," + newr.getRoleName() : newr.getRoleName());
                }
                if (newr.getRoleId() != null && curRelationsStr.contains(newr.getRoleId() + "_" + newr.getAuthOrgId())) {
                    curRelationsStr.remove(newr.getRoleId() + "_" + newr.getAuthOrgId());
                    continue;
                }
                newr.setJobId(newJob.getId());
                newr.setUserId(nowUserTenantRelationEntity.getUserId());
                if (null == newr.getRoleId()) continue;
                saveRelation.add(newr);
            }
            delRealtionList.addAll(currentRelation.stream().filter(r -> curRelationsStr.contains(r.getRoleId() + "_" + r.getAuthOrgId())).map(r -> r.getId()).collect(Collectors.toList()));
            currentMainJob.setCurState(JobVO.STATE_INACTIVE);
            currentMainJob.setJobEndTime(new Timestamp(System.currentTimeMillis()));
            saveJobList.add(currentMainJob);
        }
        EmployeeVO employeeVO = (EmployeeVO)BeanMapper.map(employeeList.get(0), EmployeeVO.class);
        employeeVO.setDeptHead(deptHead);
        this.dealDeptHead(employeeVO, currentMainJob);
        if (employeeList != null && employeeList.size() > 0) {
            for (EmployeeEntity e : employeeList) {
                this.logger.info("\u6570\u636e{},{},{}", new Object[]{e.getId(), e.getName(), e.getPostId()});
            }
            super.saveOrUpdateBatch(employeeList);
        }
        if (saveJobList != null && saveJobList.size() > 0) {
            this.jobService.saveOrUpdateBatch(saveJobList, saveJobList.size(), false);
        }
        if (updateUserList != null && updateUserList.size() > 0) {
            this.userService.saveOrUpdateBatch(updateUserList, updateUserList.size(), false);
        }
        if (userTenantRelationList != null && userTenantRelationList.size() > 0) {
            this.userTenantRelationService.saveOrUpdateBatch(userTenantRelationList, userTenantRelationList.size(), false);
        }
        if (CollectionUtils.isNotEmpty(delRealtionList)) {
            this.roleUserRelationService.delete(delRealtionList);
        }
        if (CollectionUtils.isNotEmpty(saveRelation)) {
            this.roleUserRelationService.saveOrUpdateBatch(BeanMapper.mapList(saveRelation, RoleUserRelationEntity.class), saveRelation.size(), false);
            for (RoleUserRelationVO roleUserRelationVo : saveRelation) {
                this.permissionCacheManager.putOneRoleUsersCache(roleUserRelationVo.getRoleId(), roleUserRelationVo);
            }
        }
    }

    private void generateNewJob(Long employeeId, Long orgId, Long deptId, Long postId, JobEntity newJob, Integer jobType, Integer deptHead, String projectPost, Long projectPostId) {
        newJob.setOrgId(orgId);
        newJob.setDeptId(deptId);
        newJob.setPostId(postId);
        newJob.setJobStartTime(new Timestamp(System.currentTimeMillis()));
        newJob.setCurState(JobVO.STATE_ACTIVE);
        newJob.setProperty(jobType);
        newJob.setEmployeeId(employeeId);
        newJob.setDeptHead(deptHead);
        newJob.setId(IdWorker.getId());
        newJob.setProjectPost(projectPost);
        newJob.setProjectPostId(projectPostId);
        newJob.setOnPost(1);
    }

    @Override
    public void addParttimeJob(Map<String, Object> param) {
        List<JobVO> jobs;
        List<Long> employeeIds;
        Long orgId = Long.valueOf(param.get("orgId").toString());
        Long deptId = null != param.get("deptId") ? Long.valueOf(param.get("deptId").toString()) : null;
        Long postId = null != param.get("postId") ? Long.valueOf(param.get("postId").toString()) : null;
        Integer deptHead = null != param.get("deptHead") ? Integer.valueOf(param.get("deptHead").toString()) : null;
        Map relations = null;
        Set<Object> empIds = new HashSet();
        if (param.get("detail") == null) {
            relations = new HashMap();
            List emp = (List)param.get("selectEmployees");
            this.logger.info("emp{}", (Object)JSONObject.toJSONString((Object)emp));
            for (Map map : emp) {
                ArrayList<RoleUserRelationVO> relationVOS = new ArrayList<RoleUserRelationVO>();
                RoleUserRelationVO vo = new RoleUserRelationVO();
                vo.setAuthOrgId(orgId);
                vo.setPostId(postId);
                vo.setEmployeeId(Long.valueOf(Long.parseLong((String)map.get("id"))));
                relationVOS.add(vo);
                relations.put(map.get("id"), relationVOS);
                empIds.add(Long.parseLong((String)map.get("id")));
            }
        } else {
            relations = (Map)param.get("detail");
            empIds = relations.keySet().stream().map(item -> Long.valueOf(item)).collect(Collectors.toSet());
        }
        if (CollectionUtils.isNotEmpty(employeeIds = (jobs = this.jobService.getAllByEmployeeIdsAndOrgId(new ArrayList<Long>(empIds), orgId)).stream().filter(e -> Integer.valueOf("0").equals(e.getProperty())).map(item -> item.getEmployeeId()).collect(Collectors.toList()))) {
            List<EmployeeEntity> emps = this.getAllByIds(employeeIds);
            throw new BusinessException("\u64cd\u4f5c\u5931\u8d25\uff0c\u4eba\u5458\u3010" + emps.stream().map(item -> item.getName()).collect(Collectors.joining()) + "\u3011\u5728\u6240\u9009\u7ec4\u7ec7\u4e0b\u5df2\u6709\u517c\u804c");
        }
        ArrayList<JobEntity> saveJobList = new ArrayList<JobEntity>();
        ArrayList saveRelations = new ArrayList();
        List rList = null;
        for (String employeeId : relations.keySet()) {
            rList = JSONArray.parseArray((String)JSONArray.toJSONString(relations.get(employeeId)), RoleUserRelationVO.class);
            String projectPost = ((RoleUserRelationVO)rList.get(0)).getProjectPost();
            Long projectPostId = ((RoleUserRelationVO)rList.get(0)).getProjectPostId();
            if (postId == null) {
                postId = ((RoleUserRelationVO)rList.get(0)).getPostId();
            }
            JobEntity newJob = new JobEntity();
            this.generateNewJob(Long.valueOf(employeeId), orgId, deptId, postId, newJob, JobVO.JOB_TYPE_PARTTIME, deptHead, projectPost, projectPostId);
            saveJobList.add(newJob);
            EmployeeEntity employee = (EmployeeEntity)((Object)((EmployeeMapper)this.baseMapper).selectById(Long.valueOf(employeeId)));
            UserEntity user = (UserEntity)((Object)this.userService.getById(employee.getUserId()));
            rList.forEach(relation -> {
                relation.setJobId(newJob.getId());
                relation.setUserId(user.getId());
                if (StringUtils.isNotBlank((CharSequence)relation.getRoleName()) && relation.getRoleId() != null) {
                    newJob.setRoleIds(StringUtils.isNotBlank((CharSequence)newJob.getRoleIds()) ? newJob.getRoleIds() + "," + relation.getRoleId().toString() : relation.getRoleId().toString());
                    newJob.setRoleNames(StringUtils.isNotBlank((CharSequence)newJob.getRoleNames()) ? newJob.getRoleNames() + "," + relation.getRoleName() : relation.getRoleName());
                }
            });
            saveRelations.addAll(rList.stream().filter(item -> null != item.getRoleId()).collect(Collectors.toList()));
        }
        if (deptId != null && Objects.equals(deptHead, 1)) {
            DeptEntity dept = this.deptService.selectById(deptId);
            this.jobService.updateDeptHeadNoByDeptId(deptId);
            if (CollectionUtils.isNotEmpty(saveRelations)) {
                dept.setDeptHead(((RoleUserRelationVO)saveRelations.get(0)).getUserId());
            }
            this.deptService.saveOrUpdate((Object)dept);
        }
        this.jobService.saveOrUpdateBatch(saveJobList, saveJobList.size(), false);
        if (saveRelations != null && saveRelations.size() > 0) {
            this.roleUserRelationService.saveOrUpdateBatch(BeanMapper.mapList(saveRelations, RoleUserRelationEntity.class), saveRelations.size(), false);
            for (RoleUserRelationVO roleUserRelationVo : saveRelations) {
                if (roleUserRelationVo.getRoleId() == null) continue;
                this.permissionCacheManager.putOneRoleUsersCache(roleUserRelationVo.getRoleId(), roleUserRelationVo);
            }
        }
    }

    @Override
    public List<RoleUserRelationVO> getEmployeeRolesRelations(List<Long> employeeIds) {
        List<JobEntity> mainJobs = this.jobService.getEmployeesMainJob(employeeIds, true);
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("employeeIds", employeeIds);
        param.put("jobIds", mainJobs.stream().map(BaseEntity::getId).collect(Collectors.toList()));
        param.put("tenantId", InvocationInfoProxy.getTenantid());
        List<RoleUserRelationVO> relations = this.roleUserRelationService.queryListByProperties(param);
        return relations;
    }

    @Override
    public List<EmployeeEntity> getAllByIds(List<Long> employeeIds) {
        return ((EmployeeMapper)this.baseMapper).selectBatchIds(employeeIds);
    }

    @Override
    @Transactional
    public void enabledEmployeeState(EmployeeVO employeeVo) {
        try {
            Long tenantId;
            this.redissonLocker.lock(employeeVo.getMobilePhone() + "_enabled", TimeUnit.MICROSECONDS, 10);
            Long l = tenantId = InvocationInfoProxy.getTenantid() != null ? InvocationInfoProxy.getTenantid() : employeeVo.getTenantId();
            if (1 == employeeVo.getState()) {
                QueryWrapper wrapper = new QueryWrapper();
                wrapper.eq((Object)"user_id", (Object)employeeVo.getUserId());
                wrapper.eq((Object)"tenant_id", (Object)tenantId);
                wrapper.eq((Object)"state", (Object)0);
                wrapper.eq((Object)"dr", (Object)0);
                List oldList = this.userTenantRelationService.list((Wrapper)wrapper);
                if (oldList.size() == 0) {
                    throw new BusinessException("\u672a\u67e5\u8be2\u5230\u7528\u6237\u79df\u6237\u5173\u7cfb\u4fe1\u606f");
                }
                UserTenantRelationEntity userTenantRelationEntity = (UserTenantRelationEntity)((Object)oldList.get(0));
                if (userTenantRelationEntity.getTypeId() == 1) {
                    throw new BusinessException("\u8d85\u7ea7\u7ba1\u7406\u5458\u4e0d\u80fd\u542f\u505c\u7528");
                }
                userTenantRelationEntity.setState(employeeVo.getState());
                QueryWrapper queryWrapper = new QueryWrapper();
                queryWrapper.eq((Object)"user_id", (Object)employeeVo.getUserId());
                queryWrapper.eq((Object)"state", (Object)1);
                queryWrapper.eq((Object)"dr", (Object)0);
                List enableList = this.userTenantRelationService.list((Wrapper)queryWrapper);
                if (enableList != null && enableList.size() == 0) {
                    userTenantRelationEntity.setMainSpaceFlag(1);
                    EmployeeEntity employee = (EmployeeEntity)((Object)this.selectById(employeeVo.getId()));
                    employee.setState(employeeVo.getState());
                    employee.setTenantId(userTenantRelationEntity.getTenantId());
                    employee.setOrgId(userTenantRelationEntity.getOrgId());
                    employee.setDeptId(userTenantRelationEntity.getDeptId());
                    employee.setPostId(userTenantRelationEntity.getPostId());
                    this.saveOrUpdate((Object)employee, false);
                    UserEntity user = (UserEntity)((Object)this.userService.getById(employeeVo.getUserId()));
                    user.setUserState(employeeVo.getState());
                    user.setTypeId(userTenantRelationEntity.getTypeId());
                    user.setTenantId(userTenantRelationEntity.getTenantId());
                    user.setOrgId(userTenantRelationEntity.getOrgId());
                    this.userService.saveOrUpdate((Object)user, false);
                } else if (enableList == null || enableList.size() > 0) {
                    // empty if block
                }
                this.userTenantRelationService.saveOrUpdate((Object)userTenantRelationEntity, false);
            } else {
                QueryWrapper wrapper = new QueryWrapper();
                wrapper.eq((Object)"user_id", (Object)employeeVo.getUserId());
                wrapper.eq((Object)"tenant_id", (Object)tenantId);
                wrapper.eq((Object)"state", (Object)1);
                wrapper.eq((Object)"dr", (Object)0);
                List oldList = this.userTenantRelationService.list((Wrapper)wrapper);
                if (oldList.size() == 0) {
                    throw new BusinessException("\u672a\u67e5\u8be2\u5230\u7528\u6237\u79df\u6237\u5173\u7cfb\u4fe1\u606f");
                }
                UserTenantRelationEntity userTenantRelationEntity = (UserTenantRelationEntity)((Object)oldList.get(0));
                if (userTenantRelationEntity.getTypeId() == 1) {
                    throw new BusinessException("\u8d85\u7ea7\u7ba1\u7406\u5458\u4e0d\u80fd\u542f\u505c\u7528");
                }
                userTenantRelationEntity.setState(employeeVo.getState());
                QueryWrapper queryWrapper = new QueryWrapper();
                queryWrapper.eq((Object)"user_id", (Object)employeeVo.getUserId());
                queryWrapper.ne((Object)"tenant_id", (Object)tenantId);
                queryWrapper.eq((Object)"state", (Object)1);
                queryWrapper.eq((Object)"dr", (Object)0);
                List enableList = this.userTenantRelationService.list((Wrapper)queryWrapper);
                if (enableList != null && enableList.size() == 0) {
                    userTenantRelationEntity.setMainSpaceFlag(0);
                    EmployeeEntity employee = (EmployeeEntity)((Object)this.selectById(employeeVo.getId()));
                    employee.setState(employeeVo.getState());
                    employee.setTenantId(null);
                    this.saveOrUpdate((Object)employee, false);
                    UserEntity user = (UserEntity)((Object)this.userService.getById(employeeVo.getUserId()));
                    user.setUserState(employeeVo.getState());
                    user.setTenantId(null);
                    this.userService.saveOrUpdate((Object)user, false);
                } else if (enableList != null && enableList.size() > 0 && 1 == userTenantRelationEntity.getMainSpaceFlag()) {
                    userTenantRelationEntity.setMainSpaceFlag(0);
                    UserTenantRelationEntity relation = (UserTenantRelationEntity)((Object)enableList.get(0));
                    relation.setMainSpaceFlag(1);
                    this.userTenantRelationService.saveOrUpdate((Object)relation, false);
                    EmployeeEntity employee = (EmployeeEntity)((Object)this.selectById(employeeVo.getId()));
                    employee.setTenantId(relation.getTenantId());
                    employee.setOrgId(relation.getOrgId());
                    employee.setDeptId(relation.getDeptId());
                    employee.setPostId(relation.getPostId());
                    this.saveOrUpdate((Object)employee, false);
                    UserEntity user = (UserEntity)((Object)this.userService.getById(employeeVo.getUserId()));
                    user.setTenantId(relation.getTenantId());
                    user.setTypeId(relation.getTypeId());
                    user.setOrgId(relation.getOrgId());
                    this.userService.saveOrUpdate((Object)user, false);
                }
                this.userTenantRelationService.saveOrUpdate((Object)userTenantRelationEntity, false);
                if (0 == employeeVo.getState()) {
                    this.jobService.updateStateByEmpId(employeeVo.getId(), 1);
                }
            }
        }
        catch (Exception e) {
            throw new BusinessException(e.getMessage());
        }
        finally {
            this.redissonLocker.unlock(employeeVo.getMobilePhone() + "_enabled");
        }
    }

    @Override
    @Transactional
    public void deleteEmployee(EmployeeVO employeeVo) {
        try {
            this.redissonLocker.lock(employeeVo.getMobilePhone() + "_delete", TimeUnit.MICROSECONDS, 10);
            UserVO userVo = this.userService.selectById(employeeVo.getUserId());
            EmployeeEntity employee = (EmployeeEntity)((Object)super.selectById((Serializable)employeeVo.getId()));
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"user_id", (Object)employeeVo.getUserId());
            queryWrapper.eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid());
            queryWrapper.eq((Object)"dr", (Object)0);
            List userList = this.userTenantRelationService.list((Wrapper)queryWrapper);
            if (userList == null || userList.size() <= 0) {
                QueryParam roleUserQueryParam = new QueryParam();
                roleUserQueryParam.getParams().put("employeeId", new Parameter("eq", (Object)employee.getId()));
                roleUserQueryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
                List roleUserRelations = this.roleUserRelationService.queryList(roleUserQueryParam, false);
                QueryWrapper delWrapper = new QueryWrapper();
                delWrapper.eq((Object)"employee_id", (Object)employee.getId());
                delWrapper.eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid());
                this.roleUserRelationService.remove((Wrapper)delWrapper, false);
                QueryWrapper delJobWrapper = new QueryWrapper();
                delJobWrapper.eq((Object)"employee_id", (Object)employee.getId());
                delJobWrapper.eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid());
                this.jobService.remove((Wrapper)delJobWrapper, false);
                if (roleUserRelations != null && roleUserRelations.size() > 0) {
                    for (RoleUserRelationEntity roleUserRelationEntity : roleUserRelations) {
                        this.permissionCacheManager.removeRoleUsersCache(roleUserRelationEntity.getRoleId(), roleUserRelationEntity.getUserId(), roleUserRelationEntity.getAuthOrgId());
                    }
                }
                QueryWrapper delManageWrapper = new QueryWrapper();
                delManageWrapper.eq((Object)"user_id", (Object)employee.getUserId());
                delManageWrapper.eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid());
                this.userManagerRelationAppService.remove((Wrapper)delManageWrapper, false);
                return;
            }
            UserTenantRelationEntity nowUserTenantRelation = (UserTenantRelationEntity)((Object)userList.get(0));
            if (nowUserTenantRelation.getTypeId().equals(1)) {
                throw new BusinessException(userVo.getUserName() + "\u4e3a\u8d85\u7ea7\u7ba1\u7406\u5458\uff0c\u4e0d\u80fd\u5220\u9664");
            }
            if (userVo.getLastLoginTime() != null) {
                this.logger.error(String.format("\u4eba\u5458-{}\u5df2\u7ecf\u767b\u5f55\u8fc7\u7cfb\u7edf\uff0c\u8d26\u53f7\u6709\u6548\uff0c\u4e0d\u5141\u8bb8\u5220\u9664", employee.getName()));
                throw new BusinessException(String.format("\u5f85\u5220\u9664\u7684\u4eba\u5458-[%s]\u5df2\u7ecf\u767b\u5f55\u8fc7\u7cfb\u7edf\uff0c \u8d26\u53f7\u6709\u6548\uff0c\u4e0d\u5141\u8bb8\u5220\u9664", employee.getName()));
            }
            QueryWrapper wrapper = new QueryWrapper();
            wrapper.eq((Object)"user_id", (Object)employeeVo.getUserId());
            wrapper.ne((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid());
            wrapper.eq((Object)"dr", (Object)0);
            List userTenantList = this.userTenantRelationService.list((Wrapper)wrapper);
            if (userTenantList != null && userTenantList.size() > 0) {
                if (nowUserTenantRelation.getMainSpaceFlag() == 1) {
                    UserTenantRelationEntity enrity = (UserTenantRelationEntity)((Object)userTenantList.get(0));
                    enrity.setMainSpaceFlag(1);
                    this.userTenantRelationService.saveOrUpdate((Object)enrity, false);
                    employee.setTenantId(enrity.getTenantId());
                    employee.setOrgId(enrity.getOrgId());
                    employee.setPostId(enrity.getPostId());
                    employee.setDeptId(enrity.getDeptId());
                    this.saveOrUpdate((Object)employee, false);
                    userVo.setTypeId(enrity.getTypeId());
                    userVo.setOrgId(enrity.getOrgId());
                    userVo.setTenantId(enrity.getTenantId());
                    this.userService.saveOrUpdate(BeanMapper.map((Object)userVo, UserEntity.class), false);
                }
            } else {
                this.employeeMapper.deleteById(employee.getId());
                this.userService.removeById(employee.getUserId(), false);
            }
            QueryParam roleUserQueryParam = new QueryParam();
            roleUserQueryParam.getParams().put("employeeId", new Parameter("eq", (Object)employee.getId()));
            roleUserQueryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
            List roleUserRelations = this.roleUserRelationService.queryList(roleUserQueryParam, false);
            QueryWrapper delWrapper = new QueryWrapper();
            delWrapper.eq((Object)"employee_id", (Object)employee.getId());
            delWrapper.eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid());
            this.roleUserRelationService.remove((Wrapper)delWrapper, false);
            QueryWrapper delJobWrapper = new QueryWrapper();
            delJobWrapper.eq((Object)"employee_id", (Object)employee.getId());
            delJobWrapper.eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid());
            this.jobService.remove((Wrapper)delJobWrapper, false);
            if (roleUserRelations != null && roleUserRelations.size() > 0) {
                for (RoleUserRelationEntity roleUserRelationEntity : roleUserRelations) {
                    this.permissionCacheManager.removeRoleUsersCache(roleUserRelationEntity.getRoleId(), roleUserRelationEntity.getUserId(), roleUserRelationEntity.getAuthOrgId());
                }
            }
            QueryWrapper delManageWrapper = new QueryWrapper();
            delManageWrapper.eq((Object)"user_id", (Object)employee.getUserId());
            delManageWrapper.eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid());
            this.userManagerRelationAppService.remove((Wrapper)delManageWrapper, false);
            this.userTenantRelationService.remove((Wrapper)queryWrapper, false);
            if (employeeVo.getDeptId() != null && Objects.equals(1, employeeVo.getDeptHead())) {
                DeptEntity dept = this.deptService.selectById(employeeVo.getDeptId());
                this.jobService.updateDeptHeadNoByDeptId(employeeVo.getDeptId());
                dept.setDeptHead(null);
                this.deptService.saveOrUpdate((Object)dept);
            }
        }
        catch (Exception e) {
            throw new BusinessException(e.getMessage());
        }
        finally {
            this.redissonLocker.unlock(employeeVo.getMobilePhone() + "_delete");
        }
    }

    @Override
    public EmployeeVO queryEmployeeByUserId(Long userId) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"user_id", (Object)userId);
        List entities = this.employeeMapper.selectList((Wrapper)wrapper);
        if (entities != null && entities.size() > 0) {
            EmployeeVO employeeVO = (EmployeeVO)BeanMapper.map(entities.get(0), EmployeeVO.class);
            return this.getEmployeeDetail(employeeVO);
        }
        return null;
    }

    @Override
    public List<Long> getJobOrgIdsByUserId(Long userId, Long tenantId) {
        List<JobVO> jobEntities = this.jobService.queryAllJobByEmployeeId(userId, tenantId);
        if (ListUtil.isNotEmpty(jobEntities)) {
            return jobEntities.stream().map(JobVO::getOrgId).collect(Collectors.toList());
        }
        return new ArrayList<Long>();
    }

    @Override
    public EmployeeVO detail(Long id) {
        SignEntity signEntity;
        EmployeeEntity entity = (EmployeeEntity)((Object)((EmployeeMapper)this.baseMapper).selectById(id));
        EmployeeVO employeeVO = (EmployeeVO)BeanMapper.map((Object)((Object)entity), EmployeeVO.class);
        JobEntity job = this.jobService.getCurMainJob(id);
        if (job != null) {
            employeeVO.setJobId(job.getId());
            employeeVO.setOrgId(job.getOrgId());
            employeeVO.setDeptId(job.getDeptId());
            employeeVO.setPostId(job.getPostId());
            employeeVO.setDeptHead(job.getDeptHead());
            employeeVO.setRoleIds(job.getRoleIds());
            employeeVO.setRoleNames(job.getRoleNames());
        }
        if ((signEntity = this.signService.getUserDefaultSign(entity.getUserId())) != null && StringUtils.isNotBlank((CharSequence)signEntity.getFileId())) {
            employeeVO.setUserSignatureFileId(Long.valueOf(Long.parseLong(signEntity.getFileId())));
        }
        HashMap<String, Object> queryParam = new HashMap<String, Object>();
        HashMap<String, Long> params = new HashMap<String, Long>();
        params.put("tenantId", InvocationInfoProxy.getTenantid());
        params.put("employeeId", id);
        queryParam.put("params", params);
        List<RoleUserRelationVO> appVO = this.roleUserRelationMapper.queryRoleByEmployeeId(queryParam);
        employeeVO.setRoleDataList(appVO);
        return this.getEmployeeDetail(employeeVO);
    }

    private EmployeeVO getEmployeeDetail(EmployeeVO employeeVO) {
        PostEntity post;
        DeptEntity dept;
        OrgVO org;
        UserVO userVo = this.userService.selectById(employeeVO.getUserId());
        if (userVo != null) {
            employeeVO.setUserCode(userVo.getUserCode());
        }
        Long companyId = null;
        Long deptId = null;
        Long postId = null;
        if (null != employeeVO.getJobId()) {
            companyId = employeeVO.getOrgId();
            deptId = employeeVO.getDeptId();
            postId = employeeVO.getPostId();
        } else if (InvocationInfoProxy.getTenantid() != null) {
            QueryWrapper wrapper = new QueryWrapper();
            wrapper.eq((Object)"user_id", (Object)employeeVO.getUserId());
            wrapper.eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid());
            wrapper.eq((Object)"dr", (Object)0);
            List list = this.userTenantRelationService.list((Wrapper)wrapper);
            companyId = ((UserTenantRelationEntity)((Object)list.get(0))).getOrgId();
            deptId = ((UserTenantRelationEntity)((Object)list.get(0))).getDeptId();
            postId = ((UserTenantRelationEntity)((Object)list.get(0))).getPostId();
        } else {
            companyId = employeeVO.getOrgId();
            deptId = employeeVO.getDeptId();
            postId = employeeVO.getPostId();
        }
        if (null != companyId && null != (org = this.orgService.queryDetail(employeeVO.getOrgId()))) {
            employeeVO.setOrgName(org.getShortName());
        }
        if (null != deptId && null != (dept = this.deptService.selectById(deptId))) {
            employeeVO.setDeptName(dept.getName());
        }
        if (null != postId && null != (post = this.postService.selectById(postId))) {
            employeeVO.setPostName(post.getName());
        }
        return employeeVO;
    }

    @Override
    public IPage<EmployeeJobVO> queryPostEmployeePage(Map<String, Object> paramMap) {
        List<EmployeeJobVO> records = this.employeeMapper.queryPostEmployeeList(paramMap);
        Long count = this.employeeMapper.queryPostEmployeeCount(paramMap);
        Page page = new Page();
        page.setSize(count.longValue());
        page.setTotal(count.longValue());
        page.setRecords(records);
        return page;
    }

    @Override
    public EmployeeVO querySuperEmployeeByTenantId(Long tenantId) {
        return this.employeeMapper.querySuperEmployeeByTenantId(tenantId);
    }

    @Override
    public CommonResponse<String> batchSaveImport(List<EmployeeImportVO> importVOS) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        CommonResponse employeeResponse = this.billCodeApi.getCodeBatchByRuleCode(EMPLOYEE_BILL_CODE, tenantId, importVOS.size());
        List codeList = new ArrayList();
        if (!employeeResponse.isSuccess()) {
            throw new BuilderException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        codeList = (List)employeeResponse.getData();
        ArrayList<EmployeeEntity> employeeEntitys = new ArrayList<EmployeeEntity>();
        ArrayList<JobEntity> jobEntitys = new ArrayList<JobEntity>();
        ArrayList<UserTenantRelationEntity> userTenantRelationEntitys = new ArrayList<UserTenantRelationEntity>();
        for (EmployeeImportVO importVO : importVOS) {
            EmployeeVO employeeVO = new EmployeeVO();
            employeeVO.setName(importVO.getName());
            employeeVO.setOrgId(importVO.getOrgId());
            employeeVO.setDeptId(importVO.getDeptId());
            employeeVO.setMobilePhone(importVO.getMobilePhone());
            employeeVO.setUserCode(importVO.getUserCode());
            employeeVO.setIdcard(importVO.getIdcard());
            if (StringUtils.isNotBlank((CharSequence)importVO.getSex())) {
                employeeVO.setSex(Integer.valueOf("\u7537".equals(importVO.getSex()) ? 1 : ("\u5973".equals(importVO.getSex()) ? 2 : 1)));
            } else {
                employeeVO.setSex(Integer.valueOf(1));
            }
            employeeVO.setEmployeeType(Integer.valueOf(1));
            employeeVO.setState(Integer.valueOf(1));
            employeeVO.setCode((String)codeList.get(importVOS.indexOf(importVO)));
            employeeVO.setTenantId(tenantId);
            employeeVO.setDr(BaseVO.DR_UNDELETE);
            UserVO user = this.userService.generateNewUser(employeeVO);
            if (user == null) {
                throw new BusinessException("\u65b0\u589e\u4eba\u5458\u5931\u8d25\uff0c \u624b\u673a\u53f7\u5df2\u5b58\u5728");
            }
            employeeVO.setUserId(user.getId());
            employeeVO.setId(user.getId());
            QueryWrapper query = new QueryWrapper();
            query.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
            query.eq((Object)"org_id", (Object)employeeVO.getOrgId());
            Integer sequence = this.employeeMapper.selectCount((Wrapper)query);
            employeeVO.setSequence(Integer.valueOf(null == sequence ? 1 : sequence + 1));
            EmployeeEntity dbEntity = (EmployeeEntity)((Object)BeanMapper.map((Object)employeeVO, EmployeeEntity.class));
            employeeEntitys.add(dbEntity);
            JobEntity job = this.generateJob(employeeVO);
            if (null != job) {
                job.setJobStartTime(dbEntity.getWorkTime());
                job.setEmployeeId(dbEntity.getId());
                job.setOrgId(dbEntity.getOrgId());
                job.setPostId(dbEntity.getPostId());
                job.setDeptId(dbEntity.getDeptId());
            }
            jobEntitys.add(job);
            UserTenantRelationEntity relationEntity = new UserTenantRelationEntity();
            relationEntity.setUserId(user.getId());
            relationEntity.setEmployeeId(employeeVO.getId());
            relationEntity.setOrgId(employeeVO.getOrgId());
            relationEntity.setTenantId(employeeVO.getTenantId());
            relationEntity.setPostId(employeeVO.getTenantId());
            relationEntity.setDeptId(employeeVO.getDeptId());
            relationEntity.setMainSpaceFlag(1);
            relationEntity.setTypeId(2);
            relationEntity.setState(1);
            userTenantRelationEntitys.add(relationEntity);
        }
        if (employeeEntitys != null && employeeEntitys.size() > 0) {
            super.saveOrUpdateBatch(employeeEntitys, employeeEntitys.size(), false);
        }
        if (jobEntitys != null && jobEntitys.size() > 0) {
            this.jobService.saveOrUpdateBatch(jobEntitys, jobEntitys.size(), false);
        }
        if (userTenantRelationEntitys != null && userTenantRelationEntitys.size() > 0) {
            this.userTenantRelationService.saveOrUpdateBatch(userTenantRelationEntitys, userTenantRelationEntitys.size(), false);
        }
        return CommonResponse.success((String)"\u5bfc\u5165\u6210\u529f\uff01");
    }

    @Override
    public List<Map<String, String>> getDirectAllByOrgId(Long orgId) {
        return this.employeeMapper.getDirectAllByOrgId(orgId);
    }

    @Override
    public List<Map<String, String>> searchTenantEmployees(Long tenantId, String searchText, Integer limit) {
        return this.employeeMapper.searchTenantEmployees(tenantId, searchText, limit);
    }

    @Override
    public EmployeeVO getByCode(String code) {
        EmployeeVO resp = null;
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"code", (Object)code);
        query.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        EmployeeEntity employee = (EmployeeEntity)((Object)this.employeeMapper.selectOne((Wrapper)query));
        if (null != employee) {
            resp = (EmployeeVO)BeanMapper.map((Object)((Object)employee), EmployeeVO.class);
        }
        return resp;
    }

    @Override
    public List<EmployeeVO> getAllByEmployeeCodes(List<String> employeeCodes) {
        List<Object> resp = new ArrayList<EmployeeVO>();
        QueryWrapper query = new QueryWrapper();
        query.in((Object)"code", employeeCodes);
        query.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        List employees = super.list((Wrapper)query);
        if (null != employees) {
            resp = BeanMapper.mapList((Iterable)employees, EmployeeVO.class);
        }
        return resp;
    }

    @Override
    public List<EmployeeVO> queryByPostNamesAndOrgIds(List<String> postNames, List<Long> orgIds) {
        return ((EmployeeMapper)this.baseMapper).queryByPostNamesAndOrgIds(postNames, orgIds);
    }

    @Override
    public List<EmployeeVO> queryAllEmpDetailByIds(List<Long> ids) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("tenantId", InvocationInfoProxy.getTenantid());
        params.put("jobType", JobVO.JOB_TYPE_MAIN);
        params.put("employeeIds", ids);
        params.put("startLine", 0);
        params.put("pageSize", ids.size());
        return this.employeeMapper.getList(params);
    }

    @Override
    public List<EmployeeVO> getJustByIds(List<Long> ids) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("tenantId", InvocationInfoProxy.getTenantid());
        params.put("employeeIds", ids);
        return this.employeeMapper.getJustByIds(params);
    }

    @Override
    public YnsbjDataInfo saveOrUpdateYnsbjEmployeeInfo(YnsbjEmp ynsbjEmp) {
        YnsbjDataInfo dataInfo = null;
        if ("1".equals(ynsbjEmp.getMainPostFlag())) {
            QueryWrapper employeeWrapper = new QueryWrapper();
            employeeWrapper.eq((Object)"source_id", (Object)ynsbjEmp.getMasterDataCode());
            EmployeeEntity employeeEntity = (EmployeeEntity)((Object)this.employeeMapper.selectOne((Wrapper)employeeWrapper));
            if (employeeEntity != null) {
                Long oldOrgId = employeeEntity.getOrgId();
                Long oldDeptId = employeeEntity.getDeptId();
                String orgName = null;
                if (!employeeEntity.getCode().equals(ynsbjEmp.getEmployeeCode())) {
                    employeeEntity.setCode(ynsbjEmp.getEmployeeCode());
                }
                employeeEntity.setName(ynsbjEmp.getEmployeeName());
                employeeEntity.setMobilePhone(ynsbjEmp.getMobilePhone());
                employeeEntity.setSex(Integer.parseInt(ynsbjEmp.getSex()));
                employeeEntity.setState(Integer.parseInt(ynsbjEmp.getState()));
                employeeEntity.setIdcard(ynsbjEmp.getIdcard());
                String noSyncEmpType = ynsbjEmp.getNoSyncEmpType();
                if (StringUtils.isNotBlank((CharSequence)noSyncEmpType) && employeeEntity.getEmployeeType() != null) {
                    String[] types;
                    String employeeType = employeeEntity.getEmployeeType().toString();
                    for (String type : types = noSyncEmpType.split(",")) {
                        if (!type.equals(employeeType)) continue;
                        this.logger.info("\u5458\u5de5\u4fe1\u606f\u4e0d\u518d\u540c\u6b65\uff0c{}", (Object)JSONObject.toJSONString((Object)((Object)employeeEntity)));
                        return new YnsbjDataInfo(ynsbjEmp.getUuid(), ynsbjEmp.getMasterDataCode(), "0", "\u5458\u5de5\u4fe1\u606f\u4e0d\u9700\u8981\u540c\u6b65");
                    }
                }
                employeeEntity.setEmployeeType(this.getEmployeeType(ynsbjEmp.getEmployeeType()));
                QueryWrapper deptWrapper = new QueryWrapper();
                deptWrapper.eq((Object)"code", (Object)ynsbjEmp.getDeptCode());
                DeptEntity deptEntity = (DeptEntity)((Object)this.deptService.getOne((Wrapper)deptWrapper));
                if (deptEntity != null) {
                    OrgEntity orgEntity;
                    employeeEntity.setOrgId(deptEntity.getOrgId());
                    employeeEntity.setDeptId(deptEntity.getId());
                    if (deptEntity.getOrgId() != null && (orgEntity = (OrgEntity)((Object)this.orgService.selectById(deptEntity.getOrgId()))) != null) {
                        orgName = orgEntity.getName();
                    }
                } else {
                    QueryWrapper orgWrapper = new QueryWrapper();
                    orgWrapper.eq((Object)"code", (Object)ynsbjEmp.getDeptCode());
                    OrgEntity orgEntity = (OrgEntity)((Object)this.orgService.getOne((Wrapper)orgWrapper));
                    if (orgEntity != null) {
                        employeeEntity.setOrgId(orgEntity.getId());
                        orgName = orgEntity.getName();
                    }
                }
                if (employeeEntity.getOrgId() == null) {
                    dataInfo = new YnsbjDataInfo(ynsbjEmp.getUuid(), ynsbjEmp.getMasterDataCode(), "1", "\u5458\u5de5\u6240\u4efb\u804c\u7684\u7ec4\u7ec7\u4e0d\u5b58\u5728");
                    return dataInfo;
                }
                employeeEntity.setSourceId(ynsbjEmp.getMasterDataCode());
                this.saveOrUpdate((Object)employeeEntity, false);
                UserEntity userEntity = (UserEntity)((Object)this.userService.getById(employeeEntity.getUserId()));
                userEntity.setOrgId(employeeEntity.getOrgId());
                userEntity.setUserName(ynsbjEmp.getEmployeeName());
                userEntity.setSex(Integer.parseInt(ynsbjEmp.getSex()));
                userEntity.setUserMobile(ynsbjEmp.getMobilePhone());
                userEntity.setUserEmail(ynsbjEmp.getEmail());
                userEntity.setSourceId(ynsbjEmp.getMasterDataCode());
                if (userEntity.getTypeId() == null) {
                    userEntity.setTypeId(2);
                }
                if (!employeeEntity.getCode().equals(ynsbjEmp.getEmployeeCode())) {
                    userEntity.setUserCode(ynsbjEmp.getEmployeeCode());
                    String password = this.passwordPolicyService.getUserDefaultPassword(999999L);
                    String shaPassword = PasswordUtils.encodePasswordUsingSHA(password);
                    userEntity.setPassword(PasswordUtils.encodePasswordByUserCode(shaPassword, userEntity.getSalt(), userEntity.getUserCode()));
                    userEntity.setPwdStartTime(new Date());
                }
                userEntity.setUserState(Integer.parseInt(ynsbjEmp.getState()));
                this.userService.saveOrUpdate((Object)userEntity, false);
                QueryWrapper wrapper = new QueryWrapper();
                wrapper.eq((Object)"user_id", (Object)userEntity.getId());
                wrapper.eq((Object)"tenant_id", (Object)userEntity.getTenantId());
                wrapper.eq((Object)"dr", (Object)0);
                List list = this.userTenantRelationService.list((Wrapper)wrapper);
                if (list != null && list.size() > 0) {
                    UserTenantRelationEntity userTenantRelationEntity = (UserTenantRelationEntity)((Object)list.get(0));
                    userTenantRelationEntity.setOrgId(employeeEntity.getOrgId());
                    userTenantRelationEntity.setPostId(employeeEntity.getTenantId());
                    userTenantRelationEntity.setDeptId(employeeEntity.getDeptId());
                    userTenantRelationEntity.setState(Integer.parseInt(ynsbjEmp.getState()));
                    this.userTenantRelationService.saveOrUpdate((Object)userTenantRelationEntity, false);
                } else {
                    UserTenantRelationEntity entity = new UserTenantRelationEntity();
                    entity.setUserId(userEntity.getId());
                    entity.setEmployeeId(employeeEntity.getId());
                    entity.setOrgId(employeeEntity.getOrgId());
                    entity.setTenantId(employeeEntity.getTenantId());
                    entity.setPostId(employeeEntity.getTenantId());
                    entity.setDeptId(employeeEntity.getDeptId());
                    entity.setMainSpaceFlag(1);
                    entity.setTypeId(2);
                    entity.setState(1);
                    this.userTenantRelationService.saveOrUpdate((Object)entity, false);
                }
                List<YnsbjEmpJob> ynsbjEmpjobs = ynsbjEmp.getEmpJobs();
                this.dealJob(ynsbjEmpjobs, ynsbjEmp, employeeEntity, oldOrgId, oldDeptId, orgName, true);
            } else {
                Long employeeId;
                Long userId = employeeId = Long.valueOf(IdWorker.getId());
                employeeEntity = new EmployeeEntity();
                employeeEntity.setId(employeeId);
                employeeEntity.setCode(ynsbjEmp.getEmployeeCode());
                employeeEntity.setName(ynsbjEmp.getEmployeeName());
                employeeEntity.setMobilePhone(ynsbjEmp.getMobilePhone());
                employeeEntity.setSex(Integer.parseInt(ynsbjEmp.getSex()));
                employeeEntity.setState(Integer.parseInt(ynsbjEmp.getState()));
                employeeEntity.setIdcard(ynsbjEmp.getIdcard());
                employeeEntity.setEmployeeType(this.getEmployeeType(ynsbjEmp.getEmployeeType()));
                QueryWrapper deptWrapper = new QueryWrapper();
                deptWrapper.eq((Object)"code", (Object)ynsbjEmp.getDeptCode());
                DeptEntity deptEntity = (DeptEntity)((Object)this.deptService.getOne((Wrapper)deptWrapper));
                if (deptEntity != null) {
                    employeeEntity.setOrgId(deptEntity.getOrgId());
                    employeeEntity.setDeptId(deptEntity.getId());
                } else {
                    QueryWrapper orgWrapper = new QueryWrapper();
                    orgWrapper.eq((Object)"code", (Object)ynsbjEmp.getDeptCode());
                    OrgEntity orgEntity = (OrgEntity)((Object)this.orgService.getOne((Wrapper)orgWrapper));
                    if (orgEntity != null) {
                        employeeEntity.setOrgId(orgEntity.getId());
                    }
                }
                if (employeeEntity.getOrgId() == null) {
                    dataInfo = new YnsbjDataInfo(ynsbjEmp.getUuid(), ynsbjEmp.getMasterDataCode(), "1", "\u5458\u5de5\u6240\u4efb\u804c\u7684\u7ec4\u7ec7\u4e0d\u5b58\u5728");
                    return dataInfo;
                }
                employeeEntity.setTenantId(999999L);
                employeeEntity.setUserId(userId);
                employeeEntity.setSourceId(ynsbjEmp.getMasterDataCode());
                this.saveOrUpdate((Object)employeeEntity, false);
                UserEntity userEntity = new UserEntity();
                userEntity.setId(userId);
                userEntity.setOrgId(employeeEntity.getOrgId());
                userEntity.setUserCode(ynsbjEmp.getEmployeeCode());
                userEntity.setUserName(ynsbjEmp.getEmployeeName());
                userEntity.setSex(Integer.parseInt(ynsbjEmp.getSex()));
                userEntity.setUserMobile(ynsbjEmp.getMobilePhone());
                userEntity.setSalt(PasswordUtils.getSalt());
                userEntity.setTypeId(2);
                String password = this.passwordPolicyService.getUserDefaultPassword(999999L);
                String shaPassword = PasswordUtils.encodePasswordUsingSHA(password);
                userEntity.setPassword(PasswordUtils.encodePasswordByUserCode(shaPassword, userEntity.getSalt(), userEntity.getUserCode()));
                userEntity.setPwdStartTime(new Date());
                userEntity.setTenantId(999999L);
                userEntity.setUserState(Integer.parseInt(ynsbjEmp.getState()));
                userEntity.setSourceId(ynsbjEmp.getMasterDataCode());
                this.userService.saveOrUpdate((Object)userEntity, false);
                UserTenantRelationEntity entity = new UserTenantRelationEntity();
                entity.setUserId(userEntity.getId());
                entity.setEmployeeId(employeeEntity.getId());
                entity.setOrgId(employeeEntity.getOrgId());
                entity.setTenantId(employeeEntity.getTenantId());
                entity.setPostId(employeeEntity.getTenantId());
                entity.setDeptId(employeeEntity.getDeptId());
                entity.setMainSpaceFlag(1);
                entity.setTypeId(2);
                entity.setState(1);
                this.userTenantRelationService.saveOrUpdate((Object)entity, false);
                ArrayList<JobEntity> jobList = new ArrayList<JobEntity>();
                JobEntity mainJob = new JobEntity();
                mainJob.setOrgId(employeeEntity.getOrgId());
                mainJob.setDeptId(employeeEntity.getDeptId());
                mainJob.setEmployeeId(employeeEntity.getId());
                mainJob.setProperty(1);
                mainJob.setCurState(0);
                mainJob.setTenantId(999999L);
                mainJob.setJobStartTime(new Date());
                mainJob.setSourceId(ynsbjEmp.getMasterDataCode());
                jobList.add(mainJob);
                this.logger.info("\u65b0\u589e\u517c\u804c\u4fe1\u606f\u6761\u65702-----------------\u300b" + ynsbjEmp.getEmpJobs().size());
                List<YnsbjEmpJob> ynsbjEmpjobs = ynsbjEmp.getEmpJobs();
                if (ynsbjEmpjobs != null && ynsbjEmpjobs.size() > 0) {
                    for (YnsbjEmpJob empJob : ynsbjEmpjobs) {
                        JobEntity partJob = new JobEntity();
                        QueryWrapper jobDeptWrapper = new QueryWrapper();
                        jobDeptWrapper.eq((Object)"code", (Object)empJob.getDeptCode());
                        DeptEntity jobDeptEntity = (DeptEntity)((Object)this.deptService.getOne((Wrapper)jobDeptWrapper));
                        if (jobDeptEntity != null) {
                            partJob.setOrgId(jobDeptEntity.getOrgId());
                            partJob.setDeptId(jobDeptEntity.getId());
                            partJob.setEmployeeId(employeeEntity.getId());
                            partJob.setProperty(0);
                            partJob.setCurState(0);
                            partJob.setTenantId(999999L);
                            partJob.setJobStartTime(new Date());
                            partJob.setSourceId(ynsbjEmp.getMasterDataCode());
                            jobList.add(partJob);
                            continue;
                        }
                        QueryWrapper jobOrgWrapper = new QueryWrapper();
                        jobOrgWrapper.eq((Object)"code", (Object)empJob.getDeptCode());
                        OrgEntity jobOrgEntity = (OrgEntity)((Object)this.orgService.getOne((Wrapper)jobOrgWrapper));
                        if (jobOrgEntity == null) continue;
                        partJob.setOrgId(jobOrgEntity.getId());
                        partJob.setEmployeeId(employeeEntity.getId());
                        partJob.setProperty(0);
                        partJob.setCurState(0);
                        partJob.setTenantId(999999L);
                        partJob.setJobStartTime(new Date());
                        partJob.setSourceId(ynsbjEmp.getMasterDataCode());
                        jobList.add(partJob);
                    }
                }
                this.jobService.saveOrUpdateBatch(jobList);
            }
        } else {
            QueryWrapper employeeWrapper = new QueryWrapper();
            employeeWrapper.eq((Object)"source_id", (Object)ynsbjEmp.getMasterDataCode());
            EmployeeEntity employeeEntity = (EmployeeEntity)((Object)this.employeeMapper.selectOne((Wrapper)employeeWrapper));
            if (employeeEntity != null) {
                Long oldOrgId = employeeEntity.getOrgId();
                Long oldDeptId = employeeEntity.getDeptId();
                String orgName = null;
                if (!employeeEntity.getCode().equals(ynsbjEmp.getEmployeeCode())) {
                    employeeEntity.setCode(ynsbjEmp.getEmployeeCode());
                }
                employeeEntity.setName(ynsbjEmp.getEmployeeName());
                employeeEntity.setMobilePhone(ynsbjEmp.getMobilePhone());
                employeeEntity.setSex(Integer.parseInt(ynsbjEmp.getSex()));
                employeeEntity.setState(Integer.parseInt(ynsbjEmp.getState()));
                employeeEntity.setIdcard(ynsbjEmp.getIdcard());
                employeeEntity.setEmployeeType(this.getEmployeeType(ynsbjEmp.getEmployeeType()));
                QueryWrapper deptWrapper = new QueryWrapper();
                deptWrapper.eq((Object)"code", (Object)ynsbjEmp.getDeptCode());
                DeptEntity deptEntity = (DeptEntity)((Object)this.deptService.getOne((Wrapper)deptWrapper));
                if (deptEntity != null) {
                    OrgEntity orgEntity;
                    employeeEntity.setOrgId(deptEntity.getOrgId());
                    employeeEntity.setDeptId(deptEntity.getId());
                    if (deptEntity.getOrgId() != null && (orgEntity = (OrgEntity)((Object)this.orgService.selectById(deptEntity.getOrgId()))) != null) {
                        orgName = orgEntity.getName();
                    }
                } else {
                    QueryWrapper orgWrapper = new QueryWrapper();
                    orgWrapper.eq((Object)"code", (Object)ynsbjEmp.getDeptCode());
                    OrgEntity orgEntity = (OrgEntity)((Object)this.orgService.getOne((Wrapper)orgWrapper));
                    if (orgEntity != null) {
                        employeeEntity.setOrgId(orgEntity.getId());
                        orgName = orgEntity.getName();
                    }
                }
                if (employeeEntity.getOrgId() == null) {
                    dataInfo = new YnsbjDataInfo(ynsbjEmp.getUuid(), ynsbjEmp.getMasterDataCode(), "1", "\u5458\u5de5\u6240\u4efb\u804c\u7684\u7ec4\u7ec7\u4e0d\u5b58\u5728");
                    return dataInfo;
                }
                employeeEntity.setSourceId(ynsbjEmp.getMasterDataCode());
                this.saveOrUpdate((Object)employeeEntity, false);
                UserEntity userEntity = (UserEntity)((Object)this.userService.getById(employeeEntity.getUserId()));
                userEntity.setOrgId(employeeEntity.getOrgId());
                userEntity.setUserName(ynsbjEmp.getEmployeeName());
                userEntity.setSex(Integer.parseInt(ynsbjEmp.getSex()));
                userEntity.setUserMobile(ynsbjEmp.getMobilePhone());
                if (!employeeEntity.getCode().equals(ynsbjEmp.getEmployeeCode())) {
                    userEntity.setUserCode(ynsbjEmp.getEmployeeCode());
                    String password = this.passwordPolicyService.getUserDefaultPassword(999999L);
                    String shaPassword = PasswordUtils.encodePasswordUsingSHA(password);
                    userEntity.setPassword(PasswordUtils.encodePasswordByUserCode(shaPassword, userEntity.getSalt(), userEntity.getUserCode()));
                    userEntity.setPwdStartTime(new Date());
                    userEntity.setUserState(Integer.parseInt(ynsbjEmp.getState()));
                }
                if (userEntity.getTypeId() == null) {
                    userEntity.setTypeId(2);
                }
                userEntity.setSourceId(ynsbjEmp.getMasterDataCode());
                this.userService.saveOrUpdate((Object)userEntity, false);
                QueryWrapper wrapper = new QueryWrapper();
                wrapper.eq((Object)"user_id", (Object)userEntity.getId());
                wrapper.eq((Object)"tenant_id", (Object)userEntity.getTenantId());
                wrapper.eq((Object)"dr", (Object)0);
                List list = this.userTenantRelationService.list((Wrapper)wrapper);
                if (list != null && list.size() > 0) {
                    UserTenantRelationEntity userTenantRelationEntity = (UserTenantRelationEntity)((Object)list.get(0));
                    userTenantRelationEntity.setOrgId(employeeEntity.getOrgId());
                    userTenantRelationEntity.setPostId(employeeEntity.getTenantId());
                    userTenantRelationEntity.setDeptId(employeeEntity.getDeptId());
                    userTenantRelationEntity.setState(Integer.parseInt(ynsbjEmp.getState()));
                    this.userTenantRelationService.saveOrUpdate((Object)userTenantRelationEntity, false);
                } else {
                    UserTenantRelationEntity entity = new UserTenantRelationEntity();
                    entity.setUserId(userEntity.getId());
                    entity.setEmployeeId(employeeEntity.getId());
                    entity.setOrgId(employeeEntity.getOrgId());
                    entity.setTenantId(employeeEntity.getTenantId());
                    entity.setPostId(employeeEntity.getTenantId());
                    entity.setDeptId(employeeEntity.getDeptId());
                    entity.setMainSpaceFlag(1);
                    entity.setTypeId(2);
                    entity.setState(1);
                    this.userTenantRelationService.saveOrUpdate((Object)entity, false);
                }
                List<YnsbjEmpJob> ynsbjEmpjobs = ynsbjEmp.getEmpJobs();
                this.dealJob(ynsbjEmpjobs, ynsbjEmp, employeeEntity, oldOrgId, oldDeptId, orgName, false);
            } else {
                Long employeeId;
                Long userId = employeeId = Long.valueOf(IdWorker.getId());
                employeeEntity = new EmployeeEntity();
                employeeEntity.setId(employeeId);
                employeeEntity.setCode(ynsbjEmp.getEmployeeCode());
                employeeEntity.setName(ynsbjEmp.getEmployeeName());
                employeeEntity.setMobilePhone(ynsbjEmp.getMobilePhone());
                employeeEntity.setSex(Integer.parseInt(ynsbjEmp.getSex()));
                employeeEntity.setState(Integer.parseInt(ynsbjEmp.getState()));
                employeeEntity.setIdcard(ynsbjEmp.getIdcard());
                employeeEntity.setEmployeeType(this.getEmployeeType(ynsbjEmp.getEmployeeType()));
                QueryWrapper deptWrapper = new QueryWrapper();
                deptWrapper.eq((Object)"code", (Object)ynsbjEmp.getDeptCode());
                DeptEntity deptEntity = (DeptEntity)((Object)this.deptService.getOne((Wrapper)deptWrapper));
                if (deptEntity != null) {
                    employeeEntity.setOrgId(deptEntity.getOrgId());
                    employeeEntity.setDeptId(deptEntity.getId());
                } else {
                    QueryWrapper orgWrapper = new QueryWrapper();
                    orgWrapper.eq((Object)"code", (Object)ynsbjEmp.getDeptCode());
                    OrgEntity orgEntity = (OrgEntity)((Object)this.orgService.getOne((Wrapper)orgWrapper));
                    if (orgEntity != null) {
                        employeeEntity.setOrgId(orgEntity.getId());
                    }
                }
                if (employeeEntity.getOrgId() == null) {
                    dataInfo = new YnsbjDataInfo(ynsbjEmp.getUuid(), ynsbjEmp.getMasterDataCode(), "1", "\u5458\u5de5\u6240\u4efb\u804c\u7684\u7ec4\u7ec7\u4e0d\u5b58\u5728");
                    return dataInfo;
                }
                employeeEntity.setSourceId(ynsbjEmp.getMasterDataCode());
                employeeEntity.setTenantId(999999L);
                employeeEntity.setUserId(userId);
                this.saveOrUpdate((Object)employeeEntity, false);
                UserEntity userEntity = new UserEntity();
                userEntity.setId(userId);
                userEntity.setOrgId(employeeEntity.getOrgId());
                userEntity.setUserCode(ynsbjEmp.getEmployeeCode());
                userEntity.setUserName(ynsbjEmp.getEmployeeName());
                userEntity.setSex(Integer.parseInt(ynsbjEmp.getSex()));
                userEntity.setUserMobile(ynsbjEmp.getMobilePhone());
                userEntity.setSalt(PasswordUtils.getSalt());
                String password = this.passwordPolicyService.getUserDefaultPassword(999999L);
                String shaPassword = PasswordUtils.encodePasswordUsingSHA(password);
                userEntity.setPassword(PasswordUtils.encodePasswordByUserCode(shaPassword, userEntity.getSalt(), userEntity.getUserCode()));
                userEntity.setPwdStartTime(new Date());
                userEntity.setTenantId(999999L);
                userEntity.setUserState(Integer.parseInt(ynsbjEmp.getState()));
                userEntity.setSourceId(ynsbjEmp.getMasterDataCode());
                userEntity.setTypeId(2);
                this.userService.saveOrUpdate((Object)userEntity, false);
                UserTenantRelationEntity entity = new UserTenantRelationEntity();
                entity.setUserId(userEntity.getId());
                entity.setEmployeeId(employeeEntity.getId());
                entity.setOrgId(employeeEntity.getOrgId());
                entity.setTenantId(employeeEntity.getTenantId());
                entity.setPostId(employeeEntity.getTenantId());
                entity.setDeptId(employeeEntity.getDeptId());
                entity.setMainSpaceFlag(1);
                entity.setTypeId(2);
                entity.setState(1);
                this.userTenantRelationService.saveOrUpdate((Object)entity, false);
                ArrayList<JobEntity> jobList = new ArrayList<JobEntity>();
                JobEntity mainJob = new JobEntity();
                mainJob.setOrgId(employeeEntity.getOrgId());
                mainJob.setDeptId(employeeEntity.getDeptId());
                mainJob.setEmployeeId(employeeEntity.getId());
                mainJob.setProperty(1);
                mainJob.setCurState(0);
                mainJob.setTenantId(999999L);
                mainJob.setJobStartTime(new Date());
                mainJob.setSourceId(ynsbjEmp.getMasterDataCode());
                jobList.add(mainJob);
                List<YnsbjEmpJob> ynsbjEmpjobs = ynsbjEmp.getEmpJobs();
                this.logger.info("\u65b0\u589e\u517c\u804c\u4fe1\u606f\u6761\u65704-----------------\u300b" + ynsbjEmp.getEmpJobs().size());
                if (ynsbjEmpjobs != null && ynsbjEmpjobs.size() > 0) {
                    for (YnsbjEmpJob empJob : ynsbjEmpjobs) {
                        JobEntity partJob = new JobEntity();
                        QueryWrapper jobDeptWrapper = new QueryWrapper();
                        jobDeptWrapper.eq((Object)"code", (Object)empJob.getDeptCode());
                        DeptEntity jobDeptEntity = (DeptEntity)((Object)this.deptService.getOne((Wrapper)jobDeptWrapper));
                        if (jobDeptEntity != null) {
                            partJob.setOrgId(jobDeptEntity.getOrgId());
                            partJob.setDeptId(jobDeptEntity.getId());
                            partJob.setEmployeeId(employeeEntity.getId());
                            partJob.setProperty(0);
                            partJob.setCurState(0);
                            partJob.setTenantId(999999L);
                            partJob.setJobStartTime(new Date());
                            partJob.setSourceId(ynsbjEmp.getMasterDataCode());
                            jobList.add(partJob);
                            continue;
                        }
                        QueryWrapper jobOrgWrapper = new QueryWrapper();
                        jobOrgWrapper.eq((Object)"code", (Object)empJob.getDeptCode());
                        OrgEntity jobOrgEntity = (OrgEntity)((Object)this.orgService.getOne((Wrapper)jobOrgWrapper));
                        if (jobOrgEntity == null) continue;
                        partJob.setOrgId(jobOrgEntity.getId());
                        partJob.setEmployeeId(employeeEntity.getId());
                        partJob.setProperty(0);
                        partJob.setCurState(0);
                        partJob.setTenantId(999999L);
                        partJob.setJobStartTime(new Date());
                        partJob.setSourceId(ynsbjEmp.getMasterDataCode());
                        jobList.add(partJob);
                    }
                }
                this.jobService.saveOrUpdateBatch(jobList);
            }
        }
        dataInfo = new YnsbjDataInfo(ynsbjEmp.getUuid(), ynsbjEmp.getMasterDataCode(), "0", "");
        return dataInfo;
    }

    private Integer getEmployeeType(String type) {
        int employeeType = 13;
        if (StringUtils.isEmpty((CharSequence)type)) {
            return employeeType;
        }
        switch (type) {
            case "\u5916\u8058\uff08\u5de5\u52e4\uff09": 
            case "\u5916\u8058\uff08\u7ba1\u7406\uff09": 
            case "\u5916\u8058\u4eba\u5458": 
            case "\u52b3\u52a1\u5916\u5305": {
                employeeType = 7;
                break;
            }
            case "\u52b3\u52a1\u6d3e\u9063": {
                employeeType = 14;
                break;
            }
            case "\u79bb\u804c\u4eba\u5458": {
                employeeType = 2;
                break;
            }
            case "\u653f\u5e9c\u59d4\u6d3e": 
            case "\u505c\u85aa\u7559\u804c\u4eba\u5458": 
            case "\u501f\u8c03\u4eba\u5458": 
            case "\u96c6\u56e2\u5916\u90e8\u5355\u4f4d\u501f\u5165": 
            case "\u501f\u51fa\u96c6\u56e2\u5916\u90e8\u5355\u4f4d": 
            case "\u957f\u671f\u75c5\u4f11\u5047\u4eba\u5458": 
            case "\u5b9e\u4e60\u751f": 
            case "\u96c6\u56e2\u5185\u90e8\u5355\u4f4d\u501f\u5165": 
            case "\u5176\u4ed6\u4e0d\u5728\u5c97\u4eba\u5458": 
            case "\u5f85\u3001\u4e0b\u5c97\u5458\u5de5": 
            case "\u79bb\u9000\u4f11\u6b7b\u4ea1": 
            case "\u975e\u5728\u5c97\u804c\u5de5": 
            case "\u96c6\u56e2\u5916\u90e8\u5355\u4f4d\u501f\u51fa": 
            case "\u5728\u804c\u6b7b\u4ea1": 
            case "\u80a1\u4e1c\u59d4\u6d3e\uff08\u5916\u90e8\uff09": 
            case "\u96c6\u56e2\u5185\u90e8\u5355\u4f4d\u501f\u51fa": {
                break;
            }
            case "\u9000\u4f11\u8fd4\u8058": 
            case "\u5728\u5c97\u804c\u5de5": 
            case "\u5408\u540c\u5236\u5458\u5de5": {
                employeeType = 1;
                break;
            }
            case "\u5185\u9000(\u9000\u51fa\u73b0\u804c\u5c97\u4f4d)": 
            case "\u79bb\u9000\u4f11\u4eba\u5458": 
            case "\u9000\u4f11\u4eba\u5458": 
            case "\u79bb\u4f11\u4eba\u5458": 
            case "\u5185\u9000(\u4e00\u822c\u804c\u5de5)": 
            case "\u5185\u90e8\u9000\u517b\u4eba\u5458": {
                employeeType = 3;
            }
        }
        return employeeType;
    }

    private boolean exitPartJob(Long orgId, Long deptId, List<JobVO> partJobList, Map<Long, JobVO> oldExitJob) {
        boolean exit = false;
        for (JobVO job : partJobList) {
            if (job.getProperty() != 0) continue;
            if (orgId.equals(job.getOrgId())) {
                if (deptId != null) {
                    if (job.getDeptId() != null && deptId.equals(job.getDeptId())) {
                        exit = true;
                    }
                } else if (job.getDeptId() == null) {
                    exit = true;
                }
            }
            if (!exit && !StringUtils.isBlank((CharSequence)job.getSourceId())) continue;
            exit = true;
            oldExitJob.put(job.getId(), job);
            break;
        }
        return exit;
    }

    private void dealJob(List<YnsbjEmpJob> ynsbjEmpjobs, YnsbjEmp ynsbjEmp, EmployeeEntity employeeEntity, Long oldOrgId, Long oldDeptId, String orgName, boolean doDelete) {
        JobVO oldMainJob = new JobVO();
        HashMap<Long, JobVO> oldExitJob = new HashMap<Long, JobVO>();
        List<JobVO> oldJobs = this.jobService.queryAllJobByEmployeeId(employeeEntity.getId(), employeeEntity.getTenantId());
        ArrayList<Object> jobList = new ArrayList<Object>();
        this.logger.info("\u517c\u804c\u4fe1\u606f\u6761\u65701-----------------\u300b" + ynsbjEmp.getEmpJobs().size());
        if (ynsbjEmpjobs != null && ynsbjEmpjobs.size() > 0) {
            for (YnsbjEmpJob empJob : ynsbjEmpjobs) {
                boolean exit;
                JobEntity partJob = new JobEntity();
                QueryWrapper jobDeptWrapper = new QueryWrapper();
                jobDeptWrapper.eq((Object)"code", (Object)empJob.getDeptCode());
                DeptEntity jobDeptEntity = (DeptEntity)((Object)this.deptService.getOne((Wrapper)jobDeptWrapper));
                if (jobDeptEntity != null) {
                    boolean exit2 = this.exitPartJob(jobDeptEntity.getOrgId(), jobDeptEntity.getId(), oldJobs, oldExitJob);
                    if (exit2) continue;
                    partJob.setOrgId(jobDeptEntity.getOrgId());
                    partJob.setDeptId(jobDeptEntity.getId());
                    partJob.setEmployeeId(employeeEntity.getId());
                    partJob.setProperty(0);
                    partJob.setCurState(0);
                    partJob.setJobStartTime(new Date());
                    partJob.setTenantId(999999L);
                    partJob.setSourceId(ynsbjEmp.getMasterDataCode());
                    jobList.add((Object)partJob);
                    continue;
                }
                QueryWrapper jobOrgWrapper = new QueryWrapper();
                jobOrgWrapper.eq((Object)"code", (Object)empJob.getDeptCode());
                OrgEntity jobOrgEntity = (OrgEntity)((Object)this.orgService.getOne((Wrapper)jobOrgWrapper));
                if (jobOrgEntity == null || (exit = this.exitPartJob(jobOrgEntity.getId(), null, oldJobs, oldExitJob))) continue;
                partJob.setOrgId(jobOrgEntity.getId());
                partJob.setEmployeeId(employeeEntity.getId());
                partJob.setProperty(0);
                partJob.setCurState(0);
                partJob.setJobStartTime(new Date());
                partJob.setTenantId(999999L);
                partJob.setSourceId(ynsbjEmp.getMasterDataCode());
                jobList.add((Object)partJob);
            }
        }
        ArrayList<Long> partjobIds = new ArrayList<Long>();
        ArrayList<Long> roleIds = new ArrayList<Long>();
        for (JobVO jobVO : oldJobs) {
            if (jobVO.getProperty() == 1) {
                oldMainJob = jobVO;
                continue;
            }
            if (!doDelete || !StringUtils.isNotBlank((CharSequence)jobVO.getSourceId()) || oldExitJob.get(jobVO.getId()) != null) continue;
            partjobIds.add(jobVO.getId());
            jobVO.setCurState(Integer.valueOf(1));
            jobVO.setJobEndTime(new Date());
            jobList.add(BeanMapper.map((Object)jobVO, JobEntity.class));
        }
        boolean isMoveJob = false;
        if (oldOrgId != null && !oldOrgId.equals(employeeEntity.getOrgId())) {
            isMoveJob = true;
        } else if (oldDeptId != null && employeeEntity.getDeptId() != null && !oldDeptId.equals(employeeEntity.getDeptId())) {
            isMoveJob = true;
        } else if (oldDeptId != null && employeeEntity.getDeptId() == null) {
            isMoveJob = true;
        } else if (oldDeptId == null && employeeEntity.getDeptId() != null) {
            isMoveJob = true;
        }
        if (isMoveJob) {
            JobEntity mainJob = new JobEntity();
            Long mainJobId = IdWorker.getId();
            mainJob.setId(mainJobId);
            mainJob.setOrgId(employeeEntity.getOrgId());
            mainJob.setDeptId(employeeEntity.getDeptId());
            mainJob.setEmployeeId(employeeEntity.getId());
            mainJob.setJobStartTime(new Date());
            mainJob.setProperty(1);
            mainJob.setCurState(0);
            mainJob.setTenantId(999999L);
            mainJob.setSourceId(ynsbjEmp.getMasterDataCode());
            jobList.add((Object)mainJob);
            ArrayList<Long> mainjobIds = new ArrayList<Long>();
            if (oldMainJob != null) {
                oldMainJob.setCurState(Integer.valueOf(1));
                oldMainJob.setJobEndTime(new Date());
                jobList.add(BeanMapper.map((Object)oldMainJob, JobEntity.class));
                mainjobIds.add(oldMainJob.getId());
                partjobIds.add(oldMainJob.getId());
            }
            HashMap<String, Object> params = new HashMap<String, Object>();
            if (mainjobIds != null && mainjobIds.size() > 0) {
                params.put("jobIds", mainjobIds);
                params.put("tenantId", 999999L);
                List<RoleUserRelationVO> roleList = this.roleUserRelationService.queryListByProperties(params);
                if (roleList != null && roleList.size() > 0) {
                    ArrayList<RoleUserRelationVO> addRoleUserList = new ArrayList<RoleUserRelationVO>();
                    for (RoleUserRelationVO vo : roleList) {
                        if (!roleIds.contains(vo.getId())) {
                            roleIds.add(vo.getId());
                        }
                        RoleUserRelationVO add = new RoleUserRelationVO();
                        add.setAuthOrgId(employeeEntity.getOrgId());
                        add.setTenantId(Long.valueOf(999999L));
                        add.setAuthOrgName(orgName);
                        add.setEmployeeId(employeeEntity.getId());
                        add.setEmployeeName(employeeEntity.getName());
                        add.setJobId(mainJobId);
                        add.setProperty("1");
                        add.setRoleId(vo.getRoleId());
                        add.setRoleName(vo.getRoleName());
                        add.setUserId(employeeEntity.getUserId());
                        add.setUserMobile(employeeEntity.getMobilePhone());
                        add.setUserName(employeeEntity.getName());
                        addRoleUserList.add(add);
                    }
                    this.roleUserRelationService.saveRoleUser(addRoleUserList);
                }
            }
        }
        if (partjobIds != null && partjobIds.size() > 0) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("jobIds", partjobIds);
            List<RoleUserRelationVO> roleList = this.roleUserRelationService.queryListByProperties(params);
            if (roleList != null && roleList.size() > 0) {
                for (RoleUserRelationVO vo : roleList) {
                    if (roleIds.contains(vo.getId())) continue;
                    roleIds.add(vo.getId());
                }
            }
        }
        if (roleIds != null && roleIds.size() > 0) {
            this.roleUserRelationService.delete(roleIds);
        }
        if (jobList != null && jobList.size() > 0) {
            this.jobService.saveOrUpdateBatch(jobList);
        }
    }

    @Override
    public void saveOrUpdateGdtyEmployeeInfo(GdtyEmp gdtyEmp) {
        QueryWrapper employeeWrapper = new QueryWrapper();
        employeeWrapper.eq((Object)"source_id", (Object)gdtyEmp.getMasterDataCode());
        EmployeeEntity employeeEntity = (EmployeeEntity)((Object)this.employeeMapper.selectOne((Wrapper)employeeWrapper));
        if (employeeEntity != null) {
            employeeEntity.setCode(gdtyEmp.getEmployeeCode());
            employeeEntity.setName(gdtyEmp.getEmployeeName());
            employeeEntity.setMobilePhone(gdtyEmp.getMobile());
            employeeEntity.setSex(Integer.parseInt(gdtyEmp.getSex()));
            QueryWrapper orgWrapper = new QueryWrapper();
            orgWrapper.eq((Object)"code", (Object)gdtyEmp.getOrgCode());
            OrgEntity orgEntity = (OrgEntity)((Object)this.orgService.getOne((Wrapper)orgWrapper));
            if (orgEntity != null) {
                employeeEntity.setOrgId(orgEntity.getId());
            }
            if (StringUtils.isNotBlank((CharSequence)gdtyEmp.getPostCode())) {
                QueryWrapper postWrapper = new QueryWrapper();
                postWrapper.eq((Object)"code", (Object)gdtyEmp.getPostCode());
                PostEntity postEntity = (PostEntity)((Object)this.postService.getOne((Wrapper)postWrapper));
                if (postEntity != null) {
                    employeeEntity.setPostId(postEntity.getId());
                }
            }
            if (StringUtils.isNotBlank((CharSequence)gdtyEmp.getEmployeeType())) {
                employeeEntity.setEmployeeType(Integer.parseInt(gdtyEmp.getEmployeeType()));
            }
            employeeEntity.setOtherPhone(gdtyEmp.getOtherPhone());
            if (StringUtils.isNotBlank((CharSequence)gdtyEmp.getJobStartTime())) {
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmm");
                try {
                    employeeEntity.setWorkTime(dateFormat.parse(gdtyEmp.getJobStartTime()));
                }
                catch (ParseException postEntity) {
                    // empty catch block
                }
            }
            employeeEntity.setSourceId(gdtyEmp.getMasterDataCode());
            if ("X".equals(gdtyEmp.getZstatus())) {
                employeeEntity.setState(0);
            }
            this.employeeMapper.insert((Object)employeeEntity);
            UserEntity userEntity = (UserEntity)((Object)this.userService.getById(employeeEntity.getUserId()));
            userEntity.setOrgId(employeeEntity.getOrgId());
            userEntity.setUserName(gdtyEmp.getEmployeeName());
            userEntity.setSex(Integer.parseInt(gdtyEmp.getSex()));
            userEntity.setUserMobile(gdtyEmp.getMobile());
            userEntity.setSourceId(gdtyEmp.getMasterDataCode());
            if (userEntity.getTypeId() == null) {
                userEntity.setTypeId(2);
            }
            userEntity.setUserCode(gdtyEmp.getUserCode());
            String password = this.passwordPolicyService.getUserDefaultPassword(999999L);
            String shaPassword = PasswordUtils.encodePasswordUsingSHA(password);
            userEntity.setPassword(PasswordUtils.encodePasswordByUserCode(shaPassword, userEntity.getSalt(), userEntity.getUserCode()));
            userEntity.setPwdStartTime(new Date());
            if ("X".equals(gdtyEmp.getZstatus())) {
                userEntity.setUserState(0);
            }
            this.userService.saveOrUpdate((Object)userEntity, false);
            QueryWrapper wrapper = new QueryWrapper();
            wrapper.eq((Object)"user_id", (Object)userEntity.getId());
            wrapper.eq((Object)"tenant_id", (Object)employeeEntity.getTenantId());
            wrapper.eq((Object)"dr", (Object)0);
            List list = this.userTenantRelationService.list((Wrapper)wrapper);
            if (list != null && list.size() > 0) {
                UserTenantRelationEntity userTenantRelationEntity = (UserTenantRelationEntity)((Object)list.get(0));
                userTenantRelationEntity.setOrgId(employeeEntity.getOrgId());
                userTenantRelationEntity.setPostId(employeeEntity.getTenantId());
                userTenantRelationEntity.setDeptId(employeeEntity.getDeptId());
                this.userTenantRelationService.saveOrUpdate((Object)userTenantRelationEntity, false);
            } else {
                UserTenantRelationEntity entity = new UserTenantRelationEntity();
                entity.setUserId(userEntity.getId());
                entity.setEmployeeId(employeeEntity.getId());
                entity.setOrgId(employeeEntity.getOrgId());
                entity.setTenantId(employeeEntity.getTenantId());
                entity.setPostId(employeeEntity.getTenantId());
                entity.setDeptId(employeeEntity.getDeptId());
                entity.setMainSpaceFlag(1);
                entity.setTypeId(2);
                entity.setState(1);
                this.userTenantRelationService.saveOrUpdate((Object)entity, false);
            }
            QueryWrapper jobWrapper = new QueryWrapper();
            jobWrapper.eq((Object)"employee_id", (Object)employeeEntity.getId());
            jobWrapper.eq((Object)"property", (Object)1);
            JobEntity mainJob = (JobEntity)((Object)this.jobService.getOne((Wrapper)jobWrapper));
            if (mainJob != null) {
                mainJob.setOrgId(employeeEntity.getOrgId());
                mainJob.setDeptId(employeeEntity.getDeptId());
                mainJob.setPostId(employeeEntity.getPostId());
                mainJob.setJobStartTime(employeeEntity.getWorkTime());
                this.jobService.updateById((Object)mainJob);
            } else {
                mainJob = new JobEntity();
                mainJob.setOrgId(employeeEntity.getOrgId());
                mainJob.setDeptId(employeeEntity.getDeptId());
                mainJob.setEmployeeId(employeeEntity.getId());
                mainJob.setPostId(employeeEntity.getPostId());
                mainJob.setJobStartTime(new Date());
                mainJob.setProperty(1);
                mainJob.setCurState(0);
                mainJob.setTenantId(999999L);
                this.jobService.save((Object)mainJob);
            }
        } else {
            Long employeeId;
            Long userId = employeeId = Long.valueOf(IdWorker.getId());
            employeeEntity = new EmployeeEntity();
            employeeEntity.setId(employeeId);
            employeeEntity.setCode(gdtyEmp.getEmployeeCode());
            employeeEntity.setName(gdtyEmp.getEmployeeName());
            employeeEntity.setMobilePhone(gdtyEmp.getMobile());
            employeeEntity.setSex(Integer.parseInt(gdtyEmp.getSex()));
            QueryWrapper orgWrapper = new QueryWrapper();
            orgWrapper.eq((Object)"code", (Object)gdtyEmp.getOrgCode());
            OrgEntity orgEntity = (OrgEntity)((Object)this.orgService.getOne((Wrapper)orgWrapper));
            if (orgEntity != null) {
                employeeEntity.setOrgId(orgEntity.getId());
            }
            if (StringUtils.isNotBlank((CharSequence)gdtyEmp.getPostCode())) {
                QueryWrapper postWrapper = new QueryWrapper();
                postWrapper.eq((Object)"code", (Object)gdtyEmp.getPostCode());
                PostEntity postEntity = (PostEntity)((Object)this.postService.getOne((Wrapper)postWrapper));
                if (postEntity != null) {
                    employeeEntity.setPostId(postEntity.getId());
                }
            }
            if (StringUtils.isNotBlank((CharSequence)gdtyEmp.getEmployeeType())) {
                employeeEntity.setEmployeeType(Integer.parseInt(gdtyEmp.getEmployeeType()));
            }
            employeeEntity.setOtherPhone(gdtyEmp.getOtherPhone());
            if (StringUtils.isNotBlank((CharSequence)gdtyEmp.getJobStartTime())) {
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmm");
                try {
                    employeeEntity.setWorkTime(dateFormat.parse(gdtyEmp.getJobStartTime()));
                }
                catch (ParseException postEntity) {
                    // empty catch block
                }
            }
            employeeEntity.setSourceId(gdtyEmp.getMasterDataCode());
            if ("X".equals(gdtyEmp.getZstatus())) {
                employeeEntity.setState(0);
            }
            employeeEntity.setUserId(userId);
            employeeEntity.setTenantId(999999L);
            this.employeeMapper.insert((Object)employeeEntity);
            UserEntity userEntity = new UserEntity();
            userEntity.setId(userId);
            userEntity.setOrgId(employeeEntity.getOrgId());
            userEntity.setUserName(gdtyEmp.getEmployeeName());
            userEntity.setSex(Integer.parseInt(gdtyEmp.getSex()));
            userEntity.setUserMobile(gdtyEmp.getMobile());
            userEntity.setSourceId(gdtyEmp.getMasterDataCode());
            if (userEntity.getTypeId() == null) {
                userEntity.setTypeId(2);
            }
            userEntity.setUserCode(gdtyEmp.getUserCode());
            String password = this.passwordPolicyService.getUserDefaultPassword(999999L);
            String shaPassword = PasswordUtils.encodePasswordUsingSHA(password);
            userEntity.setPassword(PasswordUtils.encodePasswordByUserCode(shaPassword, userEntity.getSalt(), userEntity.getUserCode()));
            userEntity.setPwdStartTime(new Date());
            if ("X".equals(gdtyEmp.getZstatus())) {
                userEntity.setUserState(0);
            }
            userEntity.setTenantId(999999L);
            this.userService.saveOrUpdate((Object)userEntity, false);
            QueryWrapper wrapper = new QueryWrapper();
            wrapper.eq((Object)"user_id", (Object)userEntity.getId());
            wrapper.eq((Object)"tenant_id", (Object)employeeEntity.getTenantId());
            wrapper.eq((Object)"dr", (Object)0);
            List list = this.userTenantRelationService.list((Wrapper)wrapper);
            if (list != null && list.size() > 0) {
                UserTenantRelationEntity userTenantRelationEntity = (UserTenantRelationEntity)((Object)list.get(0));
                userTenantRelationEntity.setOrgId(employeeEntity.getOrgId());
                userTenantRelationEntity.setPostId(employeeEntity.getTenantId());
                userTenantRelationEntity.setDeptId(employeeEntity.getDeptId());
                this.userTenantRelationService.saveOrUpdate((Object)userTenantRelationEntity, false);
            } else {
                UserTenantRelationEntity entity = new UserTenantRelationEntity();
                entity.setUserId(userEntity.getId());
                entity.setEmployeeId(employeeEntity.getId());
                entity.setOrgId(employeeEntity.getOrgId());
                entity.setTenantId(employeeEntity.getTenantId());
                entity.setPostId(employeeEntity.getTenantId());
                entity.setDeptId(employeeEntity.getDeptId());
                entity.setMainSpaceFlag(1);
                entity.setTypeId(2);
                entity.setState(1);
                this.userTenantRelationService.saveOrUpdate((Object)entity, false);
            }
            JobEntity mainJob = new JobEntity();
            mainJob.setOrgId(employeeEntity.getOrgId());
            mainJob.setDeptId(employeeEntity.getDeptId());
            mainJob.setEmployeeId(employeeEntity.getId());
            mainJob.setPostId(employeeEntity.getPostId());
            mainJob.setJobStartTime(new Date());
            mainJob.setProperty(1);
            mainJob.setCurState(0);
            mainJob.setTenantId(999999L);
            this.jobService.save((Object)mainJob);
        }
    }

    @Override
    public void updateJobType(Map<String, Object> memberInfo) {
        JobEntity jobEntity = (JobEntity)((Object)this.jobService.selectById(Long.valueOf(Long.parseLong(memberInfo.get("jobId").toString()))));
        jobEntity.setProjectPost(memberInfo.get("projectPost").toString());
        jobEntity.setProjectPostId(null != memberInfo.get("projectPostId") ? Long.valueOf(memberInfo.get("projectPostId").toString()) : null);
        jobEntity.setOnPost(Integer.parseInt(memberInfo.get("onPost").toString()));
        this.jobService.saveOrUpdate((Object)jobEntity);
    }

    @Override
    public IPage<EmployeeVO> pageBookList(Map<String, Object> params) {
        Iterator<Object> it;
        Object orgId = params.get("orgId");
        if (orgId != null) {
            OrgVO orgVo = this.orgService.queryDetail(Long.parseLong(orgId.toString()));
            if (orgVo != null) {
                params.put("innerCode", orgVo.getInnerCode());
            } else {
                params.put("deptId", orgId);
            }
        } else {
            return new Page();
        }
        List<Object> voList = new ArrayList();
        Page page = new Page();
        page.setCurrent((long)Integer.valueOf(params.get("pageNumber").toString()).intValue());
        page.setSize((long)Integer.valueOf(params.get("pageSize").toString()).intValue());
        long total = this.employeeMapper.countBook(params);
        page.setTotal(total);
        if (total == 0L) {
            page.setRecords(voList);
            return page;
        }
        long startLine = (page.getCurrent() < 1L ? 0L : page.getCurrent() - 1L) * page.getSize();
        params.put("startLine", startLine);
        params.put("pageSize", page.getSize());
        voList = this.employeeMapper.getBookList(params);
        List<JobEntity> jobList = this.getSubjectionList();
        List<Long> orgIds = jobList.stream().map(JobEntity::getOrgId).collect(Collectors.toList());
        List<OrgEntity> orgList = this.orgService.getAllByIds(orgIds);
        HashMap<Long, String> orgMap = new HashMap<Long, String>();
        QueryParam param = new QueryParam();
        List<Long> employeeIds = voList.stream().map(BaseVO::getId).collect(Collectors.toList());
        List<RoleUserRelationVO> roleUserList = this.roleUserRelationService.queryByEmployeeIdsList(employeeIds);
        for (OrgEntity orgEntity : orgList) {
            orgMap.put(orgEntity.getId(), orgEntity.getName());
        }
        for (EmployeeVO employeeVO : voList) {
            HashMap subjectionMap = new HashMap();
            HashMap directlyOrgListMap = new HashMap();
            HashMap<Long, String> roleMap = new HashMap<Long, String>();
            for (JobEntity job : jobList) {
                if (!employeeVO.getId().equals(job.getEmployeeId())) continue;
                if (job.getProperty().equals(1)) {
                    directlyOrgListMap.put(employeeVO.getOrgId(), orgMap.get(job.getOrgId()));
                    continue;
                }
                subjectionMap.put(employeeVO.getOrgId(), orgMap.get(job.getOrgId()));
            }
            for (RoleUserRelationVO role : roleUserList) {
                if (!role.getEmployeeId().equals(employeeVO.getId())) continue;
                roleMap.put(role.getRoleId(), role.getRoleName());
            }
            employeeVO.setDirectlyOrgList(new ArrayList(directlyOrgListMap.values()));
            employeeVO.setRoleList(new ArrayList(roleMap.values()));
            employeeVO.setSubjectionList(new ArrayList(subjectionMap.values()));
        }
        if (params.containsKey("directlyName")) {
            it = voList.iterator();
            while (it.hasNext()) {
                String string = params.get("directlyName").toString();
                for (String dirName : ((EmployeeVO)it.next()).getDirectlyOrgList()) {
                    if (dirName.contains(string)) continue;
                    it.remove();
                }
            }
        }
        if (params.containsKey("subjectionName")) {
            it = voList.iterator();
            while (it.hasNext()) {
                String string = params.get("subjectionName").toString();
                for (String subName : ((EmployeeVO)it.next()).getSubjectionList()) {
                    if (subName.contains(string)) continue;
                    it.remove();
                }
            }
        }
        if (params.containsKey("roleName")) {
            it = voList.iterator();
            while (it.hasNext()) {
                String string = params.get("roleName").toString();
                for (String roleNames : ((EmployeeVO)it.next()).getRoleList()) {
                    if (string.contains(roleNames)) continue;
                    it.remove();
                }
            }
        }
        page.setRecords(voList);
        return page;
    }

    private List<JobEntity> getSubjectionList() {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid());
        wrapper.eq((Object)"dr", (Object)0);
        List jobList = this.jobMapper.selectList((Wrapper)wrapper);
        return jobList;
    }

    @Override
    public List<EmployeeVO> queryEmployeeByPostAndOrg(List<Long> postIds, List<Long> orgIds) {
        return ((EmployeeMapper)this.baseMapper).queryEmployeeByPostAndOrg(postIds, orgIds);
    }

    @Override
    public void manageUpdateProjectMembers(Map<String, Object> memberInfo) {
        Map relations = (Map)memberInfo.get("detail");
        List rList = null;
        for (String employeeId : relations.keySet()) {
            rList = JSONArray.parseArray((String)JSONArray.toJSONString(relations.get(employeeId)), RoleUserRelationVO.class);
            this.logger.info("rList{}", (Object)rList.size());
            for (RoleUserRelationVO vo : rList) {
                this.logger.info("vo{}", (Object)vo.getJobId());
                JobEntity jobEntity = (JobEntity)((Object)this.jobService.selectById(vo.getJobId()));
                if (jobEntity != null) {
                    jobEntity.setPostId(vo.getPostId());
                }
                this.jobService.saveOrUpdate((Object)jobEntity);
            }
        }
    }

    @Override
    public List<EmployeeVO> getByCodeOrIdcard(List<String> codeOrIdcard) {
        return ((EmployeeMapper)this.baseMapper).getByCodeOrIdcard(codeOrIdcard, InvocationInfoProxy.getTenantid());
    }

    @Override
    public EmployeeVO getOneBySourceId(String sourceId) {
        EmployeeVO resp = null;
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"source_id", (Object)sourceId);
        query.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        EmployeeEntity employee = (EmployeeEntity)((Object)this.employeeMapper.selectOne((Wrapper)query));
        if (null != employee) {
            resp = (EmployeeVO)BeanMapper.map((Object)((Object)employee), EmployeeVO.class);
        }
        return resp;
    }

    @Override
    public List<EmployeeVO> getAllBySourceIds(List<String> sourceIds) {
        List<Object> resp = new ArrayList<EmployeeVO>();
        QueryWrapper query = new QueryWrapper();
        query.in((Object)"source_id", sourceIds);
        query.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        List employees = super.list((Wrapper)query);
        if (CollectionUtils.isNotEmpty((Collection)employees)) {
            resp = BeanMapper.mapList((Iterable)employees, EmployeeVO.class);
        }
        return resp;
    }

    @Override
    public void partJobBeachForZd4(JSONArray array) {
        HashMap<String, PostVO> postCodeMap = new HashMap<String, PostVO>();
        HashSet<String> empSidPostCodeCache = new HashSet<String>();
        if (array != null && array.size() > 0) {
            QueryParam param = new QueryParam();
            param.getParams().put("tenantId", Parameter.getEqInstance((Object)999999L));
            ArrayList<JobEntity> jobEntityList = new ArrayList<JobEntity>();
            for (Object o : array) {
                JSONObject data = JSONObject.parseObject((String)JSONObject.toJSONString(o));
                EmployeeVO employeeVO = this.getOneBySourceId(data.getString("HeadSID"));
                if (empSidPostCodeCache.contains(data.getString("HeadSID") + (null != data.get((Object)"projectDepartmentId") ? data.get((Object)"projectDepartmentId").toString() : "") + data.getString("Title_ID"))) {
                    this.logger.info("\u4e2d\u7535\u56db\u4eba\u5458\u517c\u804c\u4fe1\u606f\u751f\u6210\uff0c\u5f53\u524d\u4eba\u5458[name-{}]\u5728\u5f53\u524d\u7ec4\u7ec7[id-{}]\u4e0b\u5df2\u5b58\u5728\u8be5\u5c97\u4f4d\u3010code-{},name-{}\u3011\u4fe1\u606f\uff0c\u8df3\u8fc7\u6b64\u6761\u6570\u636e\uff01", new Object[]{data.getString("HeadName"), data.get((Object)"projectDepartmentId"), data.getString("Title_ID"), data.getString("Title")});
                    continue;
                }
                empSidPostCodeCache.add(data.getString("HeadSID") + (null != data.get((Object)"projectDepartmentId") ? data.get((Object)"projectDepartmentId").toString() : "") + data.getString("Title_ID"));
                if (employeeVO == null) {
                    this.logger.info("\u4e2d\u7535\u56db\u4eba\u5458\u517c\u804c\u51fa\u9519\uff01\u517c\u804c\u4eba\u5458\u4e0d\u5b58\u5728\uff01{}", (Object)data.toJSONString());
                    continue;
                }
                param.getParams().put("sourceId", Parameter.getEqInstance((Object)data.getString("C_CM_AccountingProjectSet_SuBOID")));
                List entities = this.jobService.queryList(param);
                JobEntity jobEntity = null;
                if (ListUtil.isNotEmpty((List)entities)) {
                    jobEntity = (JobEntity)((Object)entities.get(0));
                    if (null == jobEntity.getOrgId() && null != data.getLong("projectDepartmentId")) {
                        jobEntity.setOrgId(data.getLong("projectDepartmentId"));
                    }
                } else {
                    jobEntity = new JobEntity();
                    jobEntity.setSourceId(data.getString("C_CM_AccountingProjectSet_SuBOID"));
                    jobEntity.setTenantId(999999L);
                    this.generateNewJob(employeeVO.getId(), data.getLong("projectDepartmentId"), null, null, jobEntity, JobVO.JOB_TYPE_PARTTIME, 0, null, null);
                    try {
                        jobEntity.setJobStartTime(DateFormatUtil.parseDate((String)"yyyy-MM-dd'T'HH:mm:ss", (String)data.getString("BeginTime")));
                    }
                    catch (ParseException e) {
                        this.logger.info("\u683c\u5f0f\u5316\u4e2d\u7535\u56db\u4eba\u5458\u517c\u804c\u8d77\u59cb\u65f6\u95f4\u51fa\u9519\uff01{}", (Object)data.toJSONString());
                        e.printStackTrace();
                    }
                }
                PostVO post = null;
                if (StringUtils.isNotBlank((CharSequence)data.getString("Title_ID"))) {
                    post = (PostVO)postCodeMap.get(data.getString("Title_ID"));
                    if (null == post) {
                        post = this.postService.getByCode(data.getString("Title_ID"));
                    }
                    if (null == post) {
                        this.logger.info("\u4e2d\u7535\u56db\u4eba\u5458[id-{}]\u517c\u804c\u51fa\u9519\uff01\u517c\u804c\u4eba\u5458\u5c97\u4f4d[code-{},name-{}]\u4e0d\u5b58\u5728\uff01{}", new Object[]{employeeVO.getId(), data.getString("Title_ID"), data.getString("Title")});
                        continue;
                    }
                    postCodeMap.put(post.getCode(), post);
                    jobEntity.setProjectPostId(post.getId());
                }
                jobEntity.setProjectPost(data.getString("Title"));
                jobEntity.setOnPost(null != data.getInteger("IsScene") ? data.getInteger("IsScene") : 1);
                jobEntityList.add(jobEntity);
            }
            if (ListUtil.isNotEmpty(jobEntityList)) {
                this.jobService.saveOrUpdateBatch(jobEntityList);
            }
        }
    }
}

