/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.orgcenter.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.orgcenter.bean.DeptEntity;
import com.ejianc.foundation.orgcenter.bean.EmployeeEntity;
import com.ejianc.foundation.orgcenter.bean.OrgEntity;
import com.ejianc.foundation.orgcenter.mapper.OrgMapper;
import com.ejianc.foundation.orgcenter.service.IDeptService;
import com.ejianc.foundation.orgcenter.service.IEmployeeService;
import com.ejianc.foundation.orgcenter.service.IJobService;
import com.ejianc.foundation.orgcenter.service.IOrgService;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.permission.service.IRoleAppRelationService;
import com.ejianc.foundation.permission.service.IRoleService;
import com.ejianc.foundation.permission.service.IRoleUserRelationService;
import com.ejianc.foundation.utils.gdty.param.GdtyOrg;
import com.ejianc.foundation.workbench.service.ILayoutOrgRelationService;
import com.ejianc.foundation.workbench.service.ILayoutRoleRelationService;
import com.ejianc.foundation.workbench.service.ILayoutService;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.CamelAndUnderLineConverter;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Service
public class OrgServiceImpl
extends BaseServiceImpl<OrgMapper, OrgEntity>
implements IOrgService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private OrgMapper orgMapper;
    @Autowired
    private IDeptService deptService;
    @Autowired
    private IRoleUserRelationService roleUserRelationService;
    @Autowired
    private IRoleAppRelationService roleAppRelationService;
    @Autowired
    private IRoleService roleService;
    @Autowired
    private ILayoutRoleRelationService layoutRoleRelationService;
    @Autowired
    private ILayoutOrgRelationService layoutOrgRelationService;
    @Autowired
    private ILayoutService layoutService;
    @Autowired
    private IJobService jobService;
    @Autowired
    private IEmployeeService employeeService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public String delAllByOrgId(Long orgId) {
        this.logger.info("\u6267\u884c\u7ec4\u7ec7[id-{}]\u5220\u9664\u64cd\u4f5c------start-----", (Object)orgId);
        String userType = InvocationInfoProxy.getUserType();
        if (!"1".equals(userType)) {
            this.logger.info("\u7ec4\u7ec7\u5220\u9664\u64cd\u4f5c\u7ec8\u6b62\uff0c\u5f53\u524d\u767b\u9646\u4eba[userId-{}]\u65e0\u5220\u9664\u6743\u9650\u3002---------", (Object)InvocationInfoProxy.getUserid());
            return "\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u6267\u884c\u5220\u9664\u64cd\u4f5c\u3002";
        }
        return this.delProjectDepartment(orgId);
    }

    @Override
    public String delSDSJPrjDepartmentByOrgId(Long orgId) {
        this.logger.info("\u6267\u884c\u7ec4\u7ec7[id-{}]\u5220\u9664\u64cd\u4f5c------start-----", (Object)orgId);
        return this.delProjectDepartment(orgId);
    }

    private String delProjectDepartment(Long orgId) {
        OrgEntity orgEntity = (OrgEntity)((Object)super.selectById((Serializable)orgId));
        if (null == orgEntity.getOrgType() || !OrgVO.ORG_TYPE_DEPARTMENT.equals(orgEntity.getOrgType())) {
            this.logger.info("\u7ec4\u7ec7\u5220\u9664\u64cd\u4f5c\u7ec8\u6b62\uff0c\u53ea\u652f\u6301\u5bf9\u9879\u76ee\u90e8\u7684\u5220\u9664\u64cd\u4f5c\u3002---------");
            return "\u5220\u9664\u5931\u8d25\uff0c\u53ea\u80fd\u5220\u9664\u7c7b\u578b\u4e3a\u9879\u76ee\u90e8\u7684\u7ec4\u7ec7\u3002";
        }
        QueryWrapper layoutQuery = new QueryWrapper();
        layoutQuery.eq((Object)"org_id", (Object)orgId);
        layoutQuery.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        List layoutList = this.layoutService.list((Wrapper)layoutQuery);
        ArrayList<Long> layoutIds = new ArrayList<Long>();
        if (CollectionUtils.isNotEmpty((Collection)layoutList)) {
            layoutIds.addAll(layoutList.stream().map(BaseEntity::getId).collect(Collectors.toList()));
        }
        this.layoutOrgRelationService.deleteByOrgIdAndLayoutIds(layoutIds, orgId);
        QueryWrapper roleQuery = new QueryWrapper();
        roleQuery.eq((Object)"org_id", (Object)orgId);
        roleQuery.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        List roleList = this.roleService.list((Wrapper)roleQuery);
        List<Long> roleIds = null;
        if (CollectionUtils.isNotEmpty((Collection)roleList)) {
            roleIds = roleList.stream().map(BaseEntity::getId).collect(Collectors.toList());
            this.roleAppRelationService.delByRoleIds(roleIds);
        }
        if (CollectionUtils.isNotEmpty(roleIds) || CollectionUtils.isNotEmpty(layoutIds)) {
            this.layoutRoleRelationService.delByRoleIdsAndOrgId(roleIds, layoutIds);
        }
        if (CollectionUtils.isNotEmpty(layoutIds)) {
            this.logger.info("\u7ec4\u7ec7\u5220\u9664\uff1a\u5220\u9664\u5bf9\u5e94\u5e03\u5c40[ids-{}]", (Object)StringUtils.join(layoutIds, (String)","));
            this.layoutService.removeByIds(layoutIds);
        }
        QueryWrapper jobQuery = new QueryWrapper();
        jobQuery.eq((Object)"org_id", (Object)orgId);
        jobQuery.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        List jobList = this.jobService.list((Wrapper)jobQuery);
        if (CollectionUtils.isNotEmpty((Collection)jobList)) {
            ArrayList<Long> jobIds = new ArrayList<Long>();
            HashSet employeeIds = new HashSet();
            jobList.stream().forEach(job -> {
                jobIds.add(job.getId());
                if (job.getProperty() == 1) {
                    employeeIds.add(job.getEmployeeId());
                }
            });
            this.roleUserRelationService.deleteByJobIds(jobIds);
            this.logger.info("\u7ec4\u7ec7\u5220\u9664\uff1a\u5220\u9664\u5bf9\u5e94\u4efb\u804c\u8bb0\u5f55[ids-{}]", (Object)StringUtils.join(jobIds, (String)","));
            this.jobService.removeByIds(jobIds);
            if (CollectionUtils.isNotEmpty(employeeIds)) {
                this.logger.info("\u7ec4\u7ec7\u5220\u9664\uff1a\u5220\u9664\u5bf9\u5e94\u4eba\u5458[ids-{}]", (Object)StringUtils.join(employeeIds, (String)","));
                for (Long employeeId : employeeIds) {
                    EmployeeEntity employee = (EmployeeEntity)((Object)this.employeeService.selectById(employeeId));
                    this.employeeService.deleteEmployee((EmployeeVO)BeanMapper.map((Object)((Object)employee), EmployeeVO.class));
                }
            }
        }
        if (CollectionUtils.isNotEmpty(roleIds)) {
            this.logger.info("\u7ec4\u7ec7\u5220\u9664\uff1a\u5220\u9664\u5bf9\u5e94\u89d2\u8272[ids-{}]", (Object)StringUtils.join(roleIds, (String)","));
            this.roleService.delete(roleIds);
        }
        super.removeById((Serializable)orgId, false);
        this.logger.info("\u7ec4\u7ec7\u3010id-{}\u3011\u5220\u9664\u6210\u529f------end-----", (Object)orgId);
        return null;
    }

    @Override
    public List<OrgVO> queryOrgList(Map<String, Object> params) {
        OrgEntity currentEntity;
        if (InvocationInfoProxy.getTenantid() == null) {
            HttpServletRequest request = ((ServletRequestAttributes)Objects.requireNonNull(RequestContextHolder.getRequestAttributes())).getRequest();
            params.put("tenantId", this.getAuthority(request.getHeader("authority")).getLong("tenantid"));
        } else {
            params.put("tenantId", InvocationInfoProxy.getTenantid());
        }
        if (params.get("orgId") != null && (currentEntity = (OrgEntity)((Object)((OrgMapper)this.baseMapper).selectById(Long.valueOf(Long.parseLong(params.get("orgId").toString()))))) != null) {
            if (4 == currentEntity.getOrgType()) {
                this.loopOrgEntityByPid(currentEntity.getParentId(), currentEntity);
            }
            params.put("orgId", currentEntity.getId());
        }
        this.logger.info("\u7ec4\u7ec7\u6811\u67e5\u8be2\u53c2\u6570{}", (Object)JSONObject.toJSONString(params));
        List<OrgVO> list = this.orgMapper.queryOrgList(params);
        return list;
    }

    @Override
    public List<OrgVO> queryOrgList2(Map<String, Object> params) {
        OrgEntity currentEntity;
        if (InvocationInfoProxy.getTenantid() == null) {
            HttpServletRequest request = ((ServletRequestAttributes)Objects.requireNonNull(RequestContextHolder.getRequestAttributes())).getRequest();
            params.put("tenantId", this.getAuthority(request.getHeader("authority")).getLong("tenantid"));
        } else {
            params.put("tenantId", InvocationInfoProxy.getTenantid());
        }
        if (params.get("orgId") != null && (currentEntity = (OrgEntity)((Object)((OrgMapper)this.baseMapper).selectById(Long.valueOf(Long.parseLong(params.get("orgId").toString()))))) != null) {
            if (4 == currentEntity.getOrgType()) {
                this.loopOrgEntityByPid(currentEntity.getParentId(), currentEntity);
            }
            params.put("orgId", currentEntity.getId());
        }
        this.logger.info("\u7ec4\u7ec7\u6811\u67e5\u8be2\u53c2\u6570{}", (Object)JSONObject.toJSONString(params));
        List<OrgVO> list = this.orgMapper.queryOrgList2(params);
        return list;
    }

    @Override
    public List<OrgVO> getDirectChildrenByPid(Long parentId, String searchText) {
        QueryWrapper query = new QueryWrapper();
        OrgEntity parent = null;
        if (null == parentId || StringUtils.isNotEmpty((CharSequence)searchText)) {
            query.eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid());
            if (StringUtils.isEmpty((CharSequence)searchText)) {
                query.isNull((Object)"parent_id");
            }
        } else {
            query.eq((Object)"parent_id", (Object)parentId);
            parent = (OrgEntity)((Object)super.selectById((Serializable)parentId));
        }
        query.eq((Object)"state", (Object)1);
        query.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        if (StringUtils.isNotBlank((CharSequence)searchText)) {
            query.like((Object)"name", (Object)searchText);
        }
        query.orderByAsc((Object[])new String[]{"org_type", "create_time"});
        List list = super.list((Wrapper)query);
        List voList = BeanMapper.mapList((Iterable)list, OrgVO.class);
        if (null != parent && CollectionUtils.isNotEmpty((Collection)voList)) {
            for (OrgVO org : voList) {
                org.setpFName(parent.getName());
                org.setpSName(parent.getShortName());
            }
        }
        return voList;
    }

    @Override
    public OrgEntity queryBySourceId(String sourceId, Long tenantId) {
        QueryParam param = new QueryParam();
        param.getParams().put("sourceId", new Parameter("eq", (Object)sourceId));
        param.getParams().put("tenantId", new Parameter("eq", (Object)tenantId));
        List orgEntities = this.queryList(param, false);
        if (ListUtil.isNotEmpty((List)orgEntities)) {
            return (OrgEntity)((Object)orgEntities.get(0));
        }
        return null;
    }

    @Override
    public List<Map<String, Object>> getSubOrgMaps(Long orgId) {
        return this.orgMapper.getSubOrgMaps(orgId);
    }

    @Override
    public List<Map<String, Object>> findOrgMapsByTenantId(Long tenantId) {
        return this.orgMapper.findOrgMapsByTenantId(tenantId);
    }

    @Override
    public List<OrgEntity> queryListTree(Map<String, Object> params) {
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        query.eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid());
        Iterator<String> iterator = params.keySet().iterator();
        block8: while (iterator.hasNext()) {
            String key;
            switch (key = iterator.next()) {
                case "orgId": {
                    Long orgId = (Long)params.get(key);
                    OrgEntity currentEntity = null;
                    if (orgId != null) {
                        currentEntity = (OrgEntity)((Object)((OrgMapper)this.baseMapper).selectById(orgId));
                    }
                    if (currentEntity == null) continue block8;
                    if (4 == currentEntity.getOrgType()) {
                        this.loopOrgEntityByPid(currentEntity.getParentId(), currentEntity);
                    }
                    query.likeRight((Object)"inner_code", (Object)currentEntity.getInnerCode());
                    continue block8;
                }
                case "orgTypes": {
                    query.in((Object)"org_type", (Collection)((List)params.get("orgTypes")));
                    continue block8;
                }
            }
            query.like((Object)CamelAndUnderLineConverter.humpToLine((String)key), params.get(key));
        }
        query.orderByAsc((Object)"sequence");
        query.orderByDesc((Object)"create_time");
        List eList = ((OrgMapper)this.baseMapper).selectList((Wrapper)query);
        return eList;
    }

    @Override
    public OrgVO queryDetail(Long id) {
        OrgEntity entity = (OrgEntity)((Object)((OrgMapper)this.baseMapper).selectById(id));
        if (entity != null) {
            return (OrgVO)BeanMapper.map((Object)((Object)entity), OrgVO.class);
        }
        return null;
    }

    @Override
    public void delete(Long id) {
        List<OrgVO> defdocDetails = this.queryListByPid(id);
        if (defdocDetails != null && defdocDetails.size() > 0) {
            throw new BusinessException("\u8be5\u7ec4\u7ec7\u6709\u5b50\u8282\u70b9\uff0c\u4e0d\u5141\u8bb8\u5220\u9664");
        }
        QueryParam deptParam = new QueryParam();
        deptParam.getParams().put("orgId", new Parameter("eq", (Object)id));
        List deptList = this.deptService.queryList(deptParam, false);
        if (deptList != null && deptList.size() > 0) {
            throw new BusinessException("\u8be5\u7ec4\u7ec7\u4e0b\u5df2\u7ecf\u6709\u90e8\u95e8\u4e86\uff0c\u4e0d\u5141\u8bb8\u5220\u9664");
        }
        QueryWrapper jobQuery = new QueryWrapper();
        jobQuery.eq((Object)"org_id", (Object)id);
        jobQuery.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        List jobList = this.jobService.list((Wrapper)jobQuery);
        if (jobList != null && jobList.size() > 0) {
            throw new BusinessException("\u8be5\u7ec4\u7ec7\u4e0b\u5df2\u7ecf\u6709\u5458\u5de5\u4e86\uff0c \u4e0d\u5141\u8bb8\u5220\u9664");
        }
        ((OrgMapper)this.baseMapper).deleteById(id);
    }

    @Override
    public List<OrgVO> queryListByPid(Long id) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"parent_id", (Object)id);
        wrapper.eq((Object)"dr", (Object)0);
        List entity = ((OrgMapper)this.baseMapper).selectList((Wrapper)wrapper);
        if (entity != null) {
            return BeanMapper.mapList((Iterable)entity, OrgVO.class);
        }
        return null;
    }

    @Override
    public List<OrgVO> selectByMap(Map<String, Object> map) {
        List entity = ((OrgMapper)this.baseMapper).selectByMap(map);
        return BeanMapper.mapList((Iterable)entity, OrgVO.class);
    }

    @Override
    public List<OrgEntity> getAllByIds(List<Long> ids) {
        return ((OrgMapper)this.baseMapper).selectBatchIds(ids);
    }

    private void loopOrgEntityByPid(Long parentId, OrgEntity result) {
        OrgEntity entity = (OrgEntity)((Object)((OrgMapper)this.baseMapper).selectById(parentId));
        if (4 != entity.getOrgType()) {
            BeanUtils.copyProperties((Object)((Object)entity), (Object)((Object)result));
        } else if (entity.getParentId() != null && entity.getParentId() > 0L) {
            this.loopOrgEntityByPid(entity.getParentId(), result);
        } else {
            BeanUtils.copyProperties((Object)((Object)entity), (Object)((Object)result));
        }
    }

    @Override
    public OrgVO queryUserContextOrg(Long orgId) {
        OrgEntity currentEntity = (OrgEntity)((Object)((OrgMapper)this.baseMapper).selectById(orgId));
        if (currentEntity != null && 4 == currentEntity.getOrgType()) {
            this.loopOrgEntityByPid(currentEntity.getParentId(), currentEntity);
        }
        if (currentEntity != null) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"parent_id", (Object)currentEntity.getId());
            Integer count = ((OrgMapper)this.baseMapper).selectCount((Wrapper)queryWrapper);
            OrgVO orgVo = (OrgVO)BeanMapper.map((Object)((Object)currentEntity), OrgVO.class);
            if (count != null && count > 0) {
                orgVo.setIsParent(Boolean.valueOf(true));
            }
            return orgVo;
        }
        return null;
    }

    @Override
    public OrgVO queryUserContextRootOrg(Long orgId) {
        OrgEntity currentEntity = (OrgEntity)((Object)((OrgMapper)this.baseMapper).selectById(orgId));
        if (currentEntity != null && 4 == currentEntity.getOrgType()) {
            this.loopOrgEntityByPid(currentEntity.getParentId(), currentEntity);
        }
        if (currentEntity != null) {
            OrgVO orgVo = (OrgVO)BeanMapper.map((Object)((Object)currentEntity), OrgVO.class);
            orgVo.setIsParent(Boolean.valueOf(false));
            return orgVo;
        }
        return null;
    }

    @Override
    public List<OrgVO> getAllBySourceIds(List<String> sourceIds) {
        ArrayList<OrgVO> resp = new ArrayList<OrgVO>();
        QueryWrapper query = new QueryWrapper();
        query.in((Object)"source_id", sourceIds);
        query.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        List dbList = super.list((Wrapper)query);
        if (CollectionUtils.isNotEmpty((Collection)dbList)) {
            return BeanMapper.mapList((Iterable)dbList, OrgVO.class);
        }
        return resp;
    }

    @Override
    public List<OrgVO> getSubOrgs(Long orgId, Integer prjstate) {
        List<OrgVO> orgVoList = ((OrgMapper)this.baseMapper).getSubOrgs(orgId, prjstate);
        return orgVoList;
    }

    @Override
    public List<OrgVO> searchOrgs(String searchText, String orgIds, Integer prjstate) {
        ArrayList<OrgVO> orgVos = new ArrayList<OrgVO>();
        if (StringUtils.isNotBlank((CharSequence)orgIds)) {
            String[] orgIdArr;
            for (String orgId : orgIdArr = orgIds.split(",")) {
                OrgEntity entity = (OrgEntity)((Object)((OrgMapper)this.baseMapper).selectById(Long.valueOf(Long.parseLong(orgId))));
                if (entity == null || entity.getName().indexOf(searchText) == -1) continue;
                orgVos.add((OrgVO)BeanMapper.map((Object)((Object)entity), OrgVO.class));
            }
        }
        return orgVos;
    }

    @Override
    public List<OrgVO> queryUserContextOrgList(List<Long> resultList, Integer prjstate) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        StringBuffer orgIds = new StringBuffer();
        if (resultList != null && resultList.size() > 0) {
            for (Long orgId : resultList) {
                orgIds.append(orgId).append(",");
            }
        }
        if (StringUtils.isNotBlank((CharSequence)orgIds)) {
            String orgIdString = orgIds.substring(0, orgIds.length() - 1);
            return this.orgMapper.queryUserContextOrgList(tenantId, orgIdString, prjstate);
        }
        return null;
    }

    @Override
    public List<OrgVO> queryJobOrgs(Long userId) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        List<OrgVO> orgList = this.orgMapper.queryJobOrgsByUserId(userId, tenantId);
        return orgList;
    }

    @Override
    public List<OrgVO> queryAppSubByPid(Long orgId) {
        OrgEntity entity = (OrgEntity)((Object)this.orgMapper.selectById(orgId));
        if (entity != null) {
            List<OrgVO> result = this.orgMapper.queryAppSubByPid(entity.getInnerCode());
            return result;
        }
        return null;
    }

    @Override
    public List<OrgVO> findParentsByOrgId(Long orgId) {
        OrgEntity entity = (OrgEntity)((Object)this.orgMapper.selectById(orgId));
        if (entity != null) {
            List<OrgVO> result = this.orgMapper.queryParentsByOrgId(entity.getInnerCode());
            ArrayList fictitious = new ArrayList();
            if (ListUtil.isNotEmpty(result)) {
                QueryParam param = new QueryParam();
                param.getParams().put("orgType", new Parameter("eq", (Object)4));
                for (OrgVO orgVO : result) {
                    param.getParams().put("parentId", new Parameter("eq", (Object)orgVO.getId()));
                    List orgEntities = this.queryList(param);
                    if (!ListUtil.isNotEmpty((List)orgEntities)) continue;
                    fictitious.addAll(BeanMapper.mapList((Iterable)orgEntities, OrgVO.class));
                }
                for (OrgVO orgVO : fictitious) {
                    boolean has = false;
                    for (OrgVO vo : result) {
                        if (!vo.getId().equals(orgVO.getId())) continue;
                        has = true;
                        break;
                    }
                    if (has) continue;
                    result.add(orgVO);
                }
            }
            return result;
        }
        return null;
    }

    @Override
    public List<OrgVO> findParentsByOrgIdAsc(Long orgId) {
        OrgEntity entity = (OrgEntity)((Object)this.orgMapper.selectById(orgId));
        if (entity != null) {
            List<OrgVO> result = this.orgMapper.queryParentsByOrgIdAsc(entity.getInnerCode());
            return result;
        }
        return null;
    }

    @Override
    public OrgVO findOrgByTenantId(Long tenantId) {
        OrgVO orgVO = new OrgVO();
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"tenant_id", (Object)tenantId);
        wrapper.eq((Object)"dr", (Object)0);
        wrapper.isNull((Object)"parent_id");
        List entity = ((OrgMapper)this.baseMapper).selectList((Wrapper)wrapper);
        if (entity != null && entity.size() > 0) {
            orgVO = (OrgVO)BeanMapper.map(entity.get(0), OrgVO.class);
        }
        return orgVO;
    }

    @Override
    public List<OrgVO> queryOrgListByIds(List<Long> orgIds) {
        String orgIdStr = "";
        for (Long orgId : orgIds) {
            orgIdStr = orgIdStr + orgId + ",";
        }
        if (StringUtils.isNotBlank((CharSequence)orgIdStr)) {
            orgIdStr = orgIdStr.substring(0, orgIdStr.length() - 1);
            List<OrgVO> orgVos = this.orgMapper.queryOrgListByIds(orgIdStr);
            return orgVos;
        }
        return null;
    }

    @Override
    public List<OrgVO> queryAllProjectOrgsByInnerCode(String innerCode) {
        List<OrgVO> orgVos = this.orgMapper.queryAllProjectOrgsByInnerCode(innerCode);
        return orgVos;
    }

    @Override
    public List<OrgVO> queryAllOrgByInnerCodeWithoutProjectDept(String innerCode) {
        List<OrgVO> orgVos = this.orgMapper.queryAllOrgByInnerCodeWithoutProjectDept(innerCode);
        return orgVos;
    }

    @Override
    public void saveOrgAndDept(OrgEntity saveOrgBean) {
        this.orgMapper.insert((Object)saveOrgBean);
        DeptEntity deptEntity = new DeptEntity();
        Long deptPkId = IdWorker.getId();
        deptEntity.setId(deptPkId);
        deptEntity.setOrgId(saveOrgBean.getId());
        deptEntity.setCode(saveOrgBean.getCode());
        deptEntity.setName(saveOrgBean.getName());
        deptEntity.setShortName(saveOrgBean.getShortName());
        deptEntity.setState(1);
        deptEntity.setSequence(saveOrgBean.getSequence());
        deptEntity.setType(1);
        deptEntity.setSourceId(saveOrgBean.getSourceId());
        deptEntity.setTenantId(999999L);
        this.deptService.saveOrUpdate((Object)deptEntity, false);
    }

    @Override
    public void updateOrgAndDept(OrgEntity saveOrgBean) {
        this.orgMapper.updateById((Object)saveOrgBean);
        QueryWrapper deptWrapper = new QueryWrapper();
        deptWrapper.eq((Object)"source_id", (Object)saveOrgBean.getSourceId());
        DeptEntity deptEntity = (DeptEntity)((Object)this.deptService.getOne((Wrapper)deptWrapper));
        if (deptEntity == null) {
            deptEntity = new DeptEntity();
            Long deptPkId = IdWorker.getId();
            deptEntity.setId(deptPkId);
            deptEntity.setOrgId(saveOrgBean.getId());
            deptEntity.setCode(saveOrgBean.getCode());
            deptEntity.setName(saveOrgBean.getName());
            deptEntity.setShortName(saveOrgBean.getShortName());
            deptEntity.setState(1);
            deptEntity.setSequence(saveOrgBean.getSequence());
            deptEntity.setType(1);
            deptEntity.setSourceId(saveOrgBean.getSourceId());
            deptEntity.setTenantId(999999L);
        }
        deptEntity.setState(saveOrgBean.getState());
        this.deptService.saveOrUpdate((Object)deptEntity, false);
    }

    @Override
    public void insertGdtyOrgData(String insertOrgSql) {
        this.orgMapper.insertGdtyOrgData(insertOrgSql);
    }

    @Override
    public List<GdtyOrg> queryGdtyOrgData() {
        List<GdtyOrg> gdtyOrgList = this.orgMapper.queryGdtyOrgData();
        return gdtyOrgList;
    }

    @Override
    public JSONObject getAuthority(String authority) {
        JSONObject object = new JSONObject();
        if (StringUtils.isNotEmpty((CharSequence)authority)) {
            String[] ac;
            for (String s : ac = authority.split(";")) {
                String[] cookieArr = s.split("=");
                String key = StringUtils.trim((String)cookieArr[0]);
                String value = StringUtils.trim((String)cookieArr[1]);
                object.put(key, (Object)value);
            }
        }
        return object;
    }

    @Override
    public List<OrgVO> queryOrgNewList(Map<String, Object> params) {
        OrgEntity currentEntity;
        if (InvocationInfoProxy.getTenantid() == null) {
            HttpServletRequest request = ((ServletRequestAttributes)Objects.requireNonNull(RequestContextHolder.getRequestAttributes())).getRequest();
            params.put("tenantId", this.getAuthority(request.getHeader("authority")).getLong("tenantid"));
        } else {
            params.put("tenantId", InvocationInfoProxy.getTenantid());
        }
        if (params.get("orgId") != null && (currentEntity = (OrgEntity)((Object)((OrgMapper)this.baseMapper).selectById(Long.valueOf(Long.parseLong(params.get("orgId").toString()))))) != null) {
            if (4 == currentEntity.getOrgType()) {
                this.loopOrgEntityByPid(currentEntity.getParentId(), currentEntity);
            }
            params.put("orgId", currentEntity.getId());
        }
        this.logger.info("\u7ec4\u7ec7\u6811\u67e5\u8be2\u53c2\u6570{}", (Object)JSONObject.toJSONString(params));
        List<OrgVO> list = this.orgMapper.queryOrgNewList(params);
        return list;
    }

    @Override
    public List<OrgVO> queryProjectDeptList(Long employeeId, Integer prjstate) {
        List<OrgVO> orgVOList = ((OrgMapper)this.baseMapper).queryProjectDeptList(employeeId, prjstate);
        return orgVOList;
    }
}

