/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.workbench.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.aliyun.dingtalkcontact_1_0.Client;
import com.aliyun.dingtalkcontact_1_0.models.GetUserHeaders;
import com.aliyun.dingtalkcontact_1_0.models.GetUserResponse;
import com.aliyun.dingtalkcontact_1_0.models.GetUserResponseBody;
import com.aliyun.tea.TeaException;
import com.aliyun.teaopenapi.models.Config;
import com.aliyun.teautil.Common;
import com.aliyun.teautil.models.RuntimeOptions;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.dingtalk.api.DefaultDingTalkClient;
import com.dingtalk.api.request.OapiAuthScopesRequest;
import com.dingtalk.api.request.OapiUserListidRequest;
import com.dingtalk.api.request.OapiV2DepartmentListsubRequest;
import com.dingtalk.api.request.OapiV2UserGetRequest;
import com.dingtalk.api.response.OapiAuthScopesResponse;
import com.dingtalk.api.response.OapiUserListidResponse;
import com.dingtalk.api.response.OapiV2DepartmentListsubResponse;
import com.dingtalk.api.response.OapiV2UserGetResponse;
import com.ejianc.foundation.orgcenter.bean.EmployeeEntity;
import com.ejianc.foundation.orgcenter.service.IEmployeeService;
import com.ejianc.foundation.orgcenter.service.IOrgService;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.tenant.bean.DefaultPwdEntity;
import com.ejianc.foundation.tenant.bean.TenantEntity;
import com.ejianc.foundation.tenant.service.IDefaultpwdService;
import com.ejianc.foundation.tenant.service.IEnterpriseService;
import com.ejianc.foundation.tenant.service.ITenantService;
import com.ejianc.foundation.tenant.vo.EnterpriseVO;
import com.ejianc.foundation.usercenter.bean.UserEntity;
import com.ejianc.foundation.usercenter.bean.UserTenantRelationEntity;
import com.ejianc.foundation.usercenter.service.IThirdSystemService;
import com.ejianc.foundation.usercenter.service.IUserService;
import com.ejianc.foundation.usercenter.service.IUserTenantRelationService;
import com.ejianc.foundation.usercenter.util.PasswordUtils;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.foundation.workbench.service.IDdThirdAppService;
import com.ejianc.framework.cache.redissonlock.RedissonLocker;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import com.taobao.api.ApiException;
import com.taobao.api.TaobaoRequest;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import net.logstash.logback.encoder.org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DdThirdAppServiceImpl
implements IDdThirdAppService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IThirdSystemService thirdSystemService;
    @Autowired
    private ITenantService tenantService;
    @Autowired
    private IUserService userService;
    @Autowired
    private IEmployeeService employeeService;
    @Autowired
    private IOrgService orgService;
    @Autowired
    private IUserTenantRelationService userTenantRelationService;
    @Autowired
    private IDefaultpwdService iDefaultpwdService;
    @Autowired
    private IEnterpriseService enterpriseService;
    @Autowired
    private RedissonLocker redissonLocker;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void openApp(JSONObject data) {
        String corpid = data.getString("corp_id");
        JSONObject biz_data = JSON.parseObject((String)data.getString("biz_data"));
        JSONObject auth_scope = JSON.parseObject((String)biz_data.getString("auth_scope"));
        String auth_org_scopes = auth_scope.getString("auth_org_scopes");
        JSONObject auth_corp_info = JSON.parseObject((String)biz_data.getString("auth_corp_info"));
        try {
            this.redissonLocker.lock("ddThirdApp-initTenant-" + corpid, TimeUnit.MICROSECONDS, 10);
            QueryWrapper tenantWrapper = new QueryWrapper();
            tenantWrapper.eq((Object)"dr", (Object)0);
            tenantWrapper.eq((Object)"corpid", (Object)corpid);
            TenantEntity tenantEntity = (TenantEntity)((Object)this.tenantService.getOne((Wrapper)tenantWrapper));
            String suiteTicket = this.thirdSystemService.getThirdAppSuiteTicket("27781002", "ddThirdApp");
            String accessToken = this.thirdSystemService.getDdThirdAppAccessToken(corpid, suiteTicket);
            if (tenantEntity == null) {
                EnterpriseVO enterpriseVO = new EnterpriseVO();
                enterpriseVO.setComboCode("ddApp-init");
                enterpriseVO.setCorpid(corpid);
                enterpriseVO.setName(auth_corp_info.getString("corp_name"));
                JSONObject auth_user_info = JSON.parseObject((String)biz_data.getString("auth_user_info"));
                String userId = auth_user_info.getString("userId");
                JSONObject userInfo = this.getUserInfoById(userId, accessToken);
                enterpriseVO.setUserSourceId(userId);
                enterpriseVO.setUserName(userInfo.getString("name"));
                enterpriseVO.setLegalName(userInfo.getString("name"));
                String mobile = userInfo.get((Object)"mobile") != null && userInfo.getString("mobile") != "" ? userInfo.getString("mobile") : userInfo.getString("userid");
                enterpriseVO.setUserCode(userId);
                enterpriseVO.setTelephone(mobile);
                enterpriseVO.setSourceFrom("ddThirdApp");
                this.enterpriseService.initData(enterpriseVO);
                JSONObject auth_info = JSON.parseObject((String)biz_data.getString("auth_info"));
                JSONArray agent = JSON.parseArray((String)auth_info.getString("agent"));
                if (agent != null && agent.size() > 0) {
                    for (Object item : agent) {
                        JSONObject info = JSONObject.parseObject((String)item.toString());
                        if (!"120489".equals(info.getString("appid"))) continue;
                        JSONArray admin_list = JSON.parseArray((String)info.getString("admin_list"));
                        for (Object admin : admin_list) {
                            if (userId.equals(admin.toString())) continue;
                            JSONObject user = this.getUserInfoById(admin.toString(), accessToken);
                            user.put("corp_id", (Object)corpid);
                            this.saveUser(user, 3);
                        }
                    }
                }
            }
            this.changeAuthUser(auth_org_scopes, corpid, accessToken);
        }
        catch (Exception exception) {
        }
        finally {
            this.redissonLocker.unlock("ddThirdApp-initTenant-" + corpid);
        }
    }

    @Override
    public void changeAuthUser(String authOrgScopes, String corpid, String accessToken) {
        JSONObject data = JSON.parseObject((String)authOrgScopes);
        List<String> users = JSONArray.parseArray((String)data.getString("authed_user"), String.class);
        List depts = JSONArray.parseArray((String)data.getString("authed_dept"), String.class);
        List<Long> deptIds = new ArrayList<Long>();
        QueryWrapper tenantWrapper = new QueryWrapper();
        tenantWrapper.eq((Object)"dr", (Object)0);
        tenantWrapper.eq((Object)"corpid", (Object)corpid);
        TenantEntity tenantEntity = (TenantEntity)((Object)this.tenantService.getOne((Wrapper)tenantWrapper));
        OrgVO orgVO = this.orgService.findOrgByTenantId(tenantEntity.getId());
        if (StringUtils.isBlank((String)accessToken)) {
            Iterator suiteTicket = this.thirdSystemService.getThirdAppSuiteTicket("27781002", "ddThirdApp");
            accessToken = this.thirdSystemService.getDdThirdAppAccessToken(corpid, (String)((Object)suiteTicket));
        }
        this.logger.info("accessToken---------------" + accessToken);
        if (depts != null && depts.size() > 0) {
            for (String string : depts) {
                deptIds.add(Long.parseLong(string));
                deptIds = this.getDeptList(Long.parseLong(string), accessToken, deptIds);
            }
            this.logger.info("\u6388\u6743\u7684\u90e8\u95e8id-----" + ((Object)deptIds).toString());
            for (Long l : deptIds) {
                users = this.getUsersIdByDeptId(l, accessToken, users);
            }
        }
        this.logger.info("\u6388\u6743\u7684\u7528\u6237id-----" + users.toString());
        List<String> disableUsers = this.userService.selectSourceIds(users, tenantEntity.getId(), "disabled");
        new Thread(() -> {
            this.logger.info("myThread1-----");
            if (disableUsers != null && disableUsers.size() > 0) {
                for (String sourceId : disableUsers) {
                    QueryWrapper employeeWrapper = new QueryWrapper();
                    employeeWrapper.eq((Object)"dr", (Object)0);
                    employeeWrapper.eq((Object)"source_id", (Object)sourceId);
                    EmployeeEntity enployeeEntity = (EmployeeEntity)((Object)((Object)((Object)this.employeeService.getOne((Wrapper)employeeWrapper))));
                    EmployeeVO employeeVO = (EmployeeVO)BeanMapper.map((Object)((Object)enployeeEntity), EmployeeVO.class);
                    employeeVO.setTenantId(tenantEntity.getTenantId());
                    employeeVO.setState(Integer.valueOf(1));
                    this.employeeService.enabledEmployeeState(employeeVO);
                }
            }
        }, "myThread1").start();
        List<String> list = this.userService.selectSourceIds(users, tenantEntity.getId(), "exitOther");
        new Thread(() -> {
            this.logger.info("myThread2-----");
            if (exitOtherUsers != null && exitOtherUsers.size() > 0) {
                for (String userId : exitOtherUsers) {
                    UserVO userVO = this.userService.queryUserBySourceId(userId, tenantEntity.getId());
                    UserTenantRelationEntity userTenantRelationEntity = new UserTenantRelationEntity();
                    userTenantRelationEntity.setMainSpaceFlag(0);
                    userTenantRelationEntity.setUserId(userVO.getId());
                    userTenantRelationEntity.setTenantId(tenantEntity.getId());
                    userTenantRelationEntity.setTypeId(2);
                    userTenantRelationEntity.setEmployeeId(userVO.getId());
                    userTenantRelationEntity.setOrgId(orgVO.getId());
                    userTenantRelationEntity.setState(1);
                    this.userTenantRelationService.saveOrUpdate((Object)userTenantRelationEntity, false);
                }
            }
        }, "myThread2").start();
        List<String> exitUsers = this.userService.selectSourceIds(users, null, "exit");
        if (exitUsers != null && exitUsers.size() > 0) {
            ArrayList<String> noExitUsers = new ArrayList<String>();
            for (String userId : users) {
                if (exitUsers.contains(userId)) continue;
                noExitUsers.add(userId);
            }
            String finalAccessToken = accessToken;
            new Thread(() -> {
                this.logger.info("myThread3-----");
                if (noExitUsers != null && noExitUsers.size() > 0) {
                    for (String userId : noExitUsers) {
                        JSONObject userInfo = this.getUserInfoById(userId, finalAccessToken);
                        this.addUser(userInfo, tenantEntity.getId(), orgVO.getId(), 2);
                    }
                }
            }, "myThread3").start();
        }
        List<String> toDisableUsers = this.userService.selectSourceIds(users, tenantEntity.getId(), "toDisabled");
        new Thread(() -> {
            this.logger.info("myThread4-----");
            if (toDisableUsers != null && toDisableUsers.size() > 0) {
                for (String sourceId : toDisableUsers) {
                    QueryWrapper employeeWrapper = new QueryWrapper();
                    employeeWrapper.eq((Object)"dr", (Object)0);
                    employeeWrapper.eq((Object)"source_id", (Object)sourceId);
                    EmployeeEntity enployeeEntity = (EmployeeEntity)((Object)((Object)((Object)this.employeeService.getOne((Wrapper)employeeWrapper))));
                    EmployeeVO employeeVO = (EmployeeVO)BeanMapper.map((Object)((Object)enployeeEntity), EmployeeVO.class);
                    employeeVO.setTenantId(tenantEntity.getTenantId());
                    employeeVO.setState(Integer.valueOf(0));
                    this.employeeService.enabledEmployeeState(employeeVO);
                }
            }
        }, "myThread4").start();
    }

    @Override
    public CommonResponse<String> syncUser(Long tenantId) {
        TenantEntity tenantEntity = (TenantEntity)((Object)this.tenantService.getById(tenantId));
        String corpid = tenantEntity.getCorpid();
        String suiteTicket = this.thirdSystemService.getThirdAppSuiteTicket("27781002", "ddThirdApp");
        String accessToken = this.thirdSystemService.getDdThirdAppAccessToken(corpid, suiteTicket);
        try {
            DefaultDingTalkClient client = new DefaultDingTalkClient("https://oapi.dingtalk.com/auth/scopes");
            OapiAuthScopesRequest req = new OapiAuthScopesRequest();
            req.setHttpMethod("GET");
            OapiAuthScopesResponse rsp = (OapiAuthScopesResponse)client.execute((TaobaoRequest)req, accessToken);
            JSONObject body = JSON.parseObject((String)rsp.getBody());
            this.changeAuthUser(body.getString("auth_org_scopes"), corpid, accessToken);
        }
        catch (Exception e) {
            throw new BusinessException("\u540c\u6b65\u4eba\u5458\u5931\u8d25\uff01");
        }
        return CommonResponse.success((String)"\u540c\u6b65\u4eba\u5458\u6210\u529f");
    }

    @Override
    public void saveUser(JSONObject biz_data, Integer typeId) {
        String userid = biz_data.getString("userid");
        String jobnumber = biz_data.getString("jobnumber");
        String name = biz_data.getString("name");
        String corpid = biz_data.getString("corp_id");
        UserVO userVO = this.userService.queryUserByIdOrSourceId(userid);
        if (userVO != null) {
            if (!name.equals(userVO.getUserName())) {
                UserEntity entity = (UserEntity)((Object)BeanMapper.map((Object)userVO, UserEntity.class));
                entity.setUserName(name);
                EmployeeEntity employeeEntity = (EmployeeEntity)((Object)this.employeeService.selectById(userVO.getId()));
                employeeEntity.setName(name);
                this.userService.saveOrUpdate((Object)entity, false);
                this.employeeService.saveOrUpdate((Object)employeeEntity, false);
            }
        } else {
            QueryWrapper tenantWrapper = new QueryWrapper();
            tenantWrapper.eq((Object)"dr", (Object)0);
            tenantWrapper.eq((Object)"corpid", (Object)corpid);
            TenantEntity tenantEntity = (TenantEntity)((Object)this.tenantService.getOne((Wrapper)tenantWrapper));
            OrgVO orgVO = this.orgService.findOrgByTenantId(tenantEntity.getId());
            JSONObject userInfo = new JSONObject();
            userInfo.put("userid", (Object)userid);
            userInfo.put("name", (Object)name);
            userInfo.put("job_number", (Object)jobnumber);
            userInfo.put("mobile", (Object)userid);
            this.addUser(userInfo, tenantEntity.getId(), orgVO.getId(), typeId);
        }
    }

    @Override
    public void delUser(String biz_id, String corpid) {
        QueryWrapper tenantWrapper = new QueryWrapper();
        tenantWrapper.eq((Object)"dr", (Object)0);
        tenantWrapper.eq((Object)"corpid", (Object)corpid);
        TenantEntity tenantEntity = (TenantEntity)((Object)this.tenantService.getOne((Wrapper)tenantWrapper));
        InvocationInfoProxy.setTenantid((Long)tenantEntity.getId());
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"dr", (Object)0);
        wrapper.eq((Object)"source_id", (Object)biz_id);
        wrapper.eq((Object)"tenant_id", (Object)tenantEntity.getId());
        EmployeeEntity employeeEntity = (EmployeeEntity)((Object)this.employeeService.getOne((Wrapper)wrapper));
        if (employeeEntity != null) {
            this.employeeService.deleteEmployee((EmployeeVO)BeanMapper.map((Object)((Object)employeeEntity), EmployeeVO.class));
        }
    }

    public List<Long> getDeptList(Long deptId, String accessToken, List<Long> deptIds) {
        try {
            DefaultDingTalkClient client = new DefaultDingTalkClient("https://oapi.dingtalk.com/topapi/v2/department/listsub");
            OapiV2DepartmentListsubRequest req = new OapiV2DepartmentListsubRequest();
            if (deptId != null) {
                req.setDeptId(deptId);
            }
            OapiV2DepartmentListsubResponse rsp = (OapiV2DepartmentListsubResponse)client.execute((TaobaoRequest)req, accessToken);
            JSONObject body = JSONObject.parseObject((String)rsp.getBody());
            JSONArray result = JSONArray.parseArray((String)body.getString("result"));
            this.logger.info("\u83b7\u53d6\u4e0b\u7ea7\u90e8\u95e8\u4fe1\u606f--------" + body.toJSONString());
            if (result != null && result.size() > 0) {
                for (Object json : result) {
                    JSONObject item = JSON.parseObject((String)json.toString());
                    Long dept_id = Long.parseLong(item.getString("dept_id"));
                    if (deptIds.contains(dept_id)) continue;
                    deptIds.add(dept_id);
                    this.getDeptList(dept_id, accessToken, deptIds);
                }
            }
        }
        catch (ApiException e) {
            e.printStackTrace();
        }
        return deptIds;
    }

    public List<String> getUsersIdByDeptId(Long deptId, String accessToken, List<String> userIds) {
        try {
            this.logger.info("\u90e8\u95e8deptId--------->" + deptId);
            DefaultDingTalkClient client = new DefaultDingTalkClient("https://oapi.dingtalk.com/topapi/user/listid");
            OapiUserListidRequest req = new OapiUserListidRequest();
            req.setDeptId(deptId);
            OapiUserListidResponse rsp = (OapiUserListidResponse)client.execute((TaobaoRequest)req, accessToken);
            JSONObject body = JSONObject.parseObject((String)rsp.getBody());
            this.logger.info("\u83b7\u53d6\u90e8\u95e8\u4e0b\u4eba\u5458\u4fe1\u606f--------->" + body.toJSONString());
            JSONObject result = JSONObject.parseObject((String)body.getString("result"));
            JSONArray list = JSONArray.parseArray((String)result.getString("userid_list"));
            if (list != null && list.size() > 0) {
                list.forEach(item -> {
                    String userId = item.toString();
                    if (!userIds.contains(userId)) {
                        userIds.add(userId);
                    }
                });
            }
        }
        catch (ApiException e) {
            e.printStackTrace();
        }
        return userIds;
    }

    public JSONObject getUserInfoById(String userid, String accessToken) {
        try {
            this.logger.info("userid----------" + userid);
            DefaultDingTalkClient client = new DefaultDingTalkClient("https://oapi.dingtalk.com/topapi/v2/user/get");
            OapiV2UserGetRequest req = new OapiV2UserGetRequest();
            req.setUserid(userid);
            OapiV2UserGetResponse rsp = (OapiV2UserGetResponse)client.execute((TaobaoRequest)req, accessToken);
            JSONObject body = JSONObject.parseObject((String)rsp.getBody());
            JSONObject result = JSONObject.parseObject((String)body.getString("result"));
            this.logger.info("\u7b2c\u4e00\u6b21\u83b7\u53d6userInfo----------" + result.toJSONString());
            return result;
        }
        catch (ApiException e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public JSONObject getUserInfoByUnionId(String userid, String job_number, String unionId, String accessToken) {
        try {
            this.logger.info("unionId----------" + unionId);
            Config config = new Config();
            config.protocol = "https";
            config.regionId = "central";
            Client client = new Client(config);
            GetUserHeaders getUserHeaders = new GetUserHeaders();
            getUserHeaders.xAcsDingtalkAccessToken = accessToken;
            GetUserResponse rsp = client.getUserWithOptions(unionId, getUserHeaders, new RuntimeOptions());
            GetUserResponseBody body = rsp.getBody();
            JSONObject result = new JSONObject();
            result.put("name", (Object)body.getNick());
            result.put("mobile", (Object)body.getMobile());
            result.put("job_number", (Object)job_number);
            result.put("userid", (Object)userid);
            this.logger.info("\u6700\u7ec8\u7ed3\u679cuserInfo----------" + result);
            return result;
        }
        catch (TeaException err) {
            if (!Common.empty((String)err.code) && Common.empty((String)err.message)) return null;
        }
        catch (Exception _err) {
            TeaException err = new TeaException(_err.getMessage(), (Throwable)_err);
            if (!Common.empty((String)err.code) && Common.empty((String)err.message)) return null;
        }
        return null;
    }

    public void addUser(JSONObject userInfo, Long tenantId, Long orgId, Integer typeId) {
        try {
            String mobile = userInfo.get((Object)"mobile") != null && userInfo.getString("mobile") != "" ? userInfo.getString("mobile") : userInfo.getString("userid");
            UserVO userVO = new UserVO();
            userVO.setId(Long.valueOf(IdWorker.getId()));
            userVO.setUserName(userInfo.getString("name"));
            userVO.setSourceId(userInfo.getString("userid"));
            userVO.setUserMobile(mobile);
            userVO.setTenantId(tenantId);
            DefaultPwdEntity defaultPwdEntity = this.iDefaultpwdService.getUserDefaultPassword(tenantId);
            PasswordUtils.setSalt(userVO);
            String password = defaultPwdEntity.getDefaultpwd();
            String shaPassword = PasswordUtils.encodePasswordUsingSHA(password);
            userVO.setPassword(shaPassword);
            userVO.setPassword(PasswordUtils.encodebyUserCode(userVO));
            userVO.setPwdStartTime(new Date());
            userVO.setEmployeeId(userVO.getId());
            userVO.setUserCode(userInfo.getString("userid"));
            userVO.setUserState(UserVO.USER_STATE_ACTIVE);
            userVO.setTypeId(Integer.valueOf(typeId != null ? typeId : 2));
            userVO.setDr(BaseVO.DR_UNDELETE);
            userVO.setOrgId(orgId);
            UserTenantRelationEntity userTenantRelationEntity = new UserTenantRelationEntity();
            userTenantRelationEntity.setMainSpaceFlag(1);
            userTenantRelationEntity.setUserId(userVO.getId());
            userTenantRelationEntity.setTenantId(tenantId);
            userTenantRelationEntity.setTypeId(typeId != null ? typeId : 2);
            userTenantRelationEntity.setEmployeeId(userVO.getId());
            userTenantRelationEntity.setOrgId(orgId);
            userTenantRelationEntity.setState(1);
            UserEntity userEntity = (UserEntity)((Object)BeanMapper.map((Object)userVO, UserEntity.class));
            EmployeeVO employeeVO = new EmployeeVO();
            employeeVO.setId(userVO.getId());
            employeeVO.setUserId(userVO.getId());
            employeeVO.setSourceId(userInfo.getString("userid"));
            employeeVO.setName(userVO.getUserName());
            employeeVO.setCode(userInfo.getString("userid"));
            employeeVO.setEmployeeType(Integer.valueOf(1));
            employeeVO.setState(Integer.valueOf(1));
            employeeVO.setSex(Integer.valueOf(1));
            if (StringUtils.isBlank((String)userEntity.getUserMobile())) {
                employeeVO.setMobilePhone(userEntity.getSourceId());
            } else {
                employeeVO.setMobilePhone(userEntity.getUserMobile());
            }
            employeeVO.setOrgId(orgId);
            employeeVO.setTenantId(tenantId);
            this.userTenantRelationService.saveOrUpdate((Object)userTenantRelationEntity, false);
            this.employeeService.save(employeeVO, userEntity);
            this.userService.saveOrUpdate((Object)userEntity);
            this.userService.addUserApp(userVO.getId(), tenantId, orgId, typeId, "DDTHIRDAPP-INIT");
        }
        catch (Exception e) {
            this.logger.info("\u65b0\u589e\u7528\u6237\u62a5\u9519----{}", (Throwable)e);
        }
    }
}

