package com.ejianc.foundation.dataCompare.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.dataCompare.entity.DataCompareDetailEntity;
import com.ejianc.foundation.dataCompare.mapper.DataCompareDetailMapper;
import com.ejianc.foundation.dataCompare.service.IDataCompareDetailService;
import com.ejianc.foundation.dataCompare.vo.DataCompareDetailVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.*;

@Service
public class DataCompareDetailServiceImpl extends BaseServiceImpl<DataCompareDetailMapper, DataCompareDetailEntity> implements IDataCompareDetailService {

    private final Logger logger = LoggerFactory.getLogger(getClass());

    private DataCompareDetailMapper mapper;

    @Override
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {

        Long tenantId = InvocationInfoProxy.getTenantid();
        String appId = request.getParameter("appId");
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        List<DataCompareDetailVO> dataList = new ArrayList<>();
        List<DataCompareDetailVO> successList = new ArrayList<>();
        List<DataCompareDetailVO> errorList = new ArrayList<>();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        Map<String,DataCompareDetailVO> map = new HashMap<>();
        if(isFailed) {
            return CommonResponse.error("文件格式不合法");
        }else{
            List<List<String>> result = ExcelReader.readExcel(mf);
            List<String> selfDataIdList = new ArrayList<>();
            List<String> exitList = new ArrayList<>();
            if(result != null && result.size() > 0) {
                for (int i = 1; i < result.size(); i++) {
                    List<String> datas = result.get(i);
                    DataCompareDetailVO vo = new DataCompareDetailVO();
                    vo.setSelfDataId(datas.get(0));
                    vo.setSelfDataCode(datas.get(1));
                    vo.setSelfDataName(datas.get(2));
                    vo.setAbutmentDataId(datas.get(3));
                    vo.setAbutmentDataCode(datas.get(4));
                    vo.setAbutmentDataName(datas.get(5));
                    vo.setNotes(datas.get(6));
                    vo.setAppId(Long.parseLong(appId));
                    if(StringUtils.isBlank(vo.getSelfDataCode())){
                        vo.setId(IdWorker.getId());
                        vo.setErrorMsg("本系统数据编码不能为空！");
                        errorList.add(vo);
                        continue;
                    }
                    if(StringUtils.isBlank(vo.getAbutmentDataCode())){
                        vo.setId(IdWorker.getId());
                        vo.setErrorMsg("对接系统数据编码不能为空！");
                        errorList.add(vo);
                        continue;
                    }
                    if(exitList.contains(vo.getSelfDataId())){
                        vo.setErrorMsg("导入数据中本系统数据id已经存在，请修改！");
                        vo.setId(IdWorker.getId());
                        errorList.add(vo);
                        continue;
                    }
                    exitList.add(vo.getSelfDataId());
                    selfDataIdList.add(vo.getSelfDataId());
                    dataList.add(vo);
                }
                QueryWrapper<DataCompareDetailEntity> selfDataIdWrapper = new QueryWrapper<>();
                selfDataIdWrapper.eq("dr", 0);
                selfDataIdWrapper.eq("app_id", appId);
                selfDataIdWrapper.in("self_data_id", selfDataIdList);
                List<DataCompareDetailEntity> selfDataIdDatas = this.list(selfDataIdWrapper);
                List<String> selfDataIdExitList = new ArrayList<>();
                if(selfDataIdDatas!=null && selfDataIdDatas.size()>0){
                    for (DataCompareDetailEntity selfDataIdData : selfDataIdDatas) {
                        selfDataIdExitList.add(selfDataIdData.getSelfDataId());
                    }
                }

                for (DataCompareDetailVO vo : dataList) {
                    if(selfDataIdExitList.contains(vo.getSelfDataId())){
                        vo.setErrorMsg("本系统数据编码在数据库中已经存在！");
                        vo.setId(IdWorker.getId());
                        errorList.add(vo);
                        continue;
                    }
                    successList.add(vo);
                }
            }
        }

        JSONObject json = new JSONObject();
        json.put("successNum", successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", errorList.size());
        return CommonResponse.success(json);
    }
}
