package com.ejianc.foundation.oms.service.impl;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.ibatis.builder.BuilderException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.oms.bean.ComboDoorEntity;
import com.ejianc.foundation.oms.mapper.ComboDoorMapper;
import com.ejianc.foundation.oms.service.IComboDoorService;
import com.ejianc.foundation.oms.service.IComboEnterpriseService;
import com.ejianc.foundation.oms.vo.ComboDoorVO;
import com.ejianc.foundation.orgcenter.service.IEmployeeService;
import com.ejianc.foundation.orgcenter.service.IOrgService;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.workbench.bean.LayoutEntity;
import com.ejianc.foundation.workbench.bean.LayoutOrgRelationEntity;
import com.ejianc.foundation.workbench.service.ILayoutOrgRelationService;
import com.ejianc.foundation.workbench.service.ILayoutService;
import com.ejianc.foundation.workbench.vo.LayoutVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

/**
 * 套餐门户关系
 * 
 * @author generator
 * 
 */
@Service
public class ComboDoorServiceImpl extends BaseServiceImpl<ComboDoorMapper, ComboDoorEntity> implements IComboDoorService{

	private Logger logger = LoggerFactory.getLogger(this.getClass());

	private static final String LAYOUT_BILL_CODE = "IDM_LAYOUT";
	@Autowired
	private ComboDoorMapper mapper;
	@Autowired
	private IComboEnterpriseService comboEnterpriseService;
	@Autowired
	private IEmployeeService employeeService;
	@Autowired
	private IBillCodeApi billCodeApi;
	@Autowired
	private ILayoutService layoutService;
    @Autowired
    private ILayoutOrgRelationService layoutOrgRelationService;
    @Autowired
	private IOrgService orgService;
	
	@Override
	public IPage<LayoutVO> queryPage(Map<String, Object> params, boolean isEs) {
		if(params.get("pageIndex")!=null){
			Integer pn = Integer.parseInt(params.get("pageIndex").toString());
			pn = pn - 1 < 0 ? 1 : pn;
	        long startLine = (pn - 1) * Integer.parseInt(params.get("pageSize").toString());
	        params.put("startLine", startLine);
		}
		Long count = mapper.countByProPerties(params);
		IPage<LayoutVO> page = new Page<LayoutVO>();
		if(count>0){
			List<LayoutVO> doorVO = mapper.queryPageByProperties(params);
			page.setRecords(doorVO);
		}else{
			page.setRecords(null);
		}
		if(params.get("pageIndex")!=null){
			page.setCurrent(Integer.parseInt(params.get("pageIndex").toString()));
			page.setSize(Integer.parseInt(params.get("pageSize").toString()));
			page.setTotal(count);
		}
		return page;
	}

	@Override
	@Transactional
	public CommonResponse<String> delete(List<ComboDoorEntity> doorVOs) {
		for(ComboDoorEntity doorVO:doorVOs) {
			mapper.deleteAuthDoor(doorVO.getComboId(),doorVO.getDoorId());
		}
		return CommonResponse.success("删除成功");
	}

	/**
	 * 保存套餐应用关系
	 */
	@Override
	public CommonResponse<String> saveComboDoor(ComboDoorVO comboDoorVO) {
		if(comboDoorVO.getComboId()!=null){
			List<LayoutVO> doorVO = comboDoorVO.getDoorVO();
			if(doorVO!=null&&doorVO.size()>0){
				List<ComboDoorEntity> comboDoorList = new ArrayList<>();
				for(LayoutVO vo : doorVO){
					ComboDoorEntity entity = new ComboDoorEntity();
					entity.setDoorId(vo.getId());
					entity.setComboId(comboDoorVO.getComboId());
					comboDoorList.add(entity);
				}
				if(comboDoorList.size()>0){
					this.saveOrUpdateBatch(comboDoorList, comboDoorList.size(), false);
				}

				//推送已分配用户套餐的门户关系
				//1、查询该套餐是否分配租户
				List<Long> tenantIds = comboEnterpriseService.queryTenantIdBycomboId(comboDoorVO.getComboId());
				if(tenantIds!=null&&tenantIds.size()>0){
					//复制门户
			        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
			        String authTime = formatter.format(new Date());
					for(Long tenantId : tenantIds){
						List<LayoutVO> layoutVOs = mapper.queryDoorByEnterpriseId(tenantId);
						//2、查询该门户是否已在租户的套餐中，若在则忽略，不存在则新增
						if(layoutVOs==null||layoutVOs.size()==0){
							//用户不存在门户，不需要校验直接新增
							for(LayoutVO layoutVO : doorVO){
								//3、将该门户推送给租户（门户表分配的租户各生成一条复制的门户）
								//查询分配的租户超级管理员用户详情信息
								OrgVO orgVo = orgService.findOrgByTenantId(tenantId);
								EmployeeVO employeeVO = employeeService.querySuperEmployeeByTenantId(tenantId);
								if(employeeVO==null){
									logger.error("未查询到租户:"+tenantId+"的超级管理员信息，跳过授权门户信息");
									continue;
								}
								
								LayoutEntity entity = BeanMapper.map(layoutVO, LayoutEntity.class);
								//复制门户保存
								CommonResponse<String> layoutResponse = billCodeApi.getCodeBatchByRuleCode(LAYOUT_BILL_CODE, tenantId);
					        	if(layoutResponse.isSuccess()) {
					        		entity.setCode(layoutResponse.getData());
					        	}else{
					        		throw new BuilderException("网络异常， 编码生成失败， 请稍后再试");
					        	}
					        	entity.setSourceId(layoutVO.getId());
					        	entity.setId(null);
					        	entity.setCreateTime(null);
					        	entity.setCreateUserCode(null);
					        	entity.setUpdateTime(null);
					        	entity.setUpdateUserCode(null);
					        	entity.setTenantId(tenantId);
								entity.setOrgId(orgVo.getId());
								layoutService.saveOrUpdate(entity, false);
								
								LayoutOrgRelationEntity relationEntity = new LayoutOrgRelationEntity();
								relationEntity.setAuthTime(authTime);
								relationEntity.setAuthUserId(employeeVO.getUserId());
								relationEntity.setLayoutId(entity.getId());
								relationEntity.setOrgId(orgVo.getId());
								relationEntity.setLimitFlag(2);
								relationEntity.setTenantId(tenantId);
								layoutOrgRelationService.saveOrUpdate(relationEntity,false);
								
							}
							continue;
						}
						if(layoutVOs!=null&&layoutVOs.size()>0){
							Map<Long,LayoutVO> layoutMap = new HashMap<>();
							layoutVOs.forEach(e -> {
								layoutMap.put(e.getSourceId(), e);
							});

							for(LayoutVO layoutVO : doorVO){
								if(layoutMap.get(layoutVO.getId())!=null){
									//说明这个门户在这个租户中已存在则不再进行分配门户
									continue;
								}
								//3、将该门户推送给租户（门户表分配的租户各生成一条复制的门户）
								//查询分配的租户超级管理员用户详情信息
								OrgVO orgVo = orgService.findOrgByTenantId(tenantId);
								EmployeeVO employeeVO = employeeService.querySuperEmployeeByTenantId(tenantId);
								if(employeeVO==null){
									throw new BusinessException("未查询到租户:"+tenantId+"的超级管理员信息");
								}
								
								LayoutEntity entity = BeanMapper.map(layoutVO, LayoutEntity.class);
								//复制门户保存
								CommonResponse<String> layoutResponse = billCodeApi.getCodeBatchByRuleCode(LAYOUT_BILL_CODE, tenantId);
					        	if(layoutResponse.isSuccess()) {
					        		entity.setCode(layoutResponse.getData());
					        	}else{
					        		throw new BuilderException("网络异常， 编码生成失败， 请稍后再试");
					        	}
					        	entity.setSourceId(layoutVO.getId());
					        	entity.setId(null);
					        	entity.setCreateTime(null);
					        	entity.setCreateUserCode(null);
					        	entity.setUpdateTime(null);
					        	entity.setUpdateUserCode(null);
					        	entity.setTenantId(tenantId);
								entity.setOrgId(orgVo.getId());
								layoutService.saveOrUpdate(entity, false);
								
								LayoutOrgRelationEntity relationEntity = new LayoutOrgRelationEntity();
								relationEntity.setAuthTime(authTime);
								relationEntity.setAuthUserId(employeeVO.getUserId());
								relationEntity.setLayoutId(entity.getId());
								relationEntity.setOrgId(orgVo.getId());
								relationEntity.setLimitFlag(2);
								relationEntity.setTenantId(tenantId);
								layoutOrgRelationService.saveOrUpdate(relationEntity,false);
								
							}
						}
					}
				}
			}else{
				return CommonResponse.error("保存门户数据为空");
			}
		}else{
			return CommonResponse.error("套餐id不能为空");
		}
		
		return CommonResponse.success("保存成功");
	}
}
