package com.ejianc.foundation.orgcenter.service;

import java.util.List;
import java.util.Map;

import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.foundation.orgcenter.bean.EmployeeEntity;
import com.ejianc.foundation.orgcenter.vo.*;
import com.ejianc.foundation.permission.vo.RoleUserRelationVO;
import com.ejianc.foundation.usercenter.bean.UserEntity;
import com.ejianc.foundation.utils.gdty.param.GdtyEmp;
import com.ejianc.foundation.utils.ynsbj.param.YnsbjEmp;
import com.ejianc.foundation.utils.ynsbj.resp.YnsbjDataInfo;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.IBaseService;

/**
 * 员工ID
 * 
 * @author guominga
 *
 */
public interface IEmployeeService extends IBaseService<EmployeeEntity> {




	/**
	 * 查询某一个岗位下的所有人员任职
	 *
	 * @param paramMap
	 * @return
	 */
	IPage<EmployeeJobVO> queryPostEmployeePage(Map<String, Object> paramMap);
    /**
     * 分页查询人员列表
     *
     * @param params
     * @return
     */
    IPage<EmployeeVO> pageList(Map<String, Object> params);
    IPage<EmployeeVO> pageALLList(Map<String, Object> params);

    /**
     * 人员及对应用户信息保存
     *
     * @param employeeVO
     * @return
     */
    EmployeeEntity save(EmployeeVO employeeVO);

    /**
     * 注销指定人员
     *
     * @param employeeId
     * @return
     */
    void writtenOff(JobVO employeeId);

    /**
     * 人员调动，针对主职
     *
     * @param param
     */
    void moveEmployee(Map<String, Object> param);

    /**
     * 新增人员兼职记录
     *
     * @param param
     */
    void addParttimeJob(Map<String, Object> param);

    /**
     * 根据人员主键查询人员主职对应的角色人员关系列表
     *
     * @param employeeIds
     * @return
     */
    List<RoleUserRelationVO> getEmployeeRolesRelations(List<Long> employeeIds);

    /**
     * 根据主键ID查询对应的人员信息
     *
     * @param employeeIds
     * @return
     */
    List<EmployeeEntity> getAllByIds(List<Long> employeeIds);

	/**
	 * 更改员工和用户的状态
	 * 
	 * @param employeeVo
	 */
	void enabledEmployeeState(EmployeeVO employeeVo);

	/**
	 * 删除员工
	 * 
	 * @param employeeVo
	 */
	void deleteEmployee(EmployeeVO employeeVo);

	/**
	 * 根据用户ID查询员工信息
	 *
	 * @param userId
	 * @return
	 */
	EmployeeVO queryEmployeeByUserId(Long userId);

	/**
	 * 根据用户id查询用户主兼职组织id
	 *
	 * @param userId
	 * @return
	 */
	List<Long> getJobOrgIdsByUserId(Long userId,Long tenantId);

    /**
     * 根据主键Id查询人员详情
     *
     * @param id
     * @param jobId
     * @return
     */
    EmployeeVO detail(Long id);


	EmployeeEntity save(EmployeeVO employeeVO, UserEntity user);
	
	//根据租户id查询超级管理员员工用户信息
	EmployeeVO querySuperEmployeeByTenantId(Long tenantId);

	//批量保存导入数据
	CommonResponse<String> batchSaveImport(List<EmployeeImportVO> importVOS);

	/**
	 * 查询组织下的用户列表，不包含下级组织用户，首页员工列表查询使用
	 *  查询人员Id，编码，名称，性别，手机号，邮箱，角色名称
	 *
	 * @param orgId
	 * @return
	 */
    List<Map<String, String>> getDirectAllByOrgId(Long orgId);

	/**
	 * 查询指定租户下指定数量的匹配人员列表信息
	 *
	 * @param tenantId
	 * @param searchText
	 * @param limit
	 * @return
	 */
    List<Map<String, String>> searchTenantEmployees(Long tenantId, String searchText, Integer limit);

	/**
	 * 根据编码查询指定的人员信息
	 *
	 * @param code
	 * @return
	 */
    EmployeeVO getByCode(String code);

	/**
	 * 根据主键信息查询所有对应的人员主职详情
	 *
	 * @param ids
	 * @return
	 */
	List<EmployeeVO> queryAllEmpDetailByIds(List<Long> ids);
	List<EmployeeVO> getJustByIds(List<Long> ids);

	/**
	 * 云南建投总承包人员信息插入或修改
	 * 
	 * @param ynsbjEmp
	 */
	YnsbjDataInfo saveOrUpdateYnsbjEmployeeInfo(YnsbjEmp ynsbjEmp);

	/**
	 * 广东腾越人员信息插入或修改
	 * 
	 * @param gdtyEmp
	 */
	void saveOrUpdateGdtyEmployeeInfo(GdtyEmp gdtyEmp);

	public void updateJobType(Map<String, Object> memberInfo);

	public IPage<EmployeeVO> pageBookList(Map<String, Object> params);

	/**
	 * 批量查询某些组织下的某些岗位人员列表，返回结果根据组织+岗位剔重 add  by wxh 20220728
	 * @param postIds
	 * @param orgIds
	 * @return
	 */
	List<EmployeeVO> queryEmployeeByPostAndOrg(List<Long> postIds, List<Long> orgIds);
    public void manageUpdateProjectMembers(Map<String, Object> memberInfo);

    List<EmployeeVO> getByCodeOrIdcard(List<String> codeOrIdcard);

    EmployeeVO getOneBySourceId(String sourceId);

    void partJobBeachForZd4(JSONArray array);
}
