package com.ejianc.foundation.tenant.service;

import com.ejianc.foundation.tenant.vo.TenantMenuVO;
import com.ejianc.foundation.workbench.vo.MenuItemVO;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.IBaseService;
import com.ejianc.foundation.tenant.bean.TenantMenuEntity;

import java.util.List;

/**
 * 租户自定义菜单
 * 
 * @author generator
 * 
 */
public interface ITenantMenuService extends IBaseService<TenantMenuEntity> {
    /**
     * 根据租户查询树形结构菜单
     * @param param
     * @return
     */
    public List<MenuItemVO> queryTenantProperties(QueryParam param);

    /**
     * 根据菜单id查询一条数据
     * @param menuId
     * @return
     */
    public TenantMenuVO queryByMenuId(Long  menuId);

    /**
     * 根据应用ID获取当前菜单名称
     * 
     * @param appId
     * @return
     */
	public List<TenantMenuVO> queryCurrentTenantMenuList(Long tenantId, String appIdStr);
}
