package com.ejianc.foundation.utils.ynsbj.param;

import com.alibaba.fastjson.JSONObject;

public class YnsbjOrg extends YnsbjBaseParam {

	private static final long serialVersionUID = 1L;

	private String code;

	private String name;

	private String shortName; // 组织简称

	private String parentCode;

	private String parentName;

	private String state;

	public String getCode() {
		return code;
	}

	public void setCode(String code) {
		this.code = code;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getShortName() {
		return shortName;
	}

	public void setShortName(String shortName) {
		this.shortName = shortName;
	}

	public String getParentCode() {
		return parentCode;
	}

	public void setParentCode(String parentCode) {
		this.parentCode = parentCode;
	}

	public String getParentName() {
		return parentName;
	}

	public void setParentName(String parentName) {
		this.parentName = parentName;
	}

	public String getState() {
		return state;
	}

	public void setState(String state) {
		this.state = state;
	}


	public YnsbjOrg(String name, String code, String shortName, String parentCode, String parentName, String state) {
		super();
		this.name = name;
		this.code = code;
		this.shortName = shortName;
		this.parentCode = parentCode;
		this.parentName = parentName;
		this.state = state;
	}

	public static YnsbjOrg packageDept(JSONObject jsonObject) {
		String CODE = jsonObject.getString("CODE");  //MDM唯一标识
		String UUID = jsonObject.getString("UUID");
		String DESC1 = jsonObject.getString("DESC1"); //组织名称
		String DESC2 = jsonObject.getString("DESC2"); //组织编码
		String DESC4 = jsonObject.getString("DESC4"); //简称
		String DESC10 = jsonObject.getString("DESC10"); //状态（正常、冻结、合并）
		String DESC14 = jsonObject.getString("DESC14"); //上级组织编码
		String DESC15 = jsonObject.getString("DESC15"); //上级组织名称
		if("冻结".equals(DESC10)) {
			DESC10 = "0";
		}else{
			DESC10 = "1";
		}
		
		YnsbjOrg ynsbjDept = new YnsbjOrg(DESC1,DESC2,DESC4,DESC14,DESC15,DESC10);
		ynsbjDept.setMasterDataCode(CODE);
		ynsbjDept.setUuid(UUID);
		return ynsbjDept;
	}

}
