package com.ejianc.foundation.workbench.element.visitor;

import com.ejianc.foundation.workbench.element.node.Cell;

import java.io.IOException;

public class CellVisitor extends AbstractVisitor<Cell> {


    @Override
    public Appendable head(Cell element, Appendable accumulation) throws IOException {
        String className = "col-md-" + element.getSpan();

        String style = element.attr("style");

        accumulation.append("<div class=\"").append(className).append("\"");

        accumulation.append(">");

        return accumulation;
    }

    @Override
    public Appendable tail(Cell element, Appendable accumulation) throws IOException {
        return accumulation.append("</div>");
    }
}
