package com.ejianc.foundation.workbench.service;

import java.util.List;

import com.ejianc.foundation.workbench.bean.LayoutEntity;
import com.ejianc.foundation.workbench.vo.LayoutVO;
import com.ejianc.framework.skeleton.template.IBaseService;

public interface ILayoutService extends IBaseService<LayoutEntity> {

    /**
     * 根据主键Id查询对应的布局详情
     *
     * @param layoutId
     * @return
     */
	LayoutVO queryLayoutById(Long layoutId);

    /**
     * 根据主键Id查询对应的布局详情
     *
     * @param id
     * @return
     */
    LayoutEntity getById(Long id);

    /**
     * 保存布局设计信息
     *
     * @param layoutId 布局主键ID
     * @param setting   布局设计详情
     */
    void saveLayoutDesign(Long layoutId, String setting);

    /**
     * 查询当前登录人的所有布局列表
     * 
     * @param type 布局类型：1-PC布局，2-移动布局
     * @return
     */
	List<LayoutVO> queryLayoutByCurrentUser(String type);

	/**
	 * 删除自定义布局
	 * 
	 * @param layoutId
	 * @param userId
	 */
	void deleteCustomLayout(String layoutId, Long userId);

	/**
	 * 删除所有自定义布局
	 * 
	 * @param layoutId
	 */
	void deleteAllCustomLayout(Long layoutId);
}
