/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.cache;

import com.alibaba.fastjson.JSON;
import com.ejianc.foundation.cache.PermissionCacheManage;
import com.ejianc.foundation.permission.vo.AppVO;
import com.ejianc.foundation.permission.vo.ButtonVO;
import com.ejianc.framework.cache.redis.CacheManager;
import com.ejianc.framework.cache.serializer.Serializer;
import com.ejianc.framework.cache.serializer.impl.DefaultJDKSerializer;
import com.ejianc.framework.core.kit.collection.ListUtil;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AppCacheManage {
    public static final String DEFAULT_CHARSET = "UTF-8";
    private static final String APP_LIST_KEY = "app_list_key:";
    private static final String BTN_KEY = "btn_key:";
    @Autowired
    private PermissionCacheManage permissionCacheManage;
    @Autowired
    private CacheManager cacheManager;
    private Serializer serializer = new DefaultJDKSerializer();

    public void putAppListToCache(Long tenantId, List<AppVO> appVoList) {
        if (appVoList != null && appVoList.size() > 0) {
            this.cacheManager.piplineExecute(pipeline -> {
                pipeline.multi();
                String key = APP_LIST_KEY + tenantId;
                for (AppVO appVo : appVoList) {
                    byte[] keyBytes = key.getBytes(Charset.forName(DEFAULT_CHARSET));
                    byte[] fieldBytes = appVo.getId().toString().getBytes(Charset.forName(DEFAULT_CHARSET));
                    byte[] contentBytes = this.serializer.marshalToByte((Serializable)((Object)JSON.toJSONString((Object)appVo)));
                    pipeline.hset(keyBytes, fieldBytes, contentBytes);
                }
                pipeline.exec();
            });
        }
    }

    public void putAppBeanToCache(Long tenantId, AppVO appVo) {
        String key = APP_LIST_KEY + tenantId;
        this.cacheManager.hset(key, appVo.getId().toString(), (Serializable)((Object)JSON.toJSONString((Object)appVo)));
    }

    public void putBtnToCache(List<ButtonVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            vos.forEach(btn -> {
                String key = BTN_KEY + btn.getPageCode() + btn.getCode();
                this.cacheManager.set(key, (Serializable)((Object)JSON.toJSONString((Object)btn)));
            });
        }
    }

    public void rmBtnFromCache(List<ButtonVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            vos.forEach(btn -> {
                String key = BTN_KEY + btn.getPageCode() + btn.getCode();
                this.cacheManager.removeCache(key);
            });
        }
    }

    public ButtonVO getBtnCache(String pageCode, String uiKey) {
        String key = BTN_KEY + pageCode + uiKey;
        String content = (String)((Object)this.cacheManager.get(key));
        return (ButtonVO)JSON.parseObject((String)content, ButtonVO.class);
    }

    public void rmBtnRoleFromCache(List<ButtonVO> vos, List<Long> roleIds) {
        if (ListUtil.isNotEmpty(vos) && ListUtil.isNotEmpty(roleIds)) {
            vos.forEach(btn -> roleIds.forEach(roleId -> this.permissionCacheManage.removeRoleAppsBtnCache((Long)roleId, btn.getPageCode() + btn.getCode())));
        }
    }

    public AppVO getAppsCache(Long tenantId, Long appId) {
        String key = APP_LIST_KEY + tenantId;
        String content = (String)((Object)this.cacheManager.hget(key, appId.toString()));
        AppVO appVo = (AppVO)JSON.parseObject((String)content, AppVO.class);
        return appVo;
    }

    public void removeAppCache(Long tenantId, Long appId) {
        String key = APP_LIST_KEY + tenantId;
        this.cacheManager.hdel(key, appId.toString());
    }
}

