/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.weixinpay.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.usercenter.bean.ThirdSystemEntity;
import com.ejianc.foundation.usercenter.service.IThirdSystemService;
import com.ejianc.foundation.weixinpay.bean.WeixinpayInvoiceEntity;
import com.ejianc.foundation.weixinpay.bean.WeixinpayInvoiceHeaderEntity;
import com.ejianc.foundation.weixinpay.bean.WeixinpayInvoiceOrderEntity;
import com.ejianc.foundation.weixinpay.bean.WeixinpayOrderEntity;
import com.ejianc.foundation.weixinpay.mapper.WeixinpayInvoiceMapper;
import com.ejianc.foundation.weixinpay.service.IWeixinpayInvoiceHeaderService;
import com.ejianc.foundation.weixinpay.service.IWeixinpayInvoiceService;
import com.ejianc.foundation.weixinpay.service.IWeixinpayOrderService;
import com.ejianc.foundation.weixinpay.vo.WeixinpayInvoiceOrderVO;
import com.ejianc.foundation.weixinpay.vo.WeixinpayInvoiceVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.EnvironmentTools;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WeixinpayInvoiceServiceImpl
extends BaseServiceImpl<WeixinpayInvoiceMapper, WeixinpayInvoiceEntity>
implements IWeixinpayInvoiceService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IWeixinpayOrderService orderService;
    @Autowired
    private IWeixinpayInvoiceHeaderService invoiceHeaderService;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IPushMessageApi pushMessageApi;
    @Autowired
    private IThirdSystemService thirdSystemService;
    @Autowired
    private EnvironmentTools environmentTools;
    private static final String BILL_CODE = "WEIXINPAYINVOICE";

    @Override
    public WeixinpayInvoiceVO insertOrUpdate(WeixinpayInvoiceVO saveOrUpdateVO) {
        ThirdSystemEntity invoiceNoticer;
        WeixinpayInvoiceEntity entity;
        List<WeixinpayInvoiceOrderEntity> list;
        Boolean sendMsg = false;
        if (saveOrUpdateVO.getOrderList().size() == 0) {
            throw new BusinessException("\u7f3a\u5c11\u8ba2\u5355\u4fe1\u606f\uff0c\u8bf7\u9009\u62e9\u8ba2\u5355\uff01");
        }
        if (saveOrUpdateVO.getId() == null) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (!billCode.isSuccess()) {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            saveOrUpdateVO.setCode((String)billCode.getData());
            saveOrUpdateVO.setInvoiceState("\u5f00\u7968\u4e2d");
            sendMsg = true;
        }
        if ((list = (entity = (WeixinpayInvoiceEntity)((Object)BeanMapper.map((Object)((Object)saveOrUpdateVO), WeixinpayInvoiceEntity.class))).getOrderList()) != null && list.size() > 0) {
            ArrayList<Long> ids = new ArrayList<Long>();
            for (WeixinpayInvoiceOrderEntity weixinpayInvoiceOrderEntity : list) {
                ids.add(weixinpayInvoiceOrderEntity.getOrderId());
            }
            UpdateWrapper wrapper = new UpdateWrapper();
            wrapper.in((Object)"id", ids);
            wrapper.eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid());
            wrapper.set((Object)"invoice_state", (Object)"\u5f00\u7968\u4e2d");
            this.orderService.update(null, (Wrapper)wrapper);
        }
        this.saveOrUpdate((Object)entity, false);
        WeixinpayInvoiceVO vo = (WeixinpayInvoiceVO)((Object)BeanMapper.map((Object)((Object)entity), WeixinpayInvoiceVO.class));
        vo.setEnterpriseName(saveOrUpdateVO.getEnterpriseName());
        vo.setTaxNo(saveOrUpdateVO.getTaxNo());
        vo.setAddress(saveOrUpdateVO.getAddress());
        vo.setPhone(saveOrUpdateVO.getPhone());
        vo.setBankName(saveOrUpdateVO.getBankName());
        vo.setBankAccount(saveOrUpdateVO.getBankAccount());
        if (vo.getOrderList() != null && vo.getOrderList().size() > 0) {
            List<WeixinpayInvoiceOrderVO> orderList = vo.getOrderList();
            for (WeixinpayInvoiceOrderVO ovo : orderList) {
                WeixinpayOrderEntity order = (WeixinpayOrderEntity)((Object)this.orderService.selectById(ovo.getOrderId()));
                ovo.setMchid(order.getMchid());
                ovo.setOrderNo(order.getOrderNo());
                ovo.setType(order.getType());
                ovo.setNum(order.getNum());
                ovo.setMoney(order.getMoney());
            }
        }
        if (sendMsg.booleanValue() && (invoiceNoticer = this.thirdSystemService.queryThirdSystemByCode("invoiceNoticer")) != null && StringUtils.isNotBlank((CharSequence)invoiceNoticer.getConfigInfo())) {
            PushMsgParameter pushMsgParameter = new PushMsgParameter();
            ArrayList<String> channel = new ArrayList<String>();
            channel.add("sys");
            String[] receivers = invoiceNoticer.getConfigInfo().split(",");
            pushMsgParameter.setReceivers(receivers);
            pushMsgParameter.setMsgType("notice");
            String subject = "\u60a8\u6709\u4e00\u6761\u65b0\u7684\u8ba2\u5355\u53d1\u7968\u9700\u8981\u5f00\u7968\uff0c\u8bf7\u5c3d\u5feb\u5904\u7406";
            pushMsgParameter.setSubject(subject);
            pushMsgParameter.setContent(subject);
            String pcUrl = this.environmentTools.getBaseHost() + "ejc-idm-frontend/#/omsInvoice?id=" + vo.getId();
            pushMsgParameter.setPcUrl(pcUrl);
            pushMsgParameter.setTenantId(InvocationInfoProxy.getTenantid().toString());
            pushMsgParameter.setSendUserId(InvocationInfoProxy.getUserid());
            ThirdSystemEntity invoiceNoticerTemplate = this.thirdSystemService.queryThirdSystemByCode("invoiceNoticerTemplate");
            if (invoiceNoticerTemplate != null && StringUtils.isNotBlank((CharSequence)invoiceNoticerTemplate.getConfigInfo())) {
                channel.add("weixin");
                JSONObject weixinParams = new JSONObject();
                weixinParams.put("template_id", (Object)invoiceNoticerTemplate.getConfigInfo());
                JSONObject wxparams = new JSONObject();
                wxparams.put("first", (Object)subject);
                wxparams.put("keyword1", (Object)"\u8d39\u7528\u4e2d\u5fc3");
                wxparams.put("keyword2", (Object)"\u8ba2\u5355\u5f00\u7968");
                wxparams.put("keyword3", (Object)subject);
                wxparams.put("keyword4", (Object)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
                wxparams.put("remark", (Object)"\u8bf7\u53ca\u65f6\u5904\u7406\uff01");
                weixinParams.put("data", (Object)wxparams);
                pushMsgParameter.setWeixinParams(weixinParams);
            }
            pushMsgParameter.setChannel(channel.toArray(new String[channel.size()]));
            try {
                CommonResponse result = this.pushMessageApi.pushMessage(pushMsgParameter);
                if (result.isSuccess()) {
                    this.logger.error("\u6d88\u606f\u53d1\u9001\u6210\u529f---------------->" + result.getMsg());
                } else {
                    this.logger.error("\u6d88\u606f\u53d1\u9001\u5931\u8d25---------------->" + result.getMsg());
                }
            }
            catch (Exception e) {
                this.logger.error("\u8c03\u7528\u6d88\u606f\u4e2d\u5fc3RPC\u670d\u52a1\u5f02\u5e38--------------" + e);
            }
        }
        return vo;
    }

    @Override
    public WeixinpayInvoiceVO queryDetail(Long id) {
        WeixinpayInvoiceEntity entity = (WeixinpayInvoiceEntity)((Object)this.selectById(id));
        WeixinpayInvoiceVO vo = null;
        if (entity != null) {
            vo = (WeixinpayInvoiceVO)((Object)BeanMapper.map((Object)((Object)entity), WeixinpayInvoiceVO.class));
            WeixinpayInvoiceHeaderEntity invoiceHeaderEntity = (WeixinpayInvoiceHeaderEntity)((Object)this.invoiceHeaderService.selectById(entity.getInvoiceHeaderId()));
            if (invoiceHeaderEntity != null) {
                vo.setEnterpriseName(invoiceHeaderEntity.getEnterpriseName());
                vo.setTaxNo(invoiceHeaderEntity.getTaxNo());
                vo.setAddress(invoiceHeaderEntity.getAddress());
                vo.setPhone(invoiceHeaderEntity.getPhone());
                vo.setBankName(invoiceHeaderEntity.getBankName());
                vo.setBankAccount(invoiceHeaderEntity.getBankAccount());
            }
            if (vo.getOrderList() != null && vo.getOrderList().size() > 0) {
                List<WeixinpayInvoiceOrderVO> orderList = vo.getOrderList();
                for (WeixinpayInvoiceOrderVO ovo : orderList) {
                    WeixinpayOrderEntity order = (WeixinpayOrderEntity)((Object)this.orderService.selectById(ovo.getOrderId()));
                    ovo.setMchid(order.getMchid());
                    ovo.setOrderNo(order.getOrderNo());
                    ovo.setType(order.getType());
                    ovo.setNum(order.getNum());
                    ovo.setMoney(order.getMoney());
                }
            }
        }
        return vo;
    }

    @Override
    public void delete(WeixinpayInvoiceVO vo) {
        WeixinpayInvoiceEntity entity = (WeixinpayInvoiceEntity)((Object)this.selectById(vo.getId()));
        List<WeixinpayInvoiceOrderEntity> list = entity.getOrderList();
        if (list != null && list.size() > 0) {
            ArrayList<Long> ids = new ArrayList<Long>();
            for (WeixinpayInvoiceOrderEntity en : list) {
                ids.add(en.getOrderId());
            }
            UpdateWrapper wrapper = new UpdateWrapper();
            wrapper.in((Object)"id", ids);
            wrapper.eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid());
            wrapper.set((Object)"invoice_state", (Object)"\u5f85\u5f00\u7968");
            this.orderService.update(null, (Wrapper)wrapper);
        }
        this.removeById(vo.getId());
    }

    @Override
    public CommonResponse<String> invoicing(Long id) {
        WeixinpayInvoiceEntity entity = (WeixinpayInvoiceEntity)((Object)this.selectById(id));
        entity.setInvoiceState("\u5df2\u5f00\u7968");
        List<WeixinpayInvoiceOrderEntity> list = entity.getOrderList();
        if (list != null && list.size() > 0) {
            ArrayList<Long> ids = new ArrayList<Long>();
            for (WeixinpayInvoiceOrderEntity en : list) {
                ids.add(en.getOrderId());
            }
            UpdateWrapper wrapper = new UpdateWrapper();
            wrapper.in((Object)"id", ids);
            wrapper.eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid());
            wrapper.set((Object)"invoice_state", (Object)"\u5df2\u5f00\u7968");
            this.orderService.update(null, (Wrapper)wrapper);
        }
        this.saveOrUpdate((Object)entity, false);
        return CommonResponse.success((String)"\u5f00\u7968\u6210\u529f");
    }
}

