package com.ejianc.foundation.permission.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.cache.PermissionCacheManage;
import com.ejianc.foundation.permission.bean.RolePostRelationEntity;
import com.ejianc.foundation.permission.mapper.RolePostRelationMapper;
import com.ejianc.foundation.permission.service.IRolePostRelationService;
import com.ejianc.foundation.permission.vo.RolePostRelationVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import java.util.List;

/**
 * ClassName: RolePostRelationServiceImpl
 * Description:
 * Date: 2022/4/4 11:00
 *
 * @version:
 * @since JDK 1.8
 */

@Service
public class RolePostRelationServiceImpl extends BaseServiceImpl<RolePostRelationMapper, RolePostRelationEntity>
        implements IRolePostRelationService {

    @Autowired
    private RolePostRelationMapper rolePostRelationMapper;
    @Autowired
    private PermissionCacheManage permissionCacheManage;


    @Override
    public CommonResponse<String> delete(List<Long> ids) {
        for(Long id:ids) {
            RolePostRelationEntity entity = rolePostRelationMapper.selectById(id);
            //删除redis中的岗位字典
            permissionCacheManage.removeRolePostsCache(entity.getRoleId(), entity.getPostId());
        }
        rolePostRelationMapper.deleteRolePostRelation(null, ids);
        return CommonResponse.success("删除角色岗位字典成功");
    }

    @Override
    public CommonResponse<String> saveRolePost(List<RolePostRelationVO> data) {
        List<RolePostRelationEntity> entityList = BeanMapper.mapList(data, RolePostRelationEntity.class);
        if(entityList != null && entityList.size() > 0) {
            this.saveOrUpdateBatch(entityList , entityList.size(), false);
            permissionCacheManage.putRolePostsCache(data.get(0).getRoleId(), data);
            return CommonResponse.success("保存成功");
        }else{
            return CommonResponse.error("未选择岗位字典");
        }
    }

    @Override
    public void deleteByRoleIds(List<Long> roleIds) {
        rolePostRelationMapper.deleteRolePostRelation(roleIds, null);
        QueryWrapper<RolePostRelationEntity> wrapper = new QueryWrapper<>();
        wrapper.in("role_id", roleIds);
        List<RolePostRelationEntity> list = this.list(wrapper);
        if(list!=null&&list.size()>0){
            for(RolePostRelationEntity entity : list) {
                //删除redis中的岗位字典
                permissionCacheManage.removeRolePostsCache(entity.getRoleId(), entity.getPostId());
            }
        }
    }


}
