package com.ejianc.foundation.utils.gdty.param;

import com.alibaba.fastjson.JSONObject;

public class GdtyPost extends GdtyBaseParam {

	private static final long serialVersionUID = 1L;

	private String postCode;

	private String postName;

	private String orgCode;

	private String orgName;

	private String beginTime;

	private String endTime;

	public String getPostCode() {
		return postCode;
	}

	public void setPostCode(String postCode) {
		this.postCode = postCode;
	}

	public String getPostName() {
		return postName;
	}

	public void setPostName(String postName) {
		this.postName = postName;
	}

	public String getOrgCode() {
		return orgCode;
	}

	public void setOrgCode(String orgCode) {
		this.orgCode = orgCode;
	}

	public String getOrgName() {
		return orgName;
	}

	public void setOrgName(String orgName) {
		this.orgName = orgName;
	}

	public String getBeginTime() {
		return beginTime;
	}

	public void setBeginTime(String beginTime) {
		this.beginTime = beginTime;
	}

	public String getEndTime() {
		return endTime;
	}

	public void setEndTime(String endTime) {
		this.endTime = endTime;
	}

	public GdtyPost(String postCode, String postName, String orgCode, String orgName, String beginTime, String endTime) {
		this.postCode = postCode;
		this.postName = postName;
		this.orgCode = orgCode;
		this.orgName = orgName;
		this.beginTime = beginTime;
		this.endTime = endTime;
	}
	
	public static GdtyPost packageGdtyPost(JSONObject jsonObject) {
		String recordId = jsonObject.getString("RecordID"); // 唯一RecordId
		String ZPOSTIDX = jsonObject.getString("ZPOSTIDX"); //MDG岗位编码
		String ZPOSTID = jsonObject.getString("ZPOSTID"); //岗位编码
		String ZPOSTNAME = jsonObject.getString("ZPOSTNAME"); //岗位名称
		String ZORGID = jsonObject.getString("ZORGID"); //所属组织编码
		String ZORGNAME = jsonObject.getString("ZORGNAME");//所属组织名称
		String ZBEGDAT = jsonObject.getString("ZBEGDAT");// 开始日期
		String ZENDDAT = jsonObject.getString("ZENDDAT"); // 结束日期
		String ZSTATUS = jsonObject.getString("ZSTATUS"); //冻结状态
		
		GdtyPost gdtyPost = new GdtyPost(ZPOSTID, ZPOSTNAME, ZORGID, ZORGNAME, ZBEGDAT, ZENDDAT);
		gdtyPost.setRecordId(recordId);
		gdtyPost.setMasterDataCode(ZPOSTIDX);
		gdtyPost.setZstatus(ZSTATUS);
		return gdtyPost;
	}

}
