package com.ejianc.foundation.utils.ynsbj.param;

import com.alibaba.fastjson.JSONObject;

public class YnsbjDept extends YnsbjBaseParam {

	private static final long serialVersionUID = 1L;

	private String deptCode;

	private String deptName;

	private String deptProperty;

	private String parentCode;

	private String parentName;

	private String projectCode;

	private String state;

	private String categoryCode;

	public String getCategoryCode() {
		return categoryCode;
	}

	public void setCategoryCode(String categoryCode) {
		this.categoryCode = categoryCode;
	}

	public String getDeptCode() {
		return deptCode;
	}

	public void setDeptCode(String deptCode) {
		this.deptCode = deptCode;
	}

	public String getDeptName() {
		return deptName;
	}

	public void setDeptName(String deptName) {
		this.deptName = deptName;
	}

	public String getDeptProperty() {
		return deptProperty;
	}

	public void setDeptProperty(String deptProperty) {
		this.deptProperty = deptProperty;
	}

	public String getParentCode() {
		return parentCode;
	}

	public void setParentCode(String parentCode) {
		this.parentCode = parentCode;
	}

	public String getParentName() {
		return parentName;
	}

	public void setParentName(String parentName) {
		this.parentName = parentName;
	}

	public String getState() {
		return state;
	}

	public void setState(String state) {
		this.state = state;
	}

	public String getProjectCode() {
		return projectCode;
	}

	public void setProjectCode(String projectCode) {
		this.projectCode = projectCode;
	}

	public YnsbjDept() {
	}
	
	public YnsbjDept(String deptCode, String deptName, String deptProperty, String parentCode, String parentName,String projectCode, String state) {
		super();
		this.deptCode = deptCode;
		this.deptName = deptName;
		this.deptProperty = deptProperty;
		this.parentCode = parentCode;
		this.parentName = parentName;
		this.projectCode = projectCode;
		this.state = state;
	}

	public static YnsbjDept packageDept(JSONObject jsonObject) {
		String CODE = jsonObject.getString("CODE");  //MDM唯一标识
		String UUID = jsonObject.getString("UUID");
		String DESC1 = jsonObject.getString("DESC1"); //部门名称
		String DESC2 = jsonObject.getString("DESC2"); //部门编码
		String DESC3 = jsonObject.getString("DESC3"); //部门属性
		String DESC4 = jsonObject.getString("DESC4"); //上级部门编码
		String DESC5 = jsonObject.getString("DESC5"); //上级部门名称
		String DESC6 = jsonObject.getString("DESC6"); //项目部对应项目档案编码
		String DESC8 = jsonObject.getString("DESC8"); //状态（正常、撤销、合并）
		String categoryCode = jsonObject.getString("CATEGORYCODE"); //类别编码
		if("撤销".equals(DESC8)) {
			DESC8 = "0";
		}else{
			DESC8 = "1";
		}
		
		YnsbjDept ynsbjDept = new YnsbjDept(DESC2, DESC1, DESC3, DESC4, DESC5,DESC6, DESC8);
		ynsbjDept.setMasterDataCode(CODE);
		ynsbjDept.setUuid(UUID);
		ynsbjDept.setCategoryCode(categoryCode);
		return ynsbjDept;
	}

}
