package com.ejianc.foundation.workbench.service;

import com.ejianc.foundation.workbench.bean.LayoutRoleRelationEntity;
import com.ejianc.foundation.workbench.vo.LayoutRoleVO;
import com.ejianc.framework.skeleton.template.IBaseService;

import java.util.List;
import java.util.Map;

public interface ILayoutRoleRelationService extends IBaseService<LayoutRoleRelationEntity> {

    /**
     * 查询匹配条件的布局角色关系总数
     *
     * @param paramMap
     * @param layoutId
     * @return
     */
    Long count(Map<String, Object> paramMap, Long layoutId);

    /**
     * 查询匹配条件的布局角色关系列表
     *
     * @param paramMap
     * @param startLine
     * @param pageSize
     * @param layoutId
     * @return
     */
    List<LayoutRoleVO> page(Map<String, Object> paramMap, int startLine, int pageSize, Long layoutId);

    /**
     * 查询所有匹配的布局角色列表
     *
     * @param param
     * @return
     */
    List<LayoutRoleRelationEntity> queryByProperties(Map<String, Object> param);

    /**
     * 删除布局角色关系表
     * 
     * @param ids
     */
	void deleteByIds(List<Long> ids);

    /**
     * 根据角色Id以及布局Id删除对应的布局角色关系
     *
     * @param roleIds
     * @param layoutIds
     */
    void delByRoleIdsAndOrgId(List<Long> roleIds, List<Long> layoutIds);
}
