/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.permission.service.impl;

import com.ejianc.foundation.metadata.api.IMdApi;
import com.ejianc.foundation.metadata.vo.MdReferVO;
import com.ejianc.foundation.permission.bean.TasklistConfigEntity;
import com.ejianc.foundation.permission.mapper.TasklistConfigMapper;
import com.ejianc.foundation.permission.service.ITasklistConfigService;
import com.ejianc.foundation.permission.vo.TasklistConfigVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillTypeVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.EnvironmentTools;
import com.ejianc.framework.skeleton.refer.util.ReferHttpClientUtils;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;

@Service
public class TasklistConfigServiceImpl
extends BaseServiceImpl<TasklistConfigMapper, TasklistConfigEntity>
implements ITasklistConfigService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private Gson gson = new GsonBuilder().disableHtmlEscaping().create();
    @Autowired
    private TasklistConfigMapper tasklistConfigMapper;
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IMdApi mdApi;
    @Autowired
    private EnvironmentTools environmentTools;

    @Override
    public List<TasklistConfigVO> queryListData(HttpServletRequest request) {
        ArrayList<TasklistConfigVO> vos = new ArrayList<TasklistConfigVO>();
        String authority = request.getHeader("authority");
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        LinkedHashMap order = queryParam.getOrderMap();
        order.put("sequence", "asc");
        order.put("createTime", "desc");
        List pageData = this.queryList(queryParam, false);
        if (pageData != null && pageData.size() > 0) {
            ExecutorService threadPool = Executors.newFixedThreadPool(5);
            for (TasklistConfigEntity entity : pageData) {
                TasklistConfigVO vo = (TasklistConfigVO)BeanMapper.map((Object)((Object)entity), TasklistConfigVO.class);
                try {
                    MyTask myCallable = new MyTask(RequestContextHolder.getRequestAttributes(), authority, entity);
                    Future<Integer> myFuture = threadPool.submit(myCallable);
                    vo.setCountNumber(myFuture.get());
                }
                catch (Exception e) {
                    this.logger.error("\u5f02\u5e38\uff1a", (Throwable)e);
                }
                vos.add(vo);
            }
            threadPool.shutdown();
        }
        return vos;
    }

    class MyTask
    implements Callable<Integer> {
        private RequestAttributes context;
        private String authority;
        private TasklistConfigEntity entity;

        public MyTask(RequestAttributes context, String authority, TasklistConfigEntity entity) {
            this.context = context;
            this.authority = authority;
            this.entity = entity;
        }

        @Override
        public Integer call() throws Exception {
            Integer resp = null;
            this.context.setAttribute("authority", (Object)this.authority, 0);
            RequestContextHolder.setRequestAttributes((RequestAttributes)this.context);
            CommonResponse billTypeResponse = TasklistConfigServiceImpl.this.billTypeApi.getById(this.entity.getBillTypeId());
            if (billTypeResponse.isSuccess()) {
                BillTypeVO billTypeVo = (BillTypeVO)billTypeResponse.getData();
                TasklistConfigServiceImpl.this.logger.info("\u8c03\u7528\u5143\u6570\u636eapi\u53c2\u6570\uff1a---------------" + billTypeVo.getMetadataId());
                if (billTypeVo.getMetadataId() != null) {
                    CommonResponse referResponse = TasklistConfigServiceImpl.this.mdApi.queryMetadataById(billTypeVo.getMetadataId());
                    if (referResponse.isSuccess()) {
                        MdReferVO vo = (MdReferVO)referResponse.getData();
                        HashMap<String, String> paramterMap = new HashMap<String, String>();
                        paramterMap.put("sql", this.entity.getCountSql());
                        String paramterStr = TasklistConfigServiceImpl.this.gson.toJson(paramterMap);
                        String url = TasklistConfigServiceImpl.this.environmentTools.getBaseHost() + vo.getProjectName() + "/commonQuery/queryNumberBySql";
                        TasklistConfigServiceImpl.this.logger.info("\u8c03\u7528restUrl-----------------------" + url);
                        try {
                            String result = ReferHttpClientUtils.postByJson((String)url, (String)paramterStr);
                            CommonResponse re = (CommonResponse)TasklistConfigServiceImpl.this.gson.fromJson(result, new TypeToken<CommonResponse<Integer>>(){}.getType());
                            resp = (Integer)re.getData();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    } else {
                        TasklistConfigServiceImpl.this.logger.info("\u8c03\u7528\u67e5\u8be2\u5143\u6570\u636e\u670d\u52a1\u5f02\u5e38\uff1a---------------" + referResponse.getMsg());
                    }
                }
            }
            return resp;
        }
    }
}

