package com.ejianc.foundation.workbench.mapper;

import java.util.List;
import java.util.Map;

import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import com.ejianc.foundation.workbench.bean.LayoutRoleRelationEntity;
import com.ejianc.foundation.workbench.vo.LayoutRoleVO;
import com.ejianc.framework.skeleton.template.BaseCrudMapper;

@Mapper
public interface LayoutRoleRelationMapper extends BaseCrudMapper<LayoutRoleRelationEntity> {

	/**
	 * 查询匹配条件的布局角色关系总数
	 *
	 * @param paramMap
	 * @return
	 */
	Long count(Map<String, Object> paramMap);

	/**
	 * 查询匹配条件的布局角色关系列表
	 *
	 * @param paramMap
	 * @return
	 */
	List<LayoutRoleVO> page(Map<String, Object> paramMap);

	/**
	 * 根据主键ids删除
	 * 
	 * @param ids
	 */
	void deleteByIds(@Param("ids") String ids);

	/**
	 * 根据角色Id以及布局Id删除对应的布局角色关系
	 *
	 * @param roleIds
	 * @param layoutIds
	 */
    void delByRoleIdsAndOrgId(@Param(value = "roleIds") List<Long> roleIds, @Param(value = "layoutIds") List<Long> layoutIds);
}
