/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.oms.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.cache.PermissionCacheManage;
import com.ejianc.foundation.oms.bean.ComboEnterpriseEntity;
import com.ejianc.foundation.oms.mapper.ComboAppMapper;
import com.ejianc.foundation.oms.mapper.ComboDoorMapper;
import com.ejianc.foundation.oms.mapper.ComboEnterpriseMapper;
import com.ejianc.foundation.oms.mapper.ComboRoleMapper;
import com.ejianc.foundation.oms.service.IComboDoorService;
import com.ejianc.foundation.oms.service.IComboEnterpriseService;
import com.ejianc.foundation.oms.vo.ComboEnterpriseVO;
import com.ejianc.foundation.orgcenter.service.IEmployeeService;
import com.ejianc.foundation.orgcenter.service.IOrgService;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.permission.bean.RoleEntity;
import com.ejianc.foundation.permission.bean.RoleUserRelationEntity;
import com.ejianc.foundation.permission.mapper.RoleAppRelationMapper;
import com.ejianc.foundation.permission.mapper.RoleButtonRelationMapper;
import com.ejianc.foundation.permission.service.IAppService;
import com.ejianc.foundation.permission.service.IRoleService;
import com.ejianc.foundation.permission.service.IRoleUserRelationService;
import com.ejianc.foundation.permission.service.impl.RoleAppRelationServiceImpl;
import com.ejianc.foundation.permission.vo.AppVO;
import com.ejianc.foundation.permission.vo.ButtonVO;
import com.ejianc.foundation.permission.vo.RoleAppVO;
import com.ejianc.foundation.permission.vo.RoleVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.tenant.bean.TenantEntity;
import com.ejianc.foundation.tenant.mapper.TenantMenuMapper;
import com.ejianc.foundation.tenant.service.ITenantService;
import com.ejianc.foundation.tenant.vo.EnterpriseVO;
import com.ejianc.foundation.workbench.bean.LayoutEntity;
import com.ejianc.foundation.workbench.bean.LayoutOrgRelationEntity;
import com.ejianc.foundation.workbench.service.ILayoutOrgRelationService;
import com.ejianc.foundation.workbench.service.ILayoutService;
import com.ejianc.foundation.workbench.vo.LayoutVO;
import com.ejianc.framework.cache.redis.CacheManager;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ComboEnterpriseServiceImpl
extends BaseServiceImpl<ComboEnterpriseMapper, ComboEnterpriseEntity>
implements IComboEnterpriseService {
    private static final String LAYOUT_BILL_CODE = "IDM_LAYOUT";
    private static final String ROLE_BILL_CODE = "IDM_ROLE";
    private static final String CURRENTROLE_APP_KEY = "currentrole_app_key:";
    private static final String CURRENTROLE_USER_KEY = "currentrole_user_key:";
    private static final String CURRENTROLE_APP_BUTTON_KEY = "currentrole_app_button_key:";
    @Autowired
    private ComboEnterpriseMapper mapper;
    @Autowired
    private ComboRoleMapper comboRoleMapper;
    @Autowired
    private ComboAppMapper comboAppMapper;
    @Autowired
    private ComboDoorMapper comboDoorMapper;
    @Autowired
    private RoleAppRelationMapper appmapper;
    @Autowired
    private CacheManager cacheManager;
    @Autowired
    private RoleAppRelationServiceImpl roleAppRelationServiceImpl;
    @Autowired
    private IOrgService orgService;
    @Autowired
    private IEmployeeService employeeService;
    @Autowired
    private ILayoutService layoutService;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IRoleService roleService;
    @Autowired
    private IAppService appService;
    @Autowired
    private RoleButtonRelationMapper buttonmapper;
    @Autowired
    private IComboDoorService comboDoorService;
    @Autowired
    private IRoleUserRelationService roleUserRelationService;
    @Autowired
    private ILayoutOrgRelationService layoutOrgRelationService;
    @Autowired
    private PermissionCacheManage permissionCacheManage;
    @Autowired
    private ComboEnterpriseMapper comboEnterpriseMapper;
    @Autowired
    private ITenantService tenantService;
    @Autowired
    private TenantMenuMapper tenantMenuMapper;

    @Override
    public IPage<EnterpriseVO> queryPage(Map<String, Object> params, boolean isEs) {
        if (params.get("pageIndex") != null) {
            Integer pn = Integer.parseInt(params.get("pageIndex").toString());
            pn = pn - 1 < 0 ? 1 : pn;
            long startLine = (pn - 1) * Integer.parseInt(params.get("pageSize").toString());
            params.put("startLine", startLine);
        }
        Long count = this.mapper.countByProPerties(params);
        Page page = new Page();
        if (count > 0L) {
            List<EnterpriseVO> enterpriseVO = this.mapper.queryPageByProperties(params);
            page.setRecords(enterpriseVO);
        } else {
            page.setRecords(null);
        }
        if (params.get("pageIndex") != null) {
            page.setCurrent((long)Integer.parseInt(params.get("pageIndex").toString()));
            page.setSize((long)Integer.parseInt(params.get("pageSize").toString()));
            page.setTotal(count.longValue());
        }
        return page;
    }

    @Override
    @Transactional
    public CommonResponse<String> delete(List<ComboEnterpriseEntity> enterpriseVOs) {
        for (ComboEnterpriseEntity enterpriseVO : enterpriseVOs) {
            this.mapper.deleteAuthEnterprise(enterpriseVO.getComboId(), enterpriseVO.getBuyerId());
        }
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f");
    }

    @Override
    @Transactional
    public CommonResponse<String> saveComboEnterprise(ComboEnterpriseVO comboEnterpriseVO) {
        ComboEnterpriseEntity comboEnterpriseEntity = (ComboEnterpriseEntity)((Object)BeanMapper.map((Object)((Object)comboEnterpriseVO), ComboEnterpriseEntity.class));
        boolean add = true;
        if (comboEnterpriseVO.getId() != null) {
            add = false;
        }
        if (add) {
            BaseEntity entity;
            OrgVO orgVO = this.orgService.findOrgByTenantId(comboEnterpriseVO.getBuyerId());
            if (orgVO == null) {
                throw new BusinessException("\u672a\u67e5\u8be2\u5230\u8be5\u4f01\u4e1a\u7684\u6839\u7ec4\u7ec7\u4fe1\u606f");
            }
            EmployeeVO employeeVO = this.employeeService.querySuperEmployeeByTenantId(comboEnterpriseVO.getBuyerId());
            if (employeeVO == null) {
                throw new BusinessException("\u672a\u67e5\u8be2\u5230\u79df\u6237\u7684\u8d85\u7ea7\u7ba1\u7406\u5458");
            }
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("comboId", comboEnterpriseVO.getComboId());
            List<LayoutVO> allDoorVOs = this.comboDoorMapper.queryDoorByEnterpriseId(comboEnterpriseVO.getBuyerId());
            IPage<LayoutVO> pageData = this.comboDoorService.queryPage(params, false);
            List layoutVO = pageData.getRecords();
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
            String authTime = formatter.format(new Date());
            if (allDoorVOs != null && allDoorVOs.size() > 0) {
                if (layoutVO != null && layoutVO.size() > 0) {
                    HashMap doorMap = new HashMap();
                    allDoorVOs.forEach(e -> {
                        if (e.getSourceId() != null) {
                            doorMap.put(e.getSourceId(), e);
                        }
                    });
                    ArrayList<BaseEntity> saveList = new ArrayList<BaseEntity>();
                    for (LayoutVO vo : layoutVO) {
                        if (doorMap.get(vo.getId()) == null) {
                            CommonResponse layoutResponse = this.billCodeApi.getCodeBatchByRuleCode(LAYOUT_BILL_CODE, comboEnterpriseVO.getBuyerId());
                            if (layoutResponse.isSuccess()) {
                                vo.setCode((String)layoutResponse.getData());
                            } else {
                                Long code = IdWorker.getId();
                                vo.setCode(code.toString());
                            }
                            LayoutEntity saveEntity = (LayoutEntity)((Object)BeanMapper.map((Object)vo, LayoutEntity.class));
                            saveEntity.setSourceId(vo.getId());
                            saveEntity.setOrgId(orgVO.getId());
                            saveEntity.setId(null);
                            saveEntity.setCreateTime(null);
                            saveEntity.setCreateUserCode(null);
                            saveEntity.setUpdateTime(null);
                            saveEntity.setUpdateUserCode(null);
                            saveEntity.setTenantId(comboEnterpriseVO.getBuyerId());
                            this.layoutService.saveOrUpdate((Object)saveEntity, false);
                            entity = new LayoutOrgRelationEntity();
                            entity.setAuthTime(authTime);
                            entity.setAuthUserId(comboEnterpriseVO.getUserId());
                            entity.setLayoutId(saveEntity.getId());
                            entity.setOrgId(orgVO.getId());
                            entity.setLimitFlag(2);
                            entity.setTenantId(comboEnterpriseVO.getBuyerId());
                            saveList.add(entity);
                            continue;
                        }
                        LayoutEntity saveEntity = (LayoutEntity)((Object)BeanMapper.map(doorMap.get(vo.getId()), LayoutEntity.class));
                        saveEntity.setDesignType(vo.getDesignType());
                        saveEntity.setSetting(vo.getSetting());
                        saveEntity.setTemplateUrl(vo.getTemplateUrl());
                        this.layoutService.saveOrUpdate((Object)saveEntity, false);
                    }
                    if (saveList != null && saveList.size() > 0) {
                        this.layoutOrgRelationService.saveOrUpdateBatch(saveList, saveList.size() < 1000 ? saveList.size() : 1000, false);
                    }
                }
            } else if (layoutVO != null && layoutVO.size() > 0) {
                ArrayList saveList = new ArrayList();
                layoutVO.forEach(e -> {
                    CommonResponse layoutResponse = this.billCodeApi.getCodeBatchByRuleCode(LAYOUT_BILL_CODE, comboEnterpriseVO.getBuyerId());
                    if (layoutResponse.isSuccess()) {
                        e.setCode((String)layoutResponse.getData());
                    } else {
                        Long code = IdWorker.getId();
                        e.setCode(code.toString());
                    }
                    LayoutEntity saveEntity = (LayoutEntity)((Object)((Object)BeanMapper.map((Object)e, LayoutEntity.class)));
                    saveEntity.setSourceId(e.getId());
                    saveEntity.setOrgId(orgVO.getId());
                    saveEntity.setId(null);
                    saveEntity.setCreateTime(null);
                    saveEntity.setCreateUserCode(null);
                    saveEntity.setUpdateTime(null);
                    saveEntity.setUpdateUserCode(null);
                    saveEntity.setTenantId(comboEnterpriseVO.getBuyerId());
                    this.layoutService.saveOrUpdate((Object)saveEntity, false);
                    LayoutOrgRelationEntity entity = new LayoutOrgRelationEntity();
                    entity.setAuthTime(authTime);
                    entity.setAuthUserId(comboEnterpriseVO.getUserId());
                    entity.setLayoutId(saveEntity.getId());
                    entity.setOrgId(orgVO.getId());
                    entity.setLimitFlag(2);
                    entity.setTenantId(comboEnterpriseVO.getBuyerId());
                    saveList.add(entity);
                });
                if (saveList != null && saveList.size() > 0) {
                    this.layoutOrgRelationService.saveOrUpdateBatch(saveList, saveList.size() < 1000 ? saveList.size() : 1000, false);
                }
            }
            List<AppVO> appVO = this.comboAppMapper.queryPageByProperties(params);
            HashMap mapApp = new HashMap();
            if (appVO != null && appVO.size() > 0) {
                appVO.forEach(e -> mapApp.put(e.getId(), e));
            }
            List<RoleVO> nowRoleVO = this.comboRoleMapper.queryPageByProperties(params);
            List<RoleVO> allRoleVOs = this.comboRoleMapper.queryRoleByEnterpriseId(comboEnterpriseVO.getBuyerId());
            if (allRoleVOs != null && allRoleVOs.size() > 0) {
                HashMap<Long, RoleVO> mapRole = new HashMap<Long, RoleVO>();
                for (RoleVO roleVO : allRoleVOs) {
                    if (roleVO.getSourceId() == null) continue;
                    mapRole.put(roleVO.getSourceId(), roleVO);
                }
                for (RoleVO roleVO : nowRoleVO) {
                    if (mapRole.get(roleVO.getId()) != null) {
                        HashMap<String, Object> appParams = new HashMap<String, Object>();
                        appParams.put("roleId", ((RoleVO)mapRole.get(roleVO.getId())).getId());
                        IPage<AppVO> exitAppPage = this.roleAppRelationServiceImpl.queryPage(appParams, false);
                        appParams.put("roleId", roleVO.getId());
                        IPage<AppVO> allAppPage = this.roleAppRelationServiceImpl.queryPage(appParams, false);
                        if (exitAppPage.getRecords() != null && exitAppPage.getRecords().size() > 0) {
                            List exitAppVO = exitAppPage.getRecords();
                            for (AppVO vo : exitAppVO) {
                                if (mapApp.get(vo.getId()) == null) continue;
                                mapApp.remove(vo.getId());
                            }
                            RoleAppVO roleAppVO = new RoleAppVO();
                            ArrayList app = new ArrayList();
                            if (allAppPage.getRecords() != null && allAppPage.getRecords().size() > 0) {
                                for (AppVO vo : allAppPage.getRecords()) {
                                    if (mapApp.get(vo.getId()) == null) continue;
                                    vo.setTenantId(comboEnterpriseVO.getBuyerId());
                                    app.add(vo);
                                }
                            }
                            if (app == null || app.size() <= 0) continue;
                            roleAppVO.setAppVO((List)app);
                            roleAppVO.setRoleId(((RoleVO)mapRole.get(roleVO.getId())).getId());
                            this.appService.saveRoleApp(roleAppVO);
                            continue;
                        }
                        RoleAppVO roleAppVO = new RoleAppVO();
                        ArrayList<AppVO> app = new ArrayList<AppVO>();
                        if (allAppPage.getRecords() != null && allAppPage.getRecords().size() > 0) {
                            for (AppVO vo : allAppPage.getRecords()) {
                                if (mapApp.get(vo.getId()) == null) continue;
                                vo.setTenantId(comboEnterpriseVO.getBuyerId());
                                app.add(vo);
                            }
                        }
                        if (app == null || app.size() <= 0) continue;
                        roleAppVO.setAppVO(app);
                        roleAppVO.setRoleId(roleVO.getId());
                        this.appService.saveRoleApp(roleAppVO);
                        continue;
                    }
                    RoleEntity entity2 = (RoleEntity)((Object)BeanMapper.map((Object)roleVO, RoleEntity.class));
                    entity2.setTenantId(comboEnterpriseVO.getBuyerId());
                    entity2.setOrgId(orgVO.getId());
                    CommonResponse roleResponse = this.billCodeApi.getCodeBatchByRuleCode(ROLE_BILL_CODE, comboEnterpriseVO.getBuyerId());
                    if (roleResponse.isSuccess()) {
                        entity2.setCode((String)roleResponse.getData());
                    } else {
                        Long code = IdWorker.getId();
                        entity2.setCode(code.toString());
                    }
                    entity2.setSourceId(roleVO.getId());
                    entity2.setId(null);
                    entity2.setCreateTime(null);
                    entity2.setCreateUserCode(null);
                    entity2.setUpdateTime(null);
                    entity2.setUpdateUserCode(null);
                    this.roleService.saveOrUpdate((Object)entity2, false);
                    ArrayList<RoleUserRelationEntity> data = new ArrayList<RoleUserRelationEntity>();
                    RoleUserRelationEntity roleUserRelation = new RoleUserRelationEntity();
                    roleUserRelation.setAuthOrgId(employeeVO.getOrgId());
                    roleUserRelation.setEmployeeId(employeeVO.getId());
                    roleUserRelation.setJobId(employeeVO.getJobId());
                    roleUserRelation.setRoleId(entity2.getId());
                    roleUserRelation.setUserId(employeeVO.getUserId());
                    roleUserRelation.setTenantId(comboEnterpriseVO.getBuyerId());
                    data.add(roleUserRelation);
                    this.roleUserRelationService.saveRoleUser(data);
                    HashMap<String, Object> appParams = new HashMap<String, Object>();
                    appParams.put("roleId", roleVO.getId());
                    IPage<AppVO> rolePage = this.roleAppRelationServiceImpl.queryPage(appParams, false);
                    if (rolePage.getRecords() == null || rolePage.getRecords().size() <= 0) continue;
                    RoleAppVO roleAppVO = new RoleAppVO();
                    ArrayList<AppVO> app = new ArrayList<AppVO>();
                    for (AppVO vo : rolePage.getRecords()) {
                        if (mapApp.get(vo.getId()) == null) continue;
                        vo.setTenantId(comboEnterpriseVO.getBuyerId());
                        app.add(vo);
                    }
                    if (app == null || app.size() <= 0) continue;
                    roleAppVO.setAppVO(app);
                    roleAppVO.setRoleId(entity2.getId());
                    this.appService.saveRoleApp(roleAppVO);
                }
            } else if (nowRoleVO != null && nowRoleVO.size() > 0) {
                for (RoleVO roleVO : nowRoleVO) {
                    entity = (RoleEntity)((Object)BeanMapper.map((Object)roleVO, RoleEntity.class));
                    entity.setTenantId(comboEnterpriseVO.getBuyerId());
                    entity.setOrgId(orgVO.getId());
                    CommonResponse roleResponse = this.billCodeApi.getCodeBatchByRuleCode(ROLE_BILL_CODE, comboEnterpriseVO.getBuyerId());
                    if (roleResponse.isSuccess()) {
                        entity.setCode((String)roleResponse.getData());
                    } else {
                        Long code = IdWorker.getId();
                        entity.setCode(code.toString());
                    }
                    entity.setSourceId(roleVO.getId());
                    entity.setId(null);
                    entity.setCreateTime(null);
                    entity.setCreateUserCode(null);
                    entity.setUpdateTime(null);
                    entity.setUpdateUserCode(null);
                    this.roleService.saveOrUpdate(entity, false);
                    ArrayList<RoleUserRelationEntity> data = new ArrayList<RoleUserRelationEntity>();
                    RoleUserRelationEntity roleUserRelation = new RoleUserRelationEntity();
                    roleUserRelation.setAuthOrgId(employeeVO.getOrgId());
                    roleUserRelation.setEmployeeId(employeeVO.getId());
                    roleUserRelation.setJobId(employeeVO.getJobId());
                    roleUserRelation.setRoleId(entity.getId());
                    roleUserRelation.setUserId(employeeVO.getUserId());
                    roleUserRelation.setTenantId(comboEnterpriseVO.getBuyerId());
                    data.add(roleUserRelation);
                    this.roleUserRelationService.saveRoleUser(data);
                    HashMap<String, Object> appParams = new HashMap<String, Object>();
                    appParams.put("roleId", roleVO.getId());
                    IPage<AppVO> rolePage = this.roleAppRelationServiceImpl.queryPage(appParams, false);
                    if (rolePage.getRecords() == null || rolePage.getRecords().size() <= 0) continue;
                    RoleAppVO roleAppVO = new RoleAppVO();
                    ArrayList<AppVO> app = new ArrayList<AppVO>();
                    for (AppVO vo : rolePage.getRecords()) {
                        if (mapApp.get(vo.getId()) == null) continue;
                        vo.setTenantId(comboEnterpriseVO.getBuyerId());
                        app.add(vo);
                    }
                    if (app == null || app.size() <= 0) continue;
                    roleAppVO.setAppVO(app);
                    roleAppVO.setRoleId(entity.getId());
                    this.appService.saveRoleApp(roleAppVO);
                }
            }
        }
        this.saveOrUpdate((Object)comboEnterpriseEntity, false);
        if (!add) {
            this.refreshAuthCache(comboEnterpriseEntity.getBuyerId());
        }
        return CommonResponse.success((String)"\u4fdd\u5b58\u6210\u529f");
    }

    @Override
    public CommonResponse<String> loadComboEnterprise(ComboEnterpriseVO comboEnterpriseVO, Long orgId, EmployeeVO employeeVO) {
        List<RoleVO> nowRoleVO;
        ComboEnterpriseEntity comboEnterpriseEntity = (ComboEnterpriseEntity)((Object)BeanMapper.map((Object)((Object)comboEnterpriseVO), ComboEnterpriseEntity.class));
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("comboId", comboEnterpriseVO.getComboId());
        IPage<LayoutVO> pageData = this.comboDoorService.queryPage(params, false);
        List layoutVO = pageData.getRecords();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        String authTime = formatter.format(new Date());
        if (ListUtil.isNotEmpty((List)layoutVO)) {
            ArrayList saveList = new ArrayList();
            layoutVO.forEach(e -> {
                CommonResponse layoutResponse = this.billCodeApi.getCodeBatchByRuleCode(LAYOUT_BILL_CODE, comboEnterpriseVO.getBuyerId());
                if (layoutResponse.isSuccess()) {
                    e.setCode((String)layoutResponse.getData());
                } else {
                    e.setCode(comboEnterpriseVO.getBuyerId().toString());
                }
                LayoutEntity saveEntity = (LayoutEntity)((Object)((Object)BeanMapper.map((Object)e, LayoutEntity.class)));
                saveEntity.setSourceId(e.getId());
                saveEntity.setOrgId(orgId);
                saveEntity.setId(null);
                saveEntity.setCreateTime(null);
                saveEntity.setCreateUserCode(null);
                saveEntity.setUpdateTime(null);
                saveEntity.setUpdateUserCode(null);
                saveEntity.setTenantId(comboEnterpriseVO.getBuyerId());
                this.layoutService.saveOrUpdate((Object)saveEntity, false);
                LayoutOrgRelationEntity entity = new LayoutOrgRelationEntity();
                entity.setAuthTime(authTime);
                entity.setAuthUserId(comboEnterpriseVO.getUserId());
                entity.setLayoutId(saveEntity.getId());
                entity.setOrgId(orgId);
                entity.setLimitFlag(2);
                entity.setTenantId(comboEnterpriseVO.getBuyerId());
                saveList.add(entity);
            });
            if (saveList.size() > 0) {
                this.layoutOrgRelationService.saveOrUpdateBatch(saveList, saveList.size(), false);
            }
        }
        List<AppVO> appVO = this.comboAppMapper.queryPageByProperties(params);
        HashMap mapApp = new HashMap();
        if (appVO != null && appVO.size() > 0) {
            appVO.forEach(e -> mapApp.put(e.getId(), e));
        }
        if ((nowRoleVO = this.comboRoleMapper.queryPageByProperties(params)) != null && nowRoleVO.size() > 0) {
            for (RoleVO roleVO : nowRoleVO) {
                RoleEntity entity = (RoleEntity)((Object)BeanMapper.map((Object)roleVO, RoleEntity.class));
                entity.setTenantId(comboEnterpriseVO.getBuyerId());
                entity.setOrgId(orgId);
                CommonResponse roleResponse = this.billCodeApi.getCodeBatchByRuleCode(ROLE_BILL_CODE, comboEnterpriseVO.getBuyerId());
                if (roleResponse.isSuccess()) {
                    entity.setCode((String)roleResponse.getData());
                } else {
                    entity.setCode(comboEnterpriseVO.getBuyerId().toString());
                }
                entity.setSourceId(roleVO.getId());
                entity.setId(null);
                entity.setCreateTime(null);
                entity.setCreateUserCode(null);
                entity.setUpdateTime(null);
                entity.setUpdateUserCode(null);
                this.roleService.saveOrUpdate((Object)entity, false);
                ArrayList<RoleUserRelationEntity> data = new ArrayList<RoleUserRelationEntity>();
                RoleUserRelationEntity roleUserRelation = new RoleUserRelationEntity();
                roleUserRelation.setAuthOrgId(orgId);
                roleUserRelation.setEmployeeId(employeeVO.getId());
                roleUserRelation.setJobId(employeeVO.getJobId());
                roleUserRelation.setRoleId(entity.getId());
                roleUserRelation.setUserId(employeeVO.getId());
                roleUserRelation.setTenantId(comboEnterpriseVO.getBuyerId());
                data.add(roleUserRelation);
                this.roleUserRelationService.saveRoleUser(data);
                HashMap<String, Object> appParams = new HashMap<String, Object>();
                appParams.put("roleId", roleVO.getId());
                IPage<AppVO> rolePage = this.roleAppRelationServiceImpl.queryPage(appParams, false);
                if (rolePage.getRecords() == null || rolePage.getRecords().size() <= 0) continue;
                RoleAppVO roleAppVO = new RoleAppVO();
                ArrayList<AppVO> app = new ArrayList<AppVO>();
                for (AppVO vo : rolePage.getRecords()) {
                    if (mapApp.get(vo.getId()) == null) continue;
                    vo.setTenantId(comboEnterpriseVO.getBuyerId());
                    app.add(vo);
                }
                if (app == null || app.size() <= 0) continue;
                roleAppVO.setAppVO(app);
                roleAppVO.setRoleId(entity.getId());
                this.appService.saveRoleApp(roleAppVO);
            }
        }
        this.saveOrUpdate((Object)comboEnterpriseEntity, false);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6210\u529f");
    }

    public void refreshAuthCache(Long tenantId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"tenant_id", (Object)tenantId);
        List roleList = this.roleService.list((Wrapper)queryWrapper);
        if (roleList != null && roleList.size() > 0) {
            for (RoleEntity roleEntity : roleList) {
                List<AppVO> appVos = null;
                if (999999L == roleEntity.getTenantId()) {
                    appVos = this.appmapper.queryAuthListByRoleId(roleEntity.getId());
                } else {
                    HashMap<String, Object> queryParam = new HashMap<String, Object>();
                    queryParam.put("tenantId", roleEntity.getTenantId());
                    queryParam.put("roleId", roleEntity.getId());
                    appVos = this.appmapper.queryPageByProperties(queryParam);
                }
                QueryWrapper roleUserQueryWrapper = new QueryWrapper();
                roleUserQueryWrapper.eq((Object)"role_id", (Object)roleEntity.getId());
                List roleUserRelationEntities = this.roleUserRelationService.list((Wrapper)roleUserQueryWrapper);
                this.cacheManager.removeCache(CURRENTROLE_APP_KEY + roleEntity.getId());
                this.cacheManager.removeCache(CURRENTROLE_USER_KEY + roleEntity.getId());
                this.cacheManager.removeCache(CURRENTROLE_APP_BUTTON_KEY + roleEntity.getId());
                if (ListUtil.isNotEmpty(appVos)) {
                    HashMap<String, Object> param = new HashMap<String, Object>();
                    for (AppVO app : appVos) {
                        param.put("roleId", roleEntity.getId());
                        param.put("appId", app.getId());
                        param.put("dr", 0);
                        List<ButtonVO> btnVos = this.buttonmapper.queryProperties(param);
                        if (!ListUtil.isNotEmpty(btnVos)) continue;
                        app.setChildren(btnVos);
                    }
                }
                this.permissionCacheManage.putRoleAppsCache(roleEntity.getId(), appVos);
                this.permissionCacheManage.putRoleUsersCache(roleEntity.getId(), roleUserRelationEntities);
            }
        }
    }

    @Override
    public List<Long> queryTenantIdBycomboId(Long comboId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"dr", (Object)0);
        queryWrapper.eq((Object)"combo_id", (Object)comboId);
        List list = this.list((Wrapper)queryWrapper);
        ArrayList<Long> tenantIds = new ArrayList<Long>();
        if (list != null && list.size() > 0) {
            list.forEach(e -> tenantIds.add(e.getBuyerId()));
        }
        return tenantIds;
    }

    @Override
    public ComboEnterpriseVO queryComboEntityBean(Long tenantId, String comboCode) {
        ComboEnterpriseVO comboEnterpriseVo = this.comboEnterpriseMapper.queryComboEntityBean(tenantId, comboCode);
        return comboEnterpriseVo;
    }

    @Override
    public CommonResponse<String> changeMenuCategory(Long tenantId, Long menuCategoryId) {
        TenantEntity tenant = (TenantEntity)((Object)this.tenantService.getById(tenantId));
        if (tenant.getMenuCategoryId() != menuCategoryId) {
            tenant.setMenuCategoryId(menuCategoryId);
            this.tenantService.saveOrUpdate((Object)tenant, false);
            this.tenantMenuMapper.deleteByTenantId(tenantId, null);
        }
        return CommonResponse.success((String)"\u4fee\u6539\u6210\u529f");
    }
}

