package com.ejianc.foundation.news.service.impl;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.news.bean.NewsEntity;
import com.ejianc.foundation.news.mapper.NewsMapper;
import com.ejianc.foundation.news.service.INewsService;
import com.ejianc.foundation.news.vo.NewsVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

@Service
public class NewsServiceImpl extends BaseServiceImpl<NewsMapper, NewsEntity> implements INewsService {
	
	@Autowired
	private NewsMapper newsMapper;

	@Override
	public NewsVO queryDetail(Long id) {
		NewsEntity entity = baseMapper.selectById(id);
		if (entity != null) {
			return BeanMapper.map(entity, NewsVO.class);
		}
		return null;
	}

	@Override
	public void delete(Long id) {
		baseMapper.deleteById(id);
	}

	@Override
	public IPage<NewsVO> queryPageByParams(QueryParam queryParam, boolean isEs) {
		IPage<NewsVO> backData = new Page<>();
        IPage<NewsEntity> dataPage = this.queryPage(queryParam, false);
        List<NewsVO> vos = BeanMapper.mapList(dataPage.getRecords(), NewsVO.class);
		backData.setCurrent(dataPage.getCurrent());
		backData.setPages(dataPage.getPages());
		backData.setRecords(vos);
		backData.setSize(dataPage.getSize());
		backData.setTotal(dataPage.getTotal());
		return backData;
	}

	@Override
	public List<NewsEntity> queryImageList(Long tenantId) {
		Integer rotationFlag = 1;
		List<NewsEntity> entities = newsMapper.queryNewsList(tenantId,rotationFlag);
		return entities;
	}

	@Override
	public List<NewsEntity> queryNewsList(Long tenantId) {
		List<NewsEntity> entities = newsMapper.queryNewsList(tenantId,null);
		return entities;
	}

	@Override
	public List<NewsEntity> queryIndexNewsList(Long tenantId) {
		List<NewsEntity> entities = newsMapper.queryIndexNewsList(tenantId);
		return entities;
	}

}
