package com.ejianc.foundation.usercenter.util;

import java.util.Random;
import java.util.Collections;
import java.util.List;
import java.util.ArrayList;

public class PasswordGeneratorUtils {

    private static final String UPPER = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private static final String LOWER = "abcdefghijklmnopqrstuvwxyz";
    private static final String LETTER = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private static final String DIGITS = "0123456789";
    private static final String SPECIAL = "!@#$%^&*?";

    public static String generate1(Integer num) {
        //数字和字母混合
        Random random = new Random();
        List<Character> chars = new ArrayList<>();

        // 确保每类至少一个字符
        chars.add(LETTER.charAt(random.nextInt(LETTER.length())));
        chars.add(DIGITS.charAt(random.nextInt(DIGITS.length())));

        // 补充剩余2个随机字符
        String allChars = LETTER + DIGITS;
        for (int i = 0; i < num-2; i++) {
            chars.add(allChars.charAt(random.nextInt(allChars.length())));
        }

        // 打乱顺序
        Collections.shuffle(chars);

        // 转为字符串
        StringBuilder sb = new StringBuilder();
        for (char c : chars) {
            sb.append(c);
        }
        return sb.toString();
    }
    public static String generate2(Integer num) {
        //数字、字母和!@#$%^&*?混合
        Random random = new Random();
        List<Character> chars = new ArrayList<>();

        // 确保每类至少一个字符
        chars.add(LETTER.charAt(random.nextInt(LETTER.length())));
        chars.add(DIGITS.charAt(random.nextInt(DIGITS.length())));
        chars.add(SPECIAL.charAt(random.nextInt(SPECIAL.length())));

        // 补充剩余2个随机字符
        String allChars = LETTER + DIGITS + SPECIAL;
        for (int i = 0; i < num-3; i++) {
            chars.add(allChars.charAt(random.nextInt(allChars.length())));
        }

        // 打乱顺序
        Collections.shuffle(chars);

        // 转为字符串
        StringBuilder sb = new StringBuilder();
        for (char c : chars) {
            sb.append(c);
        }
        return sb.toString();
    }
    public static String generate3(Integer num) {
        //大写字母、小写字母、数字和!@#$%^&*?混合
        Random random = new Random();
        List<Character> chars = new ArrayList<>();

        // 确保每类至少一个字符
        chars.add(UPPER.charAt(random.nextInt(UPPER.length())));
        chars.add(LOWER.charAt(random.nextInt(LOWER.length())));
        chars.add(DIGITS.charAt(random.nextInt(DIGITS.length())));
        chars.add(SPECIAL.charAt(random.nextInt(SPECIAL.length())));

        // 补充剩余2个随机字符
        String allChars = UPPER + LOWER + DIGITS + SPECIAL;
        for (int i = 0; i < num-4; i++) {
            chars.add(allChars.charAt(random.nextInt(allChars.length())));
        }

        // 打乱顺序
        Collections.shuffle(chars);

        // 转为字符串
        StringBuilder sb = new StringBuilder();
        for (char c : chars) {
            sb.append(c);
        }
        return sb.toString();
    }
}
