package com.ejianc.foundation.permission.service;

import java.util.List;
import java.util.Map;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.foundation.permission.bean.RoleAppRelationEntity;
import com.ejianc.foundation.permission.vo.AppVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.IBaseService;

public interface IRoleAppRelationService extends IBaseService<RoleAppRelationEntity> {

	IPage<AppVO> queryPage(Map<String, Object> params, boolean isEs);

	CommonResponse<String> delete(List<RoleAppRelationEntity> appVOs);

	/**
	 * 查询角色已授权的应用和按钮
	 * 
	 * @param roleId
	 * @return
	 */
	List<AppVO> queryAuthListByRoleId(Long roleId);

	/**
	 * 根据角色Id删除对应角色应用关系
	 *
	 * @param roleIdList
	 */
	void delByRoleIds(List<Long> roleIdList);

	CommonResponse<Boolean> checkBtnHasPermission(String pageCode,String uiKey);

	CommonResponse<JSONObject> checkBeachBtnHasPermission(String pageCode, String uiKeys);

	public IPage<AppVO> queryBookRolePage(Map<String, Object> params, boolean b);

	public IPage<AppVO> queryBookAppPage(Map<String, Object> params, boolean b);
}
