package com.ejianc.foundation.tenant.mapper;

import java.util.List;

import com.alibaba.fastjson.JSONObject;
import org.apache.ibatis.annotations.Mapper;

import com.ejianc.foundation.tenant.bean.EnterpriseEntity;
import com.ejianc.foundation.tenant.vo.EnterpriseVO;
import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

@Mapper
public interface EnterpriseMapper extends BaseCrudMapper<EnterpriseEntity> {

	List<EnterpriseVO> getAllEnterpriseList();

	@Select("select count(DISTINCT(u.id)) as userCount from ejc_idm_user u,ejc_idm_user_tenant_relation r where " +
			"r.user_id = u.id and u.dr = 0 and r.tenant_id != 999999")
	Long getAllUserNum();

	@Select("select count(DISTINCT(u.id)) as userCount from ejc_idm_user u,ejc_idm_user_tenant_relation r where " +
			"u.create_time > CONCAT(YEAR(NOW()),'-01-01 00:00:00') and r.user_id = u.id and u.dr = 0 and r.tenant_id != 999999")
	Long getUserThisYearNum();

	/**
	 * 获取最近即将到期的租户及其到期套餐和时间
	 * @param endDate
	 * @return
	 */
	@Select("SELECT a.* FROM (SELECT t.id,t.`name`,r.combo_name comName, DATE_FORMAT(MIN(r.end_time), '%Y-%m-%d') endTime " +
			"FROM ejc_oms_combo_tenant_relation r,ejc_idm_tenant t " +
			"WHERE t.id = r.buyer_id AND r.end_time BETWEEN NOW() " +
			"AND #{endDate} GROUP BY t.id  ) a ORDER BY a.endTime")
	List<JSONObject> getEnterpriseComEndTimeLast3Month(@Param("endDate") String endDate);

	/**
	 * 根据租户查询该租户：
	 * 服务开始时间
	 * 服务结束时间
	 * 套餐内应用数量
	 *
	 * @param tenantId
	 * @return {
	 * id:租户id，
	 * name：租户name，
	 * startTime：服务开始时间，
	 * endTime：服务结束时间，
	 * appNum:套餐内应用数量
	 * }
	 */
	@Select("SELECT t.id,t.name ,DATE_FORMAT(MIN(r.start_time), '%Y-%m-%d') startTime ,DATE_FORMAT(MAX(r.end_time), '%Y-%m-%d') endTime,COUNT(DISTINCT(app.app_id)) appNum " +
			"FROM ejc_idm_tenant t,ejc_oms_combo_tenant_relation r,ejc_oms_combo_app_relation app " +
			"WHERE t.id = #{tenantId} AND t.id = r.buyer_id AND r.combo_id = app.combo_id")
	JSONObject getEnterpriseComboInfo(@Param("tenantId") Long tenantId);

}
