package com.ejianc.foundation.usercenter.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.aliyun.facebody20191230.Client;
import com.aliyun.facebody20191230.models.*;
import com.aliyun.ocr20191230.models.*;
import com.aliyun.teautil.models.RuntimeOptions;
import com.ejianc.foundation.usercenter.service.IAliyunApiService;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.*;

/** 阿里云相关服务调用接口 */
@Service
public class AliyunApiServiceImpl implements IAliyunApiService {

    private final Logger logger = LoggerFactory.getLogger(getClass());

    @Value("${openapi.aliyun.face.accessKeyId:LTAI4G8bTuUZUWGhrefAgiwB}")
    private String accessKeyId;
    @Value("${openapi.aliyun.face.accessKeySecret:qArmki0vpSswVJID8fM0OdEqfeWbmi}")
    private String accessKeySecret;
    @Value("${openapi.aliyun.face.endpoint:facebody.cn-shanghai.aliyuncs.com}")
    private String faceEndpoint;
    @Value("${openapi.aliyun.face.confidence:85}")
    private Float confidence;
    @Value("${openapi.aliyun.face.defaultFaceDb:default}")
    private String defaultFaceDb;
    @Value("${openapi.aliyun.ocr.endpoint:ocr.cn-shanghai.aliyuncs.com}")
    private String ocrEndpoint;

    private Client client;
    private com.aliyun.ocr20191230.Client ocrClient;

    /**
     * 使用AK&SK初始化账号Client
     * @return Client
     * @throws Exception
     */
    private synchronized Client createFaceClient() throws Exception {
        if(client!=null){
            return client;
        }
        com.aliyun.teaopenapi.models.Config config = new com.aliyun.teaopenapi.models.Config()
                // 您的 AccessKey ID
                .setAccessKeyId(accessKeyId)
                // 您的 AccessKey Secret
                .setAccessKeySecret(accessKeySecret);
        // 访问的域名
        config.endpoint = faceEndpoint;
//        config.endpoint = "facebody.cn-shanghai.aliyuncs.com";
        client = new Client(config);;
        return client;
    }

    /**
     * 使用AK&SK初始化账号Client
     * @return Client
     * @throws Exception
     */
    private synchronized com.aliyun.ocr20191230.Client createOcrClient() throws Exception {
        if(ocrClient!=null){
            return ocrClient;
        }
        com.aliyun.teaopenapi.models.Config config = new com.aliyun.teaopenapi.models.Config()
                // 您的 AccessKey ID
                .setAccessKeyId(accessKeyId)
                // 您的 AccessKey Secret
                .setAccessKeySecret(accessKeySecret);
        // 访问的域名
        config.endpoint = ocrEndpoint;
        ocrClient = new com.aliyun.ocr20191230.Client(config);
        return ocrClient;
    }
    /**
     * 读取网路图片形成InputStream
     * @return InputStream
     * @throws Exception
     */
    private synchronized InputStream getOssUrlInputStream(String imgUrl) throws Exception {
        URL url = new URL(imgUrl);
        return url.openConnection().getInputStream();
    }

    /**
     * 校验照片是否包含可用人脸，通过，返回true，不通过返回false
     *
     * @param inputStream 输入流
     *
     * @return {@link CommonResponse}<{@link Boolean}>
     */
    @Override
    public CommonResponse<Boolean> checkFaceQualityStream(InputStream inputStream,byte[] imgBytes) {
        logger.info("校验照片是否包含可用人脸,inputStream={}", inputStream);
        try {
            Client client = createFaceClient();
            DetectFaceAdvanceRequest detectFaceRequest = new DetectFaceAdvanceRequest();
            detectFaceRequest.setImageURLObject(inputStream);
            detectFaceRequest.setQuality(true);
            detectFaceRequest.setMaxFaceNumber(1L);
            // 复制代码运行请自行打印 API 的返回值
            DetectFaceResponse response = client.detectFaceAdvance(detectFaceRequest, new RuntimeOptions());
//            logger.info("校验照片是否包含可用人脸,inputStream={}  response={}", inputStream, JSON.toJSONString(response, SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue));
            if (response.getStatusCode() == 200) {
                DetectFaceResponseBody.DetectFaceResponseBodyData faceData = response.getBody().getData();
                if(faceData.getFaceCount()>1 || faceData.getFaceProbabilityList().size()>1){
                    return CommonResponse.error("检测到多张人脸！",false);
                }
                if(faceData.getFaceProbabilityList().get(0)<(confidence/100) || faceData.getQualities().getScoreList().get(0)<confidence){
                    return CommonResponse.error("人脸照片模糊不合格！",false);
                }
                return CommonResponse.success(true);
            }
        } catch (Exception error) {
            logger.info("校验照片是否包含可用人脸,inputStream={}  error={}", inputStream, error.getMessage());
            if(error.getMessage()!=null && error.getMessage().contains("code: 400")){
                int time = new Random().nextInt(3000);
                logger.info("校验照片是否包含可用人脸，因为限流，"+time+"毫秒后，即将重试....");
                try {
                    Thread.sleep(time);
                } catch (InterruptedException e) {
                }
                return checkFaceQualityStream(new ByteArrayInputStream(imgBytes),imgBytes);
            }
        }
        return CommonResponse.error("人脸照片校验失败！",false);
    }


    /**
     * 人脸照片活体检查
     * 通过，返回true，不通过返回false
     * @param imgUrl
     * @return
     */
    @Override
    public CommonResponse<Boolean> liveCheck(String imgUrl){
        logger.info("人脸照片活体检查,imgUrl="+imgUrl);
        try {
            Client client = createFaceClient();
            DetectLivingFaceAdvanceRequest livingFaceRequest = new DetectLivingFaceAdvanceRequest();
            List<DetectLivingFaceAdvanceRequest.DetectLivingFaceAdvanceRequestTasks> tasks = new ArrayList<>();
            DetectLivingFaceAdvanceRequest.DetectLivingFaceAdvanceRequestTasks task = new DetectLivingFaceAdvanceRequest.DetectLivingFaceAdvanceRequestTasks();
            task.setImageURLObject(getOssUrlInputStream(imgUrl));
            tasks.add(task);
            livingFaceRequest.setTasks(tasks);
            DetectLivingFaceResponse livingFaceResponse = client.detectLivingFaceAdvance(livingFaceRequest,new RuntimeOptions());
//            logger.info("人脸照片活体检查,imgUrl="+imgUrl+"  livingFaceResponse="+JSONObject.toJSONString(livingFaceResponse));
            if(livingFaceResponse.getStatusCode()==200){
                DetectLivingFaceResponseBody.DetectLivingFaceResponseBodyDataElements element = livingFaceResponse.getBody().getData().getElements().get(0);
                if(element.getResults().get(0).getRate()>confidence || "pass".equals(element.getResults().get(0).getSuggestion())){
                    return CommonResponse.success(true);
                }
                return CommonResponse.error("非直拍照片！",false);
            }
        } catch (Exception error) {
            logger.info("人脸照片活体检查,imgUrl="+imgUrl+"  error="+error.getMessage());
            if(error.getMessage()!=null && error.getMessage().contains("code: 400")){
                int time = new Random().nextInt(3000);
                logger.info("人脸照片活体检查，因为限流，"+time+"毫秒后，即将重试....");
                try {
                    Thread.sleep(time);
                } catch (InterruptedException e) {
                }
                return liveCheck(imgUrl);
            }
        }
        return CommonResponse.error("人脸活体校验失败！",false);
    }

    public static void main(String[] args) {
        int time = new Random().nextInt(3000);
        System.out.println("开始"+time+"   "+System.currentTimeMillis());
        try {
            Thread.sleep(time);
        } catch (InterruptedException e) {
        }
        System.out.println("结束"+System.currentTimeMillis());
    }
    /**
     * 对比两张图片是否是同一个人
     * 是，返回true，不是返回false
     * 支持URL与Base64编码字符串混合输入。
     * 例如：输入imgUrlA和imgBase64B的值，不输入imgUrlB和imgBase64A的值,合法。
     * @param imgUrlA
     * @param imgUrlB
     * @param imgBase64A
     * @param imgBase64B
     * @return
     */
    @Override
    public CommonResponse<Boolean> compareFace(String imgUrlA,String imgUrlB,String imgBase64A,String imgBase64B){
//        logger.info("对比两张图片是否是同一个人,imgUrlA={}  imgUrlB={}  imgBase64A={}   imgBase64B={}",imgUrlA,imgUrlB,imgBase64A,imgBase64B);
        try {
            Client client = createFaceClient();
            CompareFaceAdvanceRequest compareFaceRequest = new CompareFaceAdvanceRequest();
            if(StringUtils.isNotEmpty(imgUrlA)){
                compareFaceRequest.setImageURLAObject(getOssUrlInputStream(imgUrlA));
            }
            if(StringUtils.isNotEmpty(imgUrlB)){
                compareFaceRequest.setImageURLBObject(getOssUrlInputStream(imgUrlB));
            }
            if(StringUtils.isNotEmpty(imgBase64A)){
                compareFaceRequest.setImageDataA(imgBase64A);
            }
            if(StringUtils.isNotEmpty(imgBase64B)){
                compareFaceRequest.setImageDataB(imgBase64B);
            }

            CompareFaceResponse response = client.compareFaceAdvance(compareFaceRequest,new RuntimeOptions());
//            logger.info("对比两张图片是否是同一个人,imgUrlA={}  imgUrlB={}  imgBase64A={}   imgBase64B={} response={}",imgUrlA,imgUrlB,imgBase64A,imgBase64B,JSONObject.toJSONString(response));
            if(response.getStatusCode()==200){
                CompareFaceResponseBody.CompareFaceResponseBodyData faceData = response.getBody().getData();
                if(faceData.getConfidence()>confidence){
                    return CommonResponse.success(true);
                }
                return CommonResponse.error("人脸验证不通过！",false);
            }
        } catch (Exception error) {
            logger.info("对比两张图片是否是同一个人,imgUrlA={}  imgUrlB={}  imgBase64A={}   imgBase64B={} error={}",imgUrlA,imgUrlB,imgBase64A,imgBase64B,error.getMessage());
            if(error.getMessage()!=null && error.getMessage().contains("code: 400")){
                int time = new Random().nextInt(3000);
                logger.info("对比两张图片是否是同一个人，因为限流，"+time+"毫秒后，即将重试....");
                try {
                    Thread.sleep(time);
                } catch (InterruptedException e) {
                }
                return compareFace( imgUrlA, imgUrlB, imgBase64A, imgBase64B);
            }
        }
        return CommonResponse.error("人脸照片校验失败！",false);
    }

    /**
     * 对比两张图片是否是同一个人
     * 是，返回true，不是返回false
     * 支持URL与Base64编码字符串混合输入。
     * 例如：输入imgUrlA和imgBase64B的值，不输入imgUrlB和imgBase64A的值,合法。
     *
     * @param imgUrlA
     * @param imgUrlB
     * @param imgBase64A
     * @param imgBase64B
     * @return
     */
    @Override
    public CommonResponse<Boolean> compareFace(InputStream imgUrlA, InputStream imgUrlB, String imgBase64A,String imgBase64B,byte[] imgStrA,byte[] imgStrB) {
//        logger.info("对比两张图片是否是同一个人,imgUrlA={}  imgUrlB={}  imgBase64A={}   imgBase64B={}",imgUrlA,imgUrlB,imgBase64A,imgBase64B);
        try {
            Client client = createFaceClient();
            CompareFaceAdvanceRequest compareFaceRequest = new CompareFaceAdvanceRequest();
            if(imgUrlA!=null){
                compareFaceRequest.setImageURLAObject(imgUrlA);
            }
            if(imgUrlB!=null){
                compareFaceRequest.setImageURLBObject(imgUrlB);
            }
            if(imgBase64A!=null){
                compareFaceRequest.setImageDataA(imgBase64A);
            }
            if(imgBase64B!=null){
                compareFaceRequest.setImageDataB(imgBase64B);
            }

            CompareFaceResponse response = client.compareFaceAdvance(compareFaceRequest,new RuntimeOptions());
//            logger.info("对比两张图片是否是同一个人,imgUrlA={}  imgUrlB={}  imgBase64A={}   imgBase64B={} response={}",imgUrlA,imgUrlB,imgBase64A,imgBase64B,JSONObject.toJSONString(response));
            if(response.getStatusCode()==200){
                CompareFaceResponseBody.CompareFaceResponseBodyData faceData = response.getBody().getData();
                if(faceData.getConfidence()>confidence){
                    return CommonResponse.success(true);
                }
                return CommonResponse.error("人脸验证不通过！",false);
            }
        } catch (Exception error) {
            logger.info("对比两张图片是否是同一个人,imgUrlA={}  imgUrlB={}  imgBase64A={}   imgBase64B={} error={}",imgUrlA,imgUrlB,imgBase64A,imgBase64B,error.getMessage());
            if(error.getMessage()!=null && error.getMessage().contains("code: 400")){
                int time = new Random().nextInt(3000);
                logger.info("对比两张图片是否是同一个人，因为限流，"+time+"毫秒后，即将重试....");
                try {
                    Thread.sleep(time);
                } catch (InterruptedException e) {
                }
                return compareFace( imgUrlA!=null?new ByteArrayInputStream(imgStrA):null, imgUrlB!=null?new ByteArrayInputStream(imgStrB):null, imgBase64A, imgBase64B,imgStrA,imgStrB);
            }
        }
        return CommonResponse.error("人脸照片校验失败！",false);
    }


    /**
     * 对比两张图片是否是同一个人 支持戴口罩进行识别
     *
     * 仅支持Base64编码字符串输入。
     *
     * @param imgBase64A
     * @param imgBase64B
     * @return 是，返回true，不是返回false
     */
    @Override
    public CommonResponse<Boolean> compareFaceWithMask(String imgBase64A,String imgBase64B){
//        logger.info("对比两张图片是否是同一个人 支持戴口罩进行识别,imgBase64A={}   imgBase64B={} ",imgBase64A,imgBase64B);
        try {
            Client client = createFaceClient();
            VerifyFaceMaskRequest request = new VerifyFaceMaskRequest();
            request.setImageData(imgBase64A.getBytes(StandardCharsets.UTF_8));
            request.setRefData(imgBase64B.getBytes(StandardCharsets.UTF_8));

            VerifyFaceMaskResponse response = client.verifyFaceMask(request);
//            logger.info("对比两张图片是否是同一个人 支持戴口罩进行识别,imgBase64A={}   imgBase64B={} response={}",imgBase64A,imgBase64B,JSONObject.toJSONString(response));
            if(response.getStatusCode()==200){
                VerifyFaceMaskResponseBody.VerifyFaceMaskResponseBodyData  faceData = response.getBody().getData();
                if(faceData.getConfidence()>confidence){
                    return CommonResponse.success(true);
                }
                return CommonResponse.error("人脸验证不通过！",false);
            }
        } catch (Exception error) {
            logger.info("对比两张图片是否是同一个人 支持戴口罩进行识别,imgBase64A={}   imgBase64B={} error={}",imgBase64A,imgBase64B,error.getMessage());
            if(error.getMessage()!=null && error.getMessage().contains("code: 400")){
                int time = new Random().nextInt(3000);
                logger.info("戴口罩进行识别对比两张图片是否是同一个人，因为限流，"+time+"毫秒后，即将重试....");
                try {
                    Thread.sleep(time);
                } catch (InterruptedException e) {
                }
                return compareFaceWithMask( imgBase64A, imgBase64B);
            }
        }
        return CommonResponse.error("人脸照片校验失败！",false);
    }


    /**
     * ！！！！！！！！！！！
     * 创建人脸数据库，此接口仅用于公有云平台管理调用，业务请勿调用！！！！！！！！！！
     * ！！！！！！！！！！！
     * @param name
     * @return
     */
    @Override
    public CommonResponse<Boolean> createFaceDb(String name){
        logger.info("创建人脸数据库,name={} ",name);
        try {
            Client client = createFaceClient();
            CreateFaceDbRequest request = new CreateFaceDbRequest();
            request.setName(name);
            CreateFaceDbResponse response = client.createFaceDb(request);
//            logger.info("创建人脸数据库,name={}  response={}",name,JSONObject.toJSONString(response));
            if(response.getStatusCode() == 200){
                return CommonResponse.success("创建成功！",true);
            }
        }catch (Exception e){
            logger.info("创建人脸数据库,name={}  error={}",name,e.getMessage());
            e.printStackTrace();
        }
        return CommonResponse.error("创建失败！",false);
    }


    /**
     * ！！！！！！！！！！！
     * 删除人脸数据库，此接口仅用于公有云平台管理调用，业务请勿调用！！！！！！！！！！
     * ！！！！！！！！！！！
     * @param name
     * @return
     */
    @Override
    public CommonResponse<Boolean> deleteFaceDb(String name){
        logger.info("创建人脸数据库,name={} ",name);
        try {
            Client client = createFaceClient();
            DeleteFaceDbRequest request = new DeleteFaceDbRequest();
            request.setName(name);
            DeleteFaceDbResponse response = client.deleteFaceDb(request);
//            logger.info("删除人脸数据库,name={}  response={}",name,JSONObject.toJSONString(response));
            if(response.getStatusCode() == 200){
                return CommonResponse.success("删除成功！",true);
            }
        }catch (Exception e){
            logger.info("删除人脸数据库,name={}  error={}",name,e.getMessage());
            e.printStackTrace();
        }
        return CommonResponse.error("删除失败！",false);
    }


    /**
     * 创建人脸数据库用户
     * @param userId
     * @param userName
     * @return
     */
    @Override
    public CommonResponse<Boolean> createFaceDbUser(Long userId,String userName){
        logger.info("创建人脸数据库用户,userId={}   userName={} ",userId,userName);
        try {
            Client client = createFaceClient();
            AddFaceEntityRequest request = new AddFaceEntityRequest();
            request.setDbName(defaultFaceDb);
            request.setEntityId("user_"+userId);
            request.setLabels(userName);
            AddFaceEntityResponse response = client.addFaceEntity(request);
            logger.info("创建人脸数据库用户,userId={}   userName={}  response={} ",userId,userName,JSONObject.toJSONString(response));
            if(response.getStatusCode() == 200){
                return CommonResponse.success("创建人脸用户成功！",true);
            }
        }catch (Exception e){
            logger.info("创建人脸数据库用户,userId={}   userName={}  error={} ",userId,userName,e.getMessage());
            e.printStackTrace();
        }
        return CommonResponse.error("创建人脸用户失败！",false);
    }

    /**
     * 更新人脸数据库用户
     * @param userId
     * @param userName
     * @return
     */
    @Override
    public CommonResponse<Boolean> updateFaceDbUser(Long userId,String userName){
//        logger.info("更新人脸数据库用户,userId={}   userName={} ",userId,userName);
        try {
            Client client = createFaceClient();
            UpdateFaceEntityRequest request = new UpdateFaceEntityRequest();
            request.setDbName(defaultFaceDb);
            request.setEntityId("user_"+userId);
            request.setLabels(userName);
            UpdateFaceEntityResponse response = client.updateFaceEntity(request);
            logger.info("更新人脸数据库用户,userId={}   userName={}  response={} ",userId,userName,JSONObject.toJSONString(response));
            if(response.getStatusCode() == 200){
                return CommonResponse.success("更新人脸用户成功！",true);
            }
        }catch (Exception e){
            logger.info("更新人脸数据库用户,userId={}   userName={}  error={} ",userId,userName,e.getMessage());
            e.printStackTrace();
        }
        return CommonResponse.error("更新人脸用户失败！",false);
    }

    /**
     * 删除人脸数据库用户
     * @param userId
     * @return
     */
    @Override
    public CommonResponse<Boolean> deleteFaceDbUser(Long userId){
        logger.info("删除人脸数据库用户,userId={} ",userId);
        try {
            Client client = createFaceClient();
            DeleteFaceEntityRequest request = new DeleteFaceEntityRequest();
            request.setDbName(defaultFaceDb);
            request.setEntityId("user_"+userId);
            DeleteFaceEntityResponse response = client.deleteFaceEntity(request);
            logger.info("删除人脸数据库用户,userId={} response={} ",userId,JSONObject.toJSONString(response));
            if(response.getStatusCode() == 200){
                return CommonResponse.success("删除人脸用户成功！",true);
            }
        }catch (Exception e){
            logger.info("删除人脸数据库用户,userId={} error={} ",userId,e.getMessage());
            e.printStackTrace();
        }
        return CommonResponse.error("删除人脸用户失败！",false);
    }


    /**
     * 查询人脸数据库用户是否存在
     * true 已存在，false不存在
     * @param userId
     * @return
     */
    @Override
    public CommonResponse<Boolean> getFaceDbUser(Long userId){
        logger.info("查询人脸数据库用户是否存在,userId={} ",userId);
        try {
            Client client = createFaceClient();
            GetFaceEntityRequest request = new GetFaceEntityRequest();
            request.setDbName(defaultFaceDb);
            request.setEntityId("user_"+userId);
            GetFaceEntityResponse response = client.getFaceEntity(request);
//            logger.info("查询人脸数据库用户是否存在,userId={} response={} ",userId,JSONObject.toJSONString(response));
            if(response.getStatusCode() == 200){
                if(response.getBody().getData()!=null){
                    return CommonResponse.success("人脸用户已注册！",true);
                }
                return CommonResponse.success("人脸用户未注册！",false);
            }
        }catch (Exception error){
            logger.info("查询人脸数据库用户是否存在,userId={} error={} ",userId,error.getMessage());
            if(error.getMessage()!=null && error.getMessage().contains("code: 400")){
                int time = new Random().nextInt(3000);
                logger.info("查询人脸数据库用户是否存在，因为限流，"+time+"毫秒后，即将重试....");
                try {
                    Thread.sleep(time);
                } catch (InterruptedException e) {
                }
                return getFaceDbUser(userId);
            }
        }
        return CommonResponse.error("查询人脸用户失败！",false);
    }


    /**
     * 根据照片，查询符合照片的员工id
     *
     * @param inputStream
     * @return userId
     */
    @Override
    public CommonResponse<List<Long>> getUserByFaceStream(InputStream inputStream,byte[] imgBytes){
        logger.info("根据照片，查询符合照片的员工id,inputStream={} ",inputStream);
        try {
            Client client = createFaceClient();
            SearchFaceAdvanceRequest request = new SearchFaceAdvanceRequest();
            request.setDbName(defaultFaceDb);
            request.setImageUrlObject(inputStream);
            request.setQualityScoreThreshold(confidence);
            request.setMaxFaceNum(1L);
            request.setLimit(10);
            SearchFaceResponse response = client.searchFaceAdvance(request,new RuntimeOptions());
//            logger.info("根据照片，查询符合照片的员工id,inputStream={} response={}",inputStream,JSONObject.toJSONString(response));
            List<Long> res = new ArrayList<>();
            Map<String,String> map = new HashMap<>();
            if(response.getStatusCode() == 200){
                if(response.getBody().getData()!=null && ListUtil.isNotEmpty(response.getBody().getData().getMatchList())){
                    SearchFaceResponseBody.SearchFaceResponseBodyDataMatchList list = response.getBody().getData().getMatchList().get(0);
                    if(ListUtil.isNotEmpty(list.getFaceItems())){
                        for (SearchFaceResponseBody.SearchFaceResponseBodyDataMatchListFaceItems items : list.getFaceItems()) {
                            if(StringUtils.isEmpty(map.get(items.getEntityId()))){
                                Long userId = Long.parseLong(items.getEntityId().substring(5));
                                res.add(userId);
                                map.put(items.getEntityId(),items.getEntityId());
                            }
                        }
                        return CommonResponse.success(res);
                    }
                }
                return CommonResponse.error("未查询到该人脸信息！");
            }
        }catch (Exception error){
            logger.info("根据照片，查询符合照片的员工id,inputStream={} error={}",inputStream,error.getMessage());
            if(error.getMessage()!=null && error.getMessage().contains("code: 400")){
                int time = new Random().nextInt(3000);
                logger.info("根据照片，查询符合照片的员工id，因为限流，"+time+"毫秒后，即将重试....");
                try {
                    Thread.sleep(time);
                } catch (InterruptedException e) {
                }
                return getUserByFaceStream(new ByteArrayInputStream(imgBytes),imgBytes);
            }
        }
        return CommonResponse.error("查询人脸用户失败！");
    }



    /**
     * 添加人脸数据到指定用户
     *
     * @param userId
     * @param imageUrl
     * @return
     */
    @Override
    public CommonResponse<Boolean> addFaceToUser(Long userId,InputStream imageUrl,byte[] imgBytes){
//        logger.info("添加人脸数据到指定用户,userId={}   imageUrl={} ",userId,imageUrl);
        try {
            Client client = createFaceClient();
            AddFaceAdvanceRequest request = new AddFaceAdvanceRequest();
            request.setDbName(defaultFaceDb);
            request.setEntityId("user_"+userId);
            request.setImageUrlObject(imageUrl);
            request.setQualityScoreThreshold(confidence);
            request.setSimilarityScoreThresholdInEntity(confidence);

            AddFaceResponse response = client.addFaceAdvance(request,new RuntimeOptions());
//            logger.info("添加人脸数据到指定用户,userId={}   imageUrl={} response={}",userId,imageUrl,JSONObject.toJSONString(response));
            if(response.getStatusCode() == 200){
                if(response.getBody().getData()!=null){
                    return CommonResponse.success("添加人脸成功！",true);
                }
            }
        }catch (Exception error){
            logger.info("添加人脸数据到指定用户,userId={}   imageUrl={} error={}",userId,imageUrl,error.getMessage());
            if(error.getMessage()!=null && error.getMessage().contains("code: 400")){
                int time = new Random().nextInt(3000);
                logger.info("添加人脸数据到指定用户，因为限流，"+time+"毫秒后，即将重试....");
                try {
                    Thread.sleep(time);
                } catch (InterruptedException e) {
                }
                return addFaceToUser(userId,new ByteArrayInputStream(imgBytes),imgBytes);
            }
        }
        return CommonResponse.error("添加人脸失败！",false);
    }


    /**
     * 身份证件是否翻拍校验
     * true 翻拍，false 直拍
     * @param imageUrl
     * @return
     */
    @Override
    public CommonResponse<Boolean> detectCardScreenshot(InputStream imageUrl,byte[] imgBytes){
//        logger.info("身份证件是否翻拍校验,imgUrl={} ",imageUrl);
        try {
            com.aliyun.ocr20191230.Client client = createOcrClient();
            com.aliyun.ocr20191230.models.DetectCardScreenshotAdvanceRequest detectCardScreenshotRequest = new com.aliyun.ocr20191230.models.DetectCardScreenshotAdvanceRequest()
                    .setImageURLObject(imageUrl);
            DetectCardScreenshotResponse response = client.detectCardScreenshotAdvance(detectCardScreenshotRequest,new RuntimeOptions());
//            logger.info("身份证件是否翻拍校验,imgUrl={} response={}",imageUrl,JSONObject.toJSONString(response));
            if(response.getStatusCode()==200){
                if(response.getBody().getData()!=null){
                    DetectCardScreenshotResponseBody.DetectCardScreenshotResponseBodyData  data = response.getBody().getData();
                    if(data.getIsBlur()){
                        return CommonResponse.error("照片不清晰！",false);
                    }
                    if(!data.getIsCard()){
                        return CommonResponse.error("照片不是证件照！",false);
                    }
                    DetectCardScreenshotResponseBody.DetectCardScreenshotResponseBodyDataSpoofResult result = data.getSpoofResult();
                    if(result.getIsSpoof()){
                        return CommonResponse.success("照片是翻拍证件照！",true);
                    }
                    return CommonResponse.success("照片不是翻拍证件照！",false);
                }
            }
        }catch (Exception error){
            logger.info("身份证件是否翻拍校验,imgUrl={} error={}",imageUrl,error.getMessage());
            if(error.getMessage()!=null && error.getMessage().contains("code: 400")){
                int time = new Random().nextInt(3000);
                logger.info("身份证件是否翻拍校验，因为限流，"+time+"毫秒后，即将重试....");
                try {
                    Thread.sleep(time);
                } catch (InterruptedException e) {
                }
                return detectCardScreenshot(new ByteArrayInputStream(imgBytes),imgBytes);
            }
        }
        return CommonResponse.error("校验是否翻拍证件照失败！",false);
    }


    /**
     * 身份证件 信息识别
     * true 翻拍，false 直拍
     * @param imageUrl
     * @param side face：人像面  back：国徽面
     * @return side 是 back 才返回startDate，endDate，issue
     *
     * {
     *     name:姓名,
     *     gender:性别：男、女,
     *     nationality:民族:汉,
     *     birthDate:出生19901122,
     *     address:住址,
     *     idNumber:身份证号,
     *
     *     startDate:起始有效期20200102,
     *     endDate:截止有效期20290102,
     *     issue:颁发机关：xxx公安局
     * }
     */
    @Override
    public CommonResponse<JSONObject> recognizeIdentityCardInfo(InputStream imageUrl,String side,byte[] imgBytes){
//        logger.info("身份证件 信息识别,side={}   imageUrl={} ",side,imageUrl);
        if(imageUrl==null || StringUtils.isEmpty(side)){
            return CommonResponse.error("参数有空值！");
        }
        if(!("face".equals(side) || "back".equals(side))){
            return CommonResponse.error("side参数值必须是字符串face或者back！其中face：人像面  back：国徽面！");
        }
        JSONObject res = new JSONObject();
        res.put("side",side);
        try {
            com.aliyun.ocr20191230.Client client = createOcrClient();
            com.aliyun.ocr20191230.models.RecognizeIdentityCardAdvanceRequest recognizeIdentityCardRequest = new com.aliyun.ocr20191230.models.RecognizeIdentityCardAdvanceRequest()
                    .setImageURLObject(imageUrl).setSide(side);
            RecognizeIdentityCardResponse response = client.recognizeIdentityCardAdvance(recognizeIdentityCardRequest,new RuntimeOptions());
//            logger.info("身份证件 信息识别,side={}   imageUrl={} response={}",side,imageUrl,JSONObject.toJSONString(response));
            if(response.getStatusCode()==200){
                if(response.getBody().getData()!=null){
                    RecognizeIdentityCardResponseBody.RecognizeIdentityCardResponseBodyData data = response.getBody().getData();
                    if("face".equals(side)){
                        RecognizeIdentityCardResponseBody.RecognizeIdentityCardResponseBodyDataFrontResult frontResult = data.getFrontResult();
                        res.put("name",frontResult.getName());
                        res.put("gender",frontResult.getGender());
                        res.put("nationality",frontResult.getNationality());
                        res.put("birthDate",frontResult.getBirthDate());
                        res.put("address",frontResult.getAddress());
                        res.put("idNumber",frontResult.getIDNumber());
                    }else {
                        RecognizeIdentityCardResponseBody.RecognizeIdentityCardResponseBodyDataBackResult frontResult = data.getBackResult();
                        res.put("startDate",frontResult.getStartDate());
                        res.put("endDate",frontResult.getEndDate());
                        res.put("issue",frontResult.getIssue());
                    }
                    return CommonResponse.success(res);
                }
            }
        }catch (Exception error){
            logger.info("身份证件 信息识别,side={} imageUrl={} error={}",side,imageUrl,error.getMessage());
            if(error.getMessage()!=null && error.getMessage().contains("code: 400")){
                int time = new Random().nextInt(3000);
                logger.info("身份证件 信息识别，因为限流，"+time+"毫秒后，即将重试....");
                try {
                    Thread.sleep(time);
                } catch (InterruptedException e) {
                }
                return recognizeIdentityCardInfo(new ByteArrayInputStream(imgBytes),side,imgBytes);
            }
        }
        return CommonResponse.error("身份证识别失败！");
    }

    @Override
    public CommonResponse<List<String>> recognizePdfInfo(String pdfUrl) {
        if(StringUtils.isEmpty(pdfUrl)){
            return CommonResponse.error("参数有空值！");
        }
        List<String> res = new ArrayList<>();
        try {
            com.aliyun.ocr20191230.Client client = createOcrClient();
            com.aliyun.ocr20191230.models.RecognizePdfAdvanceRequest recognizePdfAdvanceRequest = new com.aliyun.ocr20191230.models.RecognizePdfAdvanceRequest();
            recognizePdfAdvanceRequest.setFileURLObject(getOssUrlInputStream(pdfUrl));
            RecognizePdfResponse response = client.recognizePdfAdvance(recognizePdfAdvanceRequest,new RuntimeOptions());
            if(response.getStatusCode()==200){
                if(response.getBody().getData()!=null){
                    logger.info("pdf 信息识别结果, pdfUrl={} ", pdfUrl);
                    RecognizePdfResponseBody.RecognizePdfResponseBodyData data = response.getBody().getData();
                    for (RecognizePdfResponseBody.RecognizePdfResponseBodyDataWordsInfo wordsInfo : data.getWordsInfo()) {
                        res.add(wordsInfo.getWord());
                        logger.info(wordsInfo.getWord());
                    }
                    return CommonResponse.success(res);
                }
            }
        }catch (Exception error){
            logger.info("pdf 信息识别, pdfUrl={} error={}", pdfUrl,error.getMessage());
            if(error.getMessage()!=null && error.getMessage().contains("code: 400")){
                int time = new Random().nextInt(3000);
                logger.info("pdf 信息识别，因为限流，"+time+"毫秒后，即将重试....");
                try {
                    Thread.sleep(time);
                } catch (InterruptedException e) {
                }
                return recognizePdfInfo(pdfUrl);
            }
        }
        return CommonResponse.error("pdf 信息识别失败！");
    }
}
