package com.ejianc.foundation.orgcenter.bean;

import java.util.Date;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;

/**
 * 任职bean
 * 
 * @author guominga
 *
 */
@TableName("ejc_idm_job")
public class JobEntity extends BaseEntity {

	private static final long serialVersionUID = 1L;

	/**
	 * 组织ID
	 */
	@TableField(value = "org_id")
	private Long orgId;

	/**
	 * 岗位ID
	 */
	@TableField(value = "post_id")
	private Long postId;

	/**
	 * 部门ID
	 */
	@TableField(value = "dept_id")
	private Long deptId;

	/**
	 * 员工ID
	 */
	@TableField(value = "employee_id")
	private Long employeeId;

	/**
	 * 是否主职 1：是 0：否
	 */
	@TableField(value = "property")
	private Integer property;

	/**
	 * 是否部门负责人 1：是 0：否
	 */
	@TableField(value = "dept_head")
	private Integer deptHead;

	/**
	 * 开始任职时间
	 */
	@TableField(value = "job_start_time")
	private Date jobStartTime;

	/**
	 * 结束任职时间
	 */
	@TableField(value = "job_end_time")
	private Date jobEndTime;

	/**
	 * 状态标识
	 */
	@TableField(value = "cur_state")
	private Integer curState;

	@TableField(value = "source_id")
	private String sourceId; // 来源id

	@TableField(value = "source_org_id")
	private String sourceOrgId; // 来源组织id(同步数据使用）

	@TableField(value = "source_dept_id")
	private String sourceDeptId; // 来源部门id(同步数据使用）

	@TableField(value = "system_id")
	private String systemId; // 系统id

	@TableField(value = "project_post")
	private String projectPost; // 項目职务

	@TableField(value = "emp_experience")
	private String empExperience; // 人员经历

	public Long getOrgId() {
		return orgId;
	}

	public void setOrgId(Long orgId) {
		this.orgId = orgId;
	}

	public Long getPostId() {
		return postId;
	}

	public void setPostId(Long postId) {
		this.postId = postId;
	}

	public Long getDeptId() {
		return deptId;
	}

	public void setDeptId(Long deptId) {
		this.deptId = deptId;
	}

	public Long getEmployeeId() {
		return employeeId;
	}

	public void setEmployeeId(Long employeeId) {
		this.employeeId = employeeId;
	}

	public Integer getProperty() {
		return property;
	}

	public void setProperty(Integer property) {
		this.property = property;
	}

	public Date getJobStartTime() {
		return jobStartTime;
	}

	public void setJobStartTime(Date jobStartTime) {
		this.jobStartTime = jobStartTime;
	}

	public Date getJobEndTime() {
		return jobEndTime;
	}

	public void setJobEndTime(Date jobEndTime) {
		this.jobEndTime = jobEndTime;
	}

	public Integer getCurState() {
		return curState;
	}

	public void setCurState(Integer curState) {
		this.curState = curState;
	}

	public String getSourceId() {
		return sourceId;
	}

	public void setSourceId(String sourceId) {
		this.sourceId = sourceId;
	}

	public String getSystemId() {
		return systemId;
	}

	public void setSystemId(String systemId) {
		this.systemId = systemId;
	}

	public String getSourceOrgId() {
		return sourceOrgId;
	}

	public void setSourceOrgId(String sourceOrgId) {
		this.sourceOrgId = sourceOrgId;
	}

	public String getSourceDeptId() {
		return sourceDeptId;
	}

	public void setSourceDeptId(String sourceDeptId) {
		this.sourceDeptId = sourceDeptId;
	}

	public Integer getDeptHead() {
		return deptHead;
	}

	public void setDeptHead(Integer deptHead) {
		this.deptHead = deptHead;
	}

	public String getProjectPost() {
		return projectPost;
	}

	public void setProjectPost(String projectPost) {
		this.projectPost = projectPost;
	}

	public String getEmpExperience() {
		return empExperience;
	}

	public void setEmpExperience(String empExperience) {
		this.empExperience = empExperience;
	}

}
