package com.ejianc.foundation.orgcenter.service.impl;

import java.util.List;

import org.apache.ibatis.builder.BuilderException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.orgcenter.bean.JobEntity;
import com.ejianc.foundation.orgcenter.bean.PostEntity;
import com.ejianc.foundation.orgcenter.mapper.JobMapper;
import com.ejianc.foundation.orgcenter.mapper.PostMapper;
import com.ejianc.foundation.orgcenter.service.IPostService;
import com.ejianc.foundation.orgcenter.vo.PostVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;

@Service("postService")
public class PostServiceImpl extends BaseServiceImpl<PostMapper, PostEntity> implements IPostService {

	private static final String POST_BILL_CODE = "IDM_POST";
	
	@Autowired
	private JobMapper jobMapper;
	@Autowired
	private IBillCodeApi billCodeApi;
    @Value("${oms.tenantid}")
    private String BASE_TENANT_ID;

    @Autowired
    private PostMapper postMapper;

    @Override
    public void delete(List<Long> ids){
    	//判断岗位是否已经有人员任职了
    	QueryWrapper<JobEntity> jobQueryWrapper = new QueryWrapper<>();
    	jobQueryWrapper.in("post_id", ids);
    	List<JobEntity> jobs = jobMapper.selectList(jobQueryWrapper);
    	if(jobs != null && jobs.size() > 0) {
    		throw new BusinessException("要删除的岗位中已经有人员任职了， 不允许删除！");
    	}
        baseMapper.deleteBatchIds(ids);
    }

    @Override
    public PostVO queryDetail(Long id) throws Exception {
        PostVO vo = null;
        PostEntity e = baseMapper.selectById(id);
        if(null != e) {
            vo = BeanMapper.map(e, PostVO.class);
        }
        return vo;
    }

    @Override
    public void save(PostVO postVo) throws Exception {
    	Long tenantId = InvocationInfoProxy.getTenantid();
        PostEntity saveData = null;
        if(null != postVo.getId()) {
            //更新
            saveData = baseMapper.selectById(postVo.getId());
            saveData.setNote(postVo.getNote());
            saveData.setName(postVo.getName());
            saveData.setSequence(postVo.getSequence());
            saveData.setState(postVo.getState());
            saveData.setPostDictId(postVo.getPostDictId());
        } else {
            //新增
        	CommonResponse<String> postResponse = billCodeApi.getCodeBatchByRuleCode(POST_BILL_CODE, tenantId);
        	if(postResponse.isSuccess()) {
        		postVo.setCode(postResponse.getData());
        	}else{
        		throw new BuilderException("网络异常， 编码生成失败， 请稍后再试");
        	}
            postVo.setTenantId(tenantId);
            //默认为自定义类型
            postVo.setType(0);
            postVo.setDr(BaseVO.DR_UNDELETE);
            saveData = BeanMapper.map(postVo, PostEntity.class);            
//            saveData.setOrgId(InvocationInfoProxy.getOrgId());
        }
        super.saveOrUpdate(saveData);
    }

    @Override
    public void changeState(PostVO postVO) {
        PostEntity entity = baseMapper.selectById(postVO.getId());
        if(null == entity) {
            throw new RuntimeException("修改岗位状态失败，岗位不存在或已被删除！");
        }
        entity.setState(postVO.getState());
        super.saveOrUpdate(entity);
    }

    @Override
    public PostEntity selectById(Long postId) {
        return baseMapper.selectById(postId);
    }

    @Override
    public List<PostEntity> getAllByIds(List<Long> postIds) {
        return baseMapper.selectBatchIds(postIds);
    }

    @Override
    public void changeType(PostVO postVO) {
        PostEntity entity = baseMapper.selectById(postVO.getId());
        if(null == entity) {
            throw new RuntimeException("修改岗位类型失败，岗位不存在或已被删除！");
        }
        entity.setType(postVO.getType());
        super.saveOrUpdate(entity);
    }

    @Override
    public void insertPostListFromPlatform() {
        Long tenantId = InvocationInfoProxy.getTenantid();
        List<PostVO> addList = postMapper.unSyncPostList(tenantId);
        if(!addList.isEmpty()) {
            CommonResponse<List<String>> codes = billCodeApi.getCodeBatchByRuleCode(POST_BILL_CODE, tenantId, addList.size());
            if(!codes.isSuccess()) {
                throw new RuntimeException("同步平台岗位档案失败，自动生成岗位编码失败！");
            }
            List<String> codeList = codes.getData();
            for(int i =0; i<codeList.size(); i++) {
                addList.get(i).setCode(codeList.get(i));
            }
            super.saveOrUpdateBatch(BeanMapper.mapList(addList, PostEntity.class));
        }
    }


    @Override
    public Integer getCountByPostDictId(Long id){
        QueryWrapper<PostEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("post_dict_id",id);
        queryWrapper.eq("dr",0);
        Integer count = postMapper.selectCount(queryWrapper);
        return count;
    }
}
