/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.operatelog.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.operatelog.service.IOperateLogService;
import com.ejianc.foundation.operatelog.vo.OperateLogVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OperateLogServiceImpl
implements IOperateLogService {
    private static final Integer QUERY_TIMEOUT = 60;
    private static final String ASC = "asc";
    private static final String INDEX_NAME = "ejclogspace";
    @Autowired(required=false)
    private RestHighLevelClient client;

    @Override
    public IPage<OperateLogVO> queryPageList(QueryParam queryParam) {
        IPage<OperateLogVO> page = new IPage<OperateLogVO>();
        SearchRequest searchRequest = new SearchRequest(new String[]{INDEX_NAME});
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
        Map paramMap = queryParam.getParams();
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery();
        for (Map.Entry entry : paramMap.entrySet()) {
            Parameter parameter = (Parameter)entry.getValue();
            if (parameter.getValue() == null || StringUtils.isBlank((CharSequence)(parameter.getValue() + ""))) continue;
            if ("eq".equals(parameter.getType())) {
                boolQuery.must((QueryBuilder)QueryBuilders.termQuery((String)((String)entry.getKey()), (String)parameter.getValue().toString()));
                continue;
            }
            if ("like".equals(parameter.getType())) {
                boolQuery.must((QueryBuilder)QueryBuilders.matchQuery((String)((String)entry.getKey()), (Object)parameter.getValue().toString()));
                continue;
            }
            if ("in".equals(parameter.getType())) {
                boolQuery.must((QueryBuilder)QueryBuilders.termQuery((String)((String)entry.getKey()), (Object)parameter.getValue().toString().split(",")));
                continue;
            }
            if ("between".equals(parameter.getType())) {
                String[] dataArr = parameter.getValue().toString().split(",");
                boolQuery.must((QueryBuilder)QueryBuilders.rangeQuery((String)((String)entry.getKey())).from((Object)dataArr[0]).to((Object)dataArr[1]).includeLower(true).includeUpper(true));
                continue;
            }
            if ("gt".equals(parameter.getType())) {
                boolQuery.must((QueryBuilder)QueryBuilders.rangeQuery((String)((String)entry.getKey())).gt((Object)parameter.getValue().toString()));
                continue;
            }
            if ("ge".equals(parameter.getType())) {
                boolQuery.must((QueryBuilder)QueryBuilders.rangeQuery((String)((String)entry.getKey())).gte((Object)parameter.getValue().toString()));
                continue;
            }
            if ("lt".equals(parameter.getType())) {
                boolQuery.must((QueryBuilder)QueryBuilders.rangeQuery((String)((String)entry.getKey())).lt((Object)parameter.getValue().toString()));
                continue;
            }
            if (!"le".equals(parameter.getType())) continue;
            boolQuery.must((QueryBuilder)QueryBuilders.rangeQuery((String)((String)entry.getKey())).lte((Object)parameter.getValue().toString()));
        }
        sourceBuilder.query((QueryBuilder)boolQuery);
        LinkedHashMap orderMap = queryParam.getOrderMap();
        if (orderMap != null && !orderMap.isEmpty()) {
            for (Map.Entry entry : orderMap.entrySet()) {
                sourceBuilder.sort(new FieldSortBuilder((String)entry.getKey() + ".keyword").order(ASC.equals(((String)entry.getValue()).toLowerCase()) ? SortOrder.ASC : SortOrder.DESC));
            }
        }
        sourceBuilder.from(queryParam.getPageIndex() <= 0 ? 0 : (queryParam.getPageIndex() - 1) * queryParam.getPageSize());
        sourceBuilder.size(queryParam.getPageSize());
        sourceBuilder.trackTotalHits(true);
        sourceBuilder.timeout(new TimeValue((long)QUERY_TIMEOUT.intValue(), TimeUnit.SECONDS));
        searchRequest.source(sourceBuilder);
        try {
            page = this.queryPage(searchRequest);
        }
        catch (IOException e) {
            try {
                page = this.queryPage(searchRequest);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                throw new BusinessException("\u6839\u636e parammap \u6761\u4ef6\uff0c\u67e5\u8be2\u5168\u90e8\u8bb0\u5f55\u7d22\u5f15\u5931\u8d25\uff0cMSG\uff1a" + iOException.getMessage());
            }
        }
        return page;
    }

    private IPage<OperateLogVO> queryPage(SearchRequest searchRequest) throws IOException {
        Page page = new Page();
        ArrayList<Object> list = new ArrayList<Object>();
        SearchResponse response = this.client.search(searchRequest, RequestOptions.DEFAULT);
        SearchHits hits = response.getHits();
        for (SearchHit hit : hits) {
            String sourceAsString = hit.getSourceAsString();
            list.add(JSON.parseObject((String)sourceAsString, OperateLogVO.class));
        }
        page.setRecords(list);
        page.setTotal(hits.getTotalHits().value);
        return page;
    }
}

