package com.ejianc.foundation.sync.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.orgcenter.bean.OrgEntity;
import com.ejianc.foundation.orgcenter.service.IOrgService;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.sync.service.IZjkjTianJianSyncService;
import com.ejianc.foundation.usercenter.bean.ThirdSystemEntity;
import com.ejianc.foundation.usercenter.bean.UserEntity;
import com.ejianc.foundation.usercenter.service.IThirdSystemService;
import com.ejianc.foundation.usercenter.service.IUserService;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.foundation.utils.HttpTookit;
import com.ejianc.framework.core.exception.BusinessException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;

import java.text.SimpleDateFormat;
import java.util.*;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

@Service
public class ZjkjTianJianSyncServiceImpl implements IZjkjTianJianSyncService {

	private Logger logger = LoggerFactory.getLogger(this.getClass());

	@Value("${tianjianUrl:http://36.137.93.200:10006/open_api}")
	private String tianjianUrl;
	@Autowired
	private IOrgService orgService;

	@Autowired
	private IUserService userService;

	@Autowired
	private IThirdSystemService thirdSystemService;

	@Override
	public void syncData() {
		ThirdSystemEntity thirdSystemVO = thirdSystemService.queryThirdSystemByCode("sdbjSyncDate");
		//创建一个固定数量的线程池
		ExecutorService threadPool = Executors.newFixedThreadPool(3);
		RequestAttributes context = RequestContextHolder.getRequestAttributes();
		String beginTime = thirdSystemVO.getConfigInfo();
		String endTime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date());
		/********组织************/
		// 天鉴基础数据生产环境
		Callable<String> orgDeptCallable = new DataSync(beginTime, endTime, "org", context);
		Future<String> orgDeptFuture = threadPool.submit(orgDeptCallable);

		/********人员/用户************/
		// 天鉴基础数据生产环境
		Callable<String> userCallable = new DataSync(beginTime, endTime, "user", context);
		Future<String> userFuture = threadPool.submit(userCallable);

		String orgDeptData = null;
		String userData = null;
		try {
			orgDeptData = orgDeptFuture.get();
			userData = userFuture.get();
		} catch (Exception e) {
			logger.error("获取同步数据失败：{}", e);
			throw new BusinessException("获取同步数据失败");
		} finally {
			threadPool.shutdown();
		}
		logger.info("数据处理结束(- v -)!-------");

		thirdSystemVO.setConfigInfo(endTime);
		thirdSystemService.saveOrUpdate(thirdSystemVO,false);
	}

	@Override
	public void syncOrgList(String beginTime, String endTime) {
		QueryWrapper<OrgEntity> wrapper = new QueryWrapper<>();
		if(beginTime!=null){
			wrapper.between("create_time", beginTime, endTime).or().between("update_time", beginTime, endTime);
		}
		List<OrgEntity> addList = orgService.list(wrapper);

		List<JSONObject> deptList = new ArrayList<>();
		for (OrgEntity org : addList) {
			JSONObject d = new JSONObject();
			d.put("id", org.getId().toString());
			d.put("name", org.getName().toString());
			d.put("parentId", org.getParentId().toString());
			d.put("orgType", 2);
			deptList.add(d);
		}
		String token = getToken();
		Map<String, String> headers = new HashMap<>();
		headers.put("key", "Authorization");
		headers.put("value", "Bearer " + token);
		try{
			String url = tianjianUrl + "/depart/sync";
			JSONObject params = new JSONObject();
			params.put("deptList", deptList);
			String backData = HttpTookit.postByJson(url, params.toJSONString(), headers);
			JSONObject jsonResponse = JSON.parseObject(backData);
			if("200".equals(jsonResponse.getString("code"))){
			}else{
				throw new BusinessException("组织同步数据失败");
			}
		}catch (Exception e){
			throw new BusinessException("组织同步数据失败");
		}

		if(beginTime!=null){//第一次初始化不进行数据的删除操作
			//获取删除的数据
			List<OrgVO> delList = orgService.getDelOrgs(beginTime, endTime);
			if(delList!=null && delList.size()>0){
				for (OrgVO orgVO : delList) {
					try{
						String url = tianjianUrl + "/depart/remove";
						JSONObject params = new JSONObject();
						params.put("id", orgVO.getId().toString());
						String backData = HttpTookit.postByJson(url, params.toJSONString(), headers);
						JSONObject jsonResponse = JSON.parseObject(backData);
						if("200".equals(jsonResponse.getString("code"))){
						}else{
							throw new BusinessException("组织删除数据失败");
						}
					}catch (Exception e){
						throw new BusinessException("组织删除数据失败");
					}
				}
			}
		}


	}

	@Override
	public void syncUserList(String beginTime, String endTime) {
		QueryWrapper<UserEntity> wrapper = new QueryWrapper<>();
		if(beginTime!=null){
			wrapper.between("create_time", beginTime, endTime).or().between("update_time", beginTime, endTime);
		}
		List<UserEntity> addList = userService.list(wrapper);
		List<JSONObject> userList = new ArrayList<>();
		for (UserEntity user : addList) {
			JSONObject d = new JSONObject();
			d.put("id", user.getId().toString());
			d.put("username", user.getUserCode());
			d.put("realname", user.getUserName());
			d.put("phone", user.getUserMobile());
			List<JSONObject> deptList = new ArrayList<>();
			JSONObject org = new JSONObject();
			org.put("id", user.getOrgId().toString());
			deptList.add(org);
			d.put("deptList", deptList);
			d.put("email", user.getUserEmail());
			userList.add(d);
		}
		String token = getToken();
		Map<String, String> headers = new HashMap<>();
		headers.put("key", "Authorization");
		headers.put("value", "Bearer " + token);
		try{
			String url = tianjianUrl + "/user/sync";
			JSONObject params = new JSONObject();
			params.put("userList", userList);
			String backData = HttpTookit.postByJson(url, params.toJSONString(), headers);
			JSONObject jsonResponse = JSON.parseObject(backData);
			if("200".equals(jsonResponse.getString("code"))){
			}else{
				throw new BusinessException("人员同步数据失败");
			}
		}catch (Exception e){
			throw new BusinessException("人员同步数据失败");
		}

		if(beginTime!=null){//第一次初始化不进行数据的删除操作
			//获取删除的数据
			List<UserVO> delList = userService.getDelUsers(beginTime, endTime);
			if(delList!=null && delList.size()>0){
				for (UserVO orgVO : delList) {
					try{
						String url = tianjianUrl + "/user/remove";
						JSONObject params = new JSONObject();
						params.put("id", orgVO.getId().toString());
						String backData = HttpTookit.postByJson(url, params.toJSONString(), headers);
						JSONObject jsonResponse = JSON.parseObject(backData);
						if("200".equals(jsonResponse.getString("code"))){
						}else{
							throw new BusinessException("人员删除数据失败");
						}
					}catch (Exception e){
						throw new BusinessException("人员删除数据失败");
					}
				}
			}
		}

	}

	class DataSync implements Callable<String> {

		private String beginTime;
		private String endTime;
		private String type;
		private RequestAttributes context;

		public DataSync(String beginTime, String endTime, String type, RequestAttributes context) {
			this.beginTime = beginTime;
			this.endTime = endTime;
			this.type = type;
			this.context = context;
		}

		@Override
		public String call() throws Exception {
			if("org".equals(type)){
				syncOrgList(beginTime, endTime);
			}else if("user".equals(type)){
				syncUserList(beginTime, endTime);
			}
			return "";
		}

	}

	public String getToken() {
		String token = "";
		try{
			String url = tianjianUrl + "/token/get";
			JSONObject params = new JSONObject();
			params.put("restname", "root");
			params.put("password", "Zj@kj#qunje");
			params.put("appKey", "");
			params.put("appSecret", "");
			String backData = HttpTookit.postByJson(url, params.toJSONString());
			JSONObject jsonResponse = JSON.parseObject(backData);
			if("200".equals(jsonResponse.getString("code"))){
				JSONObject data = jsonResponse.getJSONObject("data");
				token = data.getString("token");
			}else{
				throw new BusinessException("获取token失败");
			}
		}catch (Exception e){
			throw new BusinessException("获取token失败");
		}
		return token;
	}
}
