package com.ejianc.foundation.usercenter.mapper;

import java.util.List;
import java.util.Map;

import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import com.ejianc.foundation.usercenter.bean.UserEntity;
import com.ejianc.foundation.usercenter.vo.UserRefVO;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.framework.skeleton.template.BaseCrudMapper;

@Mapper
public interface UserMapper extends BaseCrudMapper<UserEntity> {

	void updateUserPassword(@Param("userId") Long userId,@Param("password") String password);

	long countRef(Map<String, Object> params);

	List<UserRefVO> queryListRef(Map<String, Object> params);
	List<UserVO> getDelUsers(@Param("beginTime") String beginTime, @Param("endTime") String endTime);

	void updateUserState(@Param("userId") Long userId,@Param("state") Integer state);

	List<UserRefVO> queryList(Map<String, Object> queryParam);

	Long queryCount(Map<String, Object> queryParam);

	List<UserVO> queryUserByPostAndOrg(@Param("postIds") List<Long> postIds, @Param("orgIds") List<Long> orgIds);

	void unbindingWechat(@Param("userId") Long userId);

	void updateUserLastLoginTime(@Param("userId") Long userId);

	List<UserVO> selectAllByIds(@Param("userIds") List<Long> userIds,@Param("tenantId") Long tenantId);

	/**
	 * 查询所有用户刷新缓存使用
	 * 
	 * @return
	 */
	List<UserEntity> queryAllUsers();

	void updateTenantIdAndUserType(@Param("userType") Integer userType, @Param("userId") Long userId,
			@Param("tenantId") Long tenantId, @Param("orgId") Long orgId);

    List<String> selectSourceIds(@Param("users") List<String> users, @Param("tenantId") Long tenantId, @Param("type") String type);

	List<UserVO> queryMangerUserList(Map<String, Object> params);
}
