package com.ejianc.foundation.utils.ynsbj.param;

import java.util.ArrayList;
import java.util.List;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;

public class YnsbjEmp extends YnsbjBaseParam {

	private static final long serialVersionUID = 1L;

	private String employeeCode; // 人员编码 DESC2

	private String employeeName;// 姓名 DESC3

	private String deptCode; // 所属部门编码 DESC62

	private String mobilePhone; // 手机号 DESC46

	private String mainPostFlag; // 是否主职 DESC22

	private String sex; // 性别 DESC55

	private String email; // 邮箱 DESC47

	private String state; // 启用状态 DESC16
	
	private List<YnsbjEmpJob> empJobs = new ArrayList<>();

	public String getEmployeeCode() {
		return employeeCode;
	}

	public void setEmployeeCode(String employeeCode) {
		this.employeeCode = employeeCode;
	}

	public String getEmployeeName() {
		return employeeName;
	}

	public void setEmployeeName(String employeeName) {
		this.employeeName = employeeName;
	}

	public String getDeptCode() {
		return deptCode;
	}

	public void setDeptCode(String deptCode) {
		this.deptCode = deptCode;
	}

	public String getMobilePhone() {
		return mobilePhone;
	}

	public void setMobilePhone(String mobilePhone) {
		this.mobilePhone = mobilePhone;
	}

	public String getMainPostFlag() {
		return mainPostFlag;
	}

	public void setMainPostFlag(String mainPostFlag) {
		this.mainPostFlag = mainPostFlag;
	}

	public String getSex() {
		return sex;
	}

	public void setSex(String sex) {
		this.sex = sex;
	}

	public String getEmail() {
		return email;
	}

	public void setEmail(String email) {
		this.email = email;
	}

	public String getState() {
		return state;
	}

	public void setState(String state) {
		this.state = state;
	}
	
	public List<YnsbjEmpJob> getEmpJobs() {
		return empJobs;
	}

	public void setEmpJobs(List<YnsbjEmpJob> empJobs) {
		this.empJobs = empJobs;
	}

	public YnsbjEmp() {}

	public YnsbjEmp(String employeeCode, String employeeName, String deptCode, String mobilePhone, String mainPostFlag,
			String sex, String email, String state) {
		super();
		this.employeeCode = employeeCode;
		this.employeeName = employeeName;
		this.deptCode = deptCode;
		this.mobilePhone = mobilePhone;
		this.mainPostFlag = mainPostFlag;
		this.sex = sex;
		this.email = email;
		this.state = state;
	}
	
//	public static void addYnsbjEmpJob(YnsbjEmpJob empJob) {
//		empJobs.add(empJob);
//	}
	
	public static YnsbjEmp packageYnsbjEmp(JSONObject jsonObject) {
		String CODE = jsonObject.getString("CODE");  //MDM唯一标识
		String UUID = jsonObject.getString("UUID"); //UUID
		String DESC2 = jsonObject.getString("DESC2"); //人员编码
		String DESC3 = jsonObject.getString("DESC3"); //人员姓名
		String DESC16 = jsonObject.getString("DESC16"); //启用状态
		String DESC22 = jsonObject.get("DESC22")!=null?jsonObject.getString("DESC22"):"N";//是否主职
		String DESC46 = jsonObject.getString("DESC46"); //手机
		String DESC47 = jsonObject.getString("DESC47"); //邮箱
		String DESC55 = jsonObject.getString("DESC55");//性别
		String DESC62 = jsonObject.getString("DESC62"); //部门编码
		List<YnsbjEmpJob> empJobs = new ArrayList<>();
		JSONObject specialityCodes = jsonObject.getJSONObject("SPECIALITYCODES");
		if(specialityCodes != null) {
			if(specialityCodes.get("B01")!=null){
				JSONArray b01 = specialityCodes.getJSONArray("B01");
				if(b01 != null && b01.size() > 0) {
					for(int i=0;i<b01.size();i++) {
						JSONObject b01Object = b01.getJSONObject(i);
						String B0104 = b01Object.getString("B0104"); //兼职部门
						String B0106 = b01Object.getString("B0106"); //兼职部门编码
						String B0107 = b01Object.getString("B0107"); //任职开始日期 
						
						YnsbjEmpJob empJob = new YnsbjEmpJob(B0104, B0106, B0107);
//						addYnsbjEmpJob(empJob);
						empJobs.add(empJob);
					}
				}
			}
		}
		
		if("Y".equals(DESC22)) {
			DESC22 = "1";
		}else{
			DESC22 = "0";
		}
		if("女".equals(DESC55)) {
			DESC55 = "2";
		}else{
			DESC55 = "1";
		}
		if("已启用".equals(DESC16)||"启用".equals(DESC16)) {
			DESC16 = "1";
		}else{
			DESC16 = "0";
		}
		
		YnsbjEmp ynsbjEmp = new YnsbjEmp(DESC2, DESC3, DESC62, 
				DESC46, DESC22, DESC55, DESC47, DESC16);
		ynsbjEmp.setMasterDataCode(CODE);
		ynsbjEmp.setUuid(UUID);
		ynsbjEmp.setEmpJobs(empJobs);
		return ynsbjEmp;
	}

}
