/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.sync.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.orgcenter.bean.OrgEntity;
import com.ejianc.foundation.orgcenter.service.IOrgService;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.sync.service.IZjkjTianJianSyncService;
import com.ejianc.foundation.usercenter.bean.ThirdSystemEntity;
import com.ejianc.foundation.usercenter.bean.UserEntity;
import com.ejianc.foundation.usercenter.service.IThirdSystemService;
import com.ejianc.foundation.usercenter.service.IUserService;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.foundation.utils.HttpTookit;
import com.ejianc.framework.core.exception.BusinessException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;

@Service
public class ZjkjTianJianSyncServiceImpl
implements IZjkjTianJianSyncService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Value(value="${tianjianUrl:http://36.137.93.200:10006/open_api}")
    private String tianjianUrl;
    @Autowired
    private IOrgService orgService;
    @Autowired
    private IUserService userService;
    @Autowired
    private IThirdSystemService thirdSystemService;

    @Override
    public void syncData() {
        ThirdSystemEntity thirdSystemVO = this.thirdSystemService.queryThirdSystemByCode("sdbjSyncDate");
        ExecutorService threadPool = Executors.newFixedThreadPool(3);
        RequestAttributes context = RequestContextHolder.getRequestAttributes();
        String beginTime = thirdSystemVO.getConfigInfo();
        String endTime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date());
        DataSync orgDeptCallable = new DataSync(beginTime, endTime, "org", context);
        Future<String> orgDeptFuture = threadPool.submit(orgDeptCallable);
        DataSync userCallable = new DataSync(beginTime, endTime, "user", context);
        Future<String> userFuture = threadPool.submit(userCallable);
        String orgDeptData = null;
        String userData = null;
        try {
            orgDeptData = orgDeptFuture.get();
            userData = userFuture.get();
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6\u540c\u6b65\u6570\u636e\u5931\u8d25\uff1a{}", (Throwable)e);
            throw new BusinessException("\u83b7\u53d6\u540c\u6b65\u6570\u636e\u5931\u8d25");
        }
        finally {
            threadPool.shutdown();
        }
        this.logger.info("\u6570\u636e\u5904\u7406\u7ed3\u675f(- v -)!-------");
        thirdSystemVO.setConfigInfo(endTime);
        this.thirdSystemService.saveOrUpdate((Object)thirdSystemVO, false);
    }

    @Override
    public void syncOrgList(String beginTime, String endTime) {
        List<OrgVO> delList;
        QueryWrapper wrapper = new QueryWrapper();
        if (beginTime != null) {
            ((QueryWrapper)((QueryWrapper)wrapper.between((Object)"create_time", (Object)beginTime, (Object)endTime)).or()).between((Object)"update_time", (Object)beginTime, (Object)endTime);
        }
        List addList = this.orgService.list((Wrapper)wrapper);
        ArrayList<JSONObject> deptList = new ArrayList<JSONObject>();
        for (OrgEntity org : addList) {
            JSONObject d = new JSONObject();
            d.put("id", (Object)org.getId().toString());
            d.put("name", (Object)org.getName().toString());
            d.put("parentId", (Object)org.getParentId().toString());
            d.put("orgType", (Object)2);
            deptList.add(d);
        }
        String token = this.getToken();
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("key", "Authorization");
        headers.put("value", "Bearer " + token);
        try {
            String url = this.tianjianUrl + "/depart/sync";
            JSONObject params = new JSONObject();
            params.put("deptList", deptList);
            String backData = HttpTookit.postByJson(url, params.toJSONString(), headers);
            JSONObject jsonResponse = JSON.parseObject((String)backData);
            if (!"200".equals(jsonResponse.getString("code"))) {
                throw new BusinessException("\u7ec4\u7ec7\u540c\u6b65\u6570\u636e\u5931\u8d25");
            }
        }
        catch (Exception e) {
            throw new BusinessException("\u7ec4\u7ec7\u540c\u6b65\u6570\u636e\u5931\u8d25");
        }
        if (beginTime != null && (delList = this.orgService.getDelOrgs(beginTime, endTime)) != null && delList.size() > 0) {
            for (OrgVO orgVO : delList) {
                try {
                    String url = this.tianjianUrl + "/depart/remove";
                    JSONObject params = new JSONObject();
                    params.put("id", (Object)orgVO.getId().toString());
                    String backData = HttpTookit.postByJson(url, params.toJSONString(), headers);
                    JSONObject jsonResponse = JSON.parseObject((String)backData);
                    if ("200".equals(jsonResponse.getString("code"))) continue;
                    throw new BusinessException("\u7ec4\u7ec7\u5220\u9664\u6570\u636e\u5931\u8d25");
                }
                catch (Exception e) {
                    throw new BusinessException("\u7ec4\u7ec7\u5220\u9664\u6570\u636e\u5931\u8d25");
                }
            }
        }
    }

    @Override
    public void syncUserList(String beginTime, String endTime) {
        List<UserVO> delList;
        QueryWrapper wrapper = new QueryWrapper();
        if (beginTime != null) {
            ((QueryWrapper)((QueryWrapper)wrapper.between((Object)"create_time", (Object)beginTime, (Object)endTime)).or()).between((Object)"update_time", (Object)beginTime, (Object)endTime);
        }
        List addList = this.userService.list((Wrapper)wrapper);
        ArrayList<JSONObject> userList = new ArrayList<JSONObject>();
        for (UserEntity user : addList) {
            JSONObject d = new JSONObject();
            d.put("id", (Object)user.getId().toString());
            d.put("username", (Object)user.getUserCode());
            d.put("realname", (Object)user.getUserName());
            d.put("phone", (Object)user.getUserMobile());
            ArrayList<JSONObject> deptList = new ArrayList<JSONObject>();
            JSONObject org = new JSONObject();
            org.put("id", (Object)user.getOrgId().toString());
            deptList.add(org);
            d.put("deptList", deptList);
            d.put("email", (Object)user.getUserEmail());
            userList.add(d);
        }
        String token = this.getToken();
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("key", "Authorization");
        headers.put("value", "Bearer " + token);
        try {
            String url = this.tianjianUrl + "/user/sync";
            JSONObject params = new JSONObject();
            params.put("userList", userList);
            String backData = HttpTookit.postByJson(url, params.toJSONString(), headers);
            JSONObject jsonResponse = JSON.parseObject((String)backData);
            if (!"200".equals(jsonResponse.getString("code"))) {
                throw new BusinessException("\u4eba\u5458\u540c\u6b65\u6570\u636e\u5931\u8d25");
            }
        }
        catch (Exception e) {
            throw new BusinessException("\u4eba\u5458\u540c\u6b65\u6570\u636e\u5931\u8d25");
        }
        if (beginTime != null && (delList = this.userService.getDelUsers(beginTime, endTime)) != null && delList.size() > 0) {
            for (UserVO orgVO : delList) {
                try {
                    String url = this.tianjianUrl + "/user/remove";
                    JSONObject params = new JSONObject();
                    params.put("id", (Object)orgVO.getId().toString());
                    String backData = HttpTookit.postByJson(url, params.toJSONString(), headers);
                    JSONObject jsonResponse = JSON.parseObject((String)backData);
                    if ("200".equals(jsonResponse.getString("code"))) continue;
                    throw new BusinessException("\u4eba\u5458\u5220\u9664\u6570\u636e\u5931\u8d25");
                }
                catch (Exception e) {
                    throw new BusinessException("\u4eba\u5458\u5220\u9664\u6570\u636e\u5931\u8d25");
                }
            }
        }
    }

    public String getToken() {
        String token = "";
        try {
            String url = this.tianjianUrl + "/token/get";
            JSONObject params = new JSONObject();
            params.put("restname", (Object)"root");
            params.put("password", (Object)"Zj@kj#qunje");
            params.put("appKey", (Object)"");
            params.put("appSecret", (Object)"");
            String backData = HttpTookit.postByJson(url, params.toJSONString());
            JSONObject jsonResponse = JSON.parseObject((String)backData);
            if (!"200".equals(jsonResponse.getString("code"))) {
                throw new BusinessException("\u83b7\u53d6token\u5931\u8d25");
            }
            JSONObject data = jsonResponse.getJSONObject("data");
            token = data.getString("token");
        }
        catch (Exception e) {
            throw new BusinessException("\u83b7\u53d6token\u5931\u8d25");
        }
        return token;
    }

    class DataSync
    implements Callable<String> {
        private String beginTime;
        private String endTime;
        private String type;
        private RequestAttributes context;

        public DataSync(String beginTime, String endTime, String type, RequestAttributes context) {
            this.beginTime = beginTime;
            this.endTime = endTime;
            this.type = type;
            this.context = context;
        }

        @Override
        public String call() throws Exception {
            if ("org".equals(this.type)) {
                ZjkjTianJianSyncServiceImpl.this.syncOrgList(this.beginTime, this.endTime);
            } else if ("user".equals(this.type)) {
                ZjkjTianJianSyncServiceImpl.this.syncUserList(this.beginTime, this.endTime);
            }
            return "";
        }
    }
}

