/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.tenant.service.impl;

import com.ejianc.foundation.tenant.bean.DefaultPwdEntity;
import com.ejianc.foundation.tenant.bean.PasswordPolicyEntity;
import com.ejianc.foundation.tenant.mapper.PasswordPolicyMapper;
import com.ejianc.foundation.tenant.service.IDefaultpwdService;
import com.ejianc.foundation.tenant.service.IPasswordPolicyService;
import com.ejianc.foundation.tenant.service.ITenantService;
import com.ejianc.foundation.tenant.vo.PasswordPolicyVO;
import com.ejianc.foundation.tenant.vo.TenantVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PasswordPolicyServiceImpl
extends BaseServiceImpl<PasswordPolicyMapper, PasswordPolicyEntity>
implements IPasswordPolicyService {
    @Autowired
    private IDefaultpwdService defaultpwdService;
    @Autowired
    private ITenantService tenantService;

    @Override
    public PasswordPolicyVO findByTenantId(Long tenantId) {
        TenantVO tenantVO = this.tenantService.selectById(tenantId);
        if (tenantVO == null) {
            throw new BusinessException("\u672a\u67e5\u8be2\u5230\u8be5\u79df\u6237\u7684\u8be6\u60c5\u4fe1\u606f");
        }
        Long passwordPolicyId = tenantVO.getPasswordPolicyId();
        PasswordPolicyVO passwordPolicyVo = null;
        PasswordPolicyEntity entity = (PasswordPolicyEntity)((Object)this.getById(passwordPolicyId));
        if (entity != null) {
            passwordPolicyVo = (PasswordPolicyVO)BeanMapper.map((Object)((Object)entity), PasswordPolicyVO.class);
        }
        return passwordPolicyVo;
    }

    @Override
    public String getUserDefaultPassword(Long tenantId) {
        DefaultPwdEntity defaultPwd = this.defaultpwdService.getUserDefaultPassword(tenantId);
        if (defaultPwd == null) {
            defaultPwd = this.defaultpwdService.getUserDefaultPassword(DefaultPwdEntity.defaultTenantId);
        }
        return defaultPwd == null ? null : defaultPwd.getDefaultpwd();
    }

    @Override
    public CommonResponse<String> save(PasswordPolicyVO passwordPolicyVO, boolean syncEs) {
        if (passwordPolicyVO.getId() != null) {
            PasswordPolicyEntity entity = (PasswordPolicyEntity)((Object)this.selectById(passwordPolicyVO.getId()));
            entity.setPwdComplexity(passwordPolicyVO.getPwdComplexity());
            entity.setMinLength(passwordPolicyVO.getMinLength());
            entity.setValiditeDays(passwordPolicyVO.getValiditeDays());
            entity.setForceUpdateFlag(passwordPolicyVO.getForceUpdateFlag());
            entity.setDefaultPwdFlag(passwordPolicyVO.getDefaultPwdFlag());
            this.saveOrUpdate((Object)entity, syncEs);
        } else {
            PasswordPolicyEntity entity = (PasswordPolicyEntity)((Object)BeanMapper.map((Object)passwordPolicyVO, PasswordPolicyEntity.class));
            this.saveOrUpdate((Object)entity, syncEs);
        }
        return CommonResponse.success((String)"\u4fdd\u5b58\u6210\u529f");
    }
}

