package com.ejianc.foundation.orgcenter.mapper;

import com.ejianc.foundation.orgcenter.vo.EmployeeJobVO;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import com.ejianc.foundation.orgcenter.bean.EmployeeEntity;
import com.ejianc.framework.skeleton.template.BaseCrudMapper;

import java.util.List;
import java.util.Map;

@Mapper
public interface EmployeeMapper extends BaseCrudMapper<EmployeeEntity> {

    /**
     * 查询条件匹配的人员数量
     *
     * @param params
     * @return
     */
    long count(Map<String, Object> params);

    /**
     * 分页查询人员列表
     *
     * @param params
     * @return
     */
    List<EmployeeVO> getList(Map<String, Object> params);

    /**
     * 修改员工的状态
     * 
     * @param id
     * @param state
     */
	void updateEmployeeState(@Param("id") Long id,@Param("state") Integer state);


	/**
	 * 查询岗位下的所有任职员工列表
	 *
	 * @param paramMap
	 * @return
	 */
	List<EmployeeJobVO> queryPostEmployeeList(Map<String, Object> paramMap);

	/**
	 * 查询岗位下的所有任职员工总数
	 * 
	 * @param paramMap
	 * @return
	 */
	Long queryPostEmployeeCount(Map<String, Object> paramMap);
	
	//根据租户id查询超级管理员员工用户信息
	EmployeeVO querySuperEmployeeByTenantId(@Param("tenantId") Long tenantId);

	/**
	 * 查询组织下的用户列表，不包含下级组织用户，首页员工列表查询使用
	 *  查询人员Id，编码，名称，性别，手机号，邮箱，角色名称
	 *
	 * @param orgId
	 * @return
	 */
    List<Map<String, String>> getDirectAllByOrgId(@Param("orgId") Long orgId);

    List<Map<String, String>> searchTenantEmployees(@Param(value = "tenantId") Long tenantId, @Param(value = "searchText")  String searchText, @Param(value = "limit")  Integer limit);

	void updateTenantId(@Param("userId") Long userId,@Param("tenantId") Long tenantId, @Param("orgId") Long orgId, 
			@Param("deptId") Long deptId, @Param("postId") Long postId);

	/**
	 * 查询条件匹配的人员数量
	 *
	 * @param params
	 * @return
	 */
	long countBook(Map<String, Object> params);

	/**
	 * 分页查询人员台账列表
	 *
	 * @param params
	 * @return
	 */
	List<EmployeeVO> getBookList(Map<String, Object> params);

	/**
	 * 批量查询某些组织下的某些岗位人员列表，返回结果根据组织+岗位剔重 add by wxh20220708
	 * @param postIds
	 * @param orgIds
	 * @return
	 */
	List<EmployeeVO> queryEmployeeByPostAndOrg(List<Long> postIds, List<Long> orgIds);

	List<EmployeeVO> getByCodeOrIdcard(@Param("codeOrIdcard") List<String> codeOrIdcard, @Param("tenantId") Long tenantId);
}
