package com.ejianc.foundation.tenant.service.impl;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.foundation.tenant.bean.DefaultPwdEntity;
import com.ejianc.foundation.tenant.bean.PasswordPolicyEntity;
import com.ejianc.foundation.tenant.mapper.PasswordPolicyMapper;
import com.ejianc.foundation.tenant.service.IDefaultpwdService;
import com.ejianc.foundation.tenant.service.IPasswordPolicyService;
import com.ejianc.foundation.tenant.service.ITenantService;
import com.ejianc.foundation.tenant.vo.PasswordPolicyVO;
import com.ejianc.foundation.tenant.vo.TenantVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

@Service
public class PasswordPolicyServiceImpl extends BaseServiceImpl<PasswordPolicyMapper, PasswordPolicyEntity> implements IPasswordPolicyService {

	@Autowired
	private IDefaultpwdService defaultpwdService;
	
	@Autowired
	private ITenantService tenantService;

	@Override
	public PasswordPolicyVO findByTenantId(Long tenantId) {
		//为防止创建密码策略时tenant_id是从上下文取得，所以这里先从tenant表查询密码策略id，再根据密码策略id查询密码策略详情；
		TenantVO tenantVO = tenantService.selectById(tenantId);
		if(tenantVO==null){
			throw new BusinessException("未查询到该租户的详情信息");
		}
		Long passwordPolicyId = tenantVO.getPasswordPolicyId();
		PasswordPolicyVO passwordPolicyVo = null;
		
//		QueryWrapper<PasswordPolicyEntity> queryWrapper = new QueryWrapper<>();
//		queryWrapper.eq("tenant_id", tenantId).eq("dr", 0);
//		PasswordPolicyEntity entity = this.getOne(queryWrapper);
		
		PasswordPolicyEntity entity = this.getById(passwordPolicyId);
		if(entity != null) {
			passwordPolicyVo = BeanMapper.map(entity, PasswordPolicyVO.class);
		}
		return passwordPolicyVo;
	}

	@Override
	public String getUserDefaultPassword(Long tenantId) {
		DefaultPwdEntity defaultPwd = defaultpwdService.getUserDefaultPassword(tenantId);
		if (defaultPwd == null) {
			defaultPwd = this.defaultpwdService.getUserDefaultPassword(DefaultPwdEntity.defaultTenantId);
		}
		return defaultPwd == null ? null : defaultPwd.getDefaultpwd();
	}

	@Override
	public CommonResponse<String> save(PasswordPolicyVO passwordPolicyVO, boolean syncEs) {
		if(passwordPolicyVO.getId()!=null){
			//修改
			PasswordPolicyEntity entity = this.selectById(passwordPolicyVO.getId());
			entity.setPwdComplexity(passwordPolicyVO.getPwdComplexity());
			entity.setMinLength(passwordPolicyVO.getMinLength());
			entity.setValiditeDays(passwordPolicyVO.getValiditeDays());
			entity.setForceUpdateFlag(passwordPolicyVO.getForceUpdateFlag());
			entity.setDefaultPwdFlag(passwordPolicyVO.getDefaultPwdFlag());
			this.saveOrUpdate(entity, syncEs);
		}else{
			//新增
			PasswordPolicyEntity entity = BeanMapper.map(passwordPolicyVO, PasswordPolicyEntity.class);
			this.saveOrUpdate(entity, syncEs);
		}
		// TODO Auto-generated method stub
		return CommonResponse.success("保存成功");
	}

}
