package com.ejianc.foundation.usercenter.service;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.tenant.bean.TenantEntity;
import com.ejianc.foundation.usercenter.bean.ThirdSystemEntity;
import com.ejianc.foundation.usercenter.vo.ThirdSystemVO;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.framework.skeleton.template.IBaseService;

public interface IThirdSystemService extends IBaseService<ThirdSystemEntity> {

	/**
	 * 根据第三方系统编号查询bean
	 *
	 * @param systemCode
	 * @return
	 */
	ThirdSystemEntity queryThirdSystemByCode(String systemCode);

	/**
	 * 获取微信公众号的access_token
	 *
	 * @param appid
	 * @param secret
	 * @return
	 */
	String getWeixinAccessToken(String appid, String secret, Boolean refresh);

	/**
	 * 获取企业微信的access_token
	 *
	 * @param corpAppId
	 * @param corpSecret
	 * @return
	 */
	String getWeixineeAccessToken(String corpAppId, String corpSecret, Boolean refresh);

	/**
	 * 获取钉钉的access_token
	 *
	 * @param corpAppId
	 * @param corpSecret
	 * @return
	 */
	String getDingDingAccessToken(String corpAppId, String corpSecret, Boolean refresh);
	/**
	 * 获取钉钉的用户信息
	 *
	 * @param code
	 * @param token
	 * @return
	 */
	String getDingDingUserInfo(String code, String token);

	/**
	 * @Author mrsir_wxp
	 * @Date 2020/10/17
	 * @Description 获取小程序的AccessToken
	 * @Param
	 * @Return
	 */
	String getMiniProgramAccessToken(String appId, String appSecret);

	/**
	 * @Author mrsir_wxp
	 * @Date 2020/10/17
	 * @Description 获取小程序的jsapi_ticket
	 * @Param
	 * @Return
	 */
	String getMiniProgramJsapiTicket(String corpAppId ,String accessToken);

	/**
	 * @Author mrsir_wxp
	 * @Date 2020/10/17
	 * @Description 获取企业的jsapi_ticket
	 * @Param
	 * @Return
	 */
	String getWeixineeJsapiTicket(String corpAppId ,String accessToken);

	/**
	 * @Author mrsir_wxp
	 * @Date 2020/10/17
	 * @Description 获取企业应用的jsapi_ticket
	 * @Param
	 * @Return
	 */
	String getWeixineeAppJsapiTicket(String corpAppId ,String accessToken);

	/**
	 * 查询第三方系统表
	 *
	 * @param sysCode
	 * @param tenantId
	 * @return
	 */
	ThirdSystemVO findSysByCode(String sysCode, Long tenantId);

	/**
	 *
	 * @param soterJson
	 * @param appId
	 * @param secret
	 * @return
	 */
    UserVO bindUserWithSoterSignature(String soterJson, String appId, String secret);

	/**
	 * 获取友空间接口令牌
	 *
	 * @param reload 强制重新获取令牌
	 * @return
	 */
	String getYonYouCloudAccessToken(boolean reload)  throws Exception;

	/**
	 * 根据临时code查询友互通免登信息
	 *
	 * @param tmpCode
	 * @return JSONObject {"yhtUserId": 友互通用户Id，"tenantId":"友互通租户Id"，"memberId":"空间用户Id"，"gzId":"空间Id"}
	 */
	JSONObject getYhtBaseInfoByCode(String tmpCode)  throws Exception;

	/**
	 * 根据友互通用户Id查询对应的友空间人员信息
	 *
	 * @param yhtUserId
	 * @return {
	 *     id	String	主键,
	 *     code	String	编码
	 * 	   user_id	String	用户id
	 * 	   name	 String	名称
	 * 	   shortname	String	姓名简拼
	 *     modifiedtime	Date	修改时间
	 *     enable	Integer	启用状态
	 *     photo	String	头像
	 *     sex	Integer	性别
	 *     birthdate	Date	生日
	 *     email	String	邮箱
	 *     mobile	String	手机号
	 *     joinworkdate	Date	参加工作时间
	 *     officetel	String	办公电话
	 *     linkaddr	String	通讯地址
	 *     mainjobinfo	List	任职信息
	 *     {
	 *          modifiedtime	Date	修改时间
	 * 			staff_id	String	所属人员
	 * 			dept_id	String	所属部门
	 * 			org_id	String	所属组织
	 * 			job_id	String	职务
	 * 			post_id	String	职位
	 * 			jobgrade_id	String	职级
	 * 			begindate	Date	任职开始时间
	 * 			enddate	Date	任职结束时间
	 * 			director	String	上级主管
	 * 			psncl_id	String	人员类别
	 *     }
	 * }
	 */
	JSONObject getYhtEmployeeInfoByYhtUserId(String yhtUserId) throws Exception;


	/**
	 * 获取友空间接口票据
	 *
	 * @param reload 强制重新获取票据
	 * @return
	 */
    String getYonYouCloudAccessTicket(boolean reload) throws Exception;

	String getQunjeToken(String restname, String password, Boolean refresh);

	/*************************************************************************************/
	/****       企业微信第三方应用相关接口      开始      **************************************/
	/*************************************************************************************/
	/**
	 * 获取第三方应用凭证
	 * 请求方式：POST（HTTPS）
	 * 请求地址： https://qyapi.weixin.qq.com/cgi-bin/service/get_suite_token
	 * 请求体
	 * {
	 * 	"suite_id":"wwddddccc7775555aaa" ,
	 * 	"suite_secret": "ldAE_H9anCRN21GKXVfdAAAAAAAAAAAAAAAAAA",
	 * 	"suite_ticket": "Cfp0_givEagXcYJIztF6sfbdmIZCmpaR8ZBsvJEFFNBrWmnD5-CGYJ3_NhYexMyw"
	 * }
	 * suite_id	是	第三方应用id或者代开发应用模板id。第三方应用以ww或wx开头应用id（对应于旧的以tj开头的套件id）；代开发应用以dk开头
	 * suite_secret	是	第三方应用secret 或者代开发应用模板secret
	 * suite_ticket	是	企业微信后台推送的ticket
	 * 响应
	 * {
	 * 	"errcode":0,
	 * 	"errmsg":"ok",
	 * 	"suite_access_token":"61W3mEpU66027wgNZ_MhGHNQDHnFATkDa9-2llMBjUwxRSNPbVsMmyD-yq8wZETSoE5NQgecigDrSHkPtIYA",
	 * 	"expires_in":7200
	 * }
	 * suite_access_token	第三方或者代开发应用access_token,最长为512字节
	 * expires_in	有效期（秒）
	 * */
	String getWXEESuiteAccessToken(JSONObject body,String suiteId);

	/**
	 * 获取预授权码
	 * 请求方式：GET（HTTPS）
	 * 请求地址： https://qyapi.weixin.qq.com/cgi-bin/service/get_pre_auth_code?suite_access_token=SUITE_ACCESS_TOKEN
	 *
	 * */
	String getWXEEPreAuthCode(String suiteAccessToken);

	/**
	 * 设置授权配置
	 * 请求方式：POST（HTTPS）
	 * 请求地址： https://qyapi.weixin.qq.com/cgi-bin/service/set_session_info?suite_access_token=SUITE_ACCESS_TOKEN
	 * {
	 * 	"pre_auth_code":"xxxxx",
	 * 	"session_info":
	 *        {
	 * 		"appid":[1,2,3],
	 * 		"auth_type":1
	 *    }
	 * }
	 * suite_access_token	是	第三方应用access_token
	 * pre_auth_code	是	预授权码
	 * session_info	是	本次授权过程中需要用到的会话信息
	 * appid	否	允许进行授权的应用id，如1、2、3， 不填或者填空数组都表示允许授权套件内所有应用（仅旧的多应用套件可传此参数，新开发者可忽略）
	 * auth_type	否	授权类型：0 正式授权， 1 测试授权。 默认值为0。注意，请确保应用在正式发布后的授权类型为“正式授权”
	 * */
	String setWXEESessionInfo(String suiteAccessToken, JSONObject body);

	/**
	 * 获取企业永久授权码
	 * 请求方式：POST（HTTPS）
	 * 请求地址： https://qyapi.weixin.qq.com/cgi-bin/service/get_permanent_code?suite_access_token=SUITE_ACCESS_TOKEN
	 * 请求体
	 * {
	 * 	"auth_code": "auth_code_value"
	 * }
	 * auth_code	是	临时授权码，会在授权成功时附加在redirect_uri中跳转回第三方服务商网站，或通过授权成功通知回调推送给服务商。长度为64至512个字节
	 * 请求结果
	 * {
	 * 	"errcode":0,
	 * 	"errmsg":"ok",
	 * 	"access_token": "xxxxxx",
	 * 	"expires_in": 7200,
	 * 	"permanent_code": "xxxx",
	 * 	"dealer_corp_info":
	 *        {
	 * 		"corpid": "xxxx",
	 * 		"corp_name": "name"
	 *    },
	 * 	"auth_corp_info":
	 *    {
	 * 		"corpid": "xxxx",
	 * 		"corp_name": "name",
	 * 		"corp_type": "verified",
	 * 		"corp_square_logo_url": "yyyyy",
	 * 		"corp_user_max": 50,
	 * 		"corp_full_name":"full_name",
	 * 		"verified_end_time":1431775834,
	 * 		"subject_type": 1,
	 * 		"corp_wxqrcode": "zzzzz",
	 * 		"corp_scale": "1-50人",
	 * 		"corp_industry": "IT服务",
	 * 		"corp_sub_industry": "计算机软件/硬件/信息服务"
	 *    },
	 * 	"auth_info":
	 *    {
	 * 		"agent" :
	 * 		[
	 *            {
	 * 				"agentid":1,
	 * 				"name":"NAME",
	 * 				"round_logo_url":"xxxxxx",
	 * 				"square_logo_url":"yyyyyy",
	 * 				"appid":1,
	 * 				"auth_mode":1,
	 * 				"is_customized_app":false,
	 * 				"auth_from_thirdapp":false,
	 * 				"privilege":
	 *                {
	 * 					"level":1,
	 * 					"allow_party":[1,2,3],
	 * 					"allow_user":["zhansan","lisi"],
	 * 					"allow_tag":[1,2,3],
	 * 					"extra_party":[4,5,6],
	 * 					"extra_user":["wangwu"],
	 * 					"extra_tag":[4,5,6]
	 *                },
	 * 				"shared_from":
	 *                {
	 * 					"corpid":"wwyyyyy",
	 * 					"share_type": 1
	 *                }
	 *            },
	 *            {
	 * 				"agentid":2,
	 * 				"name":"NAME2",
	 * 				"round_logo_url":"xxxxxx",
	 * 				"square_logo_url":"yyyyyy",
	 * 				"appid":5,
	 * 				"shared_from":
	 *                {
	 * 					"corpid":"wwyyyyy",
	 * 					"share_type": 0
	 *                }
	 *            }
	 * 		]
	 *    },
	 * 	"auth_user_info":
	 *    {
	 * 		"userid":"aa",
	 * 		"open_userid":"xxxxxx",
	 * 		"name":"xxx",
	 * 		"avatar":"http://xxx"
	 *    },
	 * 	"register_code_info":
	 *    {
	 * 		"register_code":"1111",
	 * 		"template_id":"tpl111",
	 * 		"state":"state001"
	 *    },
	 * 	"state":"state001"
	 * }
	 * access_token	授权方（企业）access_token,最长为512字节。代开发自建应用安装时不返回。
	 * expires_in	授权方（企业）access_token超时时间（秒）。代开发自建应用安装时不返回。
	 * permanent_code	企业微信永久授权码,最长为512字节
	 * auth_corp_info	授权方企业信息
	 * auth_corp_info.corpid	授权方企业微信id
	 * auth_corp_info.corp_name	授权方企业名称，即企业简称
	 * auth_corp_info.corp_type	授权方企业类型，认证号：verified, 注册号：unverified
	 * auth_corp_info.corp_square_logo_url	授权方企业方形头像
	 * auth_corp_info.corp_user_max	授权方企业用户规模
	 * auth_corp_info.corp_full_name	授权方企业的主体名称(仅认证或验证过的企业有)，即企业全称。企业微信将逐步回收该字段，后续实际返回内容为企业名称，即auth_corp_info.corp_name。
	 * auth_corp_info.subject_type	企业类型，1. 企业; 2. 政府以及事业单位; 3. 其他组织, 4.团队号
	 * auth_corp_info.verified_end_time	认证到期时间
	 * auth_corp_info.corp_wxqrcode	授权企业在微信插件（原企业号）的二维码，可用于关注微信插件
	 * auth_corp_info.corp_scale	企业规模。当企业未设置该属性时，值为空
	 * auth_corp_info.corp_industry	企业所属行业。当企业未设置该属性时，值为空
	 * auth_corp_info.corp_sub_industry	企业所属子行业。当企业未设置该属性时，值为空
	 * auth_info	授权信息。如果是通讯录应用，且没开启实体应用，是没有该项的。通讯录应用拥有企业通讯录的全部信息读写权限
	 * auth_info.agent	授权的应用信息，注意是一个数组，但仅旧的多应用套件授权时会返回多个agent，对新的单应用授权，永远只返回一个agent
	 * auth_info.agent.agentid	授权方应用id
	 * auth_info.agent.name	授权方应用名字
	 * auth_info.agent.square_logo_url	授权方应用方形头像
	 * auth_info.agent.round_logo_url	授权方应用圆形头像
	 * auth_info.agent.appid	旧的多应用套件中的对应应用id，新开发者请忽略
	 * auth_info.agent.auth_mode	授权模式，0为管理员授权；1为成员授权
	 * auth_info.agent.is_customized_app	是否为代开发自建应用
	 * auth_info.agent.auth_from_thirdapp	来自第三方应用接口唤起,仅通过第三方应用添加自建应用 获取授权链接授权代开发自建应用时，才返回该字段
	 * auth_info.agent.privilege	应用对应的权限
	 * auth_info.agent.privilege.allow_party	应用可见范围（部门）
	 * auth_info.agent.privilege.allow_tag	应用可见范围（标签）
	 * auth_info.agent.privilege.allow_user	应用可见范围（成员）
	 * auth_info.agent.privilege.extra_party	额外通讯录（部门）
	 * auth_info.agent.privilege.extra_user	额外通讯录（成员）
	 * auth_info.agent.privilege.extra_tag	额外通讯录（标签）
	 * auth_info.agent.privilege.level	权限等级。
	 * 1:通讯录基本信息只读
	 * 2:通讯录全部信息只读
	 * 3:通讯录全部信息读写
	 * 4:单个基本信息只读
	 * 5:通讯录全部信息只写
	 * auth_info.agent.shared_from	共享了应用的企业信息，仅当由企业互联或者上下游共享应用触发的安装时才返回
	 * auth_info.agent.shared_from.corpid	共享了应用的企业信息，仅当企业互联或者上下游共享应用触发的安装时才返回
	 * auth_info.agent.shared_from.share_type	共享了途径，0表示企业互联，1表示上下游
	 * auth_user_info	授权管理员的信息，可能不返回
	 * auth_user_info.userid	授权管理员的userid，可能为空
	 * auth_user_info.open_userid	授权管理员的open_userid，可能为空
	 * auth_user_info.name	授权管理员的name，可能为空
	 * auth_user_info.avatar	授权管理员的头像url，可能为空
	 * dealer_corp_info	代理服务商企业信息。应用被代理后才有该信息
	 * dealer_corp_info.corpid	代理服务商企业微信id
	 * dealer_corp_info.corp_name	代理服务商企业微信名称
	 * register_code_info	推广二维码安装相关信息，扫推广二维码安装时返回。成员授权时暂不支持。（注：无论企业是否新注册，只要通过扫推广二维码安装，都会返回该字段）
	 * register_code_info.register_code	注册码
	 * register_code_info.template_id	推广包ID
	 * register_code_info.state	仅当获取注册码指定该字段时才返回
	 * state	安装应用时，扫码或者授权链接中带的state值。详见state说明
	 * */
	JSONObject getWXEEPermanentCode(String suiteAccessToken, JSONObject body);

	/**
	 * 获取企业授权信息
	 * 请求方式：POST（HTTPS）
	 * 请求地址： https://qyapi.weixin.qq.com/cgi-bin/service/get_auth_info?suite_access_token=SUITE_ACCESS_TOKEN
	 * 请求包体
	 *  {
	 *  	"auth_corpid": "auth_corpid_value",
	 *  	"permanent_code": "code_value"
	 *  }
	 *  auth_corpid	是	授权方corpid
	 *  permanent_code	是	永久授权码，通过get_permanent_code获取
	 * 返回结果
	 * {
	 *     "errcode":0,
	 *     "errmsg":"ok",
	 * 	"dealer_corp_info":
	 *        {
	 * 		"corpid": "xxxx",
	 * 		"corp_name": "name"
	 *    },
	 * 	"auth_corp_info":
	 *    {
	 * 		"corpid": "xxxx",
	 * 		"corp_name": "name",
	 * 		"corp_type": "verified",
	 * 		"corp_square_logo_url": "yyyyy",
	 * 		"corp_user_max": 50,
	 * 		"corp_full_name":"full_name",
	 * 		"verified_end_time":1431775834,
	 * 		"subject_type": 1,
	 * 		"corp_wxqrcode": "zzzzz",
	 * 		"corp_scale": "1-50人",
	 * 		"corp_industry": "IT服务",
	 * 		"corp_sub_industry": "计算机软件/硬件/信息服务"
	 *    },
	 * 	"auth_info":
	 *    {
	 * 		"agent" :
	 * 		[
	 *            {
	 * 				"agentid":1,
	 * 				"name":"NAME",
	 * 				"round_logo_url":"xxxxxx",
	 * 				"square_logo_url":"yyyyyy",
	 * 				"appid":1,
	 * 				"auth_mode":1,
	 * 				"is_customized_app":false,
	 * 				"auth_from_thirdapp":false,
	 * 				"privilege":
	 *                {
	 * 					"level":1,
	 * 					"allow_party":[1,2,3],
	 * 					"allow_user":["zhansan","lisi"],
	 * 					"allow_tag":[1,2,3],
	 * 					"extra_party":[4,5,6],
	 * 					"extra_user":["wangwu"],
	 * 					"extra_tag":[4,5,6]
	 *                },
	 * 				"shared_from":
	 *                {
	 * 					"corpid":"wwyyyyy",
	 * 					"share_type": 1
	 *                }
	 *            },
	 *            {
	 * 				"agentid":2,
	 * 				"name":"NAME2",
	 * 				"round_logo_url":"xxxxxx",
	 * 				"square_logo_url":"yyyyyy",
	 * 				"appid":5,
	 * 				"shared_from":
	 *                {
	 * 					"corpid":"wwyyyyy",
	 * 					"share_type": 0
	 *                }
	 *            }
	 * 		]
	 *    }
	 * }
	 * auth_corp_info	授权方企业信息
	 * auth_corp_info.corpid	授权方企业微信id
	 * auth_corp_info.corp_name	授权方企业名称
	 * auth_corp_info.corp_type	授权方企业类型，认证号：verified, 注册号：unverified
	 * auth_corp_info.corp_square_logo_url	授权方企业方形头像
	 * auth_corp_info.corp_user_max	授权方企业用户规模
	 * auth_corp_info.corp_full_name	授权方企业的主体名称(仅认证或验证过的企业有)，即企业全称。企业微信将逐步回收该字段，后续实际返回内容为企业名称，即auth_corp_info.corp_name。
	 * auth_corp_info.subject_type	企业类型，1. 企业; 2. 政府以及事业单位; 3. 其他组织, 4.团队号
	 * auth_corp_info.verified_end_time	认证到期时间
	 * auth_corp_info.corp_wxqrcode	授权企业在微信插件（原企业号）的二维码，可用于关注微信插件，二维码有效期为7天
	 * auth_corp_info.corp_scale	企业规模。当企业未设置该属性时，值为空
	 * auth_corp_info.corp_industry	企业所属行业。当企业未设置该属性时，值为空
	 * auth_corp_info.corp_sub_industry	企业所属子行业。当企业未设置该属性时，值为空
	 * auth_info	授权信息。如果是通讯录应用，且没开启实体应用，是没有该项的。通讯录应用拥有企业通讯录的全部信息读写权限
	 * auth_info.agent	授权的应用信息，注意是一个数组，但仅旧的多应用套件授权时会返回多个agent，对新的单应用授权，永远只返回一个agent
	 * auth_info.agent.agentid	授权方应用id
	 * auth_info.agent.name	授权方应用名字
	 * auth_info.agent.square_logo_url	授权方应用方形头像
	 * auth_info.agent.round_logo_url	授权方应用圆形头像
	 * auth_info.agent.appid	旧的多应用套件中的对应应用id，新开发者请忽略
	 * auth_info.agent.auth_mode	授权模式，0为管理员授权；1为成员授权
	 * auth_info.agent.is_customized_app	是否为代开发自建应用
	 * auth_info.agent.auth_from_thirdapp	来自第三方应用接口唤起,仅通过第三方应用添加自建应用 获取授权链接授权代开发自建应用时，才返回该字段
	 * auth_info.agent.privilege	应用对应的权限
	 * auth_info.agent.privilege.allow_party	应用可见范围（部门）
	 * auth_info.agent.privilege.allow_tag	应用可见范围（标签）
	 * auth_info.agent.privilege.allow_user	应用可见范围（成员）
	 * auth_info.agent.privilege.extra_party	额外通讯录（部门）
	 * auth_info.agent.privilege.extra_user	额外通讯录（成员）
	 * auth_info.agent.privilege.extra_tag	额外通讯录（标签）
	 * auth_info.agent.privilege.level	权限等级。
	 * 1:通讯录基本信息只读
	 * 2:通讯录全部信息只读（已废弃）
	 * 3:通讯录全部信息读写
	 * 4:单个基本信息只读
	 * 5:通讯录全部信息只写（已废弃）
	 * auth_info.agent.shared_from	共享了应用的企业信息，仅当由企业互联或者上下游共享应用触发的安装时才返回
	 * auth_info.agent.shared_from.corpid	共享了应用的企业corpid，仅当企业互联或者上下游共享应用触发的安装时才返回
	 * auth_info.agent.shared_from.share_type	共享了途径，0表示企业互联，1表示上下游
	 * dealer_corp_info	代理服务商企业信息
	 * dealer_corp_info.corpid	代理服务商企业微信id
	 * dealer_corp_info.corp_name	代理服务商企业微信名称
	 *
	 *
	 * */
	JSONObject getWXEEAuthInfo(String suiteAccessToken, JSONObject body);

	/**
	 * 获取企业凭证
	 * 请求方式：POST（HTTPS）
	 * 请求地址： https://qyapi.weixin.qq.com/cgi-bin/service/get_corp_token?suite_access_token=SUITE_ACCESS_TOKEN
	 * 请求体
	 *  {
	 *  	"auth_corpid": "auth_corpid_value",
	 *  	"permanent_code": "code_value"
	 *  }
	 *  auth_corpid	是	授权方corpid
	 * permanent_code	是	永久授权码，通过get_permanent_code获取
	 * 响应
	 * {
	 * 	"errcode":0 ,
	 * 	"errmsg":"ok" ,
	 * 	"access_token": "xxxxxx",
	 * 	"expires_in": 7200
	 * }
	 * access_token	授权方（企业）access_token,最长为512字节
	 * expires_in	授权方（企业）access_token超时时间
	 *
	 * */
	String getWXEECorpToken(String corpid,String suiteAccessToken, JSONObject body);

	/**
	 * 读取企业微信成员详细信息
	 * 请求方式：GET（HTTPS）
	 * 请求地址：https://qyapi.weixin.qq.com/cgi-bin/user/get?access_token=ACCESS_TOKEN&userid=USERID
	 * access_token	是	调用接口凭证
	 * userid	是	成员UserID。对应管理端的帐号，企业内必须唯一。不区分大小写，长度为1~64个字节
	 *
	 * 参考链接 https://developer.work.weixin.qq.com/document/path/90332
	 *
	 * @param access_token
	 * @param userId
	 * @return
	 */
	JSONObject getWXEEUserInfo(String access_token,String userId);

	/**
	 * 读取企业微信 部门成员
	 * 请求方式：GET（HTTPS）
	 * 请求地址：https://qyapi.weixin.qq.com/cgi-bin/user/simplelist?access_token=ACCESS_TOKEN&department_id=DEPARTMENT_ID
	 * access_token	是	调用接口凭证
	 * department_id	是	获取的部门id
	 *
	 * 参考链接 https://developer.work.weixin.qq.com/document/path/90336
	 *
	 * @param access_token
	 * @param department_id
	 * @return
	 */
	JSONArray getWXEEDeptUserList(String access_token, String department_id);

	/**
	 * 获取企业微信 访问用户身份
	 *
	 * 请求方式：GET（HTTPS）
	 * 请求地址：https://qyapi.weixin.qq.com/cgi-bin/service/auth/getuserinfo3rd?suite_access_token=SUITE_ACCESS_TOKEN&code=CODE
	 * suite_access_token	是	第三方应用的suite_access_token，参见“获取第三方应用凭证” 。不允许代开发自建应用调用。代开发自建应用获取用户身份参考“获取访问用户身份”
	 * code	是	通过成员授权获取到的code，最大为512字节。每次成员授权带上的code将不一样，code只能使用一次，5分钟未被使用自动过期。
	 *
	 * 参考链接 https://developer.work.weixin.qq.com/document/path/91121
	 *
	 * @param suite_access_token
	 * @param code
	 * @return
	 */
	JSONObject getWXEEUser3rd(String suite_access_token, String code);
	/**
	 * 获取服务商的accessToken
	 *
	 * */
	String getWXEEProviderToken();

	/**-----------***************************************************************************************/
	/**-----------结束！！企业微信第三方应用相关接口************************************************************/
	/**-----------***************************************************************************************/

	/**********************************钉钉第三方应用相关接口start************************************/
	//获取钉钉第三方企业应用的access_token
	String getDdThirdAppAccessToken(String corpId, String suiteTicket);

	//获取钉钉第三方企业应用的suite_access_token
	String getDdThirdAppSuiteAccessToken(String suiteTicket);

	String getDdUserAccessToken(String code);
	/**********************************钉钉第三方应用相关接口end************************************/

	/**
	 * 公共 获取第三方应用的 租户的 企业永久授权码 已持久化数据库的授权码，非从第三方获取
	 * 目前钉钉、企业微信 第三方应用使用
	 * @param corpid 第三方系统中企业id
	 * @return
	 */
	String getTenantPromiseCode(String corpid);

	/**
	 * 公共 获取第三方应用的 租户信息
	 * 目前钉钉、企业微信 第三方应用使用
	 * @param corpid 第三方系统中企业id
	 * @return
	 */
	TenantEntity getTenantByThirdCorpid(String corpid);

	/**
	 * 公共 获取第三方应用的suite ticket
	 * 目前钉钉、企业微信 第三方应用使用
	 * @param suiteId 应用id
	 * @param sys 区分系统，企业微信：wxee，钉钉：dingding
	 * @return
	 */
	String getThirdAppSuiteTicket(String suiteId,String sys);

	/**
	 * 公共 获取第三方应用的 AccessToken
	 * 目前钉钉、企业微信 第三方应用使用
	 * @param corpid 企业id
	 * @param sys 区分系统，企业微信：wxee，钉钉：ddThirdApp
	 * @return
	 */
	String getThirdAppAccessToken(String corpid,String sys);

	/**
	 * 钉钉第三方企业应用获取应用id（企业不同，应用不同）
	 *
	 * @param corpid
	 * @return
	 */
	String getDdThirdAgentid(String corpid);

	/**
	 * 公共 设置第三方应用的suite ticket
	 * 目前钉钉、企业微信 第三方应用使用
	 * @param suiteTicket 要设置的 suiteTicket
	 * @param suiteId 应用id
	 * @param sys 区分系统，企业微信：wxee，钉钉：dingding
	 * @return
	 */
	void setThirdAppSuiteTicket(String suiteTicket,String suiteId,String sys);
}
