package com.ejianc.foundation.permission.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.ejianc.foundation.cache.AppCacheManage;
import com.ejianc.foundation.cache.PermissionCacheManage;
import com.ejianc.foundation.permission.bean.*;
import com.ejianc.foundation.permission.mapper.AppMapper;
import com.ejianc.foundation.permission.mapper.CollectAppMapper;
import com.ejianc.foundation.permission.service.*;
import com.ejianc.foundation.permission.vo.AppVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.util.*;

@Service
public class CollectAppServiceImpl extends BaseServiceImpl<CollectAppMapper, CollectAppEntity> implements ICollectAppService {
	
	@Value("${oms.tenantid}")
	private Long omsTenantid;

	@Autowired
	private PermissionCacheManage permissionCacheManage;
	@Autowired
	private AppMapper appMapper;
	@Autowired
	private CollectAppMapper collectAppMapper;
	@Autowired
	private AppCacheManage appCacheManage;

	@Override
	public CommonResponse<List<AppVO>> queryListByUsrId() {
		List<AppEntity> list = collectAppMapper.queryListByUsrId(InvocationInfoProxy.getUserid(), InvocationInfoProxy.getUserType(), InvocationInfoProxy.getTenantid());
		List<AppVO> vos = new ArrayList<>();
		List<Long> ids = new ArrayList<>();
		if(list!=null && list.size()>0){
			for (AppEntity entity : list) {
				if(!ids.contains(entity.getId())){
					ids.add(entity.getId());
					AppVO vo = BeanMapper.map(entity, AppVO.class);
					vos.add(vo);
				}
			}
			Comparator<AppVO> stuComparator = new Comparator<AppVO>() {
				@Override
				public int compare(AppVO o1, AppVO o2) {
					if(StringUtils.isBlank(o1.getSequence()) && StringUtils.isBlank(o1.getSequence())){
						return -1;
					}else if(StringUtils.isBlank(o1.getSequence())){
						return 1;
					}else if(StringUtils.isBlank(o2.getSequence())){
						return -1;
					}
					Integer sequence1 = Integer.parseInt(o1.getSequence());
					Integer sequence2 = Integer.parseInt(o2.getSequence());
					return sequence1 - sequence2;
				}
			};
			Collections.sort(vos, stuComparator);
		}
		return  CommonResponse.success(vos);
	}

	@Override
	public CommonResponse<String> saveList(List<AppVO> vos) {
		List<CollectAppEntity> addEEntitys = new ArrayList<>();
		List<Long> delIds = new ArrayList<>();
		if(vos!=null && vos.size()>0){
			for(AppVO vo : vos){
				if("del".equals(vo.getRowState())){
					delIds.add(vo.getId());
				}else if("add".equals(vo.getRowState())){
					CollectAppEntity entity = new CollectAppEntity();
					entity.setAppId(vo.getId());
					entity.setUserId(InvocationInfoProxy.getUserid());
					entity.setSequence(StringUtils.isNotBlank(vo.getSequence())?Integer.parseInt(vo.getSequence()):null);
					addEEntitys.add(entity);
				}else if ("edit".equals(vo.getRowState())){
					UpdateWrapper<CollectAppEntity> wrapper = new UpdateWrapper<>();
					wrapper.eq("app_id", vo.getId());
					wrapper.eq("user_id", InvocationInfoProxy.getUserid());
					wrapper.set("sequence", StringUtils.isNotBlank(vo.getSequence())?Integer.parseInt(vo.getSequence()):null);
					this.update(wrapper);
				}
			}
		}
		if(delIds!=null && delIds.size()>0){
			QueryWrapper<CollectAppEntity> wrapper = new QueryWrapper<>();
			wrapper.in("app_id", delIds);
			wrapper.eq("user_id", InvocationInfoProxy.getUserid());
			this.remove(wrapper);
		}
		if(addEEntitys!=null && addEEntitys.size()>0){
			this.saveOrUpdateBatch(addEEntitys, addEEntitys.size(), false);
		}

		return  CommonResponse.success();
	}

	@Override
	public void deleteCollectApp(String appId, Long userId) {
		collectAppMapper.deleteCollectApp(appId, userId);
	}
}
