package com.ejianc.foundation.tenant.service.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.tenant.bean.TenantMenuEntity;
import com.ejianc.foundation.tenant.mapper.TenantMenuMapper;
import com.ejianc.foundation.tenant.service.ITenantMenuService;
import com.ejianc.foundation.tenant.vo.TenantMenuVO;
import com.ejianc.foundation.workbench.vo.MenuItemVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

/**
 * 租户自定义菜单
 * 
 * @author generator
 * 
 */
@Service("tenantMenuService")
public class TenantMenuServiceImpl extends BaseServiceImpl<TenantMenuMapper, TenantMenuEntity> implements ITenantMenuService{

    @Autowired
    private TenantMenuMapper tenantMenuMapper;

    @Value("${oms.tenantid}")
    private String OMS_TENANT;

    /**
     * 根据tenantId查询关联的数据
     * @return
     */
    public List<MenuItemVO> queryTenantProperties(QueryParam param) {
        String code = null;
        String name = null;
        String mobile = null;
        Long tenantId = Long.parseLong(param.getParams().get("tenantId").getValue().toString());
        if(param.getParams().get("code") != null){
            code = String.valueOf(param.getParams().get("code").getValue());
        }
        if(param.getParams().get("name") != null){
            name = String.valueOf(param.getParams().get("name").getValue());
        }
        if(param.getParams().get("mobile") != null){
        	mobile = String.valueOf(param.getParams().get("mobile").getValue());
        }
        Map<Long,MenuItemVO> menuMap = new HashMap<Long,MenuItemVO>();
        List<MenuItemVO> menuList =this.queryMenuAll(tenantId,code,name);
        List<MenuItemVO> tenantList =tenantMenuMapper.queryTenantProperties(tenantId, null, mobile);

        for (MenuItemVO t: menuList){
            for(MenuItemVO vo: tenantList){
                if(vo.getInnerCode().contains(t.getId()+"")){
                    menuMap.put(t.getId(),t);
                }
            }
        }

        List<MenuItemVO> allList = new ArrayList<MenuItemVO>(menuMap.values());
        Collections.sort(allList,new Comparator<MenuItemVO>(){
            public int compare(MenuItemVO arg0, MenuItemVO arg1) {
                return arg0.getSequence().compareTo(arg1.getSequence());
            }
        });

        return allList;
    }

    /**
     * 根据菜单id查询
     * @param menuId
     * @return
     */
    public TenantMenuVO queryByMenuId(Long menuId) {
        TenantMenuVO vo = new TenantMenuVO();
        QueryWrapper<TenantMenuEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("tenant_id", InvocationInfoProxy.getTenantid());
        queryWrapper.eq("menu_id", menuId);
        List<TenantMenuEntity> list = tenantMenuMapper.selectList(queryWrapper);
        if(CollectionUtils.isNotEmpty(list)){
            TenantMenuEntity entity =list.get(0);
            vo =BeanMapper.map(entity, TenantMenuVO.class);
            return vo;
        }
        return vo;
    }

    /**
     * 查询全部菜单
     * @return
     */
    public List<MenuItemVO> queryMenuAll(Long tenantId,String code,String name){
        List<MenuItemVO> list = tenantMenuMapper.queryMenuAll(tenantId,null,null,code,name);
        return list;
    }

	@Override
	public List<TenantMenuVO> queryCurrentTenantMenuList(Long tenantId, String appIdStr) {
		List<TenantMenuVO> tenantMenuVos = tenantMenuMapper.queryCurrentTenantMenuList(appIdStr, tenantId);
		return tenantMenuVos;
	}
}
