package com.ejianc.foundation.workbench.mapper;

import java.util.List;

import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import com.ejianc.foundation.workbench.bean.LayoutEntity;
import com.ejianc.framework.skeleton.template.BaseCrudMapper;

@Mapper
public interface LayoutMapper extends BaseCrudMapper<LayoutEntity> {

	/**
	 * 根据角色Ids查询所有关联的布局
	 * 
	 * @param roleIds
	 * @return
	 */
	List<LayoutEntity> queryLayoutByRoleIds(@Param("roleIds") String roleIds, @Param("type") String type, @Param("systemId") String systemId);

	/**
	 * 删除自定义布局
	 * 
	 * @param layoutId
	 * @param userId
	 */
	void deleteCustomLayout(@Param("layoutId") String layoutId,@Param("userId") Long userId);

	/**
	 * 删除所有自定义布局
	 * 
	 * @param layoutId
	 */
	void deleteAllCustomLayout(@Param("layoutId") Long layoutId);

	LayoutEntity queryUniqueLayout(@Param("layoutId") Long layoutId,@Param("systemId") String systemId);

}
