package com.ejianc.foundation.workbench.service;

import java.util.List;
import java.util.Map;

import com.ejianc.foundation.workbench.bean.LayoutOrgRelationEntity;
import com.ejianc.foundation.workbench.vo.LayoutOrgVO;
import com.ejianc.framework.skeleton.template.IBaseService;

public interface ILayoutOrgRelationService extends IBaseService<LayoutOrgRelationEntity> {

    /**
     * 查询匹配条件的管局组织关系总数
     *
     * @param 查询参数
     * @param layoutId
     * @return
     */
    Long count(Map<String, Object> paramMap, Long layoutId);

    /**
     * 查询匹配条件的管局组织关系列表
     *
     * @param paramMap
     * @param startLine
     * @param pageSize
     * @param layoutId
     * @return
     */
    List<LayoutOrgVO> page(Map<String, Object> paramMap, int startLine, int pageSize, Long layoutId);

    /**
     * 根据主键Id查询对应的布局组织详情
     *
     * @param id
     * @return
     */
    LayoutOrgRelationEntity getById(Long id);

    /**
     * 查询所有匹配的布局组织关系列表
     *
     * @param param
     * @return
     */
    List<LayoutOrgRelationEntity> queryByProperties(Map<String, Object> param);

    /**
     * 根据主键删除数据
     * 
     * @param ids
     */
	void deleteByIds(List<Long> ids);

    /**
     * 根据布局Id以及组织Id删除对应的布局关系
     *
     * @param layoutIds
     * @param orgId
     */
    void deleteByOrgIdAndLayoutIds(List<Long> layoutIds, Long orgId);
}
