package com.ejianc.business.income.api;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.income.dto.ContractDto;
import com.ejianc.business.income.history.ProjectProgressVo;
import com.ejianc.business.income.hystrix.ContractHystrix;
import com.ejianc.business.income.vo.ContractFinishSettleVO;
import com.ejianc.business.income.vo.ContractVo;
import com.ejianc.business.income.vo.QuoteVo;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

@FeignClient(name = "ejc-income-web", url = "${common.env.feign-client-url}", path = "ejc-income-web", fallback = ContractHystrix.class)
public interface IIncomeContractApi {
    /**
     * 回写累计收款
     *
     * @param contractId
     * @param collectMny
     * @param type,累加=true,累减=false
     * @return
     */
    @RequestMapping(value = "/api/contract/updateCollectMny", method = RequestMethod.GET)
    public CommonResponse<String> updateCollectMny(@RequestParam(value = "contractId") Long contractId,
                                                   @RequestParam(value = "collectMny") BigDecimal collectMny,
                                                   @RequestParam(value = "type") Boolean type);

    /**
     * 回写累计开票
     *
     * @param contractId
     * @param invoicingTaxMny       开票（含税）
     * @param invoicingMny          开票（不含税）
     * @param type,累加=true,累减=false
     * @return
     */
    @RequestMapping(value = "/api/contract/updateInvoicingMny", method = RequestMethod.GET)
    public CommonResponse<String> updateInvoicingMny(@RequestParam(value = "contractId") Long contractId,
                                                     @RequestParam(value = "invoicingTaxMny") BigDecimal invoicingTaxMny,
                                                     @RequestParam(value = "invoicingMny") BigDecimal invoicingMny,
                                                     @RequestParam(value = "type") Boolean type);

    /**
     * 根据项目主键查询最新创建的合同
     *
     * @param projectId
     * @return
     */
    @RequestMapping(value = "/api/contract/searchContract", method = RequestMethod.GET)
    public CommonResponse<ContractVo> searchContract(@RequestParam(value = "projectId") Long projectId);

    /**
     * 根据合同主键查询合同详情
     *
     * @param contractId
     * @return
     */
    @RequestMapping(value = "/api/contract/queryDetail", method = RequestMethod.GET)
    public CommonResponse<ContractVo> queryDetail(@RequestParam(value = "contractId") Long contractId);

    /**
     * 收入合同统计
     *
     * @param projectRange 查询范围（1-所有项目，2-在建项目，3-完工项目，4-本年新签）
     * @return：incomeContractAmtCount: 统计生效施工合同的含税金额
     * claimAmtCount: 统计生效的变迁变更索赔单金额
     * productionCount: 已生效的产值统计金额（含税）
     * quoteCount: 已生效的甲方批量金额（含税）
     * receiveCount: 已生效的有合同收款登记金额（含税）
     * invoiceOpenCount: 已生效的有合同开票登记金额（含税）
     */
    @RequestMapping(value = "api/contract/incomeCount", method = RequestMethod.GET)
    public CommonResponse<JSONObject> countIncomeContract(@RequestParam(value = "projectRange") int projectRange);

    /**
     * 根据租户主键查询生效的合同列表
     *
     * @param tenantIds
     * @return
     */
    @RequestMapping(value = "/api/contract/searchContractByTenantIds", method = RequestMethod.GET)
    public CommonResponse<List<ContractVo>> searchContractByTenantIds(@RequestParam(value = "tenantIds") List<Long> tenantIds);

    /**
     * 根据租户主键查询生效的合同列表
     * post请求
     * @param tenantIds
     * @return
     */
    @RequestMapping(value = "/api/contract/postSearchContractByTenantIds", method = RequestMethod.POST)
    public CommonResponse<List<ContractDto>> postSearchContractByTenantIds(@RequestBody List<Long> tenantIds);
    /**
     * 根据项目Id查询生效的竣工结算单
     * post请求
     * @param projectIds
     * @return
     */
    @RequestMapping(value = "/api/contract/queryFinishSettle", method = RequestMethod.POST)
    public CommonResponse<List<ContractFinishSettleVO>> queryFinishSettle(@RequestBody List<Long> projectIds);


    /**
     * 根据queryParam查询收入合同列表
     *
     * @param queryParam
     * @return
     */
    @PostMapping(value = "/api/contract/getListByQueryParam")
    CommonResponse<JSONObject> getListByQueryParam(@RequestBody QueryParam queryParam);


    /**
     * @param projectId
     * @description: 查询项目合同额，产值、产值进度、日期进度
     * @author songlx
     * @date: 2021/7/29
     */
    @RequestMapping(value = "/api/contract/projectProgress", method = RequestMethod.GET)
    @ResponseBody
    CommonResponse<JSONObject> projectProgress(@RequestParam(value = "projectId") Long projectId);


    /**
     * @param projectIds
     * @description: 查询项目合同额，产值、产值进度、日期进度
     * @author xuannl
     * @date: 2021/11/11
     */
    @RequestMapping(value = "/api/contract/projectProgressList", method = RequestMethod.GET)
    @ResponseBody
    CommonResponse<List<ProjectProgressVo>> projectProgressList(@RequestParam(value = "projectIds") List<Long> projectIds);

    /**
     * @param map
     * @description: 同步开票金额数据
     * @author 姜轶凯
     * @date: 2021/12/11
     * @return
     */
    @RequestMapping(value = "/api/contract/refreshInvoiceMny", method = RequestMethod.POST)
    @ResponseBody
    CommonResponse<String> refreshInvoiceMny(Map<Long, BigDecimal> map);

    /**
     * 根据项目id批量修改详细地址
     * @param projectId
     * @param address
     */
    @RequestMapping(value = "/api/contract/refreshAddress", method = RequestMethod.POST)
    @ResponseBody
    CommonResponse<String> refreshAddress(@RequestParam(value = "projectId") Long projectId,@RequestParam(value = "address") String address);

    /**
     * 根据项目id批量修改详细地址
     * @param vos
     * @param vos
     */
    @RequestMapping(value = "/api/contract/updateReceiveTaxMny", method = RequestMethod.POST)
    @ResponseBody
    CommonResponse<String> updateReceiveTaxMny(@RequestBody List<QuoteVo> vos);

}
