package com.ejianc.business.income.history;

import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.business.income.vo.ProductionVo;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

public class ProductionHistoryVo extends BaseVO {
    private static final long serialVersionUID = 1L;
    /**
     * 合同主键
     */
    private Long contractId;
    /**
     * 合同金额
     */
    private BigDecimal contractTaxMny;
    //累计完成产值
    private BigDecimal sumProductionTaxMny;
    //累计形象进度
    private BigDecimal sumImageProgress;
    private List<ProductionVo> productionRecord = new ArrayList<>();

    /**
     * 合同状态：1-履约, 2-中止，3-终止，4-废除，5-封账
     */
    private Integer contractStatus;

    /**
     * 变更状态(1-未变更 2-变更中 3-已变更)
     */
    private Integer changeStatus;

    public Integer getContractStatus() {
        return contractStatus;
    }

    public void setContractStatus(Integer contractStatus) {
        this.contractStatus = contractStatus;
    }

    public Integer getChangeStatus() {
        return changeStatus;
    }

    public void setChangeStatus(Integer changeStatus) {
        this.changeStatus = changeStatus;
    }

    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }

    public BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    public void setContractTaxMny(BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }

    public BigDecimal getSumProductionTaxMny() {
        return sumProductionTaxMny;
    }

    public void setSumProductionTaxMny(BigDecimal sumProductionTaxMny) {
        this.sumProductionTaxMny = sumProductionTaxMny;
    }

    public BigDecimal getSumImageProgress() {
        return sumImageProgress;
    }

    public void setSumImageProgress(BigDecimal sumImageProgress) {
        this.sumImageProgress = sumImageProgress;
    }

    public List<ProductionVo> getProductionRecord() {
        return productionRecord;
    }

    public void setProductionRecord(List<ProductionVo> productionRecord) {
        this.productionRecord = productionRecord;
    }
}
