/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.income.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.income.bean.QuoteEntity;
import com.ejianc.business.income.history.QuoteHistoryVo;
import com.ejianc.business.income.service.IQuoteService;
import com.ejianc.business.income.vo.QuoteDetailVo;
import com.ejianc.business.income.vo.QuoteVo;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/quote"})
public class QuoteController {
    @Autowired
    private IQuoteService quoteService;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<QuoteVo> saveOrUpdate(@RequestBody QuoteVo vo) {
        CommonResponse<QuoteVo> response = this.quoteService.saveOrUpdate(vo);
        return response;
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<QuoteVo> queryDetail(@RequestParam Long id) {
        QuoteVo vo = this.quoteService.queryDetail(id);
        return CommonResponse.success((Object)vo);
    }

    @RequestMapping(value={"/pageList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<QuoteEntity>> pageList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("memo");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContext = this.sessionManager.getUserContext();
        String authOrgIds = userContext.getAuthOrgIds();
        if (StringUtils.isNotEmpty((String)authOrgIds)) {
            CommonResponse authResponse = this.orgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList()));
            param.getParams().put("orgId", new Parameter("in", ((List)authResponse.getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        } else {
            param.getParams().put("orgId", new Parameter("in", ((List)this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        param.getOrderMap().put("createTime", "desc");
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)this.quoteService.queryPage(param, false));
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<QuoteVo> vos) {
        this.quoteService.deleteQuote(vos);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f");
    }

    @RequestMapping(value={"/queryQuoteHistory"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<QuoteHistoryVo> queryQuoteHistory(@RequestParam Long id) {
        QuoteHistoryVo vo = this.quoteService.queryQuoteHistory(id);
        return CommonResponse.success((Object)vo);
    }

    @PostMapping(value={"excelExport"})
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("org_id", new Parameter("in", ((List)this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        param.getOrderMap().put("createTime", "desc");
        param.setPageIndex(1);
        param.setPageSize(-1);
        IPage pageData = this.quoteService.queryPage(param, false);
        HashMap beans = new HashMap();
        List list = new ArrayList();
        if (null != pageData.getRecords() && CollectionUtils.isNotEmpty((Collection)pageData.getRecords())) {
            list = BeanMapper.mapList((Iterable)pageData.getRecords(), QuoteVo.class);
            list.forEach(vo -> vo.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)vo.getBillState()).getDescription()));
        }
        beans.put("records", list);
        ExcelExport.getInstance().export("quote-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/queryQuoteDetailHistory"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> queryQuoteDetailHistory(@RequestBody QuoteDetailVo quoteDetailVo) {
        JSONObject page = this.quoteService.queryQuoteDetailHistory(quoteDetailVo);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f", (Object)page);
    }

    @RequestMapping(value={"updateQuoteDetailHistory"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> updateQuoteDetailHistory() {
        this.quoteService.updateQuoteDetailHistory();
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/refQuoteData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<QuoteVo>> refDeductionData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getFuzzyFields().add("contractName");
        param.getFuzzyFields().add("billCode");
        ArrayList<Integer> billStatus = new ArrayList<Integer>();
        billStatus.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
        billStatus.add(BillStateEnum.PASSED_STATE.getBillStateCode());
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)condition)) {
            String projectId;
            String contractId;
            JSONObject _con = JSONObject.parseObject((String)condition);
            if (_con.containsKey((Object)"contractId") && StringUtils.isNotEmpty((String)(contractId = (String)_con.get((Object)"contractId")))) {
                param.getParams().put("contractId", new Parameter("eq", (Object)contractId));
            }
            if (_con.containsKey((Object)"projectId") && StringUtils.isNotEmpty((String)(projectId = (String)_con.get((Object)"projectId")))) {
                param.getParams().put("projectId", new Parameter("eq", (Object)projectId));
            }
        }
        param.getParams().put("bill_state", new Parameter("in", billStatus));
        List quoteEntities = this.quoteService.queryList(param, false);
        IPage page = this.quoteService.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), QuoteVo.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/download"})
    @ResponseBody
    public void download(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"quote-detail-import .xlsx", (String)"\u7532\u65b9\u62a5\u91cf\u5bfc\u5165\u6a21\u677f");
    }

    @RequestMapping(value={"/excelImport"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        return this.quoteService.excelImport(request, response);
    }
}

