package com.ejianc.business.income.mapper;

import com.ejianc.business.income.bean.ContractEntity;
import com.ejianc.business.income.history.ProjectProgressVo;
import com.ejianc.business.income.vo.*;
import com.ejianc.business.income.vo.report.FinanceUseResSubVO;
import com.ejianc.business.income.vo.warn.IncomeContractWarnVo;
import com.ejianc.business.income.vo.warn.QualityAssuranceEndDateWarnVo;
import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * <p>
 * 施工合同表 Mapper 接口
 * </p>
 *
 * @author yuezx
 * @since 2020-05-28
 */
@Mapper
public interface ContractMapper extends BaseCrudMapper<ContractEntity> {
    @Select("SELECT sign_date from ejc_income_contract where id=#{id}")
    Date getSignDate(Long id);
    @Select("SELECT * from ejc_income_contract where dr = 0 and project_id = #{projectId} and bill_state in (1,3) ORDER BY create_time desc LIMIT 0,1")
    ContractVo searchContract(Long projectId);

    BigDecimal inContractMoney(@Param("range")Integer range, @Param("year")String year,@Param("orgIds")List<Long> orgIds,@Param("tenantId")Long tenantId);

    BigDecimal totalReceiveMoney(@Param("range")Integer range, @Param("year")String year,@Param("orgIds")List<Long> orgIds,@Param("tenantId")Long tenantId);

    BigDecimal outContractMoney(@Param("range")Integer range, @Param("year")String year,@Param("orgIds")List<Long> orgIds,@Param("tenantId")Long tenantId);

    BigDecimal totalSettleMoney(@Param("range")Integer range, @Param("year")String year,@Param("orgIds")List<Long> orgIds,@Param("tenantId")Long tenantId);

    BigDecimal totalOutMoney(@Param("range")Integer range, @Param("year")String year,@Param("orgIds")List<Long> orgIds,@Param("tenantId")Long tenantId);

    BigDecimal totalContractOutMoney(@Param("range")Integer range, @Param("year")String year,@Param("orgIds")List<Long> orgIds,@Param("tenantId")Long tenantId);

    List<Map> getproject(@Param("orgIds")List<Long> orgIds,@Param("tenantId")Long tenantId);

    Map getProjectDetail(@Param("projectId")Long projectId);

    List<ProjectProgressVo> getProjectDetailList(@Param("projectIds")List<Long> projectIds);

    BigDecimal outputMoney(@Param("projectId")Long projectId);

    BigDecimal contractMoney(@Param("projectId")Long projectId);

    List<Map> costCount(@Param("range")Integer range, @Param("year")String year,@Param("orgIds")List<Long> orgIds,@Param("tenantId")Long tenantId);

    List<ProjectCountVO> projectCount(@Param("range")String range, @Param("year")String year, @Param("orgIds")List<Long> orgIds, @Param("tenantId")Long tenantId);

    /**
     *  此方法复制于“projectCount”，供企业看板使用
     * @param range
     * @param year
     * @param orgIds
     * @param tenantId
     * @return
     */
    List<ProjectCountVO> projectCount_project(@Param("range")String range, @Param("year")String year, @Param("startDate") String startDate,@Param("endDate") String endDate,@Param("dateIn") String dateIn,@Param("projectType") String projectType,@Param("engineeringType") Long engineeringType, @Param("orgIds")List<Long> orgIds, @Param("tenantId")Long tenantId,@Param("type") String type);

    BigDecimal allInMoney(@Param("ids")List<Long> ids);

    BigDecimal allOutMoney(@Param("ids")List<Long> ids, @Param("orgIds")List<Long> orgIds);

    BigDecimal totalCurrentReceiveMnyTax(@Param("orgIds")List<Long> orgIds,@Param("tenantId")Long tenantId);

    Long count(Map<String,Object> params);

    List<ProjectInOutVO> getList(Map<String,Object> params);

    Map getProjectDate(@Param("projectId")Long projectId);

    List<Map<String,Object>> incomeMnyWarn(@Param(value = "sqlParamList") List<SqlParam> sqlParamList);

    List<IncomeContractWarnVo> outIncomeMnyWarn(@Param(value = "tenantIds") List<Long> tenantIds);

    List<QualityAssuranceEndDateWarnVo> qualityAssuranceEndDateWarn(@Param(value = "tenantIds") List<Long> tenantIds);

    BigDecimal getInContractMoneySum(Map<String, Object> params);

    List<ContractVo> projectSumCollectMny(List<Long> tids);
    List<FinanceUseResSubVO> totalOpenInvince(@Param("startMonth")String startMonth,@Param("endMonth") String endMonth, @Param("orgIds") List<Long> orgIds,@Param("tenantId")Long tenantId);

    List<FinanceUseResSubVO> totalReceiveInvince(@Param("startMonth")String startMonth,@Param("endMonth") String endMonth, @Param("orgIds") List<Long> orgIds,@Param("tenantId")Long tenantId);


    List<FinanceUseResSubVO> totalFinReceiveMoney(@Param("startMonth")String startMonth,@Param("endMonth") String endMonth, @Param("orgIds") List<Long> orgIds,@Param("tenantId")Long tenantId);

    List<FinanceUseResSubVO> totalFinSettleMoney(@Param("startMonth")String startMonth,@Param("endMonth") String endMonth, @Param("orgIds") List<Long> orgIds,@Param("tenantId")Long tenantId);

    List<FinanceUseResSubVO> totalFinOutMoney(@Param("startMonth")String startMonth,@Param("endMonth") String endMonth, @Param("orgIds") List<Long> orgIds,@Param("tenantId")Long tenantId);

    List<FinanceUseResSubVO> totalPayContractFinOutMoney(@Param("startMonth")String startMonth,@Param("endMonth") String endMonth, @Param("orgIds") List<Long> orgIds,@Param("tenantId")Long tenantId);

    List<ProjectWarnVo> projectOverDueWarn(@Param("orgIds") List<Long> orgIds, @Param("tenantId")Long tenantId);

    BigDecimal fetchSghtzje(@Param("projectId")Long projectId);
}
