package com.ejianc.business.income.mapper;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import com.ejianc.business.income.bean.ProductionEntity;
import com.ejianc.business.income.vo.ProductionDetailVo;
import com.ejianc.business.income.vo.report.FinanceUseResSubVO;
import com.ejianc.business.income.vo.report.ProductionReportVO;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.util.Date;
import java.util.List;

/**
 * <p>
 * 产值进度 Mapper 接口
 * </p>
 *
 * @author yuezx
 * @since 2020-06-04
 */
@Mapper
public interface ProductionMapper extends BaseCrudMapper<ProductionEntity> {
    @Select("SELECT MAX(production_date) from ejc_income_production eip where eip.dr=0 and contract_id=#{contractId} and eip.bill_state in (1,3)")
    Date getLastDate(Long contractId);


    List<FinanceUseResSubVO> totalProductionMoney(@Param("startMonth")String startMonth, @Param("endMonth") String endMonth, @Param("orgIds") List<Long> orgIds, @Param("tenantId")Long tenantId);
    /**
     * 根据来源主键（合同清单）查询历史数据的含本期累计完成量，完成产值
     * @param
     * @param
     * @return
     */
    List<ProductionDetailVo> queryProductionDetailHistory(ProductionDetailVo productionDetailVo);

    List<ProjectRegisterVO> queryNoProductionProject(@Param("tenantIds") List<Long> tenantIds);

    List<ProductionReportVO> queryProductionReport(@Param(Constants.WRAPPER)QueryWrapper<ProductionReportVO> wrapper,String yearValue);
}
