/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.income.controller;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.finance.api.IRecoveriesApi;
import com.ejianc.business.finance.vo.ReceiveVO;
import com.ejianc.business.income.service.IReportService;
import com.ejianc.business.income.utils.BigDecimalUtil;
import com.ejianc.business.income.vo.MonthESDataVO;
import com.ejianc.business.income.vo.TableRowDataVO;
import com.ejianc.business.income.vo.report.ProjectMnyVO;
import com.ejianc.business.market.api.IProjectApi;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/report"})
public class ReportController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IReportService reportService;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    IProjectApi projectApi;
    @Autowired
    IRecoveriesApi recoveriesApi;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private RestHighLevelClient client;
    private final String PROFIT_STATISTICS = "profit_statistics";
    private final String CASH_STATISTICS = "cash_statistics";
    public static final Integer QUERY_TIMEOUT = 60;

    @RequestMapping(value={"/queryCashStatistics"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<TableRowDataVO>> queryCashStatistics(@RequestParam String curYear, @RequestParam Long projectId) {
        if (StringUtils.isBlank((CharSequence)curYear)) {
            throw new BusinessException("\u5e74\u4efd\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (projectId == null) {
            throw new BusinessException("\u9879\u76ee\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        List<TableRowDataVO> resVO = this.queryCashStatisticsData(curYear, projectId);
        return CommonResponse.success((String)"\u67e5\u8be2\u5229\u6da6\u8868\u6210\u529f\uff01", resVO);
    }

    /*
     * WARNING - void declaration
     */
    private List<TableRowDataVO> queryCashStatisticsData(String curYear, Long projectId) {
        Map<Object, Object> dataMap = new HashMap();
        LinkedList<TableRowDataVO> tableRowDataVOS = new LinkedList<TableRowDataVO>();
        try {
            void var21_28;
            Map<Integer, BigDecimal> costTaxMnySumGroup;
            SearchRequest searchRequest = new SearchRequest(new String[]{"cash_statistics"});
            SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
            BoolQueryBuilder boolQuery = QueryBuilders.boolQuery();
            boolQuery.must((QueryBuilder)QueryBuilders.termQuery((String)"curYear", (String)curYear));
            boolQuery.must((QueryBuilder)QueryBuilders.termQuery((String)"projectId", (Object)projectId));
            sourceBuilder.query((QueryBuilder)boolQuery);
            sourceBuilder.from(0);
            sourceBuilder.size(10000);
            searchRequest.source(sourceBuilder);
            sourceBuilder.trackTotalHits(true);
            sourceBuilder.timeout(new TimeValue((long)QUERY_TIMEOUT.intValue(), TimeUnit.SECONDS));
            ArrayList<Object> list = new ArrayList<Object>();
            SearchResponse response = null;
            response = this.client.search(searchRequest, RequestOptions.DEFAULT);
            SearchHits hits = response.getHits();
            for (SearchHit hit : hits) {
                String sourceAsString = hit.getSourceAsString();
                list.add(JSON.parseObject((String)sourceAsString, MonthESDataVO.class));
            }
            if (CollectionUtils.isNotEmpty(list)) {
                dataMap = list.stream().collect(Collectors.toMap(obj -> obj.getFeeType() + "_" + obj.getCurMonth(), Function.identity(), (key1, key2) -> key1));
            }
            SearchRequest searchRequestForQiChu = new SearchRequest(new String[]{"cash_statistics"});
            BoolQueryBuilder boolQueryForQiChu = QueryBuilders.boolQuery();
            boolQueryForQiChu.must((QueryBuilder)QueryBuilders.rangeQuery((String)"curYear").lt((Object)curYear));
            boolQueryForQiChu.must((QueryBuilder)QueryBuilders.termQuery((String)"projectId", (Object)projectId));
            SearchSourceBuilder sourceBuilderForQiChu = new SearchSourceBuilder();
            sourceBuilderForQiChu.from(0);
            sourceBuilderForQiChu.size(10000);
            sourceBuilderForQiChu.query((QueryBuilder)boolQueryForQiChu);
            sourceBuilderForQiChu.trackTotalHits(true);
            sourceBuilderForQiChu.timeout(new TimeValue((long)QUERY_TIMEOUT.intValue(), TimeUnit.SECONDS));
            searchRequestForQiChu.source(sourceBuilderForQiChu);
            SearchResponse search = this.client.search(searchRequestForQiChu, RequestOptions.DEFAULT);
            SearchHits hits4QiChu = search.getHits();
            ArrayList<Object> list4QiChu = new ArrayList<Object>();
            for (SearchHit hit : hits4QiChu) {
                String sourceAsString = hit.getSourceAsString();
                list4QiChu.add(JSON.parseObject((String)sourceAsString, MonthESDataVO.class));
            }
            if (CollectionUtils.isNotEmpty(list4QiChu)) {
                Map<Integer, BigDecimal> qichuTaxMnySumMap = list4QiChu.stream().collect(Collectors.groupingBy(MonthESDataVO::getFeeType, Collectors.reducing(BigDecimal.ZERO, MonthESDataVO::getTaxMny, ComputeUtil::safeAdd)));
                BigDecimal lastSurplusIncome = BigDecimal.ZERO;
                Object lastSurplusCost = BigDecimal.ZERO;
                for (Integer n : qichuTaxMnySumMap.keySet()) {
                    BigDecimal taxMny = qichuTaxMnySumMap.get(n);
                    if (!n.toString().startsWith("106")) {
                        if (n.toString().startsWith("1")) {
                            lastSurplusIncome = ComputeUtil.safeAdd((BigDecimal)lastSurplusIncome, (BigDecimal)taxMny);
                        } else {
                            lastSurplusCost = ComputeUtil.safeAdd((BigDecimal)lastSurplusCost, (BigDecimal)taxMny);
                        }
                    }
                    MonthESDataVO qichuObj = new MonthESDataVO();
                    qichuObj.setCurMonth(Integer.valueOf(0));
                    qichuObj.setFeeType(n);
                    qichuObj.setTaxMny(taxMny);
                    dataMap.put(n + "_0", qichuObj);
                }
                MonthESDataVO lastSurplusObj = new MonthESDataVO();
                lastSurplusObj.setCurMonth(Integer.valueOf(1));
                lastSurplusObj.setFeeType(Integer.valueOf(106));
                lastSurplusObj.setTaxMny(ComputeUtil.safeSub((BigDecimal)lastSurplusIncome, (BigDecimal)lastSurplusCost));
                dataMap.put("106_1", lastSurplusObj);
            }
            ArrayList<Object> incomeESData = new ArrayList<Object>();
            ArrayList<Object> costESData = new ArrayList<Object>();
            for (Object feeTypeCurMonth : dataMap.keySet()) {
                if (((String)feeTypeCurMonth).startsWith("106")) continue;
                if (((String)feeTypeCurMonth).startsWith("1")) {
                    incomeESData.add(dataMap.get(feeTypeCurMonth));
                    continue;
                }
                costESData.add(dataMap.get(feeTypeCurMonth));
            }
            Map<Integer, BigDecimal> incomeTaxMnySumGroup = incomeESData.stream().collect(Collectors.groupingBy(MonthESDataVO::getCurMonth, Collectors.reducing(BigDecimal.ZERO, MonthESDataVO::getTaxMny, ComputeUtil::safeAdd)));
            if (MapUtils.isNotEmpty(incomeTaxMnySumGroup)) {
                for (Integer n : incomeTaxMnySumGroup.keySet()) {
                    MonthESDataVO incomeSumObj = new MonthESDataVO();
                    incomeSumObj.setTaxMny(incomeTaxMnySumGroup.get(n));
                    dataMap.put("199_" + n, incomeSumObj);
                }
            }
            if (MapUtils.isNotEmpty(costTaxMnySumGroup = costESData.stream().collect(Collectors.groupingBy(MonthESDataVO::getCurMonth, Collectors.reducing(BigDecimal.ZERO, MonthESDataVO::getTaxMny, ComputeUtil::safeAdd))))) {
                for (Integer key : costTaxMnySumGroup.keySet()) {
                    MonthESDataVO costSumObj = new MonthESDataVO();
                    costSumObj.setTaxMny(costTaxMnySumGroup.get(key));
                    dataMap.put("299_" + key, costSumObj);
                }
            }
            boolean bl = true;
            while (var21_28 <= 12) {
                BigDecimal surplusMny;
                BigDecimal lastSurplusMny;
                MonthESDataVO lastSurplusMonthESDataVO;
                BigDecimal costSumMny;
                BigDecimal incomeSumMny;
                MonthESDataVO costSumObj;
                MonthESDataVO incomeSum;
                MonthESDataVO profitSumObj;
                BigDecimal curSurplusMny;
                BigDecimal _lastSurplusMny;
                MonthESDataVO _lastSurplusDataVO;
                BigDecimal curCostMny;
                BigDecimal curIncomeMny;
                MonthESDataVO curCostDataVO;
                MonthESDataVO curIncomeDataVO;
                MonthESDataVO lastSurplusObj2;
                Integer year = DateUtil.thisYear();
                Integer mon = DateUtil.thisMonth() + 1;
                if (year.compareTo(Integer.valueOf(curYear)) == 1) {
                    if (var21_28 > true) {
                        lastSurplusObj2 = new MonthESDataVO();
                        void lastmon = var21_28 - true;
                        curIncomeDataVO = (MonthESDataVO)dataMap.get("199_" + (int)lastmon);
                        curCostDataVO = (MonthESDataVO)dataMap.get("299_" + (int)lastmon);
                        curIncomeMny = curIncomeDataVO != null ? curIncomeDataVO.getTaxMny() : null;
                        curCostMny = curCostDataVO != null ? curCostDataVO.getTaxMny() : null;
                        _lastSurplusDataVO = (MonthESDataVO)dataMap.get("106_" + (int)lastmon);
                        _lastSurplusMny = _lastSurplusDataVO != null ? _lastSurplusDataVO.getTaxMny() : null;
                        curSurplusMny = ComputeUtil.safeAdd((BigDecimal)_lastSurplusMny, (BigDecimal)ComputeUtil.safeSub((BigDecimal)curIncomeMny, (BigDecimal)curCostMny));
                        lastSurplusObj2.setCurMonth(Integer.valueOf((int)var21_28));
                        lastSurplusObj2.setFeeType(Integer.valueOf(106));
                        lastSurplusObj2.setTaxMny(curSurplusMny);
                        dataMap.put("106_" + (int)var21_28, lastSurplusObj2);
                    }
                    profitSumObj = new MonthESDataVO();
                    incomeSum = (MonthESDataVO)dataMap.get("199_" + (int)var21_28);
                    costSumObj = (MonthESDataVO)dataMap.get("299_" + (int)var21_28);
                    incomeSumMny = incomeSum != null ? incomeSum.getTaxMny() : null;
                    costSumMny = costSumObj != null ? costSumObj.getTaxMny() : null;
                    lastSurplusMonthESDataVO = (MonthESDataVO)dataMap.get("106_" + (int)var21_28);
                    lastSurplusMny = lastSurplusMonthESDataVO != null ? lastSurplusMonthESDataVO.getTaxMny() : null;
                    surplusMny = ComputeUtil.safeAdd((BigDecimal)lastSurplusMny, (BigDecimal)ComputeUtil.safeSub((BigDecimal)incomeSumMny, (BigDecimal)costSumMny));
                    profitSumObj.setTaxMny(surplusMny);
                    dataMap.put("301_" + (int)var21_28, profitSumObj);
                } else if (year.compareTo(Integer.valueOf(curYear)) == 0 && mon >= var21_28) {
                    if (var21_28 > true) {
                        lastSurplusObj2 = new MonthESDataVO();
                        void lastmon = var21_28 - true;
                        curIncomeDataVO = (MonthESDataVO)dataMap.get("199_" + (int)lastmon);
                        curCostDataVO = (MonthESDataVO)dataMap.get("299_" + (int)lastmon);
                        curIncomeMny = curIncomeDataVO != null ? curIncomeDataVO.getTaxMny() : null;
                        curCostMny = curCostDataVO != null ? curCostDataVO.getTaxMny() : null;
                        _lastSurplusDataVO = (MonthESDataVO)dataMap.get("106_" + (int)lastmon);
                        _lastSurplusMny = _lastSurplusDataVO != null ? _lastSurplusDataVO.getTaxMny() : null;
                        curSurplusMny = ComputeUtil.safeAdd((BigDecimal)_lastSurplusMny, (BigDecimal)ComputeUtil.safeSub((BigDecimal)curIncomeMny, (BigDecimal)curCostMny));
                        lastSurplusObj2.setCurMonth(Integer.valueOf((int)var21_28));
                        lastSurplusObj2.setFeeType(Integer.valueOf(106));
                        lastSurplusObj2.setTaxMny(curSurplusMny);
                        dataMap.put("106_" + (int)var21_28, lastSurplusObj2);
                    }
                    profitSumObj = new MonthESDataVO();
                    incomeSum = (MonthESDataVO)dataMap.get("199_" + (int)var21_28);
                    costSumObj = (MonthESDataVO)dataMap.get("299_" + (int)var21_28);
                    incomeSumMny = incomeSum != null ? incomeSum.getTaxMny() : null;
                    costSumMny = costSumObj != null ? costSumObj.getTaxMny() : null;
                    lastSurplusMonthESDataVO = (MonthESDataVO)dataMap.get("106_" + (int)var21_28);
                    lastSurplusMny = lastSurplusMonthESDataVO != null ? lastSurplusMonthESDataVO.getTaxMny() : null;
                    surplusMny = ComputeUtil.safeAdd((BigDecimal)lastSurplusMny, (BigDecimal)ComputeUtil.safeSub((BigDecimal)incomeSumMny, (BigDecimal)costSumMny));
                    profitSumObj.setTaxMny(surplusMny);
                    dataMap.put("301_" + (int)var21_28, profitSumObj);
                }
                ++var21_28;
            }
            List<TableRowDataVO> list2 = this.queryProfitStatisticsData(curYear, projectId);
            TableRowDataVO taxRowDataVO = null;
            if (CollectionUtils.isNotEmpty(list2)) {
                for (TableRowDataVO profitTableRowDataVO : list2) {
                    if (!profitTableRowDataVO.getFeeType().equals(208)) continue;
                    taxRowDataVO = profitTableRowDataVO;
                }
            }
            Map feeTypeMap = TableRowDataVO.CASH_FEE_TYPE_MAP;
            for (Integer feeType : feeTypeMap.keySet()) {
                TableRowDataVO rowDataVO = new TableRowDataVO();
                rowDataVO.setFeeType(feeType, TableRowDataVO.CASH_FEE_TYPE_MAP);
                for (int i = 1; i <= 12; ++i) {
                    String dataKey = feeType + "_" + i;
                    MonthESDataVO monthESDataVO = (MonthESDataVO)dataMap.get(dataKey);
                    if (monthESDataVO == null || monthESDataVO.getTaxMny() == null) continue;
                    BeanUtils.setProperty((Object)rowDataVO, (String)("taxMny" + i), (Object)monthESDataVO.getTaxMny());
                }
                tableRowDataVOS.add(rowDataVO.sumYearTotalAndStartTotal());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return tableRowDataVOS;
    }

    @RequestMapping(value={"/queryProfitStatistics"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<TableRowDataVO>> queryProfitStatistics(@RequestParam String curYear, @RequestParam Long projectId) {
        if (StringUtils.isBlank((CharSequence)curYear)) {
            throw new BusinessException("\u5e74\u4efd\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (projectId == null) {
            throw new BusinessException("\u9879\u76ee\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        List<TableRowDataVO> resVO = this.queryProfitStatisticsData(curYear, projectId);
        return CommonResponse.success((String)"\u67e5\u8be2\u5229\u6da6\u8868\u6210\u529f\uff01", resVO);
    }

    private List<TableRowDataVO> queryProfitStatisticsData(String curYear, Long projectId) {
        Map<Object, Object> dataMap = new HashMap();
        LinkedList<TableRowDataVO> tableRowDataVOS = new LinkedList<TableRowDataVO>();
        try {
            SearchRequest searchRequest = new SearchRequest(new String[]{"profit_statistics"});
            SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
            BoolQueryBuilder boolQuery = QueryBuilders.boolQuery();
            boolQuery.must((QueryBuilder)QueryBuilders.termQuery((String)"curYear", (String)curYear));
            boolQuery.must((QueryBuilder)QueryBuilders.termQuery((String)"projectId", (Object)projectId));
            sourceBuilder.query((QueryBuilder)boolQuery);
            sourceBuilder.from(0);
            sourceBuilder.size(10000);
            searchRequest.source(sourceBuilder);
            sourceBuilder.trackTotalHits(true);
            sourceBuilder.timeout(new TimeValue((long)QUERY_TIMEOUT.intValue(), TimeUnit.SECONDS));
            ArrayList<Object> list = new ArrayList<Object>();
            SearchResponse response = null;
            response = this.client.search(searchRequest, RequestOptions.DEFAULT);
            SearchHits hits = response.getHits();
            for (SearchHit hit : hits) {
                String sourceAsString = hit.getSourceAsString();
                list.add(JSON.parseObject((String)sourceAsString, MonthESDataVO.class));
            }
            if (CollectionUtils.isNotEmpty(list)) {
                dataMap = list.stream().collect(Collectors.toMap(obj -> obj.getFeeType() + "_" + obj.getCurMonth(), Function.identity(), (key1, key2) -> key1));
            }
            SearchRequest searchRequestForQiChu = new SearchRequest(new String[]{"profit_statistics"});
            BoolQueryBuilder boolQueryForQiChu = QueryBuilders.boolQuery();
            boolQueryForQiChu.must((QueryBuilder)QueryBuilders.rangeQuery((String)"curYear").lt((Object)curYear));
            boolQueryForQiChu.must((QueryBuilder)QueryBuilders.termQuery((String)"projectId", (Object)projectId));
            SearchSourceBuilder sourceBuilderForQiChu = new SearchSourceBuilder();
            sourceBuilderForQiChu.from(0);
            sourceBuilderForQiChu.size(10000);
            sourceBuilderForQiChu.query((QueryBuilder)boolQueryForQiChu);
            sourceBuilderForQiChu.trackTotalHits(true);
            sourceBuilderForQiChu.timeout(new TimeValue((long)QUERY_TIMEOUT.intValue(), TimeUnit.SECONDS));
            searchRequestForQiChu.source(sourceBuilderForQiChu);
            SearchResponse search = this.client.search(searchRequestForQiChu, RequestOptions.DEFAULT);
            SearchHits hits4QiChu = search.getHits();
            ArrayList<Object> list4QiChu = new ArrayList<Object>();
            for (SearchHit hit : hits4QiChu) {
                String sourceAsString = hit.getSourceAsString();
                list4QiChu.add(JSON.parseObject((String)sourceAsString, MonthESDataVO.class));
            }
            if (CollectionUtils.isNotEmpty(list4QiChu)) {
                Map<Integer, BigDecimal> qichuTaxMnySumMap = list4QiChu.stream().collect(Collectors.groupingBy(MonthESDataVO::getFeeType, Collectors.reducing(BigDecimal.ZERO, MonthESDataVO::getTaxMny, ComputeUtil::safeAdd)));
                Map<Integer, BigDecimal> qichuMnySumMap = list4QiChu.stream().collect(Collectors.groupingBy(MonthESDataVO::getFeeType, Collectors.reducing(BigDecimal.ZERO, MonthESDataVO::getMny, ComputeUtil::safeAdd)));
                Map<Integer, BigDecimal> qichuTaxSumMap = list4QiChu.stream().collect(Collectors.groupingBy(MonthESDataVO::getFeeType, Collectors.reducing(BigDecimal.ZERO, MonthESDataVO::getTax, ComputeUtil::safeAdd)));
                for (Integer feeType : qichuTaxMnySumMap.keySet()) {
                    MonthESDataVO qichuObj = new MonthESDataVO();
                    qichuObj.setCurMonth(Integer.valueOf(0));
                    qichuObj.setFeeType(feeType);
                    qichuObj.setTaxMny(qichuTaxMnySumMap.get(feeType));
                    qichuObj.setMny(qichuMnySumMap.get(feeType));
                    qichuObj.setTax((BigDecimal)qichuTaxSumMap.get(feeType));
                    dataMap.put(feeType + "_0", qichuObj);
                    this.logger.info("feeType:{}, qichuObj:{}", (Object)feeType, (Object)JSONObject.toJSONString((Object)qichuObj));
                }
            }
            ArrayList<Object> incomeESData = new ArrayList<Object>();
            ArrayList<Object> costESData = new ArrayList<Object>();
            for (String string : dataMap.keySet()) {
                if (string.startsWith("1")) {
                    incomeESData.add(dataMap.get(string));
                    continue;
                }
                costESData.add(dataMap.get(string));
            }
            Map<Integer, BigDecimal> incomeTaxMnySumGroup = incomeESData.stream().collect(Collectors.groupingBy(MonthESDataVO::getCurMonth, Collectors.reducing(BigDecimal.ZERO, MonthESDataVO::getTaxMny, ComputeUtil::safeAdd)));
            Map<Integer, BigDecimal> map = incomeESData.stream().collect(Collectors.groupingBy(MonthESDataVO::getCurMonth, Collectors.reducing(BigDecimal.ZERO, MonthESDataVO::getMny, ComputeUtil::safeAdd)));
            Map<Integer, BigDecimal> incomeTaxSumGroup = incomeESData.stream().collect(Collectors.groupingBy(MonthESDataVO::getCurMonth, Collectors.reducing(BigDecimal.ZERO, MonthESDataVO::getTax, ComputeUtil::safeAdd)));
            if (MapUtils.isNotEmpty(incomeTaxMnySumGroup)) {
                for (Integer key : incomeTaxMnySumGroup.keySet()) {
                    MonthESDataVO incomeSumObj = new MonthESDataVO();
                    incomeSumObj.setTaxMny(incomeTaxMnySumGroup.get(key));
                    incomeSumObj.setMny(map.get(key));
                    incomeSumObj.setTax(incomeTaxSumGroup.get(key));
                    dataMap.put("199_" + key, incomeSumObj);
                }
            }
            Map<Integer, BigDecimal> costTaxMnySumGroup = costESData.stream().collect(Collectors.groupingBy(MonthESDataVO::getCurMonth, Collectors.reducing(BigDecimal.ZERO, MonthESDataVO::getTaxMny, ComputeUtil::safeAdd)));
            Map<Integer, BigDecimal> costMnySumGroup = costESData.stream().collect(Collectors.groupingBy(MonthESDataVO::getCurMonth, Collectors.reducing(BigDecimal.ZERO, MonthESDataVO::getMny, ComputeUtil::safeAdd)));
            Map<Integer, BigDecimal> costTaxSumGroup = costESData.stream().collect(Collectors.groupingBy(MonthESDataVO::getCurMonth, Collectors.reducing(BigDecimal.ZERO, MonthESDataVO::getTax, ComputeUtil::safeAdd)));
            if (MapUtils.isNotEmpty(incomeTaxMnySumGroup)) {
                for (Integer key : incomeTaxMnySumGroup.keySet()) {
                    MonthESDataVO costSumObj = new MonthESDataVO();
                    costSumObj.setTaxMny(costTaxMnySumGroup.get(key));
                    costSumObj.setMny(costMnySumGroup.get(key));
                    costSumObj.setTax(costTaxSumGroup.get(key));
                    dataMap.put("299_" + key, costSumObj);
                }
            }
            for (int i = 0; i <= 12; ++i) {
                MonthESDataVO profitSumObj = new MonthESDataVO();
                MonthESDataVO incomeSum = (MonthESDataVO)dataMap.get("199_" + i);
                MonthESDataVO costSumObj = (MonthESDataVO)dataMap.get("299_" + i);
                BigDecimal incomeSumTaxMny = incomeSum != null ? incomeSum.getTaxMny() : null;
                BigDecimal incomeSumMny = incomeSum != null ? incomeSum.getMny() : null;
                BigDecimal incomeSumTax = incomeSum != null ? incomeSum.getTax() : null;
                BigDecimal costSumTaxMny = costSumObj != null ? costSumObj.getTaxMny() : null;
                BigDecimal costSumMny = costSumObj != null ? costSumObj.getMny() : null;
                BigDecimal costSumTax = costSumObj != null ? costSumObj.getTax() : null;
                profitSumObj.setTaxMny(ComputeUtil.safeSub((BigDecimal)incomeSumTaxMny, (BigDecimal)costSumTaxMny));
                profitSumObj.setMny(ComputeUtil.safeSub((BigDecimal)incomeSumMny, (BigDecimal)costSumMny));
                profitSumObj.setTax(ComputeUtil.safeSub((BigDecimal)incomeSumTax, (BigDecimal)costSumTax));
                dataMap.put("301_" + i, profitSumObj);
            }
            Map feeTypeMap = TableRowDataVO.PROFIT_FEE_TYPE_MAP;
            for (Integer feeType : feeTypeMap.keySet()) {
                MonthESDataVO monthESDataVO;
                String dataKey;
                int i;
                TableRowDataVO rowDataVO = new TableRowDataVO();
                rowDataVO.setFeeType(feeType, TableRowDataVO.PROFIT_FEE_TYPE_MAP);
                if (Integer.valueOf(208).equals(feeType)) {
                    for (i = 0; i <= 12; ++i) {
                        dataKey = feeType + "_" + i;
                        monthESDataVO = (MonthESDataVO)dataMap.get(dataKey);
                        if (monthESDataVO == null || monthESDataVO.getTax() == null) continue;
                        BeanUtils.setProperty((Object)rowDataVO, (String)("tax" + i), (Object)monthESDataVO.getTax());
                    }
                } else {
                    for (i = 0; i <= 12; ++i) {
                        dataKey = feeType + "_" + i;
                        monthESDataVO = (MonthESDataVO)dataMap.get(dataKey);
                        if (monthESDataVO == null || monthESDataVO.getTaxMny() == null) continue;
                        BeanUtils.setProperty((Object)rowDataVO, (String)("taxMny" + i), (Object)monthESDataVO.getTaxMny());
                        BeanUtils.setProperty((Object)rowDataVO, (String)("mny" + i), (Object)monthESDataVO.getMny());
                        BeanUtils.setProperty((Object)rowDataVO, (String)("tax" + i), (Object)monthESDataVO.getTax());
                    }
                }
                tableRowDataVOS.add(rowDataVO.sumTotal());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return tableRowDataVOS;
    }

    public static void main(String[] args) {
        for (int i = 0; i <= 12; ++i) {
            System.out.println("private BigDecimal taxMny" + i + ";");
            System.out.println("private BigDecimal mny" + i + ";");
            System.out.println("private BigDecimal tax" + i + ";");
        }
        StringBuilder taxMnyTotal = new StringBuilder();
        StringBuilder mnyTotal = new StringBuilder();
        StringBuilder taxTotal = new StringBuilder();
        for (int i = 0; i <= 12; ++i) {
            taxMnyTotal.append("this.taxMny" + i + ", ");
            mnyTotal.append("this.mny" + i + ", ");
            taxTotal.append("this.tax" + i + ", ");
        }
        System.out.println(taxMnyTotal.toString());
        System.out.println(mnyTotal.toString());
        System.out.println(taxTotal.toString());
    }

    @RequestMapping(value={"/projectPageList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> projectPageList(@RequestBody QueryParam param) {
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)this.reportService.pageList(param));
    }

    @RequestMapping(value={"/monthPageList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> monthPageList(@RequestBody QueryParam param) {
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)this.reportService.monthPageList(param));
    }

    @RequestMapping(value={"getProjectInOutQueryParam"}, method={RequestMethod.GET})
    public CommonResponse<QueryParam> getProjectInOutQueryParam() {
        try {
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
            String orgType = InvocationInfoProxy.getOrgType();
            if ("5".equals(orgType)) {
                queryParam.getParams().put("orgId", new Parameter("eq", (Object)1));
            }
            return CommonResponse.success((Object)queryParam);
        }
        catch (Exception e) {
            this.logger.error("\u7cfb\u7edf\u5f02\u5e38\uff1a" + e.getMessage());
            e.printStackTrace();
            return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25");
        }
    }

    @PostMapping(value={"projectExport"})
    public void projectExport(@RequestBody QueryParam param, HttpServletResponse response) {
        param.setPageIndex(1);
        param.setPageSize(10000);
        JSONObject pageList = this.reportService.pageList(param);
        HashMap<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", pageList.get((Object)"records"));
        ExcelExport.getInstance().export("projectReport-export.xlsx", beans, response);
    }

    @PostMapping(value={"monthExport"})
    public void monthExport(@RequestBody QueryParam param, HttpServletResponse response) {
        param.setPageIndex(1);
        param.setPageSize(10000);
        JSONObject pageList = this.reportService.monthPageList(param);
        HashMap<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", pageList.get((Object)"records"));
        ExcelExport.getInstance().export("monthReport-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/queryProjectMnyList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<ProjectMnyVO>> queryProjectMnyList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        if (InvocationInfoProxy.getOrgId() != null) {
            Long orgId = InvocationInfoProxy.getOrgId();
            if (null != orgId && orgId > 0L) {
                ArrayList commonOrgIds = new ArrayList();
                CommonResponse orgListResp = this.orgApi.findChildrenByParentId(orgId);
                if (!orgListResp.isSuccess()) {
                    throw new BusinessException("\u5217\u8868\u67e5\u8be2\u5931\u8d25, \u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
                }
                commonOrgIds.addAll(((List)orgListResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
                if (CollectionUtils.isNotEmpty(commonOrgIds)) {
                    param.getParams().put("orgId", new Parameter("in", commonOrgIds));
                }
            }
        } else if (StringUtils.isNotEmpty((CharSequence)authOrgIds)) {
            String[] split = authOrgIds.split(",");
            ArrayList orgList = new ArrayList();
            List<String> collect = Arrays.stream(split).collect(Collectors.toList());
            collect.forEach(item -> orgList.add(Long.parseLong(item)));
            param.getParams().put("orgId", new Parameter("in", orgList));
        }
        Map paramsmap = param.getParams();
        if (paramsmap.containsKey("quoteDate")) {
            DateTime date = DateUtil.date();
            int year = DateUtil.year((Date)date);
            String quoteDate = (String)((Parameter)paramsmap.get("quoteDate")).getValue();
            quoteDate = year + "-" + quoteDate + "-31";
            param.getParams().put("quote_date", new Parameter("le", (Object)quoteDate));
            paramsmap.remove("quoteDate");
        }
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        wrapper.groupBy(new Object[]{"project_id"});
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        List<ProjectMnyVO> list = this.reportService.queryProjectMnyList((Page<ProjectMnyVO>)page, wrapper);
        if (CollectionUtils.isNotEmpty(list)) {
            List projectIds = list.stream().map(ProjectMnyVO::getProjectId).collect(Collectors.toList());
            CommonResponse projectRes = this.projectApi.queryProjectByIds(projectIds);
            CommonResponse recoveries = this.recoveriesApi.queryProjectReceiveMny(projectIds);
            Map<Object, Object> projectMap = new HashMap();
            if (projectRes.isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)projectRes.getData()))) {
                projectMap = ((List)projectRes.getData()).stream().collect(Collectors.toMap(k -> k.getId(), k -> k));
            }
            Map<Object, Object> recoverieMap = new HashMap();
            if (recoveries.isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)recoveries.getData()))) {
                recoverieMap = ((List)recoveries.getData()).stream().collect(Collectors.toMap(k -> k.getProjectId(), k -> k));
            }
            for (ProjectMnyVO projectMnyVO : list) {
                ReceiveVO receiveVO;
                Long projectId = projectMnyVO.getProjectId();
                ProjectRegisterVO projectRegisterVO = (ProjectRegisterVO)projectMap.get(projectId);
                if (null != projectRegisterVO) {
                    projectMnyVO.setParentOrgId(projectRegisterVO.getOrgId());
                    projectMnyVO.setParentOrgName(projectRegisterVO.getOrgName());
                    projectMnyVO.setProjectManager(projectRegisterVO.getProjectManagerName());
                    projectMnyVO.setPubUnitName(projectRegisterVO.getPubUnitName());
                    projectMnyVO.setInvestorName(projectRegisterVO.getInvestorName());
                }
                if (null != (receiveVO = (ReceiveVO)recoverieMap.get(projectId))) {
                    projectMnyVO.setReceiveMny(receiveVO.getReceiveMny());
                }
                if (projectMnyVO.getParentOrgId() != null) continue;
                this.logger.error("\u6b64\u6570\u636e\u3010projectId\uff1a{}\u3011\u7684ParentOrgId\u4e3a\u7a7a\uff01", (Object)projectMnyVO.getProjectId());
            }
            if (CollectionUtils.isNotEmpty(list)) {
                Map<Long, List<ProjectMnyVO>> map = list.stream().filter(s -> s != null && s.getParentOrgId() != null).collect(Collectors.groupingBy(ProjectMnyVO::getParentOrgId));
                for (ProjectMnyVO v : list) {
                    Long parentorgid = v.getParentOrgId();
                    List<ProjectMnyVO> ll = map.get(parentorgid);
                    if (CollectionUtils.isNotEmpty(ll)) {
                        v.setOrgRowSpan(Integer.valueOf(ll.size()));
                        map.remove(parentorgid);
                        continue;
                    }
                    v.setOrgRowSpan(Integer.valueOf(0));
                }
            }
        }
        Map<Object, Object> map = new HashMap();
        map = list.stream().filter(s -> s != null).filter(s -> s.getProjectId() != null).collect(Collectors.groupingBy(ProjectMnyVO::getProjectId));
        for (ProjectMnyVO mnyVO : list) {
            Long projectId = mnyVO.getProjectId();
            List projectMnyVOS = (List)map.get(projectId);
            if (!CollectionUtils.isNotEmpty((Collection)projectMnyVOS)) continue;
            BigDecimal sumreceivemny = projectMnyVOS.stream().filter(s -> s.getReceiveMny() != null).map(ProjectMnyVO::getReceiveMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            mnyVO.setSumReceiveMny(sumreceivemny);
            BigDecimal bigDecimal = projectMnyVOS.stream().filter(s -> s.getQuoteTaxMny() != null).map(ProjectMnyVO::getQuoteTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            mnyVO.setSumQuoteTaxMny(bigDecimal);
            BigDecimal yun = BigDecimalUtil.safeSub(bigDecimal, sumreceivemny);
            mnyVO.setYue(yun);
        }
        List collect = list.stream().filter(s -> s.getParentOrgId() != null).sorted(Comparator.comparing(ProjectMnyVO::getParentOrgId)).collect(Collectors.toList());
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(collect);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"excelExportInAndOutStoreList"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExportInAndOutStoreList(@RequestBody QueryParam param, HttpServletResponse response) throws IOException {
        param.setPageSize(10000);
        param.setPageIndex(1);
        CommonResponse<IPage<ProjectMnyVO>> iPageCommonResponse = this.queryProjectMnyList(param);
        List records = ((IPage)iPageCommonResponse.getData()).getRecords();
        boolean num = false;
        if (ListUtil.isNotEmpty((List)records)) {
            int i;
            ServletOutputStream outputStream = response.getOutputStream();
            XSSFWorkbook workbook = new XSSFWorkbook();
            XSSFSheet sheet = workbook.createSheet();
            sheet.createFreezePane(0, 2, 0, 2);
            sheet.addMergedRegion(new CellRangeAddress(0, 0, 0, 7));
            sheet.setColumnWidth(7, 8100);
            XSSFRow row = sheet.createRow(0);
            XSSFCellStyle style = workbook.createCellStyle();
            style.setFillForegroundColor(IndexedColors.PALE_BLUE.getIndex());
            style.setFillPattern((short)1);
            style.setAlignment((short)2);
            XSSFCell cell = row.createCell(0);
            cell.setCellValue("\u56de\u6b3e\u6c47\u603b");
            cell.setCellStyle((CellStyle)style);
            row = sheet.createRow(1);
            cell = row.createCell(0);
            cell.setCellValue("\u533a\u57df");
            cell.setCellStyle((CellStyle)style);
            cell = row.createCell(1);
            cell.setCellValue("\u9879\u76ee\u7ecf\u7406");
            cell.setCellStyle((CellStyle)style);
            cell = row.createCell(2);
            cell.setCellStyle((CellStyle)style);
            cell.setCellValue("\u9879\u76ee");
            cell = row.createCell(3);
            cell.setCellValue("\u6295\u8d44\u4e3b\u4f53");
            cell.setCellStyle((CellStyle)style);
            cell = row.createCell(4);
            cell.setCellValue("\u53d1\u5305\u5355\u4f4d");
            cell.setCellStyle((CellStyle)style);
            cell = row.createCell(5);
            cell.setCellValue("\u56de\u6b3e\u91d1\u989d");
            cell.setCellStyle((CellStyle)style);
            cell = row.createCell(6);
            cell.setCellValue("\u5b9e\u9645\u56de\u6b3e");
            cell.setCellStyle((CellStyle)style);
            cell = row.createCell(7);
            cell.setCellValue("\u4f59\u989d");
            cell.setCellStyle((CellStyle)style);
            for (i = 0; i < 7; ++i) {
                sheet.autoSizeColumn(i);
                sheet.setColumnWidth(i, sheet.getColumnWidth(i) * 60 / 10);
            }
            for (i = 0; i < records.size(); ++i) {
                ProjectMnyVO vo = (ProjectMnyVO)records.get(i);
                row = sheet.createRow(i + 2);
                if (vo.getOrgRowSpan() > 0) {
                    cell = row.createCell(0);
                    cell.setCellValue(vo.getParentOrgName() == null ? "" : vo.getParentOrgName().toString());
                    sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum() + (vo.getOrgRowSpan() - 1), 0, 0));
                }
                cell = row.createCell(1);
                cell.setCellValue(vo.getProjectManager() != null ? vo.getProjectManager() : null);
                cell = row.createCell(2);
                cell.setCellValue(vo.getProjectName() != null ? vo.getProjectName().toString() : null);
                cell = row.createCell(3);
                cell.setCellValue(vo.getInvestorName() != null ? vo.getInvestorName().toString() : null);
                cell = row.createCell(4);
                cell.setCellValue(vo.getPubUnitName() != null ? vo.getPubUnitName().toString() : null);
                cell = row.createCell(5);
                cell.setCellValue(vo.getSumQuoteTaxMny() != null ? vo.getSumQuoteTaxMny().setScale(2, 4).toString() : "0.00");
                cell = row.createCell(6);
                cell.setCellValue(vo.getReceiveMny() != null ? vo.getReceiveMny().setScale(2, 4).toString() : "0.00");
                cell = row.createCell(7);
                cell.setCellValue(vo.getYue() != null ? vo.getYue().setScale(2, 4).toString() : "0.00");
            }
            ArrayList list1 = new ArrayList();
            records.forEach(item -> {
                if (item.getOrgRowSpan() > 0) {
                    Integer orgRowSpan = item.getOrgRowSpan();
                    list1.add(orgRowSpan);
                    int sum1 = (int)list1.stream().collect(Collectors.summarizingInt(value -> value)).getSum();
                    sheet.shiftRows(sum1 + 2, sheet.getLastRowNum() + 1, 1, true, false);
                    XSSFRow newRow = sheet.createRow(sum1 + 2);
                    XSSFCell newCell = newRow.createCell(0);
                    newCell = newRow.createCell(0);
                    newCell.setCellValue(item.getParentOrgName() == null ? "" : item.getParentOrgName().toString());
                    newCell = newRow.createCell(1);
                    newCell.setCellValue("\u5408\u8ba1");
                    BigDecimal sumQuoteTaxMny = records.stream().filter(s -> s.getParentOrgId().equals(item.getParentOrgId()) && s.getSumQuoteTaxMny() != null).map(ProjectMnyVO::getSumQuoteTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                    newCell = newRow.createCell(5);
                    newCell.setCellValue(sumQuoteTaxMny != null ? sumQuoteTaxMny.setScale(2, 4).toString() : "0.00");
                    BigDecimal receiveMny = records.stream().filter(s -> s.getParentOrgId().equals(item.getParentOrgId())).map(ProjectMnyVO::getSumReceiveMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                    newCell = newRow.createCell(6);
                    newCell.setCellValue(receiveMny != null ? receiveMny.setScale(2, 4).toString() : "0.00");
                    BigDecimal yun = BigDecimalUtil.safeSub(sumQuoteTaxMny, receiveMny);
                    newCell = newRow.createCell(7);
                    newCell.setCellValue(yun != null ? yun.setScale(2, 4).toString() : "0.00");
                    list1.remove(orgRowSpan);
                    list1.add(orgRowSpan + 1);
                }
            });
            workbook.write((OutputStream)outputStream);
        }
    }
}

