/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.income.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.income.bean.ContractEntity;
import com.ejianc.business.income.bean.ContractFinishSettleEntity;
import com.ejianc.business.income.mapper.ContractFinishSettleMapper;
import com.ejianc.business.income.service.IContractFinishSettleService;
import com.ejianc.business.income.service.IContractService;
import com.ejianc.business.income.vo.ContractFinishSettleVO;
import com.ejianc.business.income.vo.FinishHistoryVo;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.math.BigDecimal;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="contractFinishSettleService")
public class ContractFinishSettleServiceImpl
extends BaseServiceImpl<ContractFinishSettleMapper, ContractFinishSettleEntity>
implements IContractFinishSettleService {
    @Autowired
    private ContractFinishSettleMapper contractFinishSettleMapper;
    @Autowired
    private IContractService contractService;

    @Override
    public ContractFinishSettleVO queryByContractId(Long contractId) {
        ContractFinishSettleVO resp = null;
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"contract_id", (Object)contractId);
        query.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        ContractFinishSettleEntity entity = (ContractFinishSettleEntity)((Object)this.contractFinishSettleMapper.selectOne((Wrapper)query));
        if (null != entity) {
            resp = (ContractFinishSettleVO)BeanMapper.map((Object)((Object)entity), ContractFinishSettleVO.class);
        }
        return resp;
    }

    @Override
    public FinishHistoryVo queryFinishHistory(Long id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"contract_id", (Object)id);
        queryWrapper.orderByDesc((Object)"create_time");
        List finishSettleEntities = this.contractFinishSettleMapper.selectList((Wrapper)queryWrapper);
        ContractEntity contractEntity = (ContractEntity)((Object)this.contractService.selectById(id));
        BigDecimal contractTaxMny = contractEntity.getContractTaxMny() == null ? BigDecimal.ZERO : contractEntity.getContractTaxMny();
        FinishHistoryVo vo = new FinishHistoryVo();
        vo.setContractId(id);
        vo.setChangeStatus(contractEntity.getChangeStatus());
        vo.setContractStatus(contractEntity.getContractStatus());
        vo.setContractTaxMny(contractTaxMny);
        BigDecimal endSettleMny = finishSettleEntities.stream().filter(item -> item.getEndSettleMny() != null).map(ContractFinishSettleEntity::getEndSettleMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        vo.setEndSettleMny(endSettleMny);
        vo.setFinishSettleVOList(BeanMapper.mapList((Iterable)finishSettleEntities, ContractFinishSettleVO.class));
        return vo;
    }
}

