/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.income.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.income.bean.ClaimEntity;
import com.ejianc.business.income.bean.ContractEntity;
import com.ejianc.business.income.bean.ProductionClaimEntity;
import com.ejianc.business.income.bean.ProductionDetailEntity;
import com.ejianc.business.income.bean.ProductionEntity;
import com.ejianc.business.income.bean.ProductionOtherEntity;
import com.ejianc.business.income.history.ProductionHistoryVo;
import com.ejianc.business.income.mapper.ProductionMapper;
import com.ejianc.business.income.service.IClaimService;
import com.ejianc.business.income.service.IContractService;
import com.ejianc.business.income.service.IProductionClaimService;
import com.ejianc.business.income.service.IProductionDetailService;
import com.ejianc.business.income.service.IProductionOtherService;
import com.ejianc.business.income.service.IProductionService;
import com.ejianc.business.income.utils.ComputeUtil;
import com.ejianc.business.income.utils.ExcelImportUtil;
import com.ejianc.business.income.utils.TreeNodeBUtil;
import com.ejianc.business.income.vo.ProductionClaimVo;
import com.ejianc.business.income.vo.ProductionDetailVo;
import com.ejianc.business.income.vo.ProductionOtherVO;
import com.ejianc.business.income.vo.ProductionVo;
import com.ejianc.business.income.vo.comparator.ProductionDetailComparatorVo;
import com.ejianc.business.income.vo.comparator.ProductionReportComparatorVo;
import com.ejianc.business.income.vo.report.ProductionReportVO;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.business.utils.BigDecimalUtils;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.cache.utils.RedisTool;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

@Service(value="ProductionService")
public class ProductionServiceImpl
extends BaseServiceImpl<ProductionMapper, ProductionEntity>
implements IProductionService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String PRODUCTION_BILL_CODE = "INCOME_PRODUCTION";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IProductionDetailService productionDetailService;
    @Autowired
    private ProductionMapper productionMapper;
    @Autowired
    private IContractService contractService;
    @Autowired
    private IProductionClaimService productionClaimService;
    @Autowired
    private IProductionOtherService productionOtherService;
    @Autowired
    private JedisPool jedisPool;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IClaimService claimService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CommonResponse<ProductionVo> saveOrUpdate(ProductionVo productionVo) {
        List entities;
        Object lambda;
        ContractEntity contractEntity;
        block33: {
            contractEntity = (ContractEntity)((Object)this.contractService.selectById(productionVo.getContractId()));
            Jedis jedis = this.jedisPool.getResource();
            boolean locked = false;
            try {
                CommonResponse param;
                List claimVos;
                locked = RedisTool.tryLock((Jedis)jedis, (String)String.valueOf(productionVo.getContractId()), (String)"saveOrUpdate", (int)1000);
                this.logger.info("\u5224\u65ad\u5355\u636e\u5355\u636e\u9501\u7ed3\u679c------" + locked);
                if (productionVo.getContractVersion() != null && productionVo.getContractVersion() != 0) {
                    if (locked) {
                        Integer conVersion;
                        Integer version = contractEntity.getVersion() == null ? 0 : contractEntity.getVersion();
                        if (!version.equals(conVersion = productionVo.getContractVersion())) {
                            CommonResponse commonResponse = CommonResponse.error((String)"\u65bd\u5de5\u5408\u540c\u5df2\u88ab\u66f4\u65b0\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u505a\uff01");
                            return commonResponse;
                        }
                    } else {
                        CommonResponse version = CommonResponse.error((String)"\u51fa\u73b0\u5e76\u53d1\u64cd\u4f5c,\u8bf7\u7a0d\u540e\u91cd\u8bd5\uff01");
                        return version;
                    }
                }
                if ((claimVos = productionVo.getClaimList()) == null || claimVos.size() <= 0) break block33;
                HashMap<Long, Integer> versionMap = new HashMap<Long, Integer>();
                for (ProductionClaimVo claimVo : claimVos) {
                    if (claimVo.getClaimVersion() == null || claimVo.getClaimVersion() == 0) continue;
                    versionMap.put(claimVo.getClaimId(), claimVo.getClaimVersion());
                }
                if (versionMap == null || versionMap.size() <= 0) break block33;
                if (locked) {
                    param = new QueryParam();
                    param.getParams().put("id", new Parameter("in", new ArrayList(versionMap.keySet())));
                    List claimEntities = this.claimService.queryList((QueryParam)param, false);
                    for (ClaimEntity claimEntity : claimEntities) {
                        if ((claimEntity.getVersion() == null ? 0 : claimEntity.getVersion()) == (Integer)versionMap.get(claimEntity.getId())) continue;
                        CommonResponse commonResponse = CommonResponse.error((String)"\u53d8\u66f4\u7b7e\u8bc1\u6d3d\u5546\u7d22\u8d54\u5df2\u88ab\u66f4\u65b0\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u505a\uff01");
                        return commonResponse;
                    }
                    break block33;
                }
                param = CommonResponse.error((String)"\u51fa\u73b0\u5e76\u53d1\u64cd\u4f5c,\u8bf7\u7a0d\u540e\u91cd\u8bd5\uff01");
                return param;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (locked) {
                    RedisTool.releaseLock((Jedis)jedis, (String)String.valueOf(productionVo.getContractId()), (String)"saveOrUpdate");
                }
                jedis.close();
            }
        }
        Date signDate = contractEntity.getSignDate();
        if (null != signDate && productionVo.getProductionDate().getTime() < signDate.getTime()) {
            throw new BusinessException("\u4ea7\u503c\u65f6\u95f4\u53ea\u80fd\u662f\u5927\u4e8e\u7b49\u4e8e\u65bd\u5de5\u5408\u540c\u7684\u7b7e\u7ea6\u65e5\u671f");
        }
        Date lastDate = this.productionMapper.getLastDate(productionVo.getContractId());
        if (null != lastDate && productionVo.getProductionDate().getTime() < lastDate.getTime()) {
            throw new BusinessException("\u4ea7\u503c\u65f6\u95f4\u8981\u5927\u4e8e\u7b49\u4e8e\u8be5\u5408\u540c\u4e0b\u7684\u4ea7\u503c\u65f6\u95f4");
        }
        Long tenantId = InvocationInfoProxy.getTenantid();
        ProductionEntity entity = null;
        String operateType = null;
        if (productionVo.getId() != null && productionVo.getId() > 0L) {
            if (StringUtils.isEmpty((CharSequence)productionVo.getBillCode())) {
                productionVo.setBillCode(null);
            }
            entity = (ProductionEntity)((Object)BeanMapper.map((Object)productionVo, ProductionEntity.class));
            operateType = "edit";
        } else {
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("contractId", new Parameter("eq", (Object)productionVo.getContractId()));
            ArrayList<Integer> billStatus = new ArrayList<Integer>();
            billStatus.add(0);
            billStatus.add(2);
            billStatus.add(5);
            queryParam.getParams().put("bill_state", new Parameter("in", billStatus));
            List entities2 = super.queryList(queryParam, false);
            if (null != entities2 && entities2.size() > 0) {
                throw new BusinessException("\u5408\u540c\u5b58\u5728\u8fdb\u884c\u4e2d\u7684\u5355\u636e\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58");
            }
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(PRODUCTION_BILL_CODE, tenantId);
            if (!billCode.isSuccess()) {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            productionVo.setBillCode((String)billCode.getData());
            entity = (ProductionEntity)((Object)BeanMapper.map((Object)productionVo, ProductionEntity.class));
            operateType = "add";
        }
        if (productionVo.getId() != null && productionVo.getId() > 0L) {
            lambda = Wrappers.lambdaQuery();
            lambda.eq(ProductionEntity::getBillCode, (Object)productionVo.getBillCode());
            lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
            lambda.ne(BaseEntity::getId, (Object)productionVo.getId());
            entities = super.list((Wrapper)lambda);
            if (entities != null && entities.size() > 0) {
                throw new BusinessException("\u5b58\u5728\u76f8\u540c\u7f16\u7801\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
            }
        } else {
            lambda = Wrappers.lambdaQuery();
            lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
            lambda.eq(ProductionEntity::getBillCode, (Object)productionVo.getBillCode());
            entities = super.list((Wrapper)lambda);
            if (entities != null && entities.size() > 0) {
                throw new BusinessException("\u5b58\u5728\u76f8\u540c\u7f16\u7801\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
            }
        }
        for (ProductionDetailEntity detailEntity : entity.getCheckList()) {
            if (!"add".equals(detailEntity.getRowState())) continue;
            detailEntity.setId(null);
        }
        for (ProductionClaimEntity claimEntity : entity.getClaimList()) {
            if (!"add".equals(claimEntity.getRowState())) continue;
            claimEntity.setId(null);
        }
        for (ProductionOtherEntity otherEntity : entity.getOtherList()) {
            if (!"add".equals(otherEntity.getRowState())) continue;
            otherEntity.setId(null);
        }
        super.saveOrUpdateNoES((Object)entity);
        if (CollectionUtils.isNotEmpty(entity.getCheckList())) {
            HashMap<String, Long> idMap = new HashMap<String, Long>();
            for (ProductionDetailEntity cdEntity : entity.getCheckList()) {
                idMap.put(cdEntity.getTid(), cdEntity.getId());
            }
            for (ProductionDetailEntity cdEntity : entity.getCheckList()) {
                if (!StringUtils.isNotEmpty((CharSequence)cdEntity.getTpid())) continue;
                cdEntity.setParentId((Long)idMap.get(cdEntity.getTpid()));
            }
            this.productionDetailService.saveOrUpdateBatch(entity.getCheckList(), entity.getCheckList().size(), false);
        }
        return CommonResponse.success((Object)this.queryDetail(entity.getId()));
    }

    @Override
    public ProductionVo queryDetail(Long id) {
        ProductionEntity entity = (ProductionEntity)((Object)this.selectById(id));
        if (entity != null) {
            ProductionVo vo = (ProductionVo)BeanMapper.map((Object)((Object)entity), ProductionVo.class);
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("productionId", new Parameter("eq", (Object)vo.getId()));
            List details = this.productionDetailService.queryList(queryParam, false);
            if (details != null && details.size() > 0) {
                for (ProductionDetailEntity cdEntity : details) {
                    cdEntity.setTid(cdEntity.getId().toString());
                    cdEntity.setTpid(cdEntity.getParentId() != null && cdEntity.getParentId() > 0L ? cdEntity.getParentId().toString() : "");
                    cdEntity.setRowState("edit");
                }
                List resultMapList = BeanMapper.mapList((Iterable)details, ProductionDetailVo.class);
                Collections.sort(resultMapList, new ProductionDetailComparatorVo());
                vo.setCheckList(TreeNodeBUtil.buildTree((List)resultMapList));
            }
            QueryParam parm = new QueryParam();
            parm.getParams().put("productionId", new Parameter("eq", (Object)vo.getId()));
            List productionClaimEntities = this.productionClaimService.queryList(parm, false);
            vo.setClaimList(BeanMapper.mapList((Iterable)productionClaimEntities, ProductionClaimVo.class));
            List productionOtherEntities = this.productionOtherService.queryList(parm, false);
            vo.setOtherList(BeanMapper.mapList((Iterable)productionOtherEntities, ProductionOtherVO.class));
            return vo;
        }
        return null;
    }

    @Override
    public void deleteProduction(List<ProductionVo> vos) {
        super.removeByIds((Collection)vos.stream().map(BaseVO::getId).collect(Collectors.toList()), false);
    }

    @Override
    public ProductionHistoryVo queryProductionHistory(Long id) {
        ArrayList<Integer> billStatus = new ArrayList<Integer>();
        billStatus.add(1);
        billStatus.add(3);
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"contract_id", (Object)id);
        queryWrapper.orderByDesc((Object[])new String[]{"production_date", "create_time"});
        List prodEntitiesAllState = this.productionMapper.selectList((Wrapper)queryWrapper);
        queryWrapper.in((Object)"bill_state", billStatus);
        List prodEntities = this.productionMapper.selectList((Wrapper)queryWrapper);
        ContractEntity contractEntity = (ContractEntity)((Object)this.contractService.selectById(id));
        BigDecimal contractTaxMny = contractEntity.getContractTaxMny() == null ? BigDecimal.ZERO : contractEntity.getContractTaxMny();
        BigDecimal sumClaimMny = contractEntity.getSumClaimMny() == null ? BigDecimal.ZERO : contractEntity.getSumClaimMny();
        ProductionHistoryVo vo = new ProductionHistoryVo();
        vo.setContractId(id);
        vo.setChangeStatus(contractEntity.getChangeStatus());
        vo.setContractStatus(contractEntity.getContractStatus());
        vo.setContractTaxMny(contractTaxMny);
        vo.setSumProductionTaxMny(contractEntity.getSumProductionTaxMny());
        BigDecimal sumProductionTaxMny = contractEntity.getSumProductionTaxMny() == null ? BigDecimal.ZERO : contractEntity.getSumProductionTaxMny();
        BigDecimal add = contractTaxMny;
        if (add.compareTo(BigDecimal.ZERO) == 0) {
            vo.setSumImageProgress(BigDecimal.ZERO);
        } else {
            vo.setSumImageProgress(sumProductionTaxMny.divide(add, 8, 4).multiply(new BigDecimal(100)));
        }
        vo.setProductionRecord(BeanMapper.mapList((Iterable)prodEntitiesAllState, ProductionVo.class));
        return vo;
    }

    @Override
    public List<ProductionDetailVo> detailRef(Long id) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("productionId", new Parameter("eq", (Object)id));
        List details = this.productionDetailService.queryList(queryParam, false);
        if (details != null && details.size() > 0) {
            for (ProductionDetailEntity cdEntity : details) {
                cdEntity.setTid(cdEntity.getId().toString());
                cdEntity.setTpid(cdEntity.getParentId() != null && cdEntity.getParentId() > 0L ? cdEntity.getParentId().toString() : "");
                cdEntity.setRowState("edit");
            }
            List resultMapList = BeanMapper.mapList((Iterable)details, ProductionDetailVo.class);
            Collections.sort(resultMapList, new ProductionDetailComparatorVo());
            return TreeNodeBUtil.buildTree((List)resultMapList);
        }
        return null;
    }

    @Override
    public JSONObject queryProductionDetailHistory(ProductionDetailVo productionDetailVo) {
        BigDecimal sumFinishNum = new BigDecimal(0);
        BigDecimal sumFinishMny = new BigDecimal(0);
        if (productionDetailVo.getContractDetailId() != null) {
            productionDetailVo.setSourceType(Integer.valueOf(1));
            List<ProductionDetailVo> list = ((ProductionMapper)this.baseMapper).queryProductionDetailHistory(productionDetailVo);
            if (CollectionUtils.isNotEmpty(list)) {
                for (ProductionDetailVo vo : list) {
                    sumFinishNum = BigDecimalUtils.safeAdd((BigDecimal)sumFinishNum, (BigDecimal)vo.getFinishNum());
                    sumFinishMny = BigDecimalUtils.safeAdd((BigDecimal)sumFinishMny, (BigDecimal)vo.getFinishMny());
                }
            }
        }
        JSONObject jo = new JSONObject();
        jo.put("sumFinishNum", (Object)sumFinishNum);
        jo.put("sumFinishMny", (Object)sumFinishMny);
        return jo;
    }

    @Override
    public ProductionVo queryInfoProjectId(Long projectId) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"project_id", (Object)projectId);
        wrapper.in((Object)"bill_state", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
        wrapper.select(new String[]{"IFNULL(sum(finish_tax_mny) , 0 ) AS sumProductionTaxMny"});
        List list = this.list((Wrapper)wrapper);
        BigDecimal sumProductionTaxMny = BigDecimal.ZERO;
        if (list.get(0) != null) {
            sumProductionTaxMny = list.stream().map(ProductionEntity::getSumProductionTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        ProductionVo productionVo = new ProductionVo();
        productionVo.setSumProductionTaxMny(sumProductionTaxMny);
        return productionVo;
    }

    @Override
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        JSONObject resp = new JSONObject();
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5\uff01");
        }
        List result = ExcelReader.readExcel((MultipartFile)mf);
        if (result != null && result.size() > 0) {
            HashMap<String, Integer> indexMap = new HashMap<String, Integer>();
            ArrayList<ProductionDetailVo> detailVoList = new ArrayList<ProductionDetailVo>();
            HashMap<String, String> tidMap = new HashMap<String, String>();
            for (int i = 0; i < result.size(); ++i) {
                List datas = (List)result.get(i);
                ProductionDetailVo vo = new ProductionDetailVo();
                boolean flag = false;
                boolean parentWarn = false;
                String warnType = "";
                String detailIndex = (String)datas.get(0);
                vo.setDetailIndex(detailIndex);
                String id = UUID.randomUUID().toString().replaceAll("-", "");
                if (StringUtils.isNotEmpty((CharSequence)detailIndex)) {
                    String[] split = detailIndex.split("[-/.]");
                    vo.setTid(id);
                    tidMap.put(detailIndex, id);
                    if (split.length > 1) {
                        vo.setTpid(detailIndex.substring(0, detailIndex.length() - split[split.length - 1].length() - 1));
                    }
                } else {
                    vo.setTid(id);
                    vo.setTpid("");
                }
                if (indexMap.containsKey(detailIndex)) {
                    return CommonResponse.error((String)("\u7b2c" + (i + 2) + "\u884c\u5e8f\u53f7\u548c\u7b2c" + ((Integer)indexMap.get(detailIndex) + 2) + "\u884c\u91cd\u590d"));
                }
                indexMap.put(detailIndex, i);
                if (StringUtils.isEmpty((CharSequence)((CharSequence)datas.get(1)))) {
                    vo.setCode(null);
                    warnType = warnType + "\u6e05\u5355\u7f16\u7801\u4e3a\u7a7a,";
                    flag = true;
                    parentWarn = true;
                } else {
                    vo.setCode((String)datas.get(1));
                }
                if (StringUtils.isEmpty((CharSequence)((CharSequence)datas.get(2)))) {
                    vo.setName(null);
                    warnType = warnType + "\u6e05\u5355\u540d\u79f0\u4e3a\u7a7a,";
                    flag = true;
                    parentWarn = true;
                } else {
                    vo.setName((String)datas.get(2));
                }
                vo.setUnit((String)datas.get(3));
                if (StringUtils.isEmpty((CharSequence)((CharSequence)datas.get(4)))) {
                    vo.setFinishNum(null);
                    warnType = warnType + "\u672c\u671f\u5b8c\u6210\u91cf\u4e3a\u7a7a,";
                    flag = true;
                } else {
                    try {
                        vo.setFinishNum(new BigDecimal((String)datas.get(4)));
                    }
                    catch (Exception e) {
                        vo.setFinishNum(null);
                        warnType = warnType + "\u5de5\u7a0b\u91cf\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570,";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)((CharSequence)datas.get(5)))) {
                    vo.setPrice(null);
                    warnType = warnType + "\u7efc\u5408\u5355\u4ef7\u4e3a\u7a7a,";
                    flag = true;
                } else {
                    try {
                        vo.setPrice(new BigDecimal((String)datas.get(5)));
                    }
                    catch (Exception e) {
                        vo.setPrice(null);
                        warnType = warnType + "\u7efc\u5408\u5355\u4ef7\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570,";
                        flag = true;
                    }
                }
                if (!flag) {
                    vo.setFinishMny(vo.getFinishNum().multiply(vo.getPrice()));
                }
                vo.setMemo((String)datas.get(7));
                vo.setImportFlag(Boolean.valueOf(!flag));
                vo.setParentWarn(Boolean.valueOf(parentWarn));
                if (flag) {
                    warnType = warnType.substring(0, warnType.length() - 1);
                }
                vo.setWarnType(warnType);
                vo.setRowState("add");
                vo.setShadowId(vo.getTid());
                vo.setSourceType(Integer.valueOf(2));
                detailVoList.add(vo);
            }
            for (ProductionDetailVo tVo : detailVoList) {
                tVo.setTpid((String)tidMap.get(tVo.getTpid()));
            }
            List<Map<String, Object>> deailTreeData = ExcelImportUtil.treeData(BeanMapper.mapList(detailVoList, Map.class));
            List<Map<String, Object>> mapList = ExcelImportUtil.importFlag(deailTreeData);
            ArrayList<Map<String, Object>> falseList = new ArrayList<Map<String, Object>>();
            List<List<Map<String, Object>>> allList = ExcelImportUtil.separate(mapList, falseList);
            List<Map<String, Object>> errorList = ExcelImportUtil.treeToList(allList.get(1));
            resp.put("successList", allList.get(0));
            resp.put("errorList", errorList);
            resp.put("successNum", (Object)(result.size() - errorList.size()));
            resp.put("errorNum", (Object)errorList.size());
            return CommonResponse.success((Object)resp);
        }
        return CommonResponse.error((String)"Excel\u4e3a\u7a7a");
    }

    @Override
    public List<ProjectRegisterVO> queryNoProductionProject(List<Long> tenantIds) {
        return this.productionMapper.queryNoProductionProject(tenantIds);
    }

    @Override
    public JSONObject queryProductionReport(QueryParam param, Boolean excelBoolean) {
        JSONObject jsonObject = new JSONObject();
        Parameter projectId = (Parameter)param.getParams().get("projectId");
        Parameter year = (Parameter)param.getParams().get("yyear");
        if (null == projectId) {
            return null;
        }
        String yearValue = null;
        if (null != year) {
            yearValue = year.getValue().toString();
            param.getParams().remove("yyear");
        }
        ArrayList<Integer> billstate = new ArrayList<Integer>();
        billstate.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
        billstate.add(BillStateEnum.PASSED_STATE.getBillStateCode());
        param.getParams().put("c.tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        param.getParams().put("billState", new Parameter("in", billstate));
        if (null != param.getParams().get("detailCode")) {
            param.getParams().put("d.code", new Parameter("like", ((Parameter)param.getParams().get("detailCode")).getValue()));
            param.getParams().remove("detailCode");
        }
        Page pages = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        QueryWrapper wrapper = ProductionServiceImpl.changeToQueryWrapper((QueryParam)param);
        List<Object> allDataList = this.productionMapper.queryProductionReport((QueryWrapper<ProductionReportVO>)wrapper, yearValue);
        allDataList = this.handleDate(allDataList);
        allDataList = allDataList.stream().filter(v -> v.getDr() == 0).collect(Collectors.toList());
        List conProjectDateId = allDataList.stream().filter(v -> "\u5408\u540c\u9879\u76ee".equals(v.getName())).map(ProductionReportVO::getId).collect(Collectors.toList());
        List conNewProjectDateId = allDataList.stream().filter(v -> "\u5408\u540c\u65b0\u589e\u9879\u76ee".equals(v.getName())).map(ProductionReportVO::getId).collect(Collectors.toList());
        BigDecimal mnyTotal = null;
        BigDecimal sumMnyTotal = null;
        BigDecimal yearMnyTotal = null;
        BigDecimal mnyTotal1 = null;
        BigDecimal mnyTotal2 = null;
        BigDecimal mnyTotal3 = null;
        BigDecimal mnyTotal4 = null;
        BigDecimal mnyTotal5 = null;
        BigDecimal mnyTotal6 = null;
        BigDecimal mnyTotal7 = null;
        BigDecimal mnyTotal8 = null;
        BigDecimal mnyTotal9 = null;
        BigDecimal mnyTotal10 = null;
        BigDecimal mnyTotal11 = null;
        BigDecimal mnyTotal12 = null;
        BigDecimal mnyTotalNew = null;
        BigDecimal sumMnyTotalNew = null;
        BigDecimal yearMnyTotalNew = null;
        BigDecimal mnyTotal1New = null;
        BigDecimal mnyTotal2New = null;
        BigDecimal mnyTotal3New = null;
        BigDecimal mnyTotal4New = null;
        BigDecimal mnyTotal5New = null;
        BigDecimal mnyTotal6New = null;
        BigDecimal mnyTotal7New = null;
        BigDecimal mnyTotal8New = null;
        BigDecimal mnyTotal9New = null;
        BigDecimal mnyTotal10New = null;
        BigDecimal mnyTotal11New = null;
        BigDecimal mnyTotal12New = null;
        for (ProductionReportVO productionReportVO : allDataList) {
            if (conProjectDateId.contains(productionReportVO.getParentId())) {
                productionReportVO.setParentId(Long.valueOf(1L));
                mnyTotal = ComputeUtil.safeAdd(productionReportVO.getMnyTotal(), mnyTotal);
                sumMnyTotal = ComputeUtil.safeAdd(productionReportVO.getSumMnyTotal(), sumMnyTotal);
                yearMnyTotal = ComputeUtil.safeAdd(productionReportVO.getYearMnyTotal(), yearMnyTotal);
                mnyTotal1 = ComputeUtil.safeAdd(productionReportVO.getMnyTotal1(), mnyTotal1);
                mnyTotal2 = ComputeUtil.safeAdd(productionReportVO.getMnyTotal2(), mnyTotal2);
                mnyTotal3 = ComputeUtil.safeAdd(productionReportVO.getMnyTotal3(), mnyTotal3);
                mnyTotal4 = ComputeUtil.safeAdd(productionReportVO.getMnyTotal4(), mnyTotal4);
                mnyTotal5 = ComputeUtil.safeAdd(productionReportVO.getMnyTotal5(), mnyTotal5);
                mnyTotal6 = ComputeUtil.safeAdd(productionReportVO.getMnyTotal6(), mnyTotal6);
                mnyTotal7 = ComputeUtil.safeAdd(productionReportVO.getMnyTotal7(), mnyTotal7);
                mnyTotal8 = ComputeUtil.safeAdd(productionReportVO.getMnyTotal8(), mnyTotal8);
                mnyTotal9 = ComputeUtil.safeAdd(productionReportVO.getMnyTotal9(), mnyTotal9);
                mnyTotal10 = ComputeUtil.safeAdd(productionReportVO.getMnyTotal10(), mnyTotal10);
                mnyTotal11 = ComputeUtil.safeAdd(productionReportVO.getMnyTotal11(), mnyTotal11);
                mnyTotal12 = ComputeUtil.safeAdd(productionReportVO.getMnyTotal12(), mnyTotal12);
            }
            if (!conNewProjectDateId.contains(productionReportVO.getParentId())) continue;
            productionReportVO.setParentId(Long.valueOf(2L));
            mnyTotalNew = ComputeUtil.safeAdd(productionReportVO.getMnyTotal(), mnyTotalNew);
            sumMnyTotalNew = ComputeUtil.safeAdd(productionReportVO.getSumMnyTotal(), sumMnyTotalNew);
            yearMnyTotalNew = ComputeUtil.safeAdd(productionReportVO.getYearMnyTotal(), yearMnyTotalNew);
            mnyTotal1New = ComputeUtil.safeAdd(productionReportVO.getMnyTotal1(), mnyTotal1New);
            mnyTotal2New = ComputeUtil.safeAdd(productionReportVO.getMnyTotal2(), mnyTotal2New);
            mnyTotal3New = ComputeUtil.safeAdd(productionReportVO.getMnyTotal3(), mnyTotal3New);
            mnyTotal4New = ComputeUtil.safeAdd(productionReportVO.getMnyTotal4(), mnyTotal4New);
            mnyTotal5New = ComputeUtil.safeAdd(productionReportVO.getMnyTotal5(), mnyTotal5New);
            mnyTotal6New = ComputeUtil.safeAdd(productionReportVO.getMnyTotal6(), mnyTotal6New);
            mnyTotal7New = ComputeUtil.safeAdd(productionReportVO.getMnyTotal7(), mnyTotal7New);
            mnyTotal8New = ComputeUtil.safeAdd(productionReportVO.getMnyTotal8(), mnyTotal8New);
            mnyTotal9New = ComputeUtil.safeAdd(productionReportVO.getMnyTotal9(), mnyTotal9New);
            mnyTotal10New = ComputeUtil.safeAdd(productionReportVO.getMnyTotal10(), mnyTotal10New);
            mnyTotal11New = ComputeUtil.safeAdd(productionReportVO.getMnyTotal11(), mnyTotal11New);
            mnyTotal12New = ComputeUtil.safeAdd(productionReportVO.getMnyTotal12(), mnyTotal12New);
        }
        List conProList = allDataList.stream().filter(v -> "\u5408\u540c\u9879\u76ee".equals(v.getName())).collect(Collectors.toList());
        List list = allDataList.stream().filter(v -> "\u5408\u540c\u65b0\u589e\u9879\u76ee".equals(v.getName())).collect(Collectors.toList());
        List<ProductionReportVO> dataList = allDataList.stream().filter(v -> !"\u5408\u540c\u9879\u76ee".equals(v.getName())).filter(v -> !"\u5408\u540c\u65b0\u589e\u9879\u76ee".equals(v.getName())).collect(Collectors.toList());
        HashMap<Long, String> indexMap = new HashMap<Long, String>();
        if (CollectionUtils.isNotEmpty(conProList)) {
            ProductionReportVO productionReportVOOne = new ProductionReportVO();
            productionReportVOOne.setName("\u5408\u540c\u9879\u76ee");
            productionReportVOOne.setDetailCode("1");
            productionReportVOOne.setDetailIndex("1");
            productionReportVOOne.setId(Long.valueOf(1L));
            productionReportVOOne.setMnyTotal(mnyTotal);
            productionReportVOOne.setSumMnyTotal(sumMnyTotal);
            productionReportVOOne.setYearMnyTotal(yearMnyTotal);
            productionReportVOOne.setMnyTotal1(mnyTotal1);
            productionReportVOOne.setMnyTotal2(mnyTotal2);
            productionReportVOOne.setMnyTotal3(mnyTotal3);
            productionReportVOOne.setMnyTotal4(mnyTotal4);
            productionReportVOOne.setMnyTotal5(mnyTotal5);
            productionReportVOOne.setMnyTotal6(mnyTotal6);
            productionReportVOOne.setMnyTotal7(mnyTotal7);
            productionReportVOOne.setMnyTotal8(mnyTotal8);
            productionReportVOOne.setMnyTotal9(mnyTotal9);
            productionReportVOOne.setMnyTotal10(mnyTotal10);
            productionReportVOOne.setMnyTotal11(mnyTotal11);
            productionReportVOOne.setMnyTotal12(mnyTotal12);
            dataList.add(productionReportVOOne);
            indexMap.put(productionReportVOOne.getId(), productionReportVOOne.getDetailIndex());
        }
        if (CollectionUtils.isNotEmpty(list)) {
            ProductionReportVO productionReportVOTwo = new ProductionReportVO();
            productionReportVOTwo.setName("\u5408\u540c\u65b0\u589e\u9879\u76ee");
            productionReportVOTwo.setDetailCode("2");
            productionReportVOTwo.setDetailIndex("2");
            productionReportVOTwo.setId(Long.valueOf(2L));
            productionReportVOTwo.setMnyTotal(mnyTotalNew);
            productionReportVOTwo.setSumMnyTotal(sumMnyTotalNew);
            productionReportVOTwo.setYearMnyTotal(yearMnyTotalNew);
            productionReportVOTwo.setMnyTotal1(mnyTotal1New);
            productionReportVOTwo.setMnyTotal2(mnyTotal2New);
            productionReportVOTwo.setMnyTotal3(mnyTotal3New);
            productionReportVOTwo.setMnyTotal4(mnyTotal4New);
            productionReportVOTwo.setMnyTotal5(mnyTotal5New);
            productionReportVOTwo.setMnyTotal6(mnyTotal6New);
            productionReportVOTwo.setMnyTotal7(mnyTotal7New);
            productionReportVOTwo.setMnyTotal8(mnyTotal8New);
            productionReportVOTwo.setMnyTotal9(mnyTotal9New);
            productionReportVOTwo.setMnyTotal10(mnyTotal10New);
            productionReportVOTwo.setMnyTotal11(mnyTotal11New);
            productionReportVOTwo.setMnyTotal12(mnyTotal12New);
            dataList.add(productionReportVOTwo);
            indexMap.put(productionReportVOTwo.getId(), productionReportVOTwo.getDetailIndex());
        }
        dataList = this.createIndex(indexMap, dataList);
        Collections.sort(dataList, new ProductionReportComparatorVo());
        ArrayList<ProductionReportVO> resultList = new ArrayList<ProductionReportVO>();
        if (Boolean.TRUE == excelBoolean) {
            resultList.addAll(dataList);
        } else {
            resultList.addAll(TreeNodeBUtil.buildTree(dataList));
        }
        jsonObject.put("records", resultList);
        jsonObject.put("total", (Object)pages.getTotal());
        jsonObject.put("current", (Object)pages.getCurrent());
        jsonObject.put("size", (Object)pages.getSize());
        jsonObject.put("pages", (Object)pages.getPages());
        return jsonObject;
    }

    @Override
    public List<ProductionReportVO> excelExportProductionReport(QueryParam queryParam) {
        List records = (List)this.queryProductionReport(queryParam, Boolean.TRUE).get((Object)"records");
        return records;
    }

    public List<ProductionReportVO> createIndex(Map<Long, String> indexMap, List<ProductionReportVO> list) {
        List<ProductionReportVO> collect = list.stream().sorted(Comparator.comparing(ProductionReportVO::getDetailIndex)).collect(Collectors.toList());
        int i = 1;
        int length = 0;
        for (ProductionReportVO productionReportVO : collect) {
            if (length != productionReportVO.getDetailIndex().length()) {
                length = productionReportVO.getDetailIndex().length();
                i = 1;
            }
            if (null == productionReportVO.getParentId()) continue;
            if (null != indexMap.get(productionReportVO.getParentId())) {
                productionReportVO.setDetailIndex(indexMap.get(productionReportVO.getParentId()) + "." + i);
                indexMap.put(productionReportVO.getId(), productionReportVO.getDetailIndex());
                ++i;
                continue;
            }
            productionReportVO.setDetailIndex(i + "");
            indexMap.put(productionReportVO.getId(), productionReportVO.getDetailIndex());
            ++i;
        }
        return collect;
    }

    private List<ProductionReportVO> handleDate(List<ProductionReportVO> list) {
        Long id;
        HashMap<Long, BigDecimal> sumMnyTotalMap = new HashMap<Long, BigDecimal>();
        HashMap<Long, BigDecimal> yearNumMap = new HashMap<Long, BigDecimal>();
        HashMap<Long, BigDecimal> yearMnyTotalMap = new HashMap<Long, BigDecimal>();
        HashMap<Long, BigDecimal> num1Map = new HashMap<Long, BigDecimal>();
        HashMap<Long, BigDecimal> num2Map = new HashMap<Long, BigDecimal>();
        HashMap<Long, BigDecimal> num3Map = new HashMap<Long, BigDecimal>();
        HashMap<Long, BigDecimal> num4Map = new HashMap<Long, BigDecimal>();
        HashMap<Long, BigDecimal> num5Map = new HashMap<Long, BigDecimal>();
        HashMap<Long, BigDecimal> num6Map = new HashMap<Long, BigDecimal>();
        HashMap<Long, BigDecimal> num7Map = new HashMap<Long, BigDecimal>();
        HashMap<Long, BigDecimal> num8Map = new HashMap<Long, BigDecimal>();
        HashMap<Long, BigDecimal> num9Map = new HashMap<Long, BigDecimal>();
        HashMap<Long, BigDecimal> num10Map = new HashMap<Long, BigDecimal>();
        HashMap<Long, BigDecimal> num11Map = new HashMap<Long, BigDecimal>();
        HashMap<Long, BigDecimal> num12Map = new HashMap<Long, BigDecimal>();
        HashMap<Long, BigDecimal> mnyTotal1Map = new HashMap<Long, BigDecimal>();
        HashMap<Long, BigDecimal> mnyTotal2Map = new HashMap<Long, BigDecimal>();
        HashMap<Long, BigDecimal> mnyTotal3Map = new HashMap<Long, BigDecimal>();
        HashMap<Long, BigDecimal> mnyTotal4Map = new HashMap<Long, BigDecimal>();
        HashMap<Long, BigDecimal> mnyTotal5Map = new HashMap<Long, BigDecimal>();
        HashMap<Long, BigDecimal> mnyTotal6Map = new HashMap<Long, BigDecimal>();
        HashMap<Long, BigDecimal> mnyTotal7Map = new HashMap<Long, BigDecimal>();
        HashMap<Long, BigDecimal> mnyTotal8Map = new HashMap<Long, BigDecimal>();
        HashMap<Long, BigDecimal> mnyTotal9Map = new HashMap<Long, BigDecimal>();
        HashMap<Long, BigDecimal> mnyTotal10Map = new HashMap<Long, BigDecimal>();
        HashMap<Long, BigDecimal> mnyTotal11Map = new HashMap<Long, BigDecimal>();
        HashMap<Long, BigDecimal> mnyTotal12Map = new HashMap<Long, BigDecimal>();
        for (ProductionReportVO productionReportVO : list) {
            id = productionReportVO.getId();
            sumMnyTotalMap.put(id, productionReportVO.getSumMnyTotal());
            yearNumMap.put(id, productionReportVO.getYearNum());
            yearMnyTotalMap.put(id, productionReportVO.getYearMnyTotal());
            num1Map.put(id, productionReportVO.getNum1());
            num2Map.put(id, productionReportVO.getNum2());
            num3Map.put(id, productionReportVO.getNum3());
            num4Map.put(id, productionReportVO.getNum4());
            num5Map.put(id, productionReportVO.getNum5());
            num6Map.put(id, productionReportVO.getNum6());
            num7Map.put(id, productionReportVO.getNum7());
            num8Map.put(id, productionReportVO.getNum8());
            num9Map.put(id, productionReportVO.getNum9());
            num10Map.put(id, productionReportVO.getNum10());
            num11Map.put(id, productionReportVO.getNum11());
            num12Map.put(id, productionReportVO.getNum12());
            mnyTotal1Map.put(id, productionReportVO.getMnyTotal1());
            mnyTotal2Map.put(id, productionReportVO.getMnyTotal2());
            mnyTotal3Map.put(id, productionReportVO.getMnyTotal3());
            mnyTotal4Map.put(id, productionReportVO.getMnyTotal4());
            mnyTotal5Map.put(id, productionReportVO.getMnyTotal5());
            mnyTotal6Map.put(id, productionReportVO.getMnyTotal6());
            mnyTotal7Map.put(id, productionReportVO.getMnyTotal7());
            mnyTotal8Map.put(id, productionReportVO.getMnyTotal8());
            mnyTotal9Map.put(id, productionReportVO.getMnyTotal9());
            mnyTotal10Map.put(id, productionReportVO.getMnyTotal10());
            mnyTotal11Map.put(id, productionReportVO.getMnyTotal11());
            mnyTotal12Map.put(id, productionReportVO.getMnyTotal12());
        }
        for (ProductionReportVO productionReportVO : list) {
            if ("\u5408\u540c\u9879\u76ee".equals(productionReportVO.getName()) || "\u5408\u540c\u65b0\u589e\u9879\u76ee".equals(productionReportVO.getName())) continue;
            id = productionReportVO.getId();
            Long oldDetailId = productionReportVO.getOldDetailId();
            productionReportVO.setSumMnyTotal(ComputeUtil.safeAdd(ComputeUtil.nullToZero((BigDecimal)sumMnyTotalMap.get(oldDetailId)), ComputeUtil.nullToZero(productionReportVO.getSumMnyTotal())));
            productionReportVO.setYearNum(ComputeUtil.safeAdd((BigDecimal)yearNumMap.get(oldDetailId), ComputeUtil.nullToZero(productionReportVO.getYearNum())));
            productionReportVO.setYearMnyTotal(ComputeUtil.safeAdd((BigDecimal)yearMnyTotalMap.get(oldDetailId), ComputeUtil.nullToZero(productionReportVO.getYearMnyTotal())));
            productionReportVO.setNum1(ComputeUtil.safeAdd((BigDecimal)num1Map.get(oldDetailId), ComputeUtil.nullToZero(productionReportVO.getNum1())));
            productionReportVO.setNum2(ComputeUtil.safeAdd((BigDecimal)num2Map.get(oldDetailId), ComputeUtil.nullToZero(productionReportVO.getNum2())));
            productionReportVO.setNum3(ComputeUtil.safeAdd((BigDecimal)num3Map.get(oldDetailId), ComputeUtil.nullToZero(productionReportVO.getNum3())));
            productionReportVO.setNum4(ComputeUtil.safeAdd((BigDecimal)num4Map.get(oldDetailId), ComputeUtil.nullToZero(productionReportVO.getNum4())));
            productionReportVO.setNum5(ComputeUtil.safeAdd((BigDecimal)num5Map.get(oldDetailId), ComputeUtil.nullToZero(productionReportVO.getNum5())));
            productionReportVO.setNum6(ComputeUtil.safeAdd((BigDecimal)num6Map.get(oldDetailId), ComputeUtil.nullToZero(productionReportVO.getNum6())));
            productionReportVO.setNum7(ComputeUtil.safeAdd((BigDecimal)num7Map.get(oldDetailId), ComputeUtil.nullToZero(productionReportVO.getNum7())));
            productionReportVO.setNum8(ComputeUtil.safeAdd((BigDecimal)num8Map.get(oldDetailId), ComputeUtil.nullToZero(productionReportVO.getNum8())));
            productionReportVO.setNum9(ComputeUtil.safeAdd((BigDecimal)num9Map.get(oldDetailId), ComputeUtil.nullToZero(productionReportVO.getNum9())));
            productionReportVO.setNum10(ComputeUtil.safeAdd((BigDecimal)num10Map.get(oldDetailId), ComputeUtil.nullToZero(productionReportVO.getNum10())));
            productionReportVO.setNum11(ComputeUtil.safeAdd((BigDecimal)num11Map.get(oldDetailId), ComputeUtil.nullToZero(productionReportVO.getNum11())));
            productionReportVO.setNum12(ComputeUtil.safeAdd((BigDecimal)num12Map.get(oldDetailId), ComputeUtil.nullToZero(productionReportVO.getNum12())));
            productionReportVO.setMnyTotal1(ComputeUtil.safeAdd((BigDecimal)mnyTotal1Map.get(oldDetailId), ComputeUtil.nullToZero(productionReportVO.getMnyTotal1())));
            productionReportVO.setMnyTotal2(ComputeUtil.safeAdd((BigDecimal)mnyTotal2Map.get(oldDetailId), ComputeUtil.nullToZero(productionReportVO.getMnyTotal2())));
            productionReportVO.setMnyTotal3(ComputeUtil.safeAdd((BigDecimal)mnyTotal3Map.get(oldDetailId), ComputeUtil.nullToZero(productionReportVO.getMnyTotal3())));
            productionReportVO.setMnyTotal4(ComputeUtil.safeAdd((BigDecimal)mnyTotal4Map.get(oldDetailId), ComputeUtil.nullToZero(productionReportVO.getMnyTotal4())));
            productionReportVO.setMnyTotal5(ComputeUtil.safeAdd((BigDecimal)mnyTotal5Map.get(oldDetailId), ComputeUtil.nullToZero(productionReportVO.getMnyTotal5())));
            productionReportVO.setMnyTotal6(ComputeUtil.safeAdd((BigDecimal)mnyTotal6Map.get(oldDetailId), ComputeUtil.nullToZero(productionReportVO.getMnyTotal6())));
            productionReportVO.setMnyTotal7(ComputeUtil.safeAdd((BigDecimal)mnyTotal7Map.get(oldDetailId), ComputeUtil.nullToZero(productionReportVO.getMnyTotal7())));
            productionReportVO.setMnyTotal8(ComputeUtil.safeAdd((BigDecimal)mnyTotal8Map.get(oldDetailId), ComputeUtil.nullToZero(productionReportVO.getMnyTotal8())));
            productionReportVO.setMnyTotal9(ComputeUtil.safeAdd((BigDecimal)mnyTotal9Map.get(oldDetailId), ComputeUtil.nullToZero(productionReportVO.getMnyTotal9())));
            productionReportVO.setMnyTotal10(ComputeUtil.safeAdd((BigDecimal)mnyTotal10Map.get(oldDetailId), ComputeUtil.nullToZero(productionReportVO.getMnyTotal10())));
            productionReportVO.setMnyTotal11(ComputeUtil.safeAdd((BigDecimal)mnyTotal11Map.get(oldDetailId), ComputeUtil.nullToZero(productionReportVO.getMnyTotal11())));
            productionReportVO.setMnyTotal12(ComputeUtil.safeAdd((BigDecimal)mnyTotal12Map.get(oldDetailId), ComputeUtil.nullToZero(productionReportVO.getMnyTotal12())));
            sumMnyTotalMap.put(id, productionReportVO.getSumMnyTotal());
            yearNumMap.put(id, productionReportVO.getYearNum());
            yearMnyTotalMap.put(id, productionReportVO.getYearMnyTotal());
            num1Map.put(id, productionReportVO.getNum1());
            num2Map.put(id, productionReportVO.getNum2());
            num3Map.put(id, productionReportVO.getNum3());
            num4Map.put(id, productionReportVO.getNum4());
            num5Map.put(id, productionReportVO.getNum5());
            num6Map.put(id, productionReportVO.getNum6());
            num7Map.put(id, productionReportVO.getNum7());
            num8Map.put(id, productionReportVO.getNum8());
            num9Map.put(id, productionReportVO.getNum9());
            num10Map.put(id, productionReportVO.getNum10());
            num11Map.put(id, productionReportVO.getNum11());
            num12Map.put(id, productionReportVO.getNum12());
            mnyTotal1Map.put(id, productionReportVO.getMnyTotal1());
            mnyTotal2Map.put(id, productionReportVO.getMnyTotal2());
            mnyTotal3Map.put(id, productionReportVO.getMnyTotal3());
            mnyTotal4Map.put(id, productionReportVO.getMnyTotal4());
            mnyTotal5Map.put(id, productionReportVO.getMnyTotal5());
            mnyTotal6Map.put(id, productionReportVO.getMnyTotal6());
            mnyTotal7Map.put(id, productionReportVO.getMnyTotal7());
            mnyTotal8Map.put(id, productionReportVO.getMnyTotal8());
            mnyTotal9Map.put(id, productionReportVO.getMnyTotal9());
            mnyTotal10Map.put(id, productionReportVO.getMnyTotal10());
            mnyTotal11Map.put(id, productionReportVO.getMnyTotal11());
            mnyTotal12Map.put(id, productionReportVO.getMnyTotal12());
        }
        return list;
    }
}

