package com.ejianc.business.income.service;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.income.bean.QuoteEntity;
import com.ejianc.business.income.vo.QuoteDetailVo;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.IBaseService;
import com.ejianc.business.income.history.QuoteHistoryVo;
import com.ejianc.business.income.vo.QuoteVo;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * <p>
 * 甲方报量 服务类
 * </p>
 *
 * @author yuezx
 * @since 2020-06-04
 */
public interface IQuoteService extends IBaseService<QuoteEntity> {

    CommonResponse<QuoteVo> saveOrUpdate(QuoteVo productionVo);

    QuoteVo queryDetail(Long id);

    void deleteQuote(List<QuoteVo> vos);

    QuoteHistoryVo queryQuoteHistory(Long id);

    QuoteDetailVo queryNumAndPriceSum(Map<String, Object> map);

    BigDecimal totalQuoteMoney(Integer range, String year, List<Long> orgIds, Long tenantId);
    /**
     * 根据来源主键（合同清单）查询历史数据的含本期累计工程量
     * @param
     * @param
     * @return
     */
    JSONObject queryQuoteDetailHistory(QuoteDetailVo quoteDetailVo);
    /**
     * 查询合同内的历史数据集合，修改含本期累计报量和不含本期累计报量
     * @return
     */
    void updateQuoteDetailHistory();

    CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response);

}
